﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;

namespace NW4F.LayoutBinaryConverter.TexConv
{
    public class PaletteTable
    {
        enum ID
        {
            R = 0,
            G = 1,
            B = 2,
            A = 3
        }

        byte[] rgba;

        public PaletteTable(int numEntry)
        {
            rgba = new byte[numEntry * 4];   // 4B per entry (rgba)
        }

        public int numEntry
        {
            get { return rgba == null ? 0: rgba.Length / 4; }
        }

        public void Set(int index, byte r, byte g, byte b, byte a)
        {
            int offset = index * 4;

            rgba[offset + (int)ID.R] = r;
            rgba[offset + (int)ID.G] = g;
            rgba[offset + (int)ID.B] = b;
            rgba[offset + (int)ID.A] = a;
        }

        public void Get(int index, out byte rPtr, out byte gPtr, out byte bPtr, out byte aPtr)
        {
            int offset = index * 4;

            rPtr = rgba[offset + (int)ID.R];
            gPtr = rgba[offset + (int)ID.G];
            bPtr = rgba[offset + (int)ID.B];
            aPtr = rgba[offset + (int)ID.A];
        }

        public void Free()
        {
            rgba = null;
        }

    }
}
