﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Diagnostics;

namespace NW4F.LayoutBinaryConverter
{
    public class Report
    {
        static Writer _out = new Writer();
        static Writer _err = new Writer();
        static bool _sbLogMode = false;

        static TextWriter _logFile;

        static Report()
        {
            _out.Console = Console.Out;
            _err.Console = Console.Error;
        }

        /// <summary>
        /// 通常のメッセージはコンソールに出力しません。
        /// </summary>
        public static void SetQuiet()
        {
            _out.Console = null;
        }

        public static void StartLogMode()
        {
            if (! _sbLogMode)
            {
                string execPath = Environment.GetCommandLineArgs()[0];
                try
                {
                    // カレントディレクトリにログを出力する
                    _logFile = new StreamWriter(Path.GetFileNameWithoutExtension(execPath) + ".log");
                }
                catch (ArgumentException)
                {
                    Debug.Write("can't create log file.");
                    return;
                }

                _out.LogFile = _logFile;
                _err.LogFile = _logFile;
                _out.Console = null;

                _sbLogMode = true;
            }
        }

        /// <summary>
        /// ログの出力先を指定する
        /// </summary>
        public static void SetLogWriter(TextWriter outWriter, TextWriter errorWriter)
        {
            Debug.Assert(!_sbLogMode);
            if (_sbLogMode)
            {
                throw new InvalidOperationException("Log mode is started.");
            }

            _out.LogFile = outWriter;
            _err.LogFile = errorWriter;
            _out.Console = null;
        }

        public static void StopLogMode()
        {
            if (! _sbLogMode)
            {
                return;
            }

            _sbLogMode = false;

            _out.LogFile = null;
            _err.LogFile = null;
            _out.Console = Console.Out;

            _logFile.Dispose();
            _logFile = null;
        }

        public static void Stop()
        {
            StopLogMode();
        }

        public class Writer
        {
            TextWriter _logFile;
            TextWriter _console;

            public TextWriter LogFile
            {
                get
                {
                    return _logFile;
                }
                set
                {
                    _logFile = value;
                }
            }

            public TextWriter Console
            {
                get
                {
                    return _console;
                }
                set
                {
                    _console = value;
                }
            }

            public void WriteLine()
            {
                WriteLine("");
            }

            public void WriteLine(string message)
            {
                if (_logFile != null)
                {
                    _logFile.WriteLine(message);
                }
                if (_console != null)
                {
                    _console.WriteLine(message);
                }
            }
        }

        public static Writer Out
        {
            get
            {
                return _out;
            }
        }

        public static Writer Err
        {
            get
            {
                return _err;
            }
        }
    }
}
