﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace NW4F.LayoutBinaryConverter
{
    /// <summary>
    /// プラグインユーティリティです。
    /// </summary>
    public static class PluginUtil
    {
        /// <summary>
        /// DLL から特定の インタフェースを持つ型を列挙します。
        /// </summary>
        static public IEnumerable<Type> EnumrateInterfaceTypesFromDLL(Predicate<string> passPredicate, Type interfaceType)
        {
            string executionPath = System.Reflection.Assembly.GetExecutingAssembly().Location;
            foreach (var dllFilePath in Directory.GetFiles(Path.GetDirectoryName(executionPath), "*.dll"))
            {
                string dllFileName = Path.GetFileNameWithoutExtension(dllFilePath);

                if (!passPredicate(dllFileName))
                {
                    continue;
                }

                System.Reflection.Assembly platformAssembly = System.Reflection.Assembly.LoadFrom(dllFilePath);
                if (platformAssembly != null)
                {
                    var types = platformAssembly.GetTypes().Where(p => interfaceType.IsAssignableFrom(p));

                    foreach (var type in types)
                    {
                        yield return type;
                    }
                }
            }
        }
    }
}
