﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <typeinfo>
#include <nn/ui2d/ui2d_Resources.h>

namespace NW4F
{
namespace LayoutBinaryConverter
{

public ref class BinaryWriterBase abstract
{
public:
                        BinaryWriterBase(System::IO::Stream^ stream, bool swapEndian)
                        {
                            stream_ = stream; swapEndian_ = swapEndian;
                        }

    void                WriteU8(uint8_t data);
    void                WriteU16(uint16_t data);
    void                WriteS16(int16_t data);
    void                WriteU32(uint32_t data);
    void                WriteS32(int32_t data);
    void                WriteS64(int64_t data);
    void                WriteF32(float data);

    property            System::IO::Stream^ Stream { System::IO::Stream^ get() { return stream_; } }

    void                WriteStruct(UserDataHead^ userData);
    void                WriteUserDataList(uint16_t num, uint32_t blockSize);

    static float        DegammaValue(float value);

protected:

    static void         InitBinaryBlockHeader(
                            nn::font::detail::BinaryBlockHeader*          pHeader,
                            uint32_t                     sig,
                            uint32_t                                 blockSize);

    template<typename T>
    static
    array<System::Byte>^
    GetByteArray(const T& data)
    {
        array<System::Byte>^ ret = gcnew array<System::Byte>(sizeof(data));

        const uint8_t* pSrc = reinterpret_cast<const uint8_t*>(&data);
        for (int i = 0; i < ret->Length; ++i)
        {
            ret[i] = pSrc[i];
        }
        return ret;
    }

    // 構造体の型名を取得する（デバッグ用）
    template <typename T>
    static array<System::Byte>^
    GetTypeName()
    {
        const char* name = typeid(T).name();
        size_t length = strlen(name);
        array<System::Byte>^ bytes = gcnew array<System::Byte>(length+2);
        for (size_t i = 0; i < length; ++i)
        {
            bytes[i+1] = name[i];
        }
        bytes[0] = '[';
        bytes[length+1] = ']';

        return bytes;
    }

    template<typename T>
    void
    WriteStructData(const T& data)
    {
        array<System::Byte>^ writeBuf = GetByteArray(data);
        stream_->Write(writeBuf, 0, writeBuf->Length);
    }

    void WriteBytes(array<System::Byte>^ writeBuf)
    {
        stream_->Write(writeBuf, 0, writeBuf->Length);
    }

    template<typename T>
    void
    WriteBlockHeader(T* pBlock, uint32_t sig, uint32_t blockSize)
    {
        InitBinaryBlockHeader(&pBlock->blockHeader, sig, blockSize);

        WriteStructData(*pBlock);
    }

    template<typename T>
    void
    WriteBlockHeader(T* pBlock, uint32_t sig)
    {
        WriteBlockHeader(pBlock, sig, sizeof(*pBlock));
    }

    void                WriteBlockHeader(uint32_t sig);

    void                WriteBinaryFileHeader(
                            uint32_t     fileSig,
                            uint32_t     fileSize,
                            uint16_t     dataBlocks,
                            bool    bBannerVersion,
                            bool    bCompatible_0_12_x);

    void                WriteBinaryCpxFileHeader(
                            uint32_t     fileSig,
                            uint32_t     fileSize,
                            uint16_t     dataBlocks);

    System::IO::Stream^ stream_;
    bool swapEndian_;
};

}   // namespace LayoutBinaryConverter
}   // namespace NW4F
