﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "BinaryWriterBase.h"

namespace NW4F
{
namespace LayoutBinaryConverter
{

public ref class BinaryLytWriter : BinaryWriterBase
{
public:
    BinaryLytWriter(System::IO::Stream^ stream, bool isDegamma, bool isEnableViewerHidden) : BinaryWriterBase(stream, true), isDegamma_(isDegamma), isEnableViewerHidden_(isEnableViewerHidden) {}

    void                WriteBinaryFileHeader(uint32_t fileSize, uint16_t dataBlocks, bool bBannerVersion, bool bCompatible_0_12_x);

    void                WriteBlock(Schema::Flyt::ScreenSetting^ setting, Schema::Flyt::Vec2^ partsSize, uint32_t blockSize);

    void                WriteControlBlock(Schema::Flyt::Control^ control, uint32_t blockSize, uint32_t controlUserNameOffset, uint32_t controlParameterPaneNamesOffset,
                            uint32_t controlFunctionalPaneParameterNameOffsetsOffset, uint32_t controlFunctionalAnimParameterNameOffsetsOffset);

    void                WriteStruct(System::Collections::Generic::SortedList<System::String^, Schema::Flyt::TextureFile^>^ texFiles, uint32_t blockSize);

    void                WriteTextureStruct(uint32_t offset);

    void                WriteStruct(System::Collections::Generic::SortedList<System::String^, Schema::Flyt::FontFile^>^ fontFiles, uint32_t blockSize);

    void                WriteFontStruct(uint32_t offset);

    void                WriteStruct(System::Collections::Generic::ICollection<Schema::Flyt::MaterialInfo^>^ matInfos, uint32_t blockSize);

    void                WriteStruct(Schema::Flyt::MaterialInfo^ matInfo);

    void                WriteStruct(System::Collections::Generic::ICollection<Schema::Flyt::ShapeInfo^>^ shapeInfos, uint32_t blockSize);

    void                WriteStruct(Schema::Flyt::ShapeInfo^ shapeInfo);

    void                WriteStruct(System::Collections::Generic::SortedList<System::String^, Schema::Flyt::CaptureTexture^>^ captureTextures, uint32_t blockSize);

    size_t              GetCaptureTextureStructSize(Schema::Flyt::CaptureTexture^ texture);

    void                WriteCaptureTextureStruct(uint32_t textureNameOffset, uint32_t paneNameOffset, Schema::Flyt::CaptureTexture^ capture);

    void                WriteStruct(Schema::Flyt::TexMap^ texMap, System::Collections::Generic::SortedList<System::String^, Schema::Flyt::TextureFile^>^ textureFileList, bool is_indirect);

    void                WriteStruct(Schema::Flyt::TexMapAdditionalInfo^ info);

    void                WriteStruct(Schema::Flyt::TexMatrix^ texMatrix);

    void                WriteStruct(Schema::Flyt::TexCoordGen^ texCoordGen);

    void                WriteLineWidthOffset(Schema::Flyt::TextBox^ textBox);

    void                WritePerCharacterTransformStruct(Schema::Flyt::TextBox^ textBox, bool hasAnimationInfo);

    void                WriteColor(Schema::Flyt::Color4^ color);

    void                WriteStruct(Schema::Flyt::Material_CTRTevStage^ src);

    void                WriteStruct(Schema::Flyt::Material_CTRAlphaCompare^ src);

    void                WriteStruct(Schema::Flyt::Material_CTRBlendMode^ src);

    void                WriteIndirectParameter(Schema::Flyt::Material_CTRTevStage^ src);

    void                WriteProjectionTexGenParameter(Schema::Flyt::TexCoordGen^ src);

    void                WriteRawTevStage(Schema::Flyt::Material_CTRTevStage^ src);

    void                WriteRawTevStageInfo(Schema::Flyt::MaterialInfo^ src);

    void                WriteFontShadowParameter(Schema::Flyt::Color4^ blackColor, Schema::Flyt::Color4^ whiteColor);

    void                WriteBlock(uint32_t sig);

    void                WriteStruct(Schema::Flyt::TexCoord^ src);

    void                WriteNullPane(Schema::Flyt::Pane^ pane);

    void                WriteBlock(Schema::Flyt::Picture^ picture, Schema::Flyt::Pane^ pane, uint32_t blockSize, uint16_t materialIdx, bool shapeInfoEnabled);

    void                WriteBlock(Schema::Flyt::TextBox^ textBox, Schema::Flyt::Pane^ pane, uint32_t blockSize, uint16_t textBufBytes, uint16_t textStrBytes, uint32_t textStrOffset, uint16_t materialIdx, uint16_t fontIdx, uint32_t textIDOffset, uint32_t lineWidthOffsetOffset, uint32_t perCharacterTransformOffset, bool isKeepingFontScaleEnabled);

    void                WriteBlock(Schema::Flyt::Window^ window, Schema::Flyt::Pane^ pane, uint32_t blockSize, uint32_t contentOffset, uint32_t frameOffsetTableOffset);

    void                WriteBlock(Schema::Flyt::WindowContent^ content, uint16_t materialIdx);

    uint8_t             GetWindowFrameType(Schema::Flyt::WindowFrameType frameType);

    void                WriteBlock(Schema::Flyt::WindowFrame^ frame, uint16_t materialIdx);

    void                WriteBlock(Schema::Flyt::Bounding^ bounding, Schema::Flyt::Pane^ pane);

    void                WriteBlock(Schema::Flyt::Capture^ capture, Schema::Flyt::Pane^ pane, uint32_t blockSize);

    void                WriteBlock(Schema::Flyt::Alignment^ alignment, Schema::Flyt::Pane^ pane);

    void                WriteBlock(Schema::Flyt::Scissor^ scissor, Schema::Flyt::Pane^ pane);

    void                WriteBlockStateMachine(Schema::Flyt::StateMachine^ stateMachine);
    void                WriteBlockStateLayer(Schema::Flyt::StateLayer^ layer, WriterUtil^ util, BinaryLytWriter^ writer);

    void                WriteStateStringBlock(System::String^ value);
    void                WriteStateBlock(Schema::Flyt::State^ state, WriterUtil^ util, BinaryLytWriter^ writer);
    void                WriteStateTransitionTrackKeyBlock(Schema::Flyt::StateTransitionTrackKey^ key, WriterUtil^ util, BinaryLytWriter^ writer);
    void                WriteStateTransitionTrackBlock(Schema::Flyt::StateTransitionTrack^ track, WriterUtil^ util, BinaryLytWriter^ writer);
    void                WriteStateTransitionBlock(Schema::Flyt::StateTransition^ transition, WriterUtil^ util, BinaryLytWriter^ writer);
    void                WriteStateVariablesBlock(Schema::Flyt::StateVariables^ variables, WriterUtil^ util, BinaryLytWriter^ writer);

    void                WriteBlock(Schema::Flyt::Parts^ parts, Schema::Flyt::Pane^ pane, uint32_t blockSize);

    void                WriteStruct(Schema::Flyt::Group^ group);

    void                WriteStruct(Schema::Flyt::GroupPaneRef^ paneRef);

    void                WritePartsPropertyStruct(Schema::Flyt::Property^ prop, uint32_t propertyOffset, uint32_t userDataOffset, uint32_t paneBasicInfoOffset);

    void                WritePartsPaneBasicInfoStruct(Schema::Flyt::Property^ prop);

    void                WriteCombinerUserShader(Schema::Flyt::MaterialInfo^ src);

    static uint32_t     GetDetailedCombinerStageBit0(Schema::Flyt::Material_CTRTevStage^ src);

    static uint32_t     GetDetailedCombinerStageBit1(Schema::Flyt::Material_CTRTevStage^ src);

    static uint32_t     GetDetailedCombinerStageBit2(Schema::Flyt::Material_CTRTevStage^ src);

    static uint32_t     GetDetailedCombinerStageBit3(Schema::Flyt::Material_CTRTevStage^ src);

    static nn::ui2d::ResDetailedCombinerStage  GetDetailedCombinerStage(Schema::Flyt::Material_CTRTevStage^ src);

    literal uint32_t         TypeOfLayoutResource    = nn::ui2d::ResourceTypeLayout;

    literal uint32_t         TypeOfTextureResource   = nn::ui2d::ResourceTypeTexture;

    literal uint32_t         TypeOfFontResource      = nn::ui2d::ResourceTypeFont;

    literal uint32_t         TypeOfArchiveFontResource   = nn::ui2d::ResourceTypeArchiveFont;

    literal uint32_t         TypeOfShaderResource    = nn::ui2d::ResourceTypeShader;

    literal uint32_t         SizeOfTextureStruct = sizeof(nn::ui2d::ResTexture);

    literal uint32_t         SizeOfCaptureTextureStruct = sizeof(nn::ui2d::ResCaptureTexture);

    literal uint32_t         SizeOfFontStruct    = sizeof(nn::ui2d::ResFont);

    literal uint32_t         SizeOfUserDataStruct    = sizeof(nn::ui2d::ResExtUserData);

    literal uint32_t         SizeOfResCaptureTexutreList    = sizeof(nn::ui2d::ResCaptureTextureList);

    literal uint32_t         SignatureOfPaneBeginBlock = nn::ui2d::DataBlockKindPaneBegin;

    literal uint32_t         SignatureOfPaneEndBlock = nn::ui2d::DataBlockKindPaneEnd;

    literal uint32_t         SignatureOfGroupBeginBlock = nn::ui2d::DataBlockKindGroupBegin;

    literal uint32_t         SignatureOfGroupEndBlock = nn::ui2d::DataBlockKindGroupEnd;

    literal int         ResourceNameStrMax      = nn::ui2d::ResourceNameStrMax;

    literal int         GroupNameStrMax         = nn::ui2d::GroupNameStrMax;

    literal int         UserDataStrMax          = nn::ui2d::UserDataStrMax;

    literal int         MaterialNameStrMax      = nn::ui2d::MaterialNameStrMax;

    literal int         CapOfTevKColor          = nn::ui2d::MatColorMax - 1;

    literal int         CapOfTexMap             = nn::ui2d::TexMapMax;

    literal int         CapOfTexMtx             = nn::ui2d::TexMapMax;

    literal int         CapOfTexCoord           = nn::ui2d::TexMapMax;

    literal int         CapOfTexCoordGen        = nn::ui2d::TexMapMax;

    literal int         CapOfTevStage           = nn::ui2d::TevStageMax;

    literal uint32_t         SizeOfPartsPropertyStruct = sizeof(nn::ui2d::ResPartsProperty);

protected:
    bool                isDegamma_;
    bool                isEnableViewerHidden_;

    void CopyColor(nn::ui2d::ResColor* pDst, Schema::Flyt::Color4^ src);
    bool WriteColor4f(Schema::Flyt::Color4f^ src);

};

}   // namespace LayoutBinaryConverter
}   // namespace NW4F
