﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "BinaryWriterBase.h"

namespace NW4F
{
namespace LayoutBinaryConverter
{

public ref class BinaryLanWriter : BinaryWriterBase
{
public:
                            BinaryLanWriter(System::IO::Stream^ stream) : BinaryWriterBase(stream, true) {}

    void                    WriteBinaryFileHeader(uint32_t fileSize, uint16_t dataBlocks, bool bBannerVersion, bool compatible_0_12_x);

    void                    WriteBlock(AnimSection^ animSec, uint32_t blockSize, uint32_t nameOffset, uint32_t groupNameOffsetsOffset, uint32_t userDataListOffset);

    void                    WriteStruct(Schema::Flan::GroupRef^ groupRef);

    void                    WriteBlock(Schema::Flan::AnimShare^ animShare, uint32_t blockSize, uint32_t animShareInfoOffset);

    void                    WriteStruct(Schema::Flan::AnimShareInfo^ animShareInfo);

    void                    WriteBlock(
                                array<MergeAnimContent^>^
                                                        animContentAry,
                                System::Collections::Generic::SortedList<System::String^,  Schema::Flan::RefRes^>^
                                                        fileNameList,
                                Schema::Flan::AnimTag^  animTag,
                                uint32_t                     blockSize,
                                uint32_t                     animContOffsetsOffset);

    void                    WriteBlock(MergeAnimContent^ animContent, uint8_t animContNum);

    void                    WriteBlock(
                                Schema::Flan::AnimationType                                     animType,
                                System::Collections::Generic::List<Schema::Flan::AnimTarget^>^  list);

    void                    WriteBlock(Schema::Flan::AnimTarget^ animTarget, Schema::Flan::AnimationType animType);

    void                    WriteParameterizedAnim(array<Schema::Flan::ParameterizedAnimParameter^>^ parameters);

    void                    WriteKeys(array<Schema::Flan::Hermite^>^ keys, int32_t startFrame, bool bDegamma);

    void                    WriteVisibilityKey(Schema::Flan::AnimVisibilityTarget^ viTarget, int32_t startFrame);

    void                    WriteTexturePatternKey(Schema::Flan::AnimTexPatternTarget^ tpTarget, System::Collections::Generic::SortedList<System::String^, Schema::Flan::RefRes^>^ fileNameList, int32_t startFrame);

    void                    WriteParameterizedAnimParameter(Schema::Flan::ParameterizedAnimParameter^ parameter, int32_t startFrame);

    property System::IO::Stream^
                            Stream { System::IO::Stream^ get() { return stream_; } }

    literal uint32_t             TypeOfAnimationResource = nn::ui2d::ResourceTypeAnimation;
};

}   // namespace LayoutBinaryConverter
}   // namespace NW4F
