﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include <cstring>
#include "WriteCommon.h"
#include "BinaryCpxWriter.h"

#include <nn/font/font_ResourceFormat.h>

using namespace System;
using namespace System::Diagnostics;
using namespace System::IO;
using namespace System::Collections::Generic;
using namespace System::Text;

namespace font = nn::font;

namespace NW4F
{
namespace LayoutBinaryConverter
{

namespace
{

}   // namespace

void
BinaryCpxWriter::WriteBinaryFileHeader(uint32_t fileSize, uint16_t dataBlocks)
{
    BinaryWriterBase::WriteBinaryCpxFileHeader(font::BinFileSignatureFcpx, fileSize, dataBlocks);
}

void
BinaryCpxWriter::WriteResBitmapFontHeader(uint32_t offsetToStringTable)
{
    WriteS32(nn::font::ResSubFontType::ResSubFontType_BitmapFont);
    WriteU32(offsetToStringTable);
}

void
BinaryCpxWriter::WriteResMultiScalableFontHeader(float size, uint32_t alternateChar, int lineFeedOffset, int count)
{
    WriteS32(nn::font::ResSubFontType::ResSubFontType_MultiScalableFont);
    WriteF32(size);
    WriteS32(lineFeedOffset);
    WriteU32(count);
    WriteU32(32); // scalableFontDescription(sizeof(ResMultiScalableFont))
    WriteU16(static_cast<uint16_t>(alternateChar));
    WriteU16(0);
    WriteU32(0);
    WriteU32(0);
}

void
BinaryCpxWriter::WriteResPairFontHeader()
{
    WriteS32(nn::font::ResSubFontType::ResSubFontType_PairFont);
}

void
BinaryCpxWriter::WriteResScalableFontDesc(
    float boldWeight,
    uint32_t ttcFontIndex,
    uint32_t offsetToStringTable,
    uint8_t borderWidth,
    float scaleWidth,
    float scaleHeight,
    bool ignorePalt,
    bool deleteBearingX,
    int bearingOffsetX,
    bool forceMonospacedEnabled,
    int forceMonospacedWidth,
    int baselineOffset)
{
    WriteF32(boldWeight);
    WriteF32(scaleWidth);
    WriteU32(ttcFontIndex);
    WriteU32(offsetToStringTable);
    WriteU8(borderWidth);
    {
        uint8_t bits = 0;
        if (ignorePalt)
        {
            bits |= 1 << 0;
        }
        if (deleteBearingX)
        {
            bits |= 1 << 1;
        }
        if (forceMonospacedEnabled)
        {
            bits |= 1 << 2;
        }
        WriteU8(bits);
    }
    WriteS16(static_cast<int16_t>(baselineOffset));
    WriteF32(scaleHeight);
    WriteS16(static_cast<int16_t>(bearingOffsetX));
    WriteS16(static_cast<int16_t>(forceMonospacedWidth));
    WriteU32(0);
}

void
BinaryCpxWriter::WriteResCharMap(uint32_t first, uint32_t last)
{
    WriteU32(first);
    WriteU32(last);
}


}   // namespace LayoutBinaryConverter
}   // namespace NW4F



