﻿#include "sharcDebug.h"
#include <cstdarg>
#include <cstdio>
#include <intrin.h>
#include <windows.h>

namespace
{
    void
        PutString(const char* str)
    {
        std::printf(str);
        OutputDebugStringA(str);
    }

    void
        VPrintf(const char *fmt, va_list vlist)
    {
        static const size_t MAX_DEBUG_STRING_LENGTH = 260;
        static char sDebugString[MAX_DEBUG_STRING_LENGTH];

        std::vsnprintf(sDebugString, MAX_DEBUG_STRING_LENGTH, fmt, vlist);

        PutString(sDebugString);
    }

    void
        Printf(const char *fmt, ...)
    {
        std::va_list vlist;
        va_start(vlist, fmt);

        VPrintf(fmt, vlist);

        va_end(vlist);
    }
}
namespace sharc
{
    namespace debug
    {
        //---------------------------------------------------------------------------
        void
            HaltWithDetail(const char* codePos, int lineNo, const char* format, ...)
        {
            Printf("%s(%d): ", codePos, lineNo);

            {
                va_list list;
                va_start(list, format);
                VPrintf(format, list);
                va_end(list);
            }

            Printf("\n");

            __debugbreak();
        }
    }
}
