﻿using System;
// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

/*
 * プレビュー機能は未実装です
 * 仕様が確定次第対応します
*/

namespace FcpxMaker.SubForm
{
    using static FcpxMaker.Type;

    public partial class PreviewForm : Form
    {
        private string _defaultString = "abcdefghijklmnopqrstuvwxyz\r\nABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n0123456789";
        private FontDescription _desc = new FontDescription();

        /// <summary>
        /// フォントを作成します。
        /// </summary>
        public Font CreateFont(FontDescription desc)
        {
            //PrivateFontCollectionオブジェクトを作成する
            System.Drawing.Text.PrivateFontCollection pfc =
                new System.Drawing.Text.PrivateFontCollection();

            //PrivateFontCollectionにフォントを追加する
            pfc.AddFontFile(desc.FontFilePath);

            //PrivateFontCollectionの先頭のフォントのFontオブジェクトを作成する
            System.Drawing.Font font =
                new System.Drawing.Font(pfc.Families[0], desc.FontSize);

            //Labelコントロールのフォントに設定する
            //label1.Font = font;

            //後始末
            pfc.Dispose();

            return font;
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public PreviewForm()
        {
            InitializeComponent();

            // フォントを作成
            _desc.FontFilePath = @"C:\work\Bambi2\Samples\Sources\Resources\Font\IconFont-Regular.ttf";
            //_desc.FontFilePath = @"C:\work\Bambi2\Samples\Sources\Resources\Ui2d\Common\Fonts\IconFont_64_RGBA8.ffnt";
            _desc.FontSize = 12;

            _lblPreview.Font = CreateFont(_desc);

            // 初期表示
            _tbxInput.Text = _defaultString;
        }

        /// <summary>
        /// テキストが変更された時のイベントハンドラです。
        /// </summary>
        private void Event_TextChanged(object sender, EventArgs e)
        {
            _lblPreview.Text = _tbxInput.Text;
        }

        /// <summary>
        /// フォントサイズが変更された時のイベントハンドラです。
        /// </summary>
        private void Event_FontSizeValueChanged(object sender, EventArgs e)
        {
            _desc.FontSize = Convert.ToInt32(_nudFontSize.Value);

            // フォントを作り直し
            _lblPreview.Font = CreateFont(_desc);
        }

        /// <summary>
        /// フォームが閉じた時のイベントハンドラです。
        /// </summary>
        private void Event_FormClosed(object sender, FormClosedEventArgs e)
        {
            EventParam args = new EventParam(EventType.DialogClose, null);
            EventManager.entry(sender, args);
        }

        /// <summary>
        /// フォントのパラメータクラスです。
        /// </summary>
        public class FontDescription
        {
            public string FontFilePath { get; set; }

            public int FontSize { get; set; }
        }
    }
}
