﻿using System;
// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FcpxMaker
{
    public class StringUtility
    {
        /// <summary>
        /// ファイル名を取得します。
        /// </summary>
        static public string GetFileName(string filePath)
        {
            if (String.IsNullOrEmpty(filePath)) return string.Empty;

            int sPos = filePath.LastIndexOf('\\') + 1;
            return filePath.Substring(sPos);
        }

        /// <summary>
        /// ディレクトリを取得します。
        /// </summary>
        static public string GetDir(string filePath)
        {
            if (String.IsNullOrEmpty(filePath)) return string.Empty;

            int ePos = filePath.LastIndexOf('\\');
            if (ePos == -1)
            {
                return string.Empty;
            }
            return filePath.Substring(0, ePos);
        }

        /// <summary>
        /// 相対パスを取得します。
        /// </summary>
        static public string GetRelativePath(string path, string basePath)
        {
            if (String.IsNullOrEmpty(path)) return path;

            if (String.IsNullOrEmpty(basePath)) return path;

            // basePath カレントディレクトリからの絶対パスに直す
            basePath = System.IO.Path.GetFullPath(basePath);

            int dirPos = basePath.LastIndexOf('\\');
            basePath = basePath.Substring(0, dirPos);


            Uri current = new Uri(basePath + @"\");
            Uri original = new Uri(path);
            Uri relative = current.MakeRelativeUri(original);

            return relative.ToString().Replace("/", @"\");
        }

        /// <summary>
        /// 絶対パスを取得します。
        /// </summary>
        static public string GetAbsolutePath(string path, string basePath)
        {
            if (String.IsNullOrEmpty(path)) return path;

            if (String.IsNullOrEmpty(basePath)) return path;

            // basePath カレントディレクトリからの絶対パスに直す
            basePath = System.IO.Path.GetFullPath(basePath);

            int dirPos = basePath.LastIndexOf('\\');
            basePath = basePath.Substring(0, dirPos);

            Uri current = new Uri(basePath + @"\");
            Uri absolute = new Uri(current, path);
            string winPath = absolute.LocalPath + Uri.UnescapeDataString(absolute.Fragment);

            return winPath.ToString().Replace("/", @"\");

        }
    }
}
