﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FcpxMaker.Panel.Property
{
    using DataModel;
    using Node;
    using static Type;

    public partial class PropertyPanelBase : UserControl
    {
        private DataModelBase _target = null;

        /// <summary>
        /// 操作対象のデータモデルです。
        /// </summary>
        protected DataModelBase Target
        {
            get
            {
                return _target;
            }
            set
            {
                if (_target != value)
                {
                    _target = value;
                    UpdateProperty();
                }
            }
        }

        /// <summary>
        /// データモデルを関連付けます。
        /// </summary>
        virtual public void BindTarget(DataModelBase target)
        {
            this.Target = target;
        }

        /// <summary>
        /// UIを更新します。
        /// </summary>
        virtual public void UpdateProperty() { }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public PropertyPanelBase()
        {
            InitializeComponent();
        }

        /// <summary>
        /// ツリービューの更新要求を通知します。
        /// </summary>
        protected void NotifyUpdateTreeView()
        {
            EventParam args = new EventParam(EventType.UpdateTreeView, null);
            EventManager.entry(this, args);
        }

        /// <summary>
        /// データの変更を通知します。
        /// </summary>
        protected void NotifyDataModified()
        {
            EventParam args = new EventParam(EventType.DataModified, null);
            EventManager.entry(this, args);
        }
    }
}
