﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FcpxMaker.Panel.Property
{
    using FcpxMaker.DataModel;
    using static Type;

    public partial class CharCodeRangePropertyPanel : PropertyPanelBase
        , IEventListener
    {
        private bool _isSystemCall = false;

        /// <summary>
        /// 操作対象のデータモデルです。
        /// </summary>
        private CharCodeRangeDataModel TargetDataModel
        {
            get
            {
                return Target as CharCodeRangeDataModel;
            }
        }

        /// <summary>
        /// 16進数モードか。
        /// </summary>
        private bool IsHex
        {
            get { return _chkHex.Checked; }
        }

        /// <summary>
        /// UIを更新します。
        /// </summary>
        override public void UpdateProperty()
        {
            if (TargetDataModel != null)
            {
                _isSystemCall = true;

                _chkHex.Checked = TargetDataModel.IsHex;

                _nudStartEnd1.SetValue(TargetDataModel.GetFontRange(0));
                _nudStartEnd2.SetValue(TargetDataModel.GetFontRange(1));
                _nudStartEnd3.SetValue(TargetDataModel.GetFontRange(2));
                _nudStartEnd4.SetValue(TargetDataModel.GetFontRange(3));
                _nudStartEnd5.SetValue(TargetDataModel.GetFontRange(4));
                _nudStartEnd6.SetValue(TargetDataModel.GetFontRange(5));
                _nudStartEnd7.SetValue(TargetDataModel.GetFontRange(6));
                _nudStartEnd8.SetValue(TargetDataModel.GetFontRange(7));
                _nudStartEnd9.SetValue(TargetDataModel.GetFontRange(8));
                _nudStartEnd10.SetValue(TargetDataModel.GetFontRange(9));
                _nudStartEnd11.SetValue(TargetDataModel.GetFontRange(10));
                _nudStartEnd12.SetValue(TargetDataModel.GetFontRange(11));
                _nudStartEnd13.SetValue(TargetDataModel.GetFontRange(12));
                _nudStartEnd14.SetValue(TargetDataModel.GetFontRange(13));
                _nudStartEnd15.SetValue(TargetDataModel.GetFontRange(14));
                _nudStartEnd16.SetValue(TargetDataModel.GetFontRange(15));

                _isSystemCall = false;

                // ペースト時はCheckedが変化しないケースがあるので、明示的に呼び出す
                if (TargetDataModel.IsHex)
                {
                    Event_HexCheckedChanged(this, null);
                }
            }
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public CharCodeRangePropertyPanel()
        {
            InitializeComponent();
        }

        /// <summary>
        /// イベントを通知します。
        /// </summary>
        public void dispatch(object sender, EventArgs arg)
        {
            EventParam param = arg as EventParam;

            switch (param.Type)
            {
                case EventType.PasteParams:
                    {
                        UpdateProperty();
                    }
                    break;
            }
        }

        /// <summary>
        /// 開始終了のコントロールを取得します。
        /// </summary>
        CustomControl.TextBoxStartEnd GetStartEndControl(int index)
        {
            List<CustomControl.TextBoxStartEnd> StartendList = new List<CustomControl.TextBoxStartEnd>()
            {
                _nudStartEnd1,
                _nudStartEnd2,
                _nudStartEnd3,
                _nudStartEnd4,
                _nudStartEnd5,
                _nudStartEnd6,
                _nudStartEnd7,
                _nudStartEnd8,
                _nudStartEnd9,
                _nudStartEnd10,
                _nudStartEnd11,
                _nudStartEnd12,
                _nudStartEnd13,
                _nudStartEnd14,
                _nudStartEnd15,
                _nudStartEnd16,
            };

            return StartendList.ElementAt(index);
        }


        /// <summary>
        /// チェックが変更された時のイベントハンドラです。
        /// </summary>
        private void Event_CheckedChanged(object sender, EventArgs e)
        {
            CheckBox ctrl = sender as CheckBox;
            int index = (int)ctrl.Tag;
            TargetDataModel.GetFontRange(index).Checked = ctrl.Checked;
            GetStartEndControl(index).TabStop = ctrl.Checked;

            // データの変更を通知します
            NotifyDataModified();
        }

        /// <summary>
        /// 文字の範囲(開始)が変更された時のイベントハンドラです。
        /// </summary>
        private void Event_CharCodeRangeStartValueChanged(object sender, EventArgs e)
        {
            if (_isSystemCall) return;

            TextBox ctrl = sender as TextBox;
            int index = (int)ctrl.Tag;

            if (String.IsNullOrEmpty(ctrl.Text))
            {
                TargetDataModel.GetFontRange(index).First = 0;
                return;
            }

            try
            {
                if (this.IsHex)
                {
                    TargetDataModel.GetFontRange(index).First = Convert.ToUInt32(ctrl.Text, 16);
                }
                else
                {
                    TargetDataModel.GetFontRange(index).First = Convert.ToUInt32(ctrl.Text);
                }

                // ツリービューの更新要求を通知します
                NotifyUpdateTreeView();

                // データの変更を通知します
                NotifyDataModified();
            }
            catch
            {
                // 不正な値を検出した場合は0にする
                ctrl.Text = "0";
            }
        }

        /// <summary>
        /// 文字の範囲(終了)が変更された時のイベントハンドラです。
        /// </summary>
        private void Event_CharCodeRangeEndValueChanged(object sender, EventArgs e)
        {
            if (_isSystemCall) return;

            TextBox ctrl = sender as TextBox;
            int index = (int)ctrl.Tag;

            if (String.IsNullOrEmpty(ctrl.Text))
            {
                TargetDataModel.GetFontRange(index).Last = 0;
                return;
            }

            try
            {
                if (this.IsHex)
                {
                    TargetDataModel.GetFontRange(index).Last = Convert.ToUInt32(ctrl.Text, 16);
                }
                else
                {
                    TargetDataModel.GetFontRange(index).Last = Convert.ToUInt32(ctrl.Text);
                }

                // ツリービューの更新要求を通知します
                NotifyUpdateTreeView();

                // データの変更を通知します
                NotifyDataModified();
            }
            catch
            {
                // 不正な値を検出した場合は0にする
                ctrl.Text = "0";
            }
        }

        /// <summary>
        /// キーが押された時のイベントハンドラです。
        /// </summary>
        private void Event_KeyPress(object sender, KeyPressEventArgs e)
        {
            if ((this.IsHex) && ((e.KeyChar >= 'a' && e.KeyChar <= 'f') || (e.KeyChar >= 'A' && e.KeyChar <= 'F')) ||
                (e.KeyChar >= '0' && e.KeyChar <= '9') ||
                (char.IsControl(e.KeyChar)))
            {
                e.Handled = false;
            }
            else
            {
                e.Handled = true;
            }
        }

        /// <summary>
        /// 16進数チェックボックスが変更された時のイベントハンドラです。
        /// </summary>
        private void Event_HexCheckedChanged(object sender, EventArgs e)
        {
            if (_isSystemCall) return;

            bool isHex = _chkHex.Checked;

            for (int i = 0; i < 16; i++)
            {
                GetStartEndControl(i).IsHex = isHex;
            }

            TargetDataModel.IsHex = isHex;
        }
    }
}
