﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using System.Text;
using System.Threading.Tasks;

namespace FcpxMaker.Node
{
    using DataModel;
    using static FcpxMaker.Type;

    public class DataNodeFactory
    {
        /// <summary>
        /// データモデルからデータノードを生成します。
        /// </summary>
        static public DataNode CreateDataNode(DataModelBase dataModel)
        {
            if (dataModel == null) return null;

            DataNode newNode = new DataNode();
            newNode.DataType = dataModel.DataType;
            newNode.DataModel = dataModel;
            newNode.ContextMenuStrip = DataNodeContextMenu.ContextMenuStrip;

            switch (dataModel.DataType)
            {
                case DataType.Root:
                    {
                        DataNode node = CreateDataNode((dataModel as RootDataModel).SubFont);
                        if (node != null)
                        {
                            newNode.Nodes.Add(node);
                        }
                    }
                    break;
                case DataType.PairFont:
                    {
                        DataNode firstNode = CreateDataNode((dataModel as PairFontDataModel).FirstFont);
                        if (firstNode != null)
                        {
                            newNode.Nodes.Add(firstNode);
                        }
                        DataNode secondNode = CreateDataNode((dataModel as PairFontDataModel).SecondFont);
                        if (secondNode != null)
                        {
                            newNode.Nodes.Add(secondNode);
                        }
                    }
                    break;
                case DataType.BitmapFont:
                    {
                        DataNode node = CreateDataNode((dataModel as BitmapFontDataModel).FontDataModel);
                        if (node != null)
                        {
                            newNode.Nodes.Add(node);
                        }
                    }
                    break;
                case DataType.ScalableFont:
                    {
                        DataNode node = CreateDataNode((dataModel as ScalableFontDataModel).ScalableFontDescription);
                        if (node != null)
                        {
                            newNode.Nodes.Add(node);
                        }
                    }
                    break;
                case DataType.MultiScalableFont:
                    {
                        foreach (var desc in (dataModel as MultiScalableFontDataModel).ScalableFontDescriptionSet)
                        {
                            DataNode node = CreateDataNode(desc);
                            if (node != null)
                            {
                                newNode.Nodes.Add(node);
                            }
                        }
                    }
                    break;
                case DataType.ScalableFontDescription:
                    {
                        DataNode node = CreateDataNode((dataModel as ScalableFontDescriptionDataModel).FontDataModel);
                        if (node != null)
                        {
                            newNode.Nodes.Add(node);
                        }
                    }
                    break;
                case DataType.Font:
                    {
                        newNode.Text = (dataModel as FontDataModel).ToString();
                    }
                    break;
            }

            return newNode;
        }
    }
}
