﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FcpxMaker.Node
{
    /// <summary>
    /// ノード用のコンテキストメニューです。
    /// </summary>
    public class DataNodeContextMenu
    {
        static ContextMenuStrip _menuStrip = new ContextMenuStrip();

        /// <summary>
        /// コンテキストメニュー。
        /// </summary>
        static public ContextMenuStrip ContextMenuStrip
        {
            get
            {
                return _menuStrip;
            }
        }

        /// <summary>
        /// コンテキストメニューを追加します。
        /// </summary>
        static public ToolStripItem AddMenu(string name, EventHandler handler)
        {
            return _menuStrip.Items.Add(name, null, handler);
        }

        /// <summary>
        /// 子要素としてコンテキストメニューを追加します。
        /// </summary>
        static public ToolStripItem AddSubMenu(ToolStripItem parent, string name, EventHandler handler)
        {
            ToolStripMenuItem item = parent as ToolStripMenuItem;
            return item.DropDownItems.Add(name, null, handler);
        }
    }
}
