﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FcpxMaker
{
    using static FcpxMaker.Type;

    /// <summary>
    ///イベント管理クラスです。
    /// </summary>
    public class EventManager
    {
        /// <summary>
        ///イベントを登録します。
        /// </summary>
        static public void entry(object sender, EventParam type)
        {
            MainForm.Instance.BeginInvoke((MethodInvoker)delegate {
                    dispatch_(MainForm.Instance, new KeyValuePair<object, EventParam>(sender, type));
            });
        }

        static private void dispatch_(Control ctrl, KeyValuePair<object, EventParam> item)
        {
            // 子から処理する
            foreach (Control child in ctrl.Controls)
            {
                dispatch_(child, item);
            }

            IEventListener listener = ctrl as IEventListener;
            if (listener != null)
            {
                listener.dispatch(item.Key, item.Value);
            }
        }
    }

    /// <summary>
    /// イベントパラメータです。
    /// </summary>
    public class EventParam : EventArgs
    {
        readonly private EventType _type;
        readonly object _option;

        public EventParam(EventType type, object option)
        {
            _type = type;
            _option = option;
        }

        public EventType Type { get { return _type; } }
        public object Option { get { return _option; } }
    }
}
