﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FcpxMaker.Dialog
{
    using static FcpxMaker.Type;

    public partial class VersionDialog : Form
    {
        public VersionDialog()
        {
            InitializeComponent();

            Assembly assembly = Assembly.GetExecutingAssembly();
            FileVersionInfo info = FileVersionInfo.GetVersionInfo(assembly.Location);

            Icon appIcon = Icon.ExtractAssociatedIcon(assembly.Location);
            _pctAppIcon.Image = appIcon.ToBitmap();
            _lblVersion.Text = GetVersionString();
            _lblCopyRight.Text = info.LegalCopyright;
        }

        /// <summary>
        /// バージョン文字列を得る
        /// </summary>
        /// <returns></returns>
        public static string GetVersionString()
        {
            // 情報の取得
            Assembly assembly = Assembly.GetExecutingAssembly();
            FileVersionInfo info = FileVersionInfo.GetVersionInfo(assembly.Location);

            // ビルド日時の取得
            Version version = assembly.GetName().Version;
            DateTime buildDate = new DateTime(2000, 1, 1, 0, 0, 0);
            buildDate = buildDate.AddDays((double)version.Build);
            buildDate = buildDate.AddSeconds((double)version.Revision * 2.0);

            return string.Format("{0} [{1}-bit] Version {2}.{3}.{4} Release {5} ({6} {7})",
                    "NW " + info.FileDescription + ".exe",
                    IntPtr.Size == 8 ? "64" : "32",
                    info.ProductMajorPart,
                    info.ProductMinorPart,
                    info.ProductBuildPart,
                    info.ProductPrivatePart,
                    buildDate.ToShortDateString(),
                    buildDate.ToShortTimeString());
        }

        /// <summary>
        /// フォームが閉じた時のイベントハンドラです。
        /// </summary>
        private void Event_FormClosed(object sender, FormClosedEventArgs e)
        {
            EventParam args = new EventParam(EventType.DialogClose, null);
            EventManager.entry(sender, args);
        }

        /// <summary>
        /// OKが押された時のイベントハンドラです。
        /// </summary>
        private void Event_btnOk_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
