﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FcpxMaker.DataModel
{
    using NW4F.LayoutBinaryConverter.Schema.Fcpx;
    using static Type;

    /// <summary>
    /// ルートのデータモデルです。
    /// </summary>
    [Serializable]
    public class RootDataModel : DataModelBase
    {
        private string _version;

        /// <summary>
        /// バージョンです。
        /// </summary>
        public string Version
        {
            get
            {
                return _version;
            }
            set
            {
                _version = value;
            }
        }

        /// <summary>
        /// サブフォントです。
        /// </summary>
        public DataModelBase SubFont
        {
            get; set;
        }

        /// <summary>
        /// データの種類です。
        /// </summary>
        override public DataType DataType
        {
            get { return DataType.Root; }
        }

        /// <summary>
        /// データモデルを複製します。
        /// </summary>
        override public DataModelBase Clone()
        {
            RootDataModel newDataModel = new RootDataModel();
            newDataModel.SubFont = this.SubFont?.Clone();

            return newDataModel;
        }

        /// <summary>
        /// データモデルをコピーします。
        /// </summary>
        override public bool CopyParam(DataModelBase dataModel, bool copyChild)
        {
            RootDataModel dm = dataModel as RootDataModel;
            if (dm == null) return false;

            if (copyChild)
            {
                this.SubFont = dm.SubFont;
            }

            return true;
        }

        /// <summary>
        /// 子ノードとして追加可能かどうかを返します。
        /// </summary>
        override public bool CanAddChild(DataModelBase dataModel)
        {
            if (dataModel is PairFontDataModel ||
                dataModel is BitmapFontDataModel ||
                dataModel is ScalableFontDataModel ||
                dataModel is MultiScalableFontDataModel)
            {
                if ( this.SubFont == null)
                {
                    return true;
                }
            }

            return false;
        }

        /// <summary>
        /// 表示名です。
        /// </summary>
        override public string ToString()
        {
            return DataType.ToString();
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public RootDataModel()
        {
            ComplexFontDescription cfd = new ComplexFontDescription();
            _version = cfd.version;
        }
    }
}
