﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FcpxMaker.DataModel
{
    using static FcpxMaker.Type;

    public class DataModelFactory
    {
        /// <summary>
        /// データの種類からデータモデルを生成します。
        /// </summary>
        static public DataModelBase CreateDataModel(DataType type)
        {
            DataModelBase dataModel = null;

            switch (type)
            {
                case DataType.None:
                    dataModel = new DataModelBase();
                    break;
                case DataType.Root:
                    dataModel = new RootDataModel();
                    break;
                case DataType.PairFont:
                    dataModel = new PairFontDataModel();
                    break;
                case DataType.BitmapFont:
                    dataModel = new BitmapFontDataModel();
                    break;
                case DataType.ScalableFont:
                    dataModel = new ScalableFontDataModel();
                    break;
                case DataType.MultiScalableFont:
                    dataModel = new MultiScalableFontDataModel();
                    break;
                case DataType.ScalableFontDescription:
                    dataModel = new ScalableFontDescriptionDataModel();
                    break;
                case DataType.Font:
                    dataModel = new FontDataModel();
                    break;
            }

            return dataModel;
        }
    }
}
