﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;

namespace FcpxMaker
{
    [System.SerializableAttribute()]
    [System.Xml.Serialization.XmlRootAttribute("AppSetting", Namespace = "", IsNullable = false)]
    public class AppSetting
    {
        static private AppSetting _instance = null;

        /// <summary>
        /// ユーザーのアプリケーションデータのフォルダを取得します。
        /// </summary>
        [XmlIgnore]
        static public string AppSettingDirectory
        {
            get
            {
                return Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.LocalApplicationData), "Nintendo", "LayoutTools", "FcpxMaker");
            }
        }

        /// <summary>
        /// ユーザーのアプリケーションデータのパスを取得します。
        /// </summary>
        [XmlIgnore]
        static public string AppSettingFilePath
        {
            get
            {
                return Path.Combine(AppSettingDirectory, "setting.xml");
            }
        }

        /// <summary>
        /// AppSettingのインスタンスです。
        /// </summary>
        [XmlIgnore]
        static public AppSetting Inst
        {
            get
            {
                if (_instance == null)
                {
                    _instance = new AppSetting();
                }

                return _instance;
            }
        }

        /// <summary>
        /// ファイル選択ダイアログの初期ディレクトリです。
        /// </summary>
        public string FcpxOpenDialogDefaultDirectory { get; set; }

        /// <summary>
        /// フォント選択ダイアログの初期ディレクトリです。
        /// </summary>
        public string FontOpenDialogDefaultDirectory { get; set; }

        /// <summary>
        /// ファイル保存ダイアログの初期ディレクトリです。
        /// </summary>
        public string FcpxSaveDialogDefaultDirectory { get; set; }

        /// <summary>
        /// メインウィンドウの幅です。
        /// </summary>
        public int MainWindowWidth { get; set; } = 600;

        /// <summary>
        /// メインウィンドウ高さのです。
        /// </summary>
        public int MainWindowHeight { get; set; } = 600;

        /// <summary>
        /// スプリットコンテナの境界線位置です。
        /// </summary>
        public int SplitterDistance { get; set; } = 232;

        /// <summary>
        /// パラメータをコピーします。
        /// </summary>
        public void CopyParam(AppSetting input)
        {
            _instance.FcpxOpenDialogDefaultDirectory = input.FcpxOpenDialogDefaultDirectory;
            _instance.FontOpenDialogDefaultDirectory = input.FontOpenDialogDefaultDirectory;
            _instance.FcpxSaveDialogDefaultDirectory = input.FcpxSaveDialogDefaultDirectory;
            _instance.MainWindowWidth = input.MainWindowWidth;
            _instance.MainWindowHeight = input.MainWindowHeight;
            _instance.SplitterDistance = input.SplitterDistance;
        }
    }
}
