﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Linq;
using LayoutEditor.Plugin;
using LayoutEditor.Forms.ToolWindows.PropertyEditWindow;
using LECore.Structures;
using LECore.Manipulator;
using System.Windows.Forms;

namespace LayoutEditor.PluginSample
{
    /// <summary>
    /// ページプラグインサンプル ～其の壱～
    /// </summary>
    public class PagePluginSample1 : PagePluginBase
    {
        //-------------------------------------------------------
        #region デザイナ変数

        private System.Windows.Forms.Button button1;
        #endregion

        #region デザイナコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            this.button1 = new System.Windows.Forms.Button();
            this.SuspendLayout();
            //
            // button1
            //
            this.button1.Location = new System.Drawing.Point(108, 53);
            this.button1.Name = "button1";
            this.button1.Size = new System.Drawing.Size(81, 27);
            this.button1.TabIndex = 0;
            this.button1.Text = "add";
            this.button1.UseVisualStyleBackColor = true;
            this.button1.Click += new System.EventHandler(this.button1_Click);
            //
            // PagePluginSample1
            //
            this.Controls.Add(this.button1);
            this.Name = "PagePluginSample1";
            this.ResumeLayout(false);

        }
        #endregion

        //-------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        protected PagePluginSample1()
        {
            this.InitializeComponent();

            this.TargetManipulator = new UserDataHolderManipulator();
        }

        /// <summary>
        /// インスタンスを作成します。
        /// </summary>
        /// <param name="arg">作成パラメータ</param>
        /// <returns>インスタンスを返します。</returns>
        public static PropertyPage CreateInstance (object arg)
        {
            var page = new PagePluginSample1();
            page.OwnerPane = arg as IPane;

            return page;
        }

        /// <summary>
        /// プロパティを初期化します。
        /// </summary>
        protected override void InitializeProperty()
        {
        }

        /// <summary>
        /// プロパティを更新します。
        /// </summary>
        protected override void UpdateProperty()
        {
            this.TargetManipulator.BindTarget(this.TargetPane.IUserDataHolder);
        }

        /// <summary>
        /// ボタンが押されたときの処理を行います。
        /// </summary>
        /// <param name="sender">イベントの発生元</param>
        /// <param name="e">イベント情報</param>
        private void button1_Click(object sender, EventArgs e)
        {
            // ユーザー拡張データに値を追加する
            // 2回目以降は追加されない
            this.TargetManipulator.AddUserDataElement("PagePluginData", UserDataKind.String, "PagePluginValue");

            MessageBox.Show("Added.");
        }

        /// <summary>
        /// ノード名を取得します。
        /// </summary>
        public static string NodeName
        {
            get
            {
                return typeof(PagePluginSample1).Name;
            }
        }

        /// <summary>
        /// インスタンスを作成するデリゲートを取得します。
        /// DLLからstaticメソッドのデリゲートを取得するための対応です。
        /// </summary>
        public static CreatePropertyPageFunction CreateInstanceDelegate
        {
            get
            {
                return CreateInstance;
            }
        }

        /// <summary>
        /// ページの表示内容と関係しているペインを取得または設定します。
        /// peneAdapterからマテリアル操作クラスを取得する際のキーとして利用します。
        /// </summary>
        private IPane OwnerPane { get; set; }

        /// <summary>
        /// 操作対象ペインを操作するクラスを取得します。
        /// </summary>
        private IPane TargetPane
        {
            get
            {
                PaneManipulator paneManipulator = null;

                if (this.OwnerPane != null)
                {
                    paneManipulator = this.Target.Active.PartsSubPaneManipulators.FirstOrDefault(mnp => object.ReferenceEquals(mnp.IPane, this.OwnerPane)) as PaneManipulator;
                }
                else
                {
                    paneManipulator = this.Target.Active.PaneManipulator;
                }

                return paneManipulator.IPane;
            }
        }

        /// <summary>
        /// 操作対象ペインを操作するオブジェクトを取得または設定します。
        /// </summary>
        private UserDataHolderManipulator TargetManipulator { get; set; }
    }
}
