﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// NWFontCafe.h

#pragma once

#include <dolphin/gx/GXEnum.h>
#include <windows.h>
#include <string>
#ifdef GENERIC
#include <cstdint>
#endif

namespace NW4R
{
    namespace Font
    {
        namespace UnManaged
        {
            struct FontInformation;

            class TextureConvertUtility
            {
            public:
                static std::wstring PlatformName;
                static std::wstring ToolsPath;
                //static NW4F::LayoutBinaryConverter::REncoder* encoder;

                static bool InitializeOpenGL(void* deviceContext);
                static void SetPlatform(void* platformName, void* toolsPath); // プラットフォームとツールパスをwchar_t*で渡す
                static bool FinalizeOpenGL();
                static void* BuildNewTextureRGBAImage(void* pFontInfo, void* pPtrOffsetBase);
                static bool IsNeededToSrgbFetchFormat(void* pFontTextureGlyph);
                static bool IsNeededToSrgbFetchFormat(u16 sheetFormat);
                static bool GetPlatform(void* pFontInfo, void* pPtrOffsetBase, char* platform, size_t platformBufferSize);
            };
            // end of namespace
        }
    }
}

namespace NWFontCafe
{
    public ref class TextureConvertUtility : public NW4R::Font::ITextureConvertUtility
    {
    public:

        virtual System::UInt32 GetFontResourceVersion() override
        {
#if GENERIC
            return (4 << 24) | (1 << 16) |(0 << 8) |(0 << 0 );
#else
            return (3 << 0) | (0 << 8) |(0 << 16) |(0 << 24);
#endif
            // フォントバイナリのバージョン
        }

        virtual void SetPlatform(System::IntPtr platformName, System::IntPtr toolsPath) override
        {
            NW4R::Font::UnManaged::TextureConvertUtility::SetPlatform((void*)platformName, (void*)toolsPath);
        }

        virtual bool InitializeOpenGL(System::IntPtr deviceContext) override
        {
            return NW4R::Font::UnManaged::TextureConvertUtility::InitializeOpenGL((void*)deviceContext);
        }

        virtual bool FinalizeOpenGL() override
        {
            return NW4R::Font::UnManaged::TextureConvertUtility::FinalizeOpenGL();
        }

        virtual System::IntPtr BuildNewTextureRGBAImage(System::IntPtr pFontInfo, System::IntPtr pPtrOffsetBase) override
        {
            try
            {
                return (System::IntPtr)NW4R::Font::UnManaged::TextureConvertUtility::BuildNewTextureRGBAImage((void*)pFontInfo, (void*)pPtrOffsetBase);
            }
            catch (std::string e)
            {
                // RuntimeWrappedException で扱ってもらえるように、マネージ型で例外を投げなおします。
                throw gcnew System::String(e.c_str());
            }
        }

        virtual bool IsNeededToSrgbFetchFormat(System::IntPtr pFontTextureGlyph) override
        {
            return NW4R::Font::UnManaged::TextureConvertUtility::IsNeededToSrgbFetchFormat((void*)pFontTextureGlyph);
        }

        virtual bool IsNeededToSrgbFetchFormat(u16 format) override
        {
            return NW4R::Font::UnManaged::TextureConvertUtility::IsNeededToSrgbFetchFormat(format);
        }

        virtual bool IsFontResourceBigEndian() override
        {
#if GENERIC
            return false;
#else
            return false;
#endif
        }

        virtual System::String^ GetPlatform(System::IntPtr pFontInfo, System::IntPtr pPtrOffsetBase) override
        {
            char platform[8];
            if (NW4R::Font::UnManaged::TextureConvertUtility::GetPlatform((void*)pFontInfo, (void*)pPtrOffsetBase, platform, sizeof(platform)/sizeof(char)))
            {
                return gcnew System::String(platform);
            }

            return nullptr;
        }
    };

} // NWFontCafe
