﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Windows.Forms;

namespace LayoutEditor.Utility
{
    /// <summary>
    /// 待機カーソルクラス。
    /// </summary>
    public class WaitCursor : IDisposable
    {
        // カレントカーソル
        private readonly Cursor _cursor = Cursor.Current;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public WaitCursor()
        {
            // 待機カーソルに変更
            Cursor.Current = Cursors.WaitCursor;
        }

        /// <summary>
        /// リセット。
        /// </summary>
        public void Reset()
        {
            Cursor.Current = Cursors.WaitCursor;
        }

        #region IDisposable実装
        /// <summary>
        /// インタフェース実装。
        /// </summary>
        public void Dispose()
        {
            // カーソルを元に戻す
            Cursor.Current = _cursor;
        }
        #endregion
    }
}
