﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters;
using LECore.Structures.Core;
using System.Collections.Generic;

namespace LayoutEditor.Utility
{
    /// <summary>
    /// PaneGuiAdapterGroup用のヘルパーです。
    /// </summary>
    public static class PaneGuiAdapterGroupHelper
    {
        /// <summary>
        /// TransIAttrを取得します。
        /// </summary>
        public static IAnmAttribute[] GetTransIAttr(PaneGuiAdapterGroup adapterGroup)
        {
            List<IAnmAttribute> attrs = new List<IAnmAttribute>();
            foreach (IBaseGuiAdapter adapter in adapterGroup.Objects)
            {
                IAnmAttribute attr = adapter?.Target?.IPaneAttribute?.TransIAttr;
                if (attr != null)
                {
                    attrs.Add(attr);
                }
            }

            return attrs.ToArray();
        }

        /// <summary>
        /// SizeIAttrを取得します。
        /// </summary>
        public static IAnmAttribute[] GetSizeIAttr(PaneGuiAdapterGroup adapterGroup)
        {
            List<IAnmAttribute> attrs = new List<IAnmAttribute>();
            foreach (IBaseGuiAdapter adapter in adapterGroup.Objects)
            {
                IAnmAttribute attr = adapter?.Target?.IPaneAttribute?.SizeIAttr;
                if (attr != null)
                {
                    attrs.Add(attr);
                }
            }

            return attrs.ToArray();
        }

        /// <summary>
        /// ScaleIAttrを取得します。
        /// </summary>
        public static IAnmAttribute[] GetScaleIAttr(PaneGuiAdapterGroup adapterGroup)
        {
            List<IAnmAttribute> attrs = new List<IAnmAttribute>();
            foreach (IBaseGuiAdapter adapter in adapterGroup.Objects)
            {
                IAnmAttribute attr = adapter?.Target?.IPaneAttribute?.ScaleIAttr;
                if (attr != null)
                {
                    attrs.Add(attr);
                }
            }

            return attrs.ToArray();
        }

        /// <summary>
        /// RotAngIAttrを取得します。
        /// </summary>
        public static IAnmAttribute[] GetRotAngIAttr(PaneGuiAdapterGroup adapterGroup)
        {
            List<IAnmAttribute> attrs = new List<IAnmAttribute>();
            foreach (IBaseGuiAdapter adapter in adapterGroup.Objects)
            {
                IAnmAttribute attr = adapter?.Target?.IPaneAttribute?.RotAngIAttr;
                if (attr != null)
                {
                    attrs.Add(attr);
                }
            }

            return attrs.ToArray();
        }

        /// <summary>
        /// TransparencyIAttrを取得します。
        /// </summary>
        public static IAnmAttribute[] GetTransparencyIAttr(PaneGuiAdapterGroup adapterGroup)
        {
            List<IAnmAttribute> attrs = new List<IAnmAttribute>();
            foreach (IBaseGuiAdapter adapter in adapterGroup.Objects)
            {
                IAnmAttribute attr = adapter?.Target?.IPaneAttribute?.TransparencyIAttr;
                if (attr != null)
                {
                    attrs.Add(attr);
                }
            }

            return attrs.ToArray();
        }

        /// <summary>
        /// VisibleIAttrを取得します。
        /// </summary>
        public static IAnmAttribute[] GetVisibleIAttr(PaneGuiAdapterGroup adapterGroup)
        {
            List<IAnmAttribute> attrs = new List<IAnmAttribute>();
            foreach (IBaseGuiAdapter adapter in adapterGroup.Objects)
            {
                IAnmAttribute attr = adapter?.Target?.IPaneAttribute?.VisibleIAttr;
                if (attr != null)
                {
                    attrs.Add(attr);
                }
            }

            return attrs.ToArray();
        }

        /// <summary>
        /// BlackColorIAnmAttrを取得します。
        /// </summary>
        public static IAnmAttribute[] GetBlackColorIAnmAttr(PaneGuiAdapterGroup adapterGroup)
        {
            List<IAnmAttribute> attrs = new List<IAnmAttribute>();
            foreach (IBaseGuiAdapter adapter in adapterGroup.Objects)
            {
                PaneGUIAdapter peneAdapter = adapter as PaneGUIAdapter;

                if (peneAdapter != null)
                {
                    foreach (MaterialGUIAdapter matAdapter in peneAdapter.MaterialAdapters)
                    {
                        IAnmAttribute attr = matAdapter?.IMaterial?.BlackColorIAnmAttr;
                        if (attr != null)
                        {
                            attrs.Add(attr);
                        }
                    }
                }
            }

            return attrs.ToArray();
        }

        /// <summary>
        /// WhiteColorIAnmAttrを取得します。
        /// </summary>
        public static IAnmAttribute[] GetWhiteColorIAnmAttr(PaneGuiAdapterGroup adapterGroup)
        {
            List<IAnmAttribute> attrs = new List<IAnmAttribute>();
            foreach (IBaseGuiAdapter adapter in adapterGroup.Objects)
            {
                PaneGUIAdapter peneAdapter = adapter as PaneGUIAdapter;

                if (peneAdapter != null)
                {
                    foreach (MaterialGUIAdapter matAdapter in peneAdapter.MaterialAdapters)
                    {
                        IAnmAttribute attr = matAdapter?.IMaterial?.WhiteColorIAnmAttr;
                        if (attr != null)
                        {
                            attrs.Add(attr);
                        }
                    }
                }
            }

            return attrs.ToArray();
        }

        /// <summary>
        /// TopColorIAnmAttrを取得します。
        /// </summary>
        public static IAnmAttribute[] GetTopColorIAnmAttr(PaneGuiAdapterGroup adapterGroup)
        {
            List<IAnmAttribute> attrs = new List<IAnmAttribute>();
            foreach (IBaseGuiAdapter adapter in adapterGroup.Objects)
            {
                IAnmAttribute attr = adapter?.Target?.ITextBox?.TopColorIAnmAttr;
                if (attr != null)
                {
                    attrs.Add(attr);
                }
            }

            return attrs.ToArray();
        }

        /// <summary>
        /// BottomColorIAnmAttrを取得します。
        /// </summary>
        public static IAnmAttribute[] GetBottomColorIAnmAttr(PaneGuiAdapterGroup adapterGroup)
        {
            List<IAnmAttribute> attrs = new List<IAnmAttribute>();
            foreach (IBaseGuiAdapter adapter in adapterGroup.Objects)
            {
                IAnmAttribute attr = adapter?.Target?.ITextBox?.BottomColorIAnmAttr;
                if (attr != null)
                {
                    attrs.Add(attr);
                }
            }

            return attrs.ToArray();
        }

        /// <summary>
        /// ShadowBlackColorIAnmAttrを取得します。
        /// </summary>
        public static IAnmAttribute[] GetShadowBlackColorIAnmAttr(PaneGuiAdapterGroup adapterGroup)
        {
            List<IAnmAttribute> attrs = new List<IAnmAttribute>();
            foreach (IBaseGuiAdapter adapter in adapterGroup.Objects)
            {
                IAnmAttribute attr = adapter?.Target?.ITextBox?.ShadowBlackColorIAnmAttr;
                if (attr != null)
                {
                    attrs.Add(attr);
                }
            }

            return attrs.ToArray();
        }

        /// <summary>
        /// ShadowWhiteColorIAnmAttrを取得します。
        /// </summary>
        public static IAnmAttribute[] GetShadowWhiteColorIAnmAttr(PaneGuiAdapterGroup adapterGroup)
        {
            List<IAnmAttribute> attrs = new List<IAnmAttribute>();
            foreach (IBaseGuiAdapter adapter in adapterGroup.Objects)
            {
                IAnmAttribute attr = adapter?.Target?.ITextBox?.ShadowWhiteColorIAnmAttr;
                if (attr != null)
                {
                    attrs.Add(attr);
                }
            }

            return attrs.ToArray();
        }

        /// <summary>
        /// PerCharTransformTimeOffsetIAnmAttrを取得します。
        /// </summary>
        public static IAnmAttribute[] GetPerCharTransformTimeOffsetIAnmAttr(PaneGuiAdapterGroup adapterGroup)
        {
            List<IAnmAttribute> attrs = new List<IAnmAttribute>();
            foreach (IBaseGuiAdapter adapter in adapterGroup.Objects)
            {
                IAnmAttribute attr = adapter?.Target?.ITextBox?.PerCharTransformTimeOffsetIAnmAttr;
                if (attr != null)
                {
                    attrs.Add(attr);
                }
            }

            return attrs.ToArray();
        }

        /// <summary>
        /// PerCharTransformTimeWidthIAnmAttrを取得します。
        /// </summary>
        public static IAnmAttribute[] GetPerCharTransformTimeWidthIAnmAttr(PaneGuiAdapterGroup adapterGroup)
        {
            List<IAnmAttribute> attrs = new List<IAnmAttribute>();
            foreach (IBaseGuiAdapter adapter in adapterGroup.Objects)
            {
                IAnmAttribute attr = adapter?.Target?.ITextBox?.PerCharTransformTimeWidthIAnmAttr;
                if (attr != null)
                {
                    attrs.Add(attr);
                }
            }

            return attrs.ToArray();
        }
    }
}
