﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using LECore.Structures.Core;
using LayoutEditor.Structures.SerializableObject;
using LECore.Structures.SerializableObject.Lyt;
using System.Windows.Forms;

namespace LayoutEditor
{
    /// <summary>
    /// レンダラのファクトリです。
    /// </summary>
    public static class RendererFactory
    {
        /// <summary>
        /// レンダラを構築します。
        /// </summary>
        public static IRenderer Create(AppSetting.RendererType rendererKind)
        {
            switch (rendererKind)
            {
                case AppSetting.RendererType.D3D:
                    // CRTの動的ロード処理を回避するため、
                    // 明示的にコンストラクタを呼び出すコードを記述しています。
                    // _renderer = new D3DRenderer();
                    Type type = Type.GetType("LayoutEditor.DynamicBinding.D3DRenderer");
                    System.Reflection.ConstructorInfo constructorInfo = type.GetConstructor(Type.EmptyTypes);
                    return constructorInfo.Invoke(null) as IRenderer;
                case AppSetting.RendererType.GDI:

                    return new GDIRenderer();
                default:
                    return null;
            }
        }

        /// <summary>
        /// コントロールの初期化設定を取得します。
        /// </summary>
        /// <param name="rendererKind"></param>
        /// <returns></returns>
        public static ControlStyles GetControlState(AppSetting.RendererType rendererKind)
        {
            //---------------------------------------------------
            // レンダラを初期化します。
            switch (rendererKind)
            {
                case AppSetting.RendererType.D3D:
                    return
                        ControlStyles.AllPaintingInWmPaint |// ちらつき抑える
                        ControlStyles.Opaque;               // 背景は描画しない
                case AppSetting.RendererType.GDI:
                    return
                        ControlStyles.AllPaintingInWmPaint |
                        ControlStyles.DoubleBuffer;
                default:
                    return 0;
            }
        }
    }
}
