﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using System.Drawing;
using System.Windows.Forms;

using System.Reflection;
using System.Diagnostics;

namespace LayoutEditor
{
    /// <summary>
    /// ImageResMgr の概要の説明です。
    /// </summary>
    public sealed class ImageResMgr
    {
        static ImageResMgr(){}

        #region マニフェストリソース
        /// <summary>
        /// マニフェストリソースを取得。
        /// </summary>
        public static Stream GetManifestResourceStream(string name)
        {
            string resourceName   = "LayoutEditor.res." + name;
            Stream resourceStream = Assembly.GetExecutingAssembly().GetManifestResourceStream(resourceName);
            Debug.Assert(resourceStream != null, string.Format("マニフェストリソース '{0}' が見つかりません。", resourceName));
            return resourceStream;
        }

        /// <summary>
        /// マニフェストリソースビットマップを取得。
        /// </summary>
        public static Bitmap GetManifestResourceBitmap(string name)
        {
            return new Bitmap(GetManifestResourceStream("bmp." + name));
        }

        /// <summary>
        /// マニフェストリソースアイコンを取得。
        /// </summary>
        public static Icon GetManifestResourceIcon(string name)
        {
            return new Icon(GetManifestResourceStream("ico." + name));
        }

        /// <summary>
        /// マニフェストリソースアイコンを取得。
        /// </summary>
        public static Bitmap GetManifestResourcePng(string name)
        {
            return new Bitmap(GetManifestResourceStream("png." + name));
        }

        /// <summary>
        /// マニフェストリソースカーソルを取得。
        /// </summary>
        public static Cursor GetManifestResourceCursor(string name)
        {
            return new Cursor(GetManifestResourceStream("cur." + name));
        }

        /// <summary>
        /// シェーダを取得。
        /// </summary>
        public static Stream GetShader(string name)
        {
            return GetManifestResourceStream("shader." + name);
        }

        #endregion
    }
}
