﻿using LECore.Structures;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace LayoutEditor.src.Forms.ToolWindows.StateSettingWindow
{
    public partial class EditTransitionTrackDlg : Form
    {
        Action _OnOkAction { get; set; }

        public float Offset { get { return (float)_nudOffset.Value; } set { _nudOffset.Value = (Decimal)value; } }

        public float Duration { get { return (float)_nudDuration.Value; } set { _nudDuration.Value = (Decimal)value; } }

        public EasingType EasingType
        {
            get
            {
                EasingType type = EasingType.Linear;

                if (_cmbEasingKind.SelectedItem != null)
                {
                    Enum.TryParse<EasingType>(_cmbEasingKind.SelectedItem.ToString(), out type);
                }
                return type;
            }
        }

        public float EasingExtraParamater { get { return (float)_nudEasingParamater.Value; } set { _nudEasingParamater.Value = (Decimal)value; } }

        //----------------------------------------------------------

        public EditTransitionTrackDlg()
        {
            InitializeComponent();

            {
                _cmbEasingKind.Items.Clear();
                foreach (var kind in Enum.GetValues(typeof(EasingType)))
                {
                    _cmbEasingKind.Items.Add(kind.ToString());
                }
            }
        }

        //----------------------------------------------------------

        public void Setup(IStateMachine stateMachine, IStateTransitionTrack track, Action onOkAction)
        {
            _OnOkAction = onOkAction;

            var layer = stateMachine.GetSelectedIStateLayer();
            if (layer == null)
            {
                Debug.Assert(false);
                return;
            }

            if(track == null)
            {
                Debug.Assert(false);
                return;
            }

            this.Offset = track.Offset;
            this.Duration = track.Duration;

            // EasingType
            _cmbEasingKind.SelectedIndex = _cmbEasingKind.FindStringExact(track.StateEasing.EasingType.ToString());
            this.EasingExtraParamater = track.StateEasing.EasingExtraParamater;

            _cmbEasingKind_SelectedIndexChanged(null, null);
        }

        void UpdateButtons_()
        {
            bool isValid = true;
            _btnOK.Enabled = isValid;
        }

        //----------------------------------------------------------

        private void AddPropertyDlg_Deactivate(object sender, EventArgs e)
        {
            this.Hide();
        }

        //----------------------------------------------------------

        public void ShowInEditMode()
        {
            Show();
        }

        //----------------------------------------------------------

        private void _btnOK_Click(object sender, EventArgs e)
        {
            if(_OnOkAction != null)
            {
                _OnOkAction();
            }

            this.Hide();
        }

        private void _cmbEasingKind_SelectedIndexChanged(object sender, EventArgs e)
        {
            _nudEasingParamater.Enabled = this.EasingType.UseExtraParamater();
        }
    }
}
