﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using LECore.Structures;

namespace LayoutEditor.src.Forms.ToolWindows.StateSettingWindow
{
    public partial class EditStateTrackKeyEventDlg : Form
    {
        Action _onOk;
        public EditStateTrackKeyEventDlg()
        {
            InitializeComponent();
        }

        public StateMachineEventKind StateMachineEventKind { get { return _pnlEventEdit.StateMachineEventKind; } }

        public object Param1 { get { return _pnlEventEdit.Param1; } }
        public object Param2 { get { return _pnlEventEdit.Param2; } }
        public uint Delay { get { return (uint)_pnlEventEdit.Delay; } }

        public void Setup(ISubScene subScene, uint delay, object param1, object param2, Action onOk)
        {
            _onOk = onOk;
            _pnlEventEdit.Setup(subScene, StateMachineEventKind.StateChangeRequested, delay, param1, param2);
        }

        private void EditStateTrackKeyEventPanel_Deactivate(object sender, EventArgs e)
        {
            Hide();
        }

        private void _btnOK_Click(object sender, EventArgs e)
        {
            _onOk();
            Hide();
        }
    }
}
