﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Diagnostics;
using System.Linq;
using System.Windows.Forms;
using System.Reflection;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow
{
    using Adapters;

    using LayoutEditor.Controls;
    using LECore.Manipulator;
    using LECore.Structures;
    using Pane;
    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow;
    using WindowKind = LECore.Structures.SerializableObject.Lyt.WindowKind;
    using LECore.Structures.Core;
    using Utility;
    using src.Controls;

    /// <summary>
    /// WindowPanePage の概要の説明です。
    /// </summary>
    public class WindowPanePage : PropertyPage
    {
        #region デザイナメンバ

        private System.Windows.Forms.GroupBox _grpFrame;
        private System.Windows.Forms.GroupBox _grpInflation;
        private System.Windows.Forms.GroupBox _grpContents;
        private System.Windows.Forms.GroupBox _grpTargetParts;
        private System.Windows.Forms.CheckBox _chkSameLeftRight;
        private System.Windows.Forms.CheckBox _chkSameTopBottom;
        private System.Windows.Forms.GroupBox _grpFlipRot;
        private LayoutEditor.Controls.UIRadioButton _radFlipRotTypeRot270;
        private LayoutEditor.Controls.UIRadioButton _radFlipRotTypeRot180;
        private LayoutEditor.Controls.UIRadioButton _radFlipRotTypeRot90;
        private LayoutEditor.Controls.UIRadioButton _radFlipRotTypeFlipV;
        private LayoutEditor.Controls.UIRadioButton _radFlipRotTypeFlipH;
        private LayoutEditor.Controls.UIRadioButton _radFlipRotTypeNone;
        private LayoutEditor.Controls.UINumericUpDown _nudInflationT;
        private LayoutEditor.Controls.UINumericUpDown _nudInflationB;
        private LayoutEditor.Controls.UINumericUpDown _nudInflationL;
        private LayoutEditor.Controls.UINumericUpDown _nudInflationR;
        private System.Windows.Forms.Label _lblInflationD;
        private System.Windows.Forms.Label _lblInflationU;
        private System.Windows.Forms.Label _lblInflationR;
        private System.Windows.Forms.Label _lblInflationL;
        private Button _btnCopyLTParamToAll;
        private GroupBox _grpVtxColor;
        private VertexColorEditPanel _pnlVtxColor;
        private Button button1;
        private Label lblCopy;
        private UICheckBox _chkUseLTMaterial;
        private UICheckBox _chkVtxColorForAllWindow;
        private UICheckBox _chkContentNotDraw;
        private Label _line;
        private LayoutEditor.Controls.DockContentToolTip _ttpMain;
        private System.ComponentModel.IContainer components;
        private LayoutEditor.src.Forms.ToolWindows.common.TextureCoordEdit _ctlTexCoord;
        private Label lblFrameSize;
        private Label label2;
        private Label label1;
        private Button _btnSetFrameSize;
        private CheckBox _chkSameFrameLR;
        private CheckBox _chkSameFrameTB;
        private Panel _pnlFrameSize;
        private Label _lblFrameSize;
        private src.Controls.BindAnimationLabel _lblVertexColor;
        private AnimationMarkNumericUpDown _nudFrameSizeT;
        private AnimationMarkNumericUpDown _nudFrameSizeR;
        private AnimationMarkNumericUpDown _nudFrameSizeL;
        private AnimationMarkNumericUpDown _nudFrameSizeB;
        private BindAnimationLabel _lblSizeRight;
        private BindAnimationLabel _lblSizeLeft;
        private BindAnimationLabel _lblSizeBottom;
        private BindAnimationLabel _lblSizeTop;
        private Label _lblContentNone;

        #endregion デザイナメンバ

        #region デザイナ生成コード
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(WindowPanePage));
            this._ttpMain = new LayoutEditor.Controls.DockContentToolTip(this.components);
            this._lblContentNone = new System.Windows.Forms.Label();
            this._grpFrame = new System.Windows.Forms.GroupBox();
            this._lblFrameSize = new System.Windows.Forms.Label();
            this._pnlFrameSize = new System.Windows.Forms.Panel();
            this._nudFrameSizeR = new LayoutEditor.src.Controls.AnimationMarkNumericUpDown();
            this._nudFrameSizeL = new LayoutEditor.src.Controls.AnimationMarkNumericUpDown();
            this._nudFrameSizeB = new LayoutEditor.src.Controls.AnimationMarkNumericUpDown();
            this._nudFrameSizeT = new LayoutEditor.src.Controls.AnimationMarkNumericUpDown();
            this._chkSameFrameTB = new System.Windows.Forms.CheckBox();
            this._chkSameFrameLR = new System.Windows.Forms.CheckBox();
            this._btnSetFrameSize = new System.Windows.Forms.Button();
            this.lblFrameSize = new System.Windows.Forms.Label();
            this.label2 = new System.Windows.Forms.Label();
            this.label1 = new System.Windows.Forms.Label();
            this._chkUseLTMaterial = new LayoutEditor.Controls.UICheckBox();
            this.lblCopy = new System.Windows.Forms.Label();
            this.button1 = new System.Windows.Forms.Button();
            this._btnCopyLTParamToAll = new System.Windows.Forms.Button();
            this._grpVtxColor = new System.Windows.Forms.GroupBox();
            this._lblVertexColor = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._chkVtxColorForAllWindow = new LayoutEditor.Controls.UICheckBox();
            this._pnlVtxColor = new LayoutEditor.Controls.VertexColorEditPanel();
            this._grpTargetParts = new System.Windows.Forms.GroupBox();
            this._grpFlipRot = new System.Windows.Forms.GroupBox();
            this._radFlipRotTypeRot270 = new LayoutEditor.Controls.UIRadioButton();
            this._radFlipRotTypeRot180 = new LayoutEditor.Controls.UIRadioButton();
            this._radFlipRotTypeRot90 = new LayoutEditor.Controls.UIRadioButton();
            this._radFlipRotTypeFlipV = new LayoutEditor.Controls.UIRadioButton();
            this._radFlipRotTypeFlipH = new LayoutEditor.Controls.UIRadioButton();
            this._radFlipRotTypeNone = new LayoutEditor.Controls.UIRadioButton();
            this._grpContents = new System.Windows.Forms.GroupBox();
            this._ctlTexCoord = new LayoutEditor.src.Forms.ToolWindows.common.TextureCoordEdit();
            this._line = new System.Windows.Forms.Label();
            this._chkContentNotDraw = new LayoutEditor.Controls.UICheckBox();
            this._grpInflation = new System.Windows.Forms.GroupBox();
            this._nudInflationR = new LayoutEditor.Controls.UINumericUpDown();
            this._nudInflationL = new LayoutEditor.Controls.UINumericUpDown();
            this._nudInflationB = new LayoutEditor.Controls.UINumericUpDown();
            this._nudInflationT = new LayoutEditor.Controls.UINumericUpDown();
            this._chkSameLeftRight = new System.Windows.Forms.CheckBox();
            this._chkSameTopBottom = new System.Windows.Forms.CheckBox();
            this._lblInflationD = new System.Windows.Forms.Label();
            this._lblInflationU = new System.Windows.Forms.Label();
            this._lblInflationR = new System.Windows.Forms.Label();
            this._lblInflationL = new System.Windows.Forms.Label();
            this._lblSizeTop = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblSizeBottom = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblSizeLeft = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblSizeRight = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._grpFrame.SuspendLayout();
            this._pnlFrameSize.SuspendLayout();
            this._grpVtxColor.SuspendLayout();
            this._grpTargetParts.SuspendLayout();
            this._grpFlipRot.SuspendLayout();
            this._grpContents.SuspendLayout();
            this._grpInflation.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._nudInflationR)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this._nudInflationL)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this._nudInflationB)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this._nudInflationT)).BeginInit();
            this.SuspendLayout();
            //
            // _lblContentNone
            //
            this._lblContentNone.BackColor = System.Drawing.SystemColors.Control;
            resources.ApplyResources(this._lblContentNone, "_lblContentNone");
            this._lblContentNone.Name = "_lblContentNone";
            this._ttpMain.SetToolTip(this._lblContentNone, resources.GetString("_lblContentNone.ToolTip"));
            //
            // _grpFrame
            //
            this._grpFrame.Controls.Add(this._lblFrameSize);
            this._grpFrame.Controls.Add(this._pnlFrameSize);
            this._grpFrame.Controls.Add(this._btnSetFrameSize);
            this._grpFrame.Controls.Add(this.lblFrameSize);
            this._grpFrame.Controls.Add(this.label2);
            this._grpFrame.Controls.Add(this.label1);
            this._grpFrame.Controls.Add(this._chkUseLTMaterial);
            this._grpFrame.Controls.Add(this.lblCopy);
            this._grpFrame.Controls.Add(this.button1);
            this._grpFrame.Controls.Add(this._btnCopyLTParamToAll);
            resources.ApplyResources(this._grpFrame, "_grpFrame");
            this._grpFrame.Name = "_grpFrame";
            this._grpFrame.TabStop = false;
            this._ttpMain.SetToolTip(this._grpFrame, resources.GetString("_grpFrame.ToolTip"));
            //
            // _lblFrameSize
            //
            this._lblFrameSize.BackColor = System.Drawing.SystemColors.Control;
            resources.ApplyResources(this._lblFrameSize, "_lblFrameSize");
            this._lblFrameSize.Name = "_lblFrameSize";
            this._ttpMain.SetToolTip(this._lblFrameSize, resources.GetString("_lblFrameSize.ToolTip"));
            //
            // _pnlFrameSize
            //
            this._pnlFrameSize.Controls.Add(this._lblSizeRight);
            this._pnlFrameSize.Controls.Add(this._lblSizeLeft);
            this._pnlFrameSize.Controls.Add(this._lblSizeBottom);
            this._pnlFrameSize.Controls.Add(this._lblSizeTop);
            this._pnlFrameSize.Controls.Add(this._nudFrameSizeR);
            this._pnlFrameSize.Controls.Add(this._nudFrameSizeL);
            this._pnlFrameSize.Controls.Add(this._nudFrameSizeB);
            this._pnlFrameSize.Controls.Add(this._nudFrameSizeT);
            this._pnlFrameSize.Controls.Add(this._chkSameFrameTB);
            this._pnlFrameSize.Controls.Add(this._chkSameFrameLR);
            resources.ApplyResources(this._pnlFrameSize, "_pnlFrameSize");
            this._pnlFrameSize.Name = "_pnlFrameSize";
            //
            // _nudFrameSizeR
            //
            this._nudFrameSizeR.DecimalPlace = 0;
            this._nudFrameSizeR.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            resources.ApplyResources(this._nudFrameSizeR, "_nudFrameSizeR");
            this._nudFrameSizeR.Maximum = new decimal(new int[] {
            10000,
            0,
            0,
            0});
            this._nudFrameSizeR.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this._nudFrameSizeR.Name = "_nudFrameSizeR";
            this._nudFrameSizeR.NumericUpDownBackColor = System.Drawing.SystemColors.Window;
            this._nudFrameSizeR.NumericUpDownSize = new System.Drawing.Size(64, 19);
            this._nudFrameSizeR.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._nudFrameSizeR.UseAnimationMark = true;
            this._nudFrameSizeR.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            //
            // _nudFrameSizeL
            //
            this._nudFrameSizeL.DecimalPlace = 0;
            this._nudFrameSizeL.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            resources.ApplyResources(this._nudFrameSizeL, "_nudFrameSizeL");
            this._nudFrameSizeL.Maximum = new decimal(new int[] {
            10000,
            0,
            0,
            0});
            this._nudFrameSizeL.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this._nudFrameSizeL.Name = "_nudFrameSizeL";
            this._nudFrameSizeL.NumericUpDownBackColor = System.Drawing.SystemColors.Window;
            this._nudFrameSizeL.NumericUpDownSize = new System.Drawing.Size(64, 19);
            this._nudFrameSizeL.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._nudFrameSizeL.UseAnimationMark = true;
            this._nudFrameSizeL.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            //
            // _nudFrameSizeB
            //
            this._nudFrameSizeB.DecimalPlace = 0;
            this._nudFrameSizeB.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            resources.ApplyResources(this._nudFrameSizeB, "_nudFrameSizeB");
            this._nudFrameSizeB.Maximum = new decimal(new int[] {
            10000,
            0,
            0,
            0});
            this._nudFrameSizeB.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this._nudFrameSizeB.Name = "_nudFrameSizeB";
            this._nudFrameSizeB.NumericUpDownBackColor = System.Drawing.SystemColors.Window;
            this._nudFrameSizeB.NumericUpDownSize = new System.Drawing.Size(64, 19);
            this._nudFrameSizeB.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._nudFrameSizeB.UseAnimationMark = true;
            this._nudFrameSizeB.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            //
            // _nudFrameSizeT
            //
            this._nudFrameSizeT.DecimalPlace = 0;
            this._nudFrameSizeT.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            resources.ApplyResources(this._nudFrameSizeT, "_nudFrameSizeT");
            this._nudFrameSizeT.Maximum = new decimal(new int[] {
            10000,
            0,
            0,
            0});
            this._nudFrameSizeT.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this._nudFrameSizeT.Name = "_nudFrameSizeT";
            this._nudFrameSizeT.NumericUpDownBackColor = System.Drawing.SystemColors.Window;
            this._nudFrameSizeT.NumericUpDownSize = new System.Drawing.Size(64, 19);
            this._nudFrameSizeT.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._nudFrameSizeT.UseAnimationMark = true;
            this._nudFrameSizeT.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            //
            // _chkSameFrameTB
            //
            resources.ApplyResources(this._chkSameFrameTB, "_chkSameFrameTB");
            this._chkSameFrameTB.Name = "_chkSameFrameTB";
            this._chkSameFrameTB.CheckedChanged += new System.EventHandler(this.Event_ChkFrameSame_CheckedChanged);
            //
            // _chkSameFrameLR
            //
            resources.ApplyResources(this._chkSameFrameLR, "_chkSameFrameLR");
            this._chkSameFrameLR.Name = "_chkSameFrameLR";
            this._chkSameFrameLR.CheckedChanged += new System.EventHandler(this.Event_ChkFrameSame_CheckedChanged);
            //
            // _btnSetFrameSize
            //
            resources.ApplyResources(this._btnSetFrameSize, "_btnSetFrameSize");
            this._btnSetFrameSize.Name = "_btnSetFrameSize";
            this._btnSetFrameSize.UseVisualStyleBackColor = true;
            this._btnSetFrameSize.Click += new System.EventHandler(this.Event_btnSetFrameSize_Click);
            //
            // lblFrameSize
            //
            resources.ApplyResources(this.lblFrameSize, "lblFrameSize");
            this.lblFrameSize.Name = "lblFrameSize";
            //
            // label2
            //
            resources.ApplyResources(this.label2, "label2");
            this.label2.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.label2.Name = "label2";
            //
            // label1
            //
            resources.ApplyResources(this.label1, "label1");
            this.label1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.label1.Name = "label1";
            //
            // _chkUseLTMaterial
            //
            resources.ApplyResources(this._chkUseLTMaterial, "_chkUseLTMaterial");
            this._chkUseLTMaterial.Name = "_chkUseLTMaterial";
            this._chkUseLTMaterial.CheckedChanged += new System.EventHandler(this.Event_ChkUseLTMaterial_CheckedChanged);
            //
            // lblCopy
            //
            resources.ApplyResources(this.lblCopy, "lblCopy");
            this.lblCopy.Name = "lblCopy";
            //
            // button1
            //
            resources.ApplyResources(this.button1, "button1");
            this.button1.Name = "button1";
            this.button1.UseVisualStyleBackColor = true;
            this.button1.Click += new System.EventHandler(this.Event_BtnCopyLTParamToFrameContent_Click);
            //
            // _btnCopyLTParamToAll
            //
            resources.ApplyResources(this._btnCopyLTParamToAll, "_btnCopyLTParamToAll");
            this._btnCopyLTParamToAll.Name = "_btnCopyLTParamToAll";
            this._btnCopyLTParamToAll.UseVisualStyleBackColor = true;
            this._btnCopyLTParamToAll.Click += new System.EventHandler(this.Event_BtnCopyLTParamToFrame_Click);
            //
            // _grpVtxColor
            //
            this._grpVtxColor.Controls.Add(this._lblVertexColor);
            this._grpVtxColor.Controls.Add(this._chkVtxColorForAllWindow);
            this._grpVtxColor.Controls.Add(this._pnlVtxColor);
            resources.ApplyResources(this._grpVtxColor, "_grpVtxColor");
            this._grpVtxColor.Name = "_grpVtxColor";
            this._grpVtxColor.TabStop = false;
            //
            // _lblVertexColor
            //
            resources.ApplyResources(this._lblVertexColor, "_lblVertexColor");
            this._lblVertexColor.Name = "_lblVertexColor";
            this._lblVertexColor.UseContextMenu = false;
            //
            // _chkVtxColorForAllWindow
            //
            resources.ApplyResources(this._chkVtxColorForAllWindow, "_chkVtxColorForAllWindow");
            this._chkVtxColorForAllWindow.Name = "_chkVtxColorForAllWindow";
            this._chkVtxColorForAllWindow.CheckedChanged += new System.EventHandler(this.Event_ChkVtxColorForAllWindow_CheckedChanged);
            //
            // _pnlVtxColor
            //
            resources.ApplyResources(this._pnlVtxColor, "_pnlVtxColor");
            this._pnlVtxColor.Name = "_pnlVtxColor";
            this._pnlVtxColor.UseAnimationMark = true;
            //
            // _grpTargetParts
            //
            this._grpTargetParts.Controls.Add(this._grpFlipRot);
            resources.ApplyResources(this._grpTargetParts, "_grpTargetParts");
            this._grpTargetParts.Name = "_grpTargetParts";
            this._grpTargetParts.TabStop = false;
            //
            // _grpFlipRot
            //
            this._grpFlipRot.Controls.Add(this._radFlipRotTypeRot270);
            this._grpFlipRot.Controls.Add(this._radFlipRotTypeRot180);
            this._grpFlipRot.Controls.Add(this._radFlipRotTypeRot90);
            this._grpFlipRot.Controls.Add(this._radFlipRotTypeFlipV);
            this._grpFlipRot.Controls.Add(this._radFlipRotTypeFlipH);
            this._grpFlipRot.Controls.Add(this._radFlipRotTypeNone);
            resources.ApplyResources(this._grpFlipRot, "_grpFlipRot");
            this._grpFlipRot.Name = "_grpFlipRot";
            this._grpFlipRot.TabStop = false;
            //
            // _radFlipRotTypeRot270
            //
            resources.ApplyResources(this._radFlipRotTypeRot270, "_radFlipRotTypeRot270");
            this._radFlipRotTypeRot270.Name = "_radFlipRotTypeRot270";
            //
            // _radFlipRotTypeRot180
            //
            resources.ApplyResources(this._radFlipRotTypeRot180, "_radFlipRotTypeRot180");
            this._radFlipRotTypeRot180.Name = "_radFlipRotTypeRot180";
            //
            // _radFlipRotTypeRot90
            //
            resources.ApplyResources(this._radFlipRotTypeRot90, "_radFlipRotTypeRot90");
            this._radFlipRotTypeRot90.Name = "_radFlipRotTypeRot90";
            //
            // _radFlipRotTypeFlipV
            //
            resources.ApplyResources(this._radFlipRotTypeFlipV, "_radFlipRotTypeFlipV");
            this._radFlipRotTypeFlipV.Name = "_radFlipRotTypeFlipV";
            //
            // _radFlipRotTypeFlipH
            //
            resources.ApplyResources(this._radFlipRotTypeFlipH, "_radFlipRotTypeFlipH");
            this._radFlipRotTypeFlipH.Name = "_radFlipRotTypeFlipH";
            //
            // _radFlipRotTypeNone
            //
            resources.ApplyResources(this._radFlipRotTypeNone, "_radFlipRotTypeNone");
            this._radFlipRotTypeNone.Name = "_radFlipRotTypeNone";
            //
            // _grpContents
            //
            this._grpContents.Controls.Add(this._ctlTexCoord);
            this._grpContents.Controls.Add(this._lblContentNone);
            this._grpContents.Controls.Add(this._line);
            this._grpContents.Controls.Add(this._chkContentNotDraw);
            this._grpContents.Controls.Add(this._grpInflation);
            resources.ApplyResources(this._grpContents, "_grpContents");
            this._grpContents.Name = "_grpContents";
            this._grpContents.TabStop = false;
            //
            // _ctlTexCoord
            //
            resources.ApplyResources(this._ctlTexCoord, "_ctlTexCoord");
            this._ctlTexCoord.Name = "_ctlTexCoord";
            //
            // _line
            //
            resources.ApplyResources(this._line, "_line");
            this._line.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this._line.Name = "_line";
            //
            // _chkContentNotDraw
            //
            resources.ApplyResources(this._chkContentNotDraw, "_chkContentNotDraw");
            this._chkContentNotDraw.Name = "_chkContentNotDraw";
            this._chkContentNotDraw.CheckedChanged += new System.EventHandler(this.Event_chkContentNone_CheckedChanged);
            //
            // _grpInflation
            //
            this._grpInflation.Controls.Add(this._nudInflationR);
            this._grpInflation.Controls.Add(this._nudInflationL);
            this._grpInflation.Controls.Add(this._nudInflationB);
            this._grpInflation.Controls.Add(this._nudInflationT);
            this._grpInflation.Controls.Add(this._chkSameLeftRight);
            this._grpInflation.Controls.Add(this._chkSameTopBottom);
            this._grpInflation.Controls.Add(this._lblInflationD);
            this._grpInflation.Controls.Add(this._lblInflationU);
            this._grpInflation.Controls.Add(this._lblInflationR);
            this._grpInflation.Controls.Add(this._lblInflationL);
            resources.ApplyResources(this._grpInflation, "_grpInflation");
            this._grpInflation.Name = "_grpInflation";
            this._grpInflation.TabStop = false;
            //
            // _nudInflationR
            //
            this._nudInflationR.DecimalPlaces = 2;
            resources.ApplyResources(this._nudInflationR, "_nudInflationR");
            this._nudInflationR.Maximum = new decimal(new int[] {
            10000,
            0,
            0,
            0});
            this._nudInflationR.Minimum = new decimal(new int[] {
            10000,
            0,
            0,
            -2147483648});
            this._nudInflationR.Name = "_nudInflationR";
            //
            // _nudInflationL
            //
            this._nudInflationL.DecimalPlaces = 2;
            resources.ApplyResources(this._nudInflationL, "_nudInflationL");
            this._nudInflationL.Maximum = new decimal(new int[] {
            10000,
            0,
            0,
            0});
            this._nudInflationL.Minimum = new decimal(new int[] {
            10000,
            0,
            0,
            -2147483648});
            this._nudInflationL.Name = "_nudInflationL";
            //
            // _nudInflationB
            //
            this._nudInflationB.DecimalPlaces = 2;
            resources.ApplyResources(this._nudInflationB, "_nudInflationB");
            this._nudInflationB.Maximum = new decimal(new int[] {
            10000,
            0,
            0,
            0});
            this._nudInflationB.Minimum = new decimal(new int[] {
            10000,
            0,
            0,
            -2147483648});
            this._nudInflationB.Name = "_nudInflationB";
            //
            // _nudInflationT
            //
            this._nudInflationT.DecimalPlaces = 2;
            resources.ApplyResources(this._nudInflationT, "_nudInflationT");
            this._nudInflationT.Maximum = new decimal(new int[] {
            10000,
            0,
            0,
            0});
            this._nudInflationT.Minimum = new decimal(new int[] {
            10000,
            0,
            0,
            -2147483648});
            this._nudInflationT.Name = "_nudInflationT";
            //
            // _chkSameLeftRight
            //
            resources.ApplyResources(this._chkSameLeftRight, "_chkSameLeftRight");
            this._chkSameLeftRight.Name = "_chkSameLeftRight";
            this._chkSameLeftRight.CheckedChanged += new System.EventHandler(this.Event_ChkSame_CheckedChanged);
            //
            // _chkSameTopBottom
            //
            resources.ApplyResources(this._chkSameTopBottom, "_chkSameTopBottom");
            this._chkSameTopBottom.Name = "_chkSameTopBottom";
            this._chkSameTopBottom.CheckedChanged += new System.EventHandler(this.Event_ChkSame_CheckedChanged);
            //
            // _lblInflationD
            //
            resources.ApplyResources(this._lblInflationD, "_lblInflationD");
            this._lblInflationD.Name = "_lblInflationD";
            //
            // _lblInflationU
            //
            resources.ApplyResources(this._lblInflationU, "_lblInflationU");
            this._lblInflationU.Name = "_lblInflationU";
            //
            // _lblInflationR
            //
            resources.ApplyResources(this._lblInflationR, "_lblInflationR");
            this._lblInflationR.Name = "_lblInflationR";
            //
            // _lblInflationL
            //
            resources.ApplyResources(this._lblInflationL, "_lblInflationL");
            this._lblInflationL.Name = "_lblInflationL";
            //
            // _lblSizeTop
            //
            resources.ApplyResources(this._lblSizeTop, "_lblSizeTop");
            this._lblSizeTop.Name = "_lblSizeTop";
            this._lblSizeTop.UseContextMenu = false;
            //
            // _lblSizeBottom
            //
            resources.ApplyResources(this._lblSizeBottom, "_lblSizeBottom");
            this._lblSizeBottom.Name = "_lblSizeBottom";
            this._lblSizeBottom.UseContextMenu = false;
            //
            // _lblSizeLeft
            //
            resources.ApplyResources(this._lblSizeLeft, "_lblSizeLeft");
            this._lblSizeLeft.Name = "_lblSizeLeft";
            this._lblSizeLeft.UseContextMenu = false;
            //
            // _lblSizeRight
            //
            resources.ApplyResources(this._lblSizeRight, "_lblSizeRight");
            this._lblSizeRight.Name = "_lblSizeRight";
            this._lblSizeRight.UseContextMenu = false;
            //
            // WindowPanePage
            //
            this.Controls.Add(this._grpVtxColor);
            this.Controls.Add(this._grpContents);
            this.Controls.Add(this._grpTargetParts);
            this.Controls.Add(this._grpFrame);
            this.Name = "WindowPanePage";
            resources.ApplyResources(this, "$this");
            this._grpFrame.ResumeLayout(false);
            this._grpFrame.PerformLayout();
            this._pnlFrameSize.ResumeLayout(false);
            this._pnlFrameSize.PerformLayout();
            this._grpVtxColor.ResumeLayout(false);
            this._grpVtxColor.PerformLayout();
            this._grpTargetParts.ResumeLayout(false);
            this._grpFlipRot.ResumeLayout(false);
            this._grpContents.ResumeLayout(false);
            this._grpInflation.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this._nudInflationR)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this._nudInflationL)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this._nudInflationB)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this._nudInflationT)).EndInit();
            this.ResumeLayout(false);

        }
        #endregion デザイナ生成コード

        #region プロパティ

        WindowFrameMaterialCopyDlg _windowFrameCopyDlg = new WindowFrameMaterialCopyDlg();

        /// <summary>
        /// 操作対象ペインを操作するクラスを取得します。
        /// </summary>
        public IWindowPaneAdapterEntry TargetEntry
        {
            get
            {
                return Target.Active.FindTargetWindowPaneAdapterEntry(_TargetIndex);
            }
        }

        /// <summary>
        /// 操作対象ペインを操作するクラスを取得します。
        /// </summary>
        public IEnumerable<IWindowPaneAdapterEntry> TargetEntries
        {
            get
            {
                return Target.Objects.Select(adpt => (adpt as PaneGUIAdapter).FindTargetWindowPaneAdapterEntry(_TargetIndex))
                    .Where(adpt => adpt != null);
            }
        }

        /// <summary>
        /// 複数が対象にある場合に、何番目を対象とするかを指定します。
        /// </summary>
        protected int _TargetIndex
        {
            get;
            set;
        }

        /// <summary>
        /// 操作対象ペインを操作するクラスを取得します。
        /// </summary>
        WindowManipulator _TargetWindowMpn
        {
            get { return TargetEntry?.Manipulator; }
        }

        /// <summary>
        /// 操作対象ペインを操作するクラスを取得します。
        /// </summary>
        IEnumerable<WindowManipulator> _TargetWindowMnps
        {
            get
            {
                return TargetEntries.Select(adpt => adpt.Manipulator).Where(mnp => mnp != null);
            }
        }

        /// <summary>
        /// ウインドウ内マテリアルの操作対象IDを取得します。
        /// </summary>
        LEWindowPartsID _TargetMatID
        {
            get { return TargetEntry != null ? TargetEntry.CurrentTargetPartsID : LEWindowPartsID.Content; }
        }

        /// <summary>
        /// 操作対象サブシーンを取得します。
        /// </summary>
        ISubScene _CurrentISubScene
        {
            get { return LECore.LayoutEditorCore.Scene.CurrentISubScene; }
        }

        /// @@@
        /// <summary>
        /// "左上のマテリアルを共有"が有効になっているのか調べます。
        /// </summary>
        bool EnabledUseLTMaterial
        {
            get
            {
                ILEWindow targetWindow = _TargetWindowMpn.ILEWindow;
                return ILEWindowHelper.IsEnabledUseLTMaterial(_TargetMatID, targetWindow);
            }
        }

        #endregion プロパティ

        //----------------------------------------------------------
        // 生成
        //----------------------------------------------------------

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public WindowPanePage()
        {
            InitializeComponent();

            // コンテキストメニューを追加する
            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(_lblVertexColor, _pnlVtxColor.AnimationMarkArray);

            // アニメーションマークを関連付ける
            _lblSizeTop.BindAnimationMark(_nudFrameSizeT.AnimationMarkInst);
            _lblSizeBottom.BindAnimationMark(_nudFrameSizeB.AnimationMarkInst);
            _lblSizeLeft.BindAnimationMark(_nudFrameSizeL.AnimationMarkInst);
            _lblSizeRight.BindAnimationMark(_nudFrameSizeR.AnimationMarkInst);
        }

        /// <summary>
        /// プロパティ初期化。
        ///
        /// GUIに関するユーザ独自の初期化処理を記述します。
        /// </summary>
        protected override void InitializeProperty()
        {
            //-------- フリップ・回転ラジオボタン
            _radFlipRotTypeNone.Tag = LEWindowFrameFlipRotate.None;
            _radFlipRotTypeFlipH.Tag = LEWindowFrameFlipRotate.FlipH;
            _radFlipRotTypeFlipV.Tag = LEWindowFrameFlipRotate.FlipV;
            _radFlipRotTypeRot90.Tag = LEWindowFrameFlipRotate.Rotate90;
            _radFlipRotTypeRot180.Tag = LEWindowFrameFlipRotate.Rotate180;
            _radFlipRotTypeRot270.Tag = LEWindowFrameFlipRotate.Rotate270;

            _radFlipRotTypeNone.CheckedChanged += Event_RadFlipRotType_CheckedChanged;
            _radFlipRotTypeFlipH.CheckedChanged += Event_RadFlipRotType_CheckedChanged;
            _radFlipRotTypeFlipV.CheckedChanged += Event_RadFlipRotType_CheckedChanged;
            _radFlipRotTypeRot90.CheckedChanged += Event_RadFlipRotType_CheckedChanged;
            _radFlipRotTypeRot180.CheckedChanged += Event_RadFlipRotType_CheckedChanged;
            _radFlipRotTypeRot270.CheckedChanged += Event_RadFlipRotType_CheckedChanged;

            //-------- コンテンツ領域：4隅頂点色
            _pnlVtxColor.ColorChange += new VertexColorEditPanel.OnColorChange( _pnlVtxColor_ColorChange );

            //-------- フレームサイズ
            _nudFrameSizeT.ValueChanged += Event_NudFrameSize_ValueChanged;
            _nudFrameSizeB.ValueChanged += Event_NudFrameSize_ValueChanged;
            _nudFrameSizeL.ValueChanged += Event_NudFrameSize_ValueChanged;
            _nudFrameSizeR.ValueChanged += Event_NudFrameSize_ValueChanged;

            //-------- コンテンツ領域：拡大量
            _nudInflationT.ValueChanged += Event_NudInflation_ValueChanged;
            _nudInflationB.ValueChanged += Event_NudInflation_ValueChanged;
            _nudInflationL.ValueChanged += Event_NudInflation_ValueChanged;
            _nudInflationR.ValueChanged += Event_NudInflation_ValueChanged;

            _ctlTexCoord.Initialize(() => NotifyPropertyChanged());

            // ViewManagerへのメッセージハンドラを設定します
            _nudFrameSizeT.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _nudFrameSizeB.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _nudFrameSizeL.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _nudFrameSizeR.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _pnlVtxColor.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
        }

        /// <summary>
        /// インスタンス作成。
        /// </summary>
        public static PropertyPage CreateInstance( object arg )
        {
            return new WindowPanePage();
        }

        #region UpdateProperty関連(データをGUIに設定する処理：再描画のたびに呼ばれます)

        /// <summary>
        /// コンテンツグループの状態を更新します。
        /// </summary>
        void UpdateProperty_ContentsGroup_()
        {
            // コンテンツグループの状態を更新します。
            _grpContents.Enabled = TargetEntry.CurrentTargetPartsID == LEWindowPartsID.Content;
            _grpVtxColor.Enabled = _TargetWindowMpn.ILEWindow.WindowKind == WindowKind.HorizontalNoContent ?
                true : _grpContents.Enabled;
        }

        /// <summary>
        /// GUIラジオボタンの状態を更新します。
        /// </summary>
        void UpdateProperty_FlipRotStateRadioButtons_()
        {
            //-------- フリップ・回転ラジオボタン
            LEWindowFrameFlipRotate flipRotState =
                _TargetWindowMpn.ILEWindow.GetMaterialFlipRotateState( _TargetMatID );
            _radFlipRotTypeNone.SetCheckedByTag( flipRotState );
            _radFlipRotTypeFlipH.SetCheckedByTag( flipRotState );
            _radFlipRotTypeFlipV.SetCheckedByTag( flipRotState );
            _radFlipRotTypeRot90.SetCheckedByTag( flipRotState );
            _radFlipRotTypeRot180.SetCheckedByTag( flipRotState );
            _radFlipRotTypeRot270.SetCheckedByTag( flipRotState );
        }

        /// <summary>
        /// GUIを更新します。
        /// </summary>
        protected override void UpdateProperty()
        {
            IWindowPaneAdapterEntry paneAdapter = TargetEntry;
            if (paneAdapter == null)
            {
                return;
            }

            // ターゲットを参照してUIを更新する
            ILEWindow targetWindow = _TargetWindowMpn.ILEWindow;

            _btnCopyLTParamToAll.Enabled = targetWindow.NumTexture != 2;

            // アニメーションマークとコンテキストメニューの有効無効
            bool bUse = CanUseAnimationMark(targetWindow?.OwnerPane?.OwnerSubScene);
            IEnumerable<IAnimationMarkUsable> animCtrlList = GetAnimationMarkUsableControl();
            foreach (IAnimationMarkUsable ctrl in animCtrlList)
            {
                ctrl.UseAnimationMark = bUse;
            }

            //-------- フリップ・回転ラジオボタン
            UpdateProperty_FlipRotStateRadioButtons_();


            //-------- フレーム
            bool frameSpecified = targetWindow.IsFrameSizeOrFrameSizeCurveSpecified;

            _btnSetFrameSize.Enabled = LECore.LayoutEditorCore.PlatformDetail.CustomWindowFrameSizeEnabled && _CurrentISubScene.IsBaseValueEditable();

            _pnlFrameSize.Enabled = frameSpecified;
            _btnSetFrameSize.Text = frameSpecified ? StringResMgr.Get("TAG_RESET") : StringResMgr.Get("TAG_SET");
            _nudFrameSizeB.Enabled = targetWindow.WindowKind == WindowKind.Around;
            _nudFrameSizeT.SetValue(Convert.ToDecimal(targetWindow.FrameSize.Top));
            _nudFrameSizeB.SetValue(Convert.ToDecimal(targetWindow.FrameSize.Bottom));
            _nudFrameSizeL.SetValue(Convert.ToDecimal(targetWindow.FrameSize.Left));
            _nudFrameSizeR.SetValue(Convert.ToDecimal(targetWindow.FrameSize.Right));

            //-------- 操作対象コンボボックス
            bool isUseLTMaterialEnabled = targetWindow.NumTexture != 2 && targetWindow.WindowKind == WindowKind.Around;
            _chkUseLTMaterial.Enabled = isUseLTMaterialEnabled;
            _chkUseLTMaterial.SetChecked(targetWindow.UseLTMaterial);

            // フリップ回転設定は、フレーム画像に対してのみ有効です。
            _grpFlipRot.Enabled = ((LEWindowPartsID.Content != TargetEntry.CurrentTargetPartsID) &&
                                   (targetWindow.NumTexture > 2));

            // コンテンツ書かないフラグ
            _chkContentNotDraw.SetChecked(targetWindow.NotDrawContent);

            //-------- コンテンツ領域：4隅頂点色
            _pnlVtxColor.Set(
                targetWindow.VtxCol_LT.AsColor,
                targetWindow.VtxCol_RT.AsColor,
                targetWindow.VtxCol_LB.AsColor,
                targetWindow.VtxCol_RB.AsColor);

            _chkVtxColorForAllWindow.Checked = targetWindow.UseVtxColorForAllWindow;
            _chkVtxColorForAllWindow.Enabled = targetWindow.WindowKind != WindowKind.HorizontalNoContent;

            //-------- コンテンツ領域：拡張量
            ILEWindowContentsInflation inflation = targetWindow.ContentsInflation;
            UINumericUpDown.InvokeEvent = false;
            _nudInflationT.Value = Convert.ToDecimal(inflation.Top);
            _nudInflationB.Value = Convert.ToDecimal(inflation.Bottom);
            _nudInflationL.Value = Convert.ToDecimal(inflation.Left);
            _nudInflationR.Value = Convert.ToDecimal(inflation.Right);
            UINumericUpDown.InvokeEvent = true;

            //-------- コンテンツ領域：テクスチャ座標数
            _ctlTexCoord.SetTarget(_TargetWindowMpn, _TargetWindowMnps, GetMultiEditColor());
            _ctlTexCoord.UpdateProperty();

            // コンテンツグループの状態を更新します。
            UpdateProperty_ContentsGroup_();

            // アニメーションマークで利用するアトリビュートを関連付け
            _nudFrameSizeT.SetTargetAttribute(targetWindow.FrameSizeIAnmAttr.FindSubAttributeByIdx(0));
            _nudFrameSizeB.SetTargetAttribute(targetWindow.FrameSizeIAnmAttr.FindSubAttributeByIdx(1));
            _nudFrameSizeL.SetTargetAttribute(targetWindow.FrameSizeIAnmAttr.FindSubAttributeByIdx(2));
            _nudFrameSizeR.SetTargetAttribute(targetWindow.FrameSizeIAnmAttr.FindSubAttributeByIdx(3));
            _pnlVtxColor.SetTargetAttribute(targetWindow);

            // アニメーションマークの更新
            foreach (IAnimationMarkUsable ctrl in animCtrlList)
            {
                ctrl.UpdateAnimationMark();
            }
        }

        /// <summary>
        /// ターゲット変更時に呼びだされます
        /// </summary>
        public override void OnTargetChangeHandler()
        {
        }

        /// <summary>
        /// アニメーションマークが利用可能なコントロールの一覧を取得する。
        /// </summary>
        protected override IEnumerable<IAnimationMarkUsable> GetAnimationMarkUsableControl()
        {
            List<IAnimationMarkUsable> list = new List<IAnimationMarkUsable>();

            list.Add(_lblSizeTop);
            list.Add(_lblSizeBottom);
            list.Add(_lblSizeLeft);
            list.Add(_lblSizeRight);
            list.Add(_lblVertexColor);
            list.Add(_nudFrameSizeT);
            list.Add(_nudFrameSizeB);
            list.Add(_nudFrameSizeL);
            list.Add(_nudFrameSizeR);
            list.Add(_pnlVtxColor);

            return list;
        }

        #endregion UpdateProperty関連(データをGUIに設定する処理：再描画のたびに呼ばれます)

        #region GUIイベントハンドラ

        /// <summary>
        /// フレームマテリアルをコピーします。
        /// </summary>
        void CopyWindowFrameMaterial_(

                                      LEWindowPartsID dstPartsID,
                                      PaneParamaterCopyOption option)
        {
            IPane ownerPane = TargetEntry.Manipulator.ILEWindow.OwnerPane;
            PaneManipulator mnp = new PaneManipulator();
            mnp.BindTarget(ownerPane);

            mnp.CopyMaterial(ownerPane, (int)LEWindowPartsID.CornerLT, (int)dstPartsID, option);
        }

        /// <summary>
        /// 左上隅マテリアル情報を全てのフレーム＆コンテントにコピー
        /// </summary>
        private void Event_BtnCopyLTParamToFrameContent_Click( object sender, EventArgs e )
        {
            CopyFrameLTParam( true);
        }

        /// <summary>
        /// 左上隅マテリアル情報を全てのフレームにコピー
        /// </summary>
        private void Event_BtnCopyLTParamToFrame_Click( object sender, EventArgs e )
        {
            CopyFrameLTParam( false);
        }

        /// <summary>
        /// 左上隅マテリアル情報のコピー
        /// </summary>
        private void CopyFrameLTParam( bool copyToContent)
        {
            // ダイアログを表示。
            if( _windowFrameCopyDlg.ShowDialog( this ) == DialogResult.OK )
            {
                IPane srcPane = TargetEntry.Manipulator.ILEWindow.OwnerPane;

                // オプションの設定
                PaneParamaterCopyOption option = new PaneParamaterCopyOption();
                option.DisableOption( ParamaterKind.All );

                if( _windowFrameCopyDlg.CopyTexture )
                {
                    option.EnableOption( ParamaterKind.Material_Textures );
                }

                if( _windowFrameCopyDlg.CopyAnimation )
                {
                    option.EnableOption( ParamaterKind.Animation_All );
                }
                option.EnableOption( ParamaterKind.Material_ColorBlend |
                                     ParamaterKind.Material_Details );

                // マテリアルのコピー

                ILEWindow srcWnd = TargetEntry.Manipulator.ILEWindow;
                _CurrentISubScene.BeginMassiveModify();

                if( copyToContent != false )
                {
                    CopyWindowFrameMaterial_( LEWindowPartsID.Content, option );
                }

                if( srcWnd.NumTexture == 5 )
                {

                    CopyWindowFrameMaterial_( LEWindowPartsID.CornerLB, option );
                    CopyWindowFrameMaterial_( LEWindowPartsID.CornerRT, option );
                    CopyWindowFrameMaterial_( LEWindowPartsID.CornerRB, option );
                }
                else if( srcWnd.NumTexture == 9 )
                {
                    CopyWindowFrameMaterial_( LEWindowPartsID.CornerLB, option );
                    CopyWindowFrameMaterial_( LEWindowPartsID.CornerRT, option );
                    CopyWindowFrameMaterial_( LEWindowPartsID.CornerRB, option );

                    CopyWindowFrameMaterial_( LEWindowPartsID.FrameT, option );
                    CopyWindowFrameMaterial_( LEWindowPartsID.FrameB, option );
                    CopyWindowFrameMaterial_( LEWindowPartsID.FrameL, option );
                    CopyWindowFrameMaterial_( LEWindowPartsID.FrameR, option );
                }

                _CurrentISubScene.EndMassiveModify();
            }
        }

        /// <summary>
        /// フリップ・回転状態ラジオボタンハンドラ
        /// </summary>
        private void Event_RadFlipRotType_CheckedChanged( object sender, EventArgs e )
        {
            if (IsGUIUpdating) { return; }

            UIRadioButton uib = sender as UIRadioButton;

            // 新しい値
            LEWindowFrameFlipRotate newFlipRotState =
                (LEWindowFrameFlipRotate)uib.Tag;

            // 現在の値
            LEWindowFrameFlipRotate nowFlipRotState =
                _TargetWindowMpn.ILEWindow.GetMaterialFlipRotateState( _TargetMatID );

            // 変更があれば、設定します。
            if( newFlipRotState != nowFlipRotState )
            {
                _TargetWindowMpn.SetMaterialFlipState( _TargetMatID, newFlipRotState );
            }
        }

        ///
        private WindowPropertyPanel WindowPropertyPanel
        {
            get
            {
                var panel = this.Owner as WindowPropertyPanel;
                Debug.Assert(panel != null);
                return panel;
            }
        }

        /// <summary>
        /// 詳細なマテリアル使用フラグ：チェックボックスハンドラ
        /// </summary>
        private void Event_ChkUseDetailedMaterial_CheckedChanged( object sender, System.EventArgs e )
        {
            if (IsGUIUpdating) { return; }

            UICheckBox cb = sender as UICheckBox;

            bool useDetail = _TargetWindowMpn.ILEWindow.GetUseDetailedMaterialFlag(TargetEntry.CurrentTargetPartsID);
            if( useDetail != cb.Checked )
            {
                _TargetWindowMpn.SetUseDetailedMaterialFlag(TargetEntry.CurrentTargetPartsID, cb.Checked);
            }
        }

        /// <summary>
        /// コンテンツ領域：カラー変更ハンドラ
        /// </summary>
        void _pnlVtxColor_ColorChange( Color LT, Color RT, Color LB, Color RB )
        {
            if (IsGUIUpdating) { return; }

            _CurrentISubScene.BeginMassiveModify();

            _TargetWindowMpn.VtxCol_LT = new RGBAColor(LT);
            _TargetWindowMpn.VtxCol_RT = new RGBAColor(RT);
            _TargetWindowMpn.VtxCol_LB = new RGBAColor(LB);
            _TargetWindowMpn.VtxCol_RB = new RGBAColor(RB);

            _CurrentISubScene.EndMassiveModify();
        }

        /// <summary>
        /// 頂点カラーをペイン全体に適用する
        /// </summary>
        private void Event_ChkVtxColorForAllWindow_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            _TargetWindowMpn.UseVtxColorForAllWindow = _chkVtxColorForAllWindow.Checked;
        }

        /// <summary>
        ///
        /// </summary>
        void SetToTargetInflation_()
        {
            ILEWindowContentsInflation inflation = _TargetWindowMpn.ILEWindow.ContentsInflation;
            try
            {
                float t = Convert.ToSingle( _nudInflationT.Value );
                float b = Convert.ToSingle( _nudInflationB.Value );
                float l = Convert.ToSingle( _nudInflationL.Value );
                float r = Convert.ToSingle( _nudInflationR.Value );

                // 値を統一する必要がある場合は、変更された方に値を統一します。
                if( b != t && _chkSameTopBottom.Checked )
                {
                    if( inflation.Top != t )
                    {
                        b = t;
                    }
                    else
                    {
                        t = b;
                    }
                }

                if( l != r && _chkSameLeftRight.Checked )
                {
                    if( inflation.Left != l )
                    {
                        r = l;
                    }
                    else
                    {
                        l = r;
                    }
                }

                _TargetWindowMpn.SetContentsInflation( t, b, l, r );
            }
            catch
            {
                // UIの値を元に戻します。
                _nudInflationT.Value = Convert.ToDecimal( inflation.Top );
                _nudInflationB.Value = Convert.ToDecimal( inflation.Bottom );
                _nudInflationL.Value = Convert.ToDecimal( inflation.Left );
                _nudInflationR.Value = Convert.ToDecimal( inflation.Right );
            }
        }

        /// <summary>
        ///
        /// </summary>
        private void SetToFrameSize_()
        {
            float t = Convert.ToSingle(_nudFrameSizeT.Value);
            float b = Convert.ToSingle(_nudFrameSizeB.Value);
            float l = Convert.ToSingle(_nudFrameSizeL.Value);
            float r = Convert.ToSingle(_nudFrameSizeR.Value);

            // 値を統一する必要がある場合は、変更された方に値を統一します。
            if (b != t && _chkSameFrameTB.Checked)
            {
                if (_TargetWindowMpn.ILEWindow.FrameSize.Top != t)
                {
                    b = t;
                }
                else
                {
                    t = b;
                }
            }

            if (l != r && _chkSameFrameLR.Checked)
            {
                if (_TargetWindowMpn.ILEWindow.FrameSize.Left != l)
                {
                    r = l;
                }
                else
                {
                    l = r;
                }
            }

            _TargetWindowMpn.SetFrameSize(t, b, l, r);
        }

        /// <summary>
        /// フレームサイズ変更
        /// </summary>
        private void Event_NudFrameSize_ValueChanged(object sender, EventArgs e)
        {
            SetToFrameSize_();
        }

        /// <summary>
        /// フレームサイズ同期チェックボックスハンドラ
        /// </summary>
        private void Event_ChkFrameSame_CheckedChanged(object sender, System.EventArgs e)
        {
            SetToFrameSize_();
        }

        private void Event_btnSetFrameSize_Click(object sender, EventArgs e)
        {
            if (!_TargetWindowMpn.ILEWindow.IsFrameSizeOrFrameSizeCurveSpecified)
            {
                FVec2 posLT, sizeLT, posRB, sizeRB;
                _TargetWindowMpn.ILEWindow.GetWindowPartsRectangle(ILEWindowHelper.NumTextureMax, LEWindowPartsID.CornerLT, out posLT, out sizeLT);
                _TargetWindowMpn.ILEWindow.GetWindowPartsRectangle(ILEWindowHelper.NumTextureMax, LEWindowPartsID.CornerRB, out posRB, out sizeRB);

                _TargetWindowMpn.SetFrameSize(sizeLT.Y, sizeRB.Y, sizeLT.X, sizeRB.X);
            }
            else
            {
                _TargetWindowMpn.ResetCustomFrameSize();
            }
        }

        /// <summary>
        /// コンテントサイズ変更
        /// </summary>
        private void Event_NudInflation_ValueChanged( object sender, EventArgs e )
        {
            if (IsGUIUpdating) { return; }

            SetToTargetInflation_();
        }

        /// <summary>
        /// コンテントサイズ同期チェックボックスハンドラ
        /// </summary>
        private void Event_ChkSame_CheckedChanged( object sender, System.EventArgs e )
        {
            if (IsGUIUpdating) { return; }

            SetToTargetInflation_();
        }

        /// <summary>
        /// 使用するテクスチャ座標数ハンドラ
        /// </summary>
        private void Event_NudNumTexCoord_ValueChanged( object sender, System.EventArgs e )
        {
            if (IsGUIUpdating) { return; }

            NumericUpDown nud = sender as NumericUpDown;

            _TargetWindowMpn.NumContentsTexCoord = Convert.ToInt32( nud.Value );
        }

        #region ISceneModifyListener メンバ
        /// <summary>
        /// シーン変更イベントハンドラ
        /// </summary>
        public override void OnSceneModifyHandler( object sender, SceneModifyEventArgs e )
        {
            if (this.Owner == null)
            {
                return;
            }

            base.OnSceneModifyHandler(sender, e);
        }
        #endregion

        /// <summary>
        ///
        /// </summary>
        private void Event_ChkUseLTMaterial_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            UICheckBox cb = sender as UICheckBox;

            bool value = _TargetWindowMpn.ILEWindow.UseLTMaterial;
            if( value != cb.Checked )
            {
                _TargetWindowMpn.UseLTMaterial = cb.Checked;
            }
        }

        /// <summary>
        /// コンテンツ書かない
        /// </summary>
        private void Event_chkContentNone_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            UICheckBox cb = sender as UICheckBox;

            bool value = _TargetWindowMpn.ILEWindow.NotDrawContent;
            if (value != cb.Checked)
            {
                _TargetWindowMpn.NotDrawContent = cb.Checked;
            }
        }

        #endregion GUIイベントハンドラ
    }
}
