﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Pane
{
    using LayoutEditor.Forms.Dialogs;
    public partial class WindowFrameMaterialCopyDlg : LEBaseDlg
    {
        /// <summary>
        /// テクスチャをコピーするか
        /// </summary>
        public bool CopyTexture {get { return _chkCopyTexture.Checked; }}

        /// <summary>
        /// アニメーションをコピーするか
        /// </summary>
        public bool CopyAnimation { get { return _chkCopyAnimation.Checked; } }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public WindowFrameMaterialCopyDlg()
        {
            InitializeComponent();
        }

        /// <summary>
        /// OKボタン
        /// </summary>
        private void Event_BtnOK_Click( object sender, EventArgs e )
        {
            DialogResult = DialogResult.OK;
        }

        /// <summary>
        /// キャンセルボタン
        /// </summary>
        private void Event_BtnCancel_Click( object sender, EventArgs e )
        {
            DialogResult = DialogResult.Cancel;
        }
    }
}
