﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Linq;
using System.Diagnostics;
using System.Windows.Forms;
using LECore.Structures.Nsrif.Attributes;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow
{
    using Adapters;
    using LayoutEditor.Controls;
    using LECore;
    using LECore.Manipulator;
    using LECore.Structures;
    using LECore.Structures.Core;
    using src.Controls;
    using System.Collections.Generic;
    using TextureControls;
    using HVLocation = Tuple<LECore.Structures.HorizontalLocation, LECore.Structures.VerticalLocation>;

    /// <summary>
    /// PropWndPaneMaskPage の概要の説明です。
    /// </summary>
    public class PropWndPaneDropShadowPage : PropertyPage
    {
        #region デザイナ生成フィールド
        private System.Windows.Forms.Label _lblRotZ;
        private LayoutEditor.Controls.DockContentToolTip _ttpPaneBasic;
        private System.ComponentModel.IContainer components;
        private GroupBox _grpStroke;
        private Label _lblDropShadowWarning;
        private GroupBox _grpDropShadow;
        private GroupBox _grpOuterGlow;
        private ColorEditPanel _colStrokeColor;
        private FloatEditSlider _fesStrokeSize;
        private UIComboBox _comboStrokeBlendMode;
        private UICheckBox _chkDropShadowEnabled;
        private UICheckBox _chkOuterGlowEnabled;
        private UICheckBox _chkStrokeEnabled;
        private FloatEditSlider _fesOuterGlowSize;
        private FloatEditSlider _fesOuterGlowSpread;
        private UIComboBox _comboOuterGlowBlendMode;
        private ColorEditPanel _colOuterGlowColor;
        private FloatEditSlider _fesDropShadowSize;
        private FloatEditSlider _fesDropShadowSpread;
        private FloatEditSlider _fesDropShadowDistance;
        private FloatEditSlider _fesDropShadowAngle;
        private UIComboBox _comboDropShadowBlendMode;
        private ColorEditPanel _colDropShadowColor;
        private UICheckBox _chkOnlyEffect;
        private UICheckBox _chkKnockout;
        private BindAnimationLabel _lblStrokeColor;
        private BindAnimationLabel _lblDropShadowColor;
        private BindAnimationLabel _lblOuterGlowColor;
        private GroupBox _grpCommonOption;
        private UICheckBox _chkStaticRendering;
        private BindAnimationLabel _lblDropShadowSize;
        private BindAnimationLabel _lblDropShadowSpread;
        private BindAnimationLabel _lblDropShadowDistance;
        private BindAnimationLabel _lblDropShadowAngle;
        private BindAnimationLabel _lblDropShadowBlendMode;
        private BindAnimationLabel _lblOuterGlowSize;
        private BindAnimationLabel _lblOuterGlowSpread;
        private BindAnimationLabel _lblOuterGlowBlendMode;
        private BindAnimationLabel _lblStrokeBlendMode;
        private BindAnimationLabel _lblStrokeSize;
        private ErrorProvider _erpPaneNameChange;

        #endregion デザイナ生成フィールド

        #region デザイナ生成コード
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(PropWndPaneDropShadowPage));
            this._lblRotZ = new System.Windows.Forms.Label();
            this._ttpPaneBasic = new LayoutEditor.Controls.DockContentToolTip(this.components);
            this._chkDropShadowEnabled = new LayoutEditor.Controls.UICheckBox();
            this._chkOuterGlowEnabled = new LayoutEditor.Controls.UICheckBox();
            this._chkStrokeEnabled = new LayoutEditor.Controls.UICheckBox();
            this._grpDropShadow = new System.Windows.Forms.GroupBox();
            this._lblDropShadowSize = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblDropShadowSpread = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblDropShadowDistance = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblDropShadowAngle = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblDropShadowBlendMode = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblDropShadowColor = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._fesDropShadowSize = new LayoutEditor.Controls.FloatEditSlider();
            this._fesDropShadowSpread = new LayoutEditor.Controls.FloatEditSlider();
            this._fesDropShadowDistance = new LayoutEditor.Controls.FloatEditSlider();
            this._fesDropShadowAngle = new LayoutEditor.Controls.FloatEditSlider();
            this._comboDropShadowBlendMode = new LayoutEditor.Controls.UIComboBox();
            this._colDropShadowColor = new LayoutEditor.Controls.ColorEditPanel();
            this._colStrokeColor = new LayoutEditor.Controls.ColorEditPanel();
            this._colOuterGlowColor = new LayoutEditor.Controls.ColorEditPanel();
            this._erpPaneNameChange = new System.Windows.Forms.ErrorProvider(this.components);
            this._grpStroke = new System.Windows.Forms.GroupBox();
            this._lblStrokeBlendMode = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblStrokeSize = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblStrokeColor = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._comboStrokeBlendMode = new LayoutEditor.Controls.UIComboBox();
            this._fesStrokeSize = new LayoutEditor.Controls.FloatEditSlider();
            this._lblDropShadowWarning = new System.Windows.Forms.Label();
            this._grpOuterGlow = new System.Windows.Forms.GroupBox();
            this._lblOuterGlowSize = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblOuterGlowSpread = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblOuterGlowBlendMode = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblOuterGlowColor = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._fesOuterGlowSize = new LayoutEditor.Controls.FloatEditSlider();
            this._fesOuterGlowSpread = new LayoutEditor.Controls.FloatEditSlider();
            this._comboOuterGlowBlendMode = new LayoutEditor.Controls.UIComboBox();
            this._chkOnlyEffect = new LayoutEditor.Controls.UICheckBox();
            this._chkKnockout = new LayoutEditor.Controls.UICheckBox();
            this._chkStaticRendering = new LayoutEditor.Controls.UICheckBox();
            this._grpCommonOption = new System.Windows.Forms.GroupBox();
            this._grpDropShadow.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._erpPaneNameChange)).BeginInit();
            this._grpStroke.SuspendLayout();
            this._grpOuterGlow.SuspendLayout();
            this._grpCommonOption.SuspendLayout();
            this.SuspendLayout();
            //
            // _lblRotZ
            //
            resources.ApplyResources(this._lblRotZ, "_lblRotZ");
            this._lblRotZ.Name = "_lblRotZ";
            //
            // _chkDropShadowEnabled
            //
            resources.ApplyResources(this._chkDropShadowEnabled, "_chkDropShadowEnabled");
            this._chkDropShadowEnabled.Name = "_chkDropShadowEnabled";
            this._chkDropShadowEnabled.CheckedChanged += new System.EventHandler(this.Event_chkDropShadowEnabled_CheckedChanged);
            //
            // _chkOuterGlowEnabled
            //
            resources.ApplyResources(this._chkOuterGlowEnabled, "_chkOuterGlowEnabled");
            this._chkOuterGlowEnabled.Name = "_chkOuterGlowEnabled";
            this._chkOuterGlowEnabled.CheckedChanged += new System.EventHandler(this.Event_chkOuterGlowEnabled_CheckedChanged);
            //
            // _chkStrokeEnabled
            //
            resources.ApplyResources(this._chkStrokeEnabled, "_chkStrokeEnabled");
            this._chkStrokeEnabled.Name = "_chkStrokeEnabled";
            this._chkStrokeEnabled.CheckedChanged += new System.EventHandler(this.Event_chkStrokeEnabled_CheckedChanged);
            //
            // _grpDropShadow
            //
            this._grpDropShadow.Controls.Add(this._lblDropShadowSize);
            this._grpDropShadow.Controls.Add(this._lblDropShadowSpread);
            this._grpDropShadow.Controls.Add(this._lblDropShadowDistance);
            this._grpDropShadow.Controls.Add(this._lblDropShadowAngle);
            this._grpDropShadow.Controls.Add(this._lblDropShadowBlendMode);
            this._grpDropShadow.Controls.Add(this._lblDropShadowColor);
            this._grpDropShadow.Controls.Add(this._fesDropShadowSize);
            this._grpDropShadow.Controls.Add(this._fesDropShadowSpread);
            this._grpDropShadow.Controls.Add(this._fesDropShadowDistance);
            this._grpDropShadow.Controls.Add(this._fesDropShadowAngle);
            this._grpDropShadow.Controls.Add(this._comboDropShadowBlendMode);
            this._grpDropShadow.Controls.Add(this._colDropShadowColor);
            resources.ApplyResources(this._grpDropShadow, "_grpDropShadow");
            this._grpDropShadow.Name = "_grpDropShadow";
            this._grpDropShadow.TabStop = false;
            //
            // _lblDropShadowSize
            //
            resources.ApplyResources(this._lblDropShadowSize, "_lblDropShadowSize");
            this._lblDropShadowSize.Name = "_lblDropShadowSize";
            this._lblDropShadowSize.UseAnimationMark = true;
            this._lblDropShadowSize.UseContextMenu = true;
            //
            // _lblDropShadowSpread
            //
            resources.ApplyResources(this._lblDropShadowSpread, "_lblDropShadowSpread");
            this._lblDropShadowSpread.Name = "_lblDropShadowSpread";
            this._lblDropShadowSpread.UseAnimationMark = true;
            this._lblDropShadowSpread.UseContextMenu = true;
            //
            // _lblDropShadowDistance
            //
            resources.ApplyResources(this._lblDropShadowDistance, "_lblDropShadowDistance");
            this._lblDropShadowDistance.Name = "_lblDropShadowDistance";
            this._lblDropShadowDistance.UseAnimationMark = true;
            this._lblDropShadowDistance.UseContextMenu = true;
            //
            // _lblDropShadowAngle
            //
            resources.ApplyResources(this._lblDropShadowAngle, "_lblDropShadowAngle");
            this._lblDropShadowAngle.Name = "_lblDropShadowAngle";
            this._lblDropShadowAngle.UseAnimationMark = true;
            this._lblDropShadowAngle.UseContextMenu = true;
            //
            // _lblDropShadowBlendMode
            //
            resources.ApplyResources(this._lblDropShadowBlendMode, "_lblDropShadowBlendMode");
            this._lblDropShadowBlendMode.Name = "_lblDropShadowBlendMode";
            this._lblDropShadowBlendMode.UseAnimationMark = false;
            this._lblDropShadowBlendMode.UseContextMenu = false;
            //
            // _lblDropShadowColor
            //
            resources.ApplyResources(this._lblDropShadowColor, "_lblDropShadowColor");
            this._lblDropShadowColor.Name = "_lblDropShadowColor";
            this._lblDropShadowColor.UseAnimationMark = true;
            this._lblDropShadowColor.UseContextMenu = true;
            //
            // _fesDropShadowSize
            //
            resources.ApplyResources(this._fesDropShadowSize, "_fesDropShadowSize");
            this._fesDropShadowSize.Format = "f2";
            this._fesDropShadowSize.MaxValue = 100F;
            this._fesDropShadowSize.MinValue = 0F;
            this._fesDropShadowSize.Name = "_fesDropShadowSize";
            this._fesDropShadowSize.RangeLabelFormat = "f2";
            this._fesDropShadowSize.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size56;
            this._fesDropShadowSize.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._fesDropShadowSize.TrackBarLargeChange = 0F;
            this._fesDropShadowSize.TrackBarPrecision = 100;
            this._fesDropShadowSize.TrackBarSmallChange = 0F;
            this._fesDropShadowSize.UseAnimationMark = true;
            this._fesDropShadowSize.Value = 5F;
            this._fesDropShadowSize.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_fesDropShadowSize_ValueEdit);
            //
            // _fesDropShadowSpread
            //
            resources.ApplyResources(this._fesDropShadowSpread, "_fesDropShadowSpread");
            this._fesDropShadowSpread.Format = "f2";
            this._fesDropShadowSpread.MaxValue = 100F;
            this._fesDropShadowSpread.MinValue = 0F;
            this._fesDropShadowSpread.Name = "_fesDropShadowSpread";
            this._fesDropShadowSpread.RangeLabelFormat = "f2";
            this._fesDropShadowSpread.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size56;
            this._fesDropShadowSpread.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._fesDropShadowSpread.TrackBarLargeChange = 0F;
            this._fesDropShadowSpread.TrackBarPrecision = 100;
            this._fesDropShadowSpread.TrackBarSmallChange = 0F;
            this._fesDropShadowSpread.UseAnimationMark = true;
            this._fesDropShadowSpread.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_fesDropShadowSpread_ValueEdit);
            //
            // _fesDropShadowDistance
            //
            resources.ApplyResources(this._fesDropShadowDistance, "_fesDropShadowDistance");
            this._fesDropShadowDistance.Format = "f2";
            this._fesDropShadowDistance.MaxValue = 100F;
            this._fesDropShadowDistance.MinValue = 0F;
            this._fesDropShadowDistance.Name = "_fesDropShadowDistance";
            this._fesDropShadowDistance.RangeLabelFormat = "f2";
            this._fesDropShadowDistance.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size56;
            this._fesDropShadowDistance.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._fesDropShadowDistance.TrackBarLargeChange = 0F;
            this._fesDropShadowDistance.TrackBarPrecision = 100;
            this._fesDropShadowDistance.TrackBarSmallChange = 0F;
            this._fesDropShadowDistance.UseAnimationMark = true;
            this._fesDropShadowDistance.Value = 5F;
            this._fesDropShadowDistance.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_fesDropShadowDistance_ValueEdit);
            //
            // _fesDropShadowAngle
            //
            resources.ApplyResources(this._fesDropShadowAngle, "_fesDropShadowAngle");
            this._fesDropShadowAngle.Format = "f2";
            this._fesDropShadowAngle.MaxValue = 360F;
            this._fesDropShadowAngle.MinValue = 0F;
            this._fesDropShadowAngle.Name = "_fesDropShadowAngle";
            this._fesDropShadowAngle.RangeLabelFormat = "f2";
            this._fesDropShadowAngle.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size56;
            this._fesDropShadowAngle.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._fesDropShadowAngle.TrackBarLargeChange = 0F;
            this._fesDropShadowAngle.TrackBarPrecision = 100;
            this._fesDropShadowAngle.TrackBarSmallChange = 0F;
            this._fesDropShadowAngle.UseAnimationMark = true;
            this._fesDropShadowAngle.Value = 120F;
            this._fesDropShadowAngle.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_fesDropShadowAngle_ValueEdit);
            //
            // _comboDropShadowBlendMode
            //
            this._comboDropShadowBlendMode.FormattingEnabled = true;
            this._comboDropShadowBlendMode.Items.AddRange(new object[] {
            resources.GetString("_comboDropShadowBlendMode.Items"),
            resources.GetString("_comboDropShadowBlendMode.Items1"),
            resources.GetString("_comboDropShadowBlendMode.Items2"),
            resources.GetString("_comboDropShadowBlendMode.Items3")});
            resources.ApplyResources(this._comboDropShadowBlendMode, "_comboDropShadowBlendMode");
            this._comboDropShadowBlendMode.Name = "_comboDropShadowBlendMode";
            this._comboDropShadowBlendMode.SelectedItemData = null;
            this._comboDropShadowBlendMode.SelectedIndexChanged += new System.EventHandler(this.Event_comboDropShadowBlendMode_SelectedIndexChanged);
            //
            // _colDropShadowColor
            //
            this._colDropShadowColor.AllowDrop = true;
            resources.ApplyResources(this._colDropShadowColor, "_colDropShadowColor");
            this._colDropShadowColor.Name = "_colDropShadowColor";
            this._colDropShadowColor.Tag = "";
            this._colDropShadowColor.UseAnimationMark = true;
            this._colDropShadowColor.ColorEdit += new LayoutEditor.Controls.ColorEditEventHandler(this.Event_colDropShadowColor_ColorEdit);
            //
            // _colStrokeColor
            //
            this._colStrokeColor.AllowDrop = true;
            resources.ApplyResources(this._colStrokeColor, "_colStrokeColor");
            this._colStrokeColor.Name = "_colStrokeColor";
            this._colStrokeColor.Tag = "";
            this._colStrokeColor.UseAnimationMark = true;
            this._colStrokeColor.ColorEdit += new LayoutEditor.Controls.ColorEditEventHandler(this.Event_colStrokeColor_ColorEdit);
            //
            // _colOuterGlowColor
            //
            this._colOuterGlowColor.AllowDrop = true;
            resources.ApplyResources(this._colOuterGlowColor, "_colOuterGlowColor");
            this._colOuterGlowColor.Name = "_colOuterGlowColor";
            this._colOuterGlowColor.Tag = "";
            this._colOuterGlowColor.UseAnimationMark = true;
            this._colOuterGlowColor.ColorEdit += new LayoutEditor.Controls.ColorEditEventHandler(this.Event_colOuterGlowColor_ColorEdit);
            //
            // _erpPaneNameChange
            //
            this._erpPaneNameChange.ContainerControl = this;
            resources.ApplyResources(this._erpPaneNameChange, "_erpPaneNameChange");
            //
            // _grpStroke
            //
            this._grpStroke.Controls.Add(this._lblStrokeBlendMode);
            this._grpStroke.Controls.Add(this._lblStrokeSize);
            this._grpStroke.Controls.Add(this._lblStrokeColor);
            this._grpStroke.Controls.Add(this._comboStrokeBlendMode);
            this._grpStroke.Controls.Add(this._fesStrokeSize);
            this._grpStroke.Controls.Add(this._colStrokeColor);
            resources.ApplyResources(this._grpStroke, "_grpStroke");
            this._grpStroke.Name = "_grpStroke";
            this._grpStroke.TabStop = false;
            //
            // _lblStrokeBlendMode
            //
            resources.ApplyResources(this._lblStrokeBlendMode, "_lblStrokeBlendMode");
            this._lblStrokeBlendMode.Name = "_lblStrokeBlendMode";
            this._lblStrokeBlendMode.UseAnimationMark = false;
            this._lblStrokeBlendMode.UseContextMenu = false;
            //
            // _lblStrokeSize
            //
            resources.ApplyResources(this._lblStrokeSize, "_lblStrokeSize");
            this._lblStrokeSize.Name = "_lblStrokeSize";
            this._lblStrokeSize.UseAnimationMark = true;
            this._lblStrokeSize.UseContextMenu = true;
            //
            // _lblStrokeColor
            //
            resources.ApplyResources(this._lblStrokeColor, "_lblStrokeColor");
            this._lblStrokeColor.Name = "_lblStrokeColor";
            this._lblStrokeColor.UseAnimationMark = true;
            this._lblStrokeColor.UseContextMenu = true;
            //
            // _comboStrokeBlendMode
            //
            this._comboStrokeBlendMode.FormattingEnabled = true;
            this._comboStrokeBlendMode.Items.AddRange(new object[] {
            resources.GetString("_comboStrokeBlendMode.Items"),
            resources.GetString("_comboStrokeBlendMode.Items1"),
            resources.GetString("_comboStrokeBlendMode.Items2"),
            resources.GetString("_comboStrokeBlendMode.Items3")});
            resources.ApplyResources(this._comboStrokeBlendMode, "_comboStrokeBlendMode");
            this._comboStrokeBlendMode.Name = "_comboStrokeBlendMode";
            this._comboStrokeBlendMode.SelectedItemData = null;
            this._comboStrokeBlendMode.SelectedIndexChanged += new System.EventHandler(this.Event_comboStrokeBlendMode_SelectedIndexChanged);
            //
            // _fesStrokeSize
            //
            resources.ApplyResources(this._fesStrokeSize, "_fesStrokeSize");
            this._fesStrokeSize.Format = "f2";
            this._fesStrokeSize.MaxValue = 100F;
            this._fesStrokeSize.MinValue = 0F;
            this._fesStrokeSize.Name = "_fesStrokeSize";
            this._fesStrokeSize.RangeLabelFormat = "f2";
            this._fesStrokeSize.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size56;
            this._fesStrokeSize.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._fesStrokeSize.TrackBarLargeChange = 0F;
            this._fesStrokeSize.TrackBarPrecision = 100;
            this._fesStrokeSize.TrackBarSmallChange = 0F;
            this._fesStrokeSize.UseAnimationMark = true;
            this._fesStrokeSize.Value = 3F;
            this._fesStrokeSize.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_fesStrokeSize_ValueEdit);
            //
            // _lblDropShadowWarning
            //
            resources.ApplyResources(this._lblDropShadowWarning, "_lblDropShadowWarning");
            this._lblDropShadowWarning.Name = "_lblDropShadowWarning";
            //
            // _grpOuterGlow
            //
            this._grpOuterGlow.Controls.Add(this._lblOuterGlowSize);
            this._grpOuterGlow.Controls.Add(this._lblOuterGlowSpread);
            this._grpOuterGlow.Controls.Add(this._lblOuterGlowBlendMode);
            this._grpOuterGlow.Controls.Add(this._lblOuterGlowColor);
            this._grpOuterGlow.Controls.Add(this._fesOuterGlowSize);
            this._grpOuterGlow.Controls.Add(this._fesOuterGlowSpread);
            this._grpOuterGlow.Controls.Add(this._comboOuterGlowBlendMode);
            this._grpOuterGlow.Controls.Add(this._colOuterGlowColor);
            resources.ApplyResources(this._grpOuterGlow, "_grpOuterGlow");
            this._grpOuterGlow.Name = "_grpOuterGlow";
            this._grpOuterGlow.TabStop = false;
            //
            // _lblOuterGlowSize
            //
            resources.ApplyResources(this._lblOuterGlowSize, "_lblOuterGlowSize");
            this._lblOuterGlowSize.Name = "_lblOuterGlowSize";
            this._lblOuterGlowSize.UseAnimationMark = true;
            this._lblOuterGlowSize.UseContextMenu = true;
            //
            // _lblOuterGlowSpread
            //
            resources.ApplyResources(this._lblOuterGlowSpread, "_lblOuterGlowSpread");
            this._lblOuterGlowSpread.Name = "_lblOuterGlowSpread";
            this._lblOuterGlowSpread.UseAnimationMark = true;
            this._lblOuterGlowSpread.UseContextMenu = true;
            //
            // _lblOuterGlowBlendMode
            //
            resources.ApplyResources(this._lblOuterGlowBlendMode, "_lblOuterGlowBlendMode");
            this._lblOuterGlowBlendMode.Name = "_lblOuterGlowBlendMode";
            this._lblOuterGlowBlendMode.UseAnimationMark = false;
            this._lblOuterGlowBlendMode.UseContextMenu = false;
            //
            // _lblOuterGlowColor
            //
            resources.ApplyResources(this._lblOuterGlowColor, "_lblOuterGlowColor");
            this._lblOuterGlowColor.Name = "_lblOuterGlowColor";
            this._lblOuterGlowColor.UseAnimationMark = true;
            this._lblOuterGlowColor.UseContextMenu = true;
            //
            // _fesOuterGlowSize
            //
            resources.ApplyResources(this._fesOuterGlowSize, "_fesOuterGlowSize");
            this._fesOuterGlowSize.Format = "f2";
            this._fesOuterGlowSize.MaxValue = 100F;
            this._fesOuterGlowSize.MinValue = 0F;
            this._fesOuterGlowSize.Name = "_fesOuterGlowSize";
            this._fesOuterGlowSize.RangeLabelFormat = "f2";
            this._fesOuterGlowSize.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size56;
            this._fesOuterGlowSize.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._fesOuterGlowSize.TrackBarLargeChange = 0F;
            this._fesOuterGlowSize.TrackBarPrecision = 100;
            this._fesOuterGlowSize.TrackBarSmallChange = 0F;
            this._fesOuterGlowSize.UseAnimationMark = true;
            this._fesOuterGlowSize.Value = 5F;
            this._fesOuterGlowSize.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_fesOuterGlowSize_ValueEdit);
            //
            // _fesOuterGlowSpread
            //
            resources.ApplyResources(this._fesOuterGlowSpread, "_fesOuterGlowSpread");
            this._fesOuterGlowSpread.Format = "f2";
            this._fesOuterGlowSpread.MaxValue = 100F;
            this._fesOuterGlowSpread.MinValue = 0F;
            this._fesOuterGlowSpread.Name = "_fesOuterGlowSpread";
            this._fesOuterGlowSpread.RangeLabelFormat = "f2";
            this._fesOuterGlowSpread.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size56;
            this._fesOuterGlowSpread.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._fesOuterGlowSpread.TrackBarLargeChange = 0F;
            this._fesOuterGlowSpread.TrackBarPrecision = 100;
            this._fesOuterGlowSpread.TrackBarSmallChange = 0F;
            this._fesOuterGlowSpread.UseAnimationMark = true;
            this._fesOuterGlowSpread.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_fesOuterGlowSpread_ValueEdit);
            //
            // _comboOuterGlowBlendMode
            //
            this._comboOuterGlowBlendMode.FormattingEnabled = true;
            this._comboOuterGlowBlendMode.Items.AddRange(new object[] {
            resources.GetString("_comboOuterGlowBlendMode.Items"),
            resources.GetString("_comboOuterGlowBlendMode.Items1"),
            resources.GetString("_comboOuterGlowBlendMode.Items2"),
            resources.GetString("_comboOuterGlowBlendMode.Items3")});
            resources.ApplyResources(this._comboOuterGlowBlendMode, "_comboOuterGlowBlendMode");
            this._comboOuterGlowBlendMode.Name = "_comboOuterGlowBlendMode";
            this._comboOuterGlowBlendMode.SelectedItemData = null;
            this._comboOuterGlowBlendMode.SelectedIndexChanged += new System.EventHandler(this.Event_comboOuterGlowBlendMode_SelectedIndexChanged);
            //
            // _chkOnlyEffect
            //
            resources.ApplyResources(this._chkOnlyEffect, "_chkOnlyEffect");
            this._chkOnlyEffect.Name = "_chkOnlyEffect";
            this._chkOnlyEffect.CheckedChanged += new System.EventHandler(this.Event_chkOnlyEffect_CheckedChanged);
            //
            // _chkKnockout
            //
            resources.ApplyResources(this._chkKnockout, "_chkKnockout");
            this._chkKnockout.Name = "_chkKnockout";
            this._chkKnockout.CheckedChanged += new System.EventHandler(this.Event_chkKnockout_CheckedChanged);
            //
            // _chkStaticRendering
            //
            resources.ApplyResources(this._chkStaticRendering, "_chkStaticRendering");
            this._chkStaticRendering.Name = "_chkStaticRendering";
            this._chkStaticRendering.CheckedChanged += new System.EventHandler(this.Event_chkStaticRendering_CheckedChanged);
            //
            // _grpCommonOption
            //
            this._grpCommonOption.Controls.Add(this._chkKnockout);
            this._grpCommonOption.Controls.Add(this._chkStaticRendering);
            this._grpCommonOption.Controls.Add(this._chkOnlyEffect);
            resources.ApplyResources(this._grpCommonOption, "_grpCommonOption");
            this._grpCommonOption.Name = "_grpCommonOption";
            this._grpCommonOption.TabStop = false;
            //
            // PropWndPaneDropShadowPage
            //
            this.Controls.Add(this._grpCommonOption);
            this.Controls.Add(this._chkDropShadowEnabled);
            this.Controls.Add(this._chkOuterGlowEnabled);
            this.Controls.Add(this._chkStrokeEnabled);
            this.Controls.Add(this._grpDropShadow);
            this.Controls.Add(this._grpOuterGlow);
            this.Controls.Add(this._lblDropShadowWarning);
            this.Controls.Add(this._grpStroke);
            this.Name = "PropWndPaneDropShadowPage";
            resources.ApplyResources(this, "$this");
            this._grpDropShadow.ResumeLayout(false);
            this._grpDropShadow.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this._erpPaneNameChange)).EndInit();
            this._grpStroke.ResumeLayout(false);
            this._grpStroke.PerformLayout();
            this._grpOuterGlow.ResumeLayout(false);
            this._grpOuterGlow.PerformLayout();
            this._grpCommonOption.ResumeLayout(false);
            this._grpCommonOption.PerformLayout();
            this.ResumeLayout(false);
            this.PerformLayout();

        }

        #endregion デザイナ生成コード

        #region ----------- フィールド

        DropShadowManipulator _dropShadowMnp = new DropShadowManipulator();

        #endregion ----------- フィールド

        #region ----------- プロパティ

        #endregion ----------- プロパティ

        #region ----------- 非公開プロパティ

        DropShadowManipulator _TargetDropShadowMpn
        {
            get
            {
                return Target.Active.DropShadowManipulator;
            }
        }

        #endregion ----------- 非公開プロパティ

        private readonly Image _imgMask1 = ImageResMgr.GetManifestResourcePng("mask1.png");
        private readonly Image _imgMask2 = ImageResMgr.GetManifestResourcePng("mask2.png");

        /// <summary>
        /// プロパティ初期化。
        /// </summary>
        protected override void InitializeProperty()
        {
            // ViewManagerへのメッセージハンドラを設定します
            _fesStrokeSize.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _colStrokeColor.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _colOuterGlowColor.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _fesOuterGlowSpread.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _fesOuterGlowSize.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _colDropShadowColor.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _fesDropShadowAngle.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _fesDropShadowDistance.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _fesDropShadowSpread.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _fesDropShadowSize.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
        }

        /// <summary>
        /// GUIの値を更新します。
        /// </summary>
        protected override void UpdateProperty()
        {
            if (_TargetDropShadowMpn == null)
            {
                return;
            }

            // ターゲットを参照してUIを更新する
            IDropShadow srcDropShadow = _TargetDropShadowMpn.IDropShadow;

            _fesStrokeSize.SetTargetAttribute(srcDropShadow.IStrokeSizeAttr);
            _colStrokeColor.SetTargetAttribute(srcDropShadow.IStrokeColorAttr);
            _colOuterGlowColor.SetTargetAttribute(srcDropShadow.IOuterGlowColorAttr);
            _fesOuterGlowSpread.SetTargetAttribute(srcDropShadow.IOuterGlowSpreadAttr);
            _fesOuterGlowSize.SetTargetAttribute(srcDropShadow.IOuterGlowSizeAttr);
            _colDropShadowColor.SetTargetAttribute(srcDropShadow.IDropShadowColorAttr);
            _fesDropShadowAngle.SetTargetAttribute(srcDropShadow.IDropShadowAngleAttr);
            _fesDropShadowDistance.SetTargetAttribute(srcDropShadow.IDropShadowDistanceAttr);
            _fesDropShadowSpread.SetTargetAttribute(srcDropShadow.IDropShadowSpreadAttr);
            _fesDropShadowSize.SetTargetAttribute(srcDropShadow.IDropShadowSizeAttr);

            _chkKnockout.SetChecked(srcDropShadow.IsKnockoutEnabled);
            _chkOnlyEffect.SetChecked(srcDropShadow.IsOnlyEffectEnabled);
            _chkStaticRendering.SetChecked(srcDropShadow.IsStaticRenderingEnabled);

            _grpStroke.Visible = srcDropShadow.IsStrokeEnabled;
            _chkStrokeEnabled.SetChecked(srcDropShadow.IsStrokeEnabled);
            _fesStrokeSize.SetValue(srcDropShadow.strokeSize);
            _comboStrokeBlendMode.SetSelectedIndex((int)srcDropShadow.strokeBlendMode);
            _colStrokeColor.Color = new FloatColor(srcDropShadow.strokeColor);
            _colStrokeColor.Refresh();

            _grpOuterGlow.Visible = srcDropShadow.IsOuterGlowEnabled;
            _chkOuterGlowEnabled.SetChecked(srcDropShadow.IsOuterGlowEnabled);
            _comboOuterGlowBlendMode.SetSelectedIndex((int)srcDropShadow.outerGlowBlendMode);
            _colOuterGlowColor.Color = new FloatColor(srcDropShadow.outerGlowColor);
            _fesOuterGlowSpread.SetValue(srcDropShadow.outerGlowSpread);
            _fesOuterGlowSize.SetValue(srcDropShadow.outerGlowSize);

            _grpDropShadow.Visible = srcDropShadow.IsDropShadowEnabled;
            _chkDropShadowEnabled.SetChecked(srcDropShadow.IsDropShadowEnabled);
            _comboDropShadowBlendMode.SetSelectedIndex((int)srcDropShadow.dropShadowBlendMode);
            _colDropShadowColor.Color = new FloatColor(srcDropShadow.dropShadowColor);
            _fesDropShadowAngle.SetValue(srcDropShadow.dropShadowAngle);
            _fesDropShadowDistance.SetValue(srcDropShadow.dropShadowDistance);
            _fesDropShadowSpread.SetValue(srcDropShadow.dropShadowSpread);
            _fesDropShadowSize.SetValue(srcDropShadow.dropShadowSize);

            // 同時編集
            Color color = GetMultiEditColor();
            Color panelColor = GetMultiEditPanelColor();
            _chkKnockout.BackColor = panelColor;
            _chkOnlyEffect.BackColor = panelColor;
            _chkStaticRendering.BackColor = panelColor;
            _chkStrokeEnabled.BackColor = panelColor;
            _fesStrokeSize.TextBoxBackColor = color;
            _lblStrokeBlendMode.BackColor = panelColor;
            _colStrokeColor.TextBoxBackColor = color;
            _chkOuterGlowEnabled.BackColor = panelColor;
            _lblOuterGlowBlendMode.BackColor = panelColor;
            _colOuterGlowColor.TextBoxBackColor = color;
            _fesOuterGlowSpread.TextBoxBackColor = color;
            _fesOuterGlowSize.TextBoxBackColor = color;
            _chkDropShadowEnabled.BackColor = panelColor;
            _lblDropShadowBlendMode.BackColor = panelColor;
            _colDropShadowColor.TextBoxBackColor = color;
            _fesDropShadowAngle.TextBoxBackColor = color;
            _fesDropShadowDistance.TextBoxBackColor = color;
            _fesDropShadowSpread.TextBoxBackColor = color;
            _fesDropShadowSize.TextBoxBackColor = color;

            UpdateAnimationMark();
        }

        // コンストラクタ
        public PropWndPaneDropShadowPage()
        {
            InitializeComponent();

            // コンテキストメニューを追加する
            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(_lblStrokeColor, _colStrokeColor.AnimationMarkArray);
            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(_lblOuterGlowColor, _colOuterGlowColor.AnimationMarkArray);
            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(_lblDropShadowColor, _colDropShadowColor.AnimationMarkArray);

            // アニメーションマークを関連付ける
            _lblStrokeSize.BindAnimationMark(_fesStrokeSize.AnimationMarkInst);
            _lblOuterGlowSpread.BindAnimationMark(_fesOuterGlowSpread.AnimationMarkInst);
            _lblOuterGlowSize.BindAnimationMark(_fesOuterGlowSize.AnimationMarkInst);
            _lblDropShadowAngle.BindAnimationMark(_fesDropShadowAngle.AnimationMarkInst);
            _lblDropShadowDistance.BindAnimationMark(_fesDropShadowDistance.AnimationMarkInst);
            _lblDropShadowSpread.BindAnimationMark(_fesDropShadowSpread.AnimationMarkInst);
            _lblDropShadowSize.BindAnimationMark(_fesDropShadowSize.AnimationMarkInst);
        }

        /// <summary>
        /// インスタンス作成。
        /// </summary>
        public static PropertyPage CreateInstance(object arg)
        {
            var page = new PropWndPaneDropShadowPage();
            page._OwnerPane = arg as IPane;

            return page;
        }

        public override void OnSceneModifyHandler(object sender, SceneModifyEventArgs e)
        {
            if (e.Target == SceneModifyEventArgs.Kind.PlatformChanged)
            {
                UpdateProperty();
            }
            else if (e.Target == SceneModifyEventArgs.Kind.PaneAnimAddRemove ||
                     e.Target == SceneModifyEventArgs.Kind.PaneAnimModify)
            {
                UpdateAnimationMark();
            }
            else
            {
                base.OnSceneModifyHandler(sender, e);
            }
        }

        /// <summary>
        /// アニメーションマークを更新します。
        /// </summary>
        private void UpdateAnimationMark()
        {
            // アニメーションマークの更新
            foreach (IAnimationMarkUsable ctrl in GetAnimationMarkUsableControl())
            {
                ctrl.UpdateAnimationMark();
            }
        }

        /// <summary>
        /// ページの表示内容と関係しているペインです。
        /// peneAdapterからマテリアル操作クラスを取得する際のキーとして利用します。
        /// </summary>
        private IPane _OwnerPane
        {
            get;
            set;
        }

        #region GUIハンドラ

        /// <summary>
        /// ターゲットアダプタ
        /// </summary>
        private MaskGUIAdapter TargetAdapter
        {
            get
            {
                MaskGUIAdapter maskAdapter = null;
                PaneGUIAdapter peneAdapter = base.Target.Active;

                if (peneAdapter != null)
                {
                    maskAdapter = peneAdapter.MaskGUIAdapter != null ? peneAdapter.MaskGUIAdapter : null;
                }
                return maskAdapter;
            }
        }

        /// <summary>
        /// ターゲットテクスチャマップ
        /// </summary>
        private TexMap TargetTexMap
        {
            get
            {
                MaskGUIAdapter maskAdapter = TargetAdapter;
                TexMapList texMapList = maskAdapter != null ? maskAdapter.TexMapList : null;
                return texMapList == null || texMapList.TexMaps.Count == 0 ? null : texMapList[0];
            }
        }

        /// <summary>
        /// アニメーションマークが利用可能なコントロールの一覧を取得する。
        /// </summary>
        protected override IEnumerable<IAnimationMarkUsable> GetAnimationMarkUsableControl()
        {
            List<IAnimationMarkUsable> list = new List<IAnimationMarkUsable>();

            list.Add(_lblStrokeSize);
            list.Add(_lblOuterGlowSpread);
            list.Add(_lblOuterGlowSize);
            list.Add(_lblDropShadowAngle);
            list.Add(_lblDropShadowDistance);
            list.Add(_lblDropShadowSpread);
            list.Add(_lblDropShadowSize);
            list.Add(_lblStrokeColor);
            list.Add(_lblOuterGlowColor);
            list.Add(_lblDropShadowColor);
            list.Add(_fesStrokeSize);
            list.Add(_colStrokeColor);
            list.Add(_colOuterGlowColor);
            list.Add(_fesOuterGlowSpread);
            list.Add(_fesOuterGlowSize);
            list.Add(_colDropShadowColor);
            list.Add(_fesDropShadowAngle);
            list.Add(_fesDropShadowDistance);
            list.Add(_fesDropShadowSpread);
            list.Add(_fesDropShadowSize);

            return list;
        }

        private void Event_chkStrokeEnabled_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) return;

            bool check = _chkStrokeEnabled.Checked;
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                _dropShadowMnp.BindTarget(adapter.Target.IDropShadow);
                _dropShadowMnp.IsStrokeEnabled = check;

                IPane ownerPane = _dropShadowMnp.IDropShadow.OwnerPane;
                if (check && ownerPane != null)
                {
                    _dropShadowMnp.CreateCaptureTextureForDropShadow(ownerPane, ownerPane.OwnerSubScene.ITextureMgr);
                }
            }, Target.Active, Target.Objects);
        }

        private void Event_fesStrokeSize_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (IsGUIUpdating) return;

            float val = _fesStrokeSize.Value;
            if (e.EditFixed)
            {
                MultiEdit_((obj) => {
                    PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                    _dropShadowMnp.BindTarget(adapter.Target.IDropShadow);
                    _dropShadowMnp.strokeSize = val;
                }, Target.Active, Target.Objects);
            }
        }

        private void Event_comboStrokeBlendMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) return;

            int val = _comboStrokeBlendMode.SelectedIndex;
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                _dropShadowMnp.BindTarget(adapter.Target.IDropShadow);
                _dropShadowMnp.strokeBlendMode = (LECore.Structures.LECoreInterface.DropShadowBlendMode)val;
            }, Target.Active, Target.Objects);
        }

        private void Event_colStrokeColor_ColorEdit(object sender, ColorEditEventArgs e)
        {
            if (IsGUIUpdating) return;

            RGBAColor val = _colStrokeColor.Color.ToRGBAColor();
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                _dropShadowMnp.BindTarget(adapter.Target.IDropShadow);
                _dropShadowMnp.strokeColor = val;
            }, Target.Active, Target.Objects);
        }

        private void Event_chkOuterGlowEnabled_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) return;

            bool check = _chkOuterGlowEnabled.Checked;
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                _dropShadowMnp.BindTarget(adapter.Target.IDropShadow);
                _dropShadowMnp.IsOuterGlowEnabled = check;

                IPane ownerPane = _dropShadowMnp.IDropShadow.OwnerPane;
                if (check && ownerPane != null)
                {
                    _dropShadowMnp.CreateCaptureTextureForDropShadow(ownerPane, ownerPane.OwnerSubScene.ITextureMgr);
                }
            }, Target.Active, Target.Objects);
        }

        private void Event_comboOuterGlowBlendMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) return;

            int val = _comboOuterGlowBlendMode.SelectedIndex;
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                _dropShadowMnp.BindTarget(adapter.Target.IDropShadow);
                _dropShadowMnp.outerGlowBlendMode = (LECore.Structures.LECoreInterface.DropShadowBlendMode)val;
            }, Target.Active, Target.Objects);
        }

        private void Event_colOuterGlowColor_ColorEdit(object sender, ColorEditEventArgs e)
        {
            if (IsGUIUpdating) return;

            RGBAColor val = _colOuterGlowColor.Color.ToRGBAColor();
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                _dropShadowMnp.BindTarget(adapter.Target.IDropShadow);
                _dropShadowMnp.outerGlowColor = val;
            }, Target.Active, Target.Objects);
        }

        private void Event_fesOuterGlowSpread_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (IsGUIUpdating) return;

            if (e.EditFixed)
            {
                float val = _fesOuterGlowSpread.Value;
                MultiEdit_((obj) => {
                    PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                    _dropShadowMnp.BindTarget(adapter.Target.IDropShadow);
                    _dropShadowMnp.outerGlowSpread = val;
                }, Target.Active, Target.Objects);
            }
        }

        private void Event_fesOuterGlowSize_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (IsGUIUpdating) return;

            if (e.EditFixed)
            {
                float val = _fesOuterGlowSize.Value;
                MultiEdit_((obj) => {
                    PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                    _dropShadowMnp.BindTarget(adapter.Target.IDropShadow);
                    _dropShadowMnp.outerGlowSize = val;
                }, Target.Active, Target.Objects);
            }
        }

        private void Event_chkDropShadowEnabled_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) return;

            bool check = _chkDropShadowEnabled.Checked;
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                _dropShadowMnp.BindTarget(adapter.Target.IDropShadow);
                _dropShadowMnp.IsDropShadowEnabled = check;

                IPane ownerPane = _dropShadowMnp.IDropShadow.OwnerPane;
                if (check && ownerPane != null)
                {
                    _dropShadowMnp.CreateCaptureTextureForDropShadow(ownerPane, ownerPane.OwnerSubScene.ITextureMgr);
                }
            }, Target.Active, Target.Objects);
        }

        private void Event_comboDropShadowBlendMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) return;

            int val = _comboDropShadowBlendMode.SelectedIndex;
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                _dropShadowMnp.BindTarget(adapter.Target.IDropShadow);
                _dropShadowMnp.dropShadowBlendMode = (LECore.Structures.LECoreInterface.DropShadowBlendMode)val;
            }, Target.Active, Target.Objects);
        }

        private void Event_colDropShadowColor_ColorEdit(object sender, ColorEditEventArgs e)
        {
            if (IsGUIUpdating) return;

            RGBAColor val = _colDropShadowColor.Color.ToRGBAColor();
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                _dropShadowMnp.BindTarget(adapter.Target.IDropShadow);
                _dropShadowMnp.dropShadowColor = val;
            }, Target.Active, Target.Objects);
        }

        private void Event_fesDropShadowAngle_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (IsGUIUpdating) return;

            if (e.EditFixed)
            {
                float val = _fesDropShadowAngle.Value;
                MultiEdit_((obj) => {
                    PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                    _dropShadowMnp.BindTarget(adapter.Target.IDropShadow);
                    _dropShadowMnp.dropShadowAngle = val;
                }, Target.Active, Target.Objects);
            }
        }

        private void Event_fesDropShadowDistance_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (IsGUIUpdating) return;

            if (e.EditFixed)
            {
                float val = _fesDropShadowDistance.Value;
                MultiEdit_((obj) => {
                    PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                    _dropShadowMnp.BindTarget(adapter.Target.IDropShadow);
                    _dropShadowMnp.dropShadowDistance = val;
                }, Target.Active, Target.Objects);
            }
        }

        private void Event_fesDropShadowSpread_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (IsGUIUpdating) return;

            if (e.EditFixed)
            {
                float val = _fesDropShadowSpread.Value;
                MultiEdit_((obj) => {
                    PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                    _dropShadowMnp.BindTarget(adapter.Target.IDropShadow);
                    _dropShadowMnp.dropShadowSpread = val;
                }, Target.Active, Target.Objects);
            }
        }

        private void Event_fesDropShadowSize_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (IsGUIUpdating) return;

            if (e.EditFixed)
            {
                float val = _fesDropShadowSize.Value;
                MultiEdit_((obj) => {
                    PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                    _dropShadowMnp.BindTarget(adapter.Target.IDropShadow);
                    _dropShadowMnp.dropShadowSize = val;
                }, Target.Active, Target.Objects);
            }
        }

        private void Event_chkKnockout_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) return;

            bool check = _chkKnockout.Checked;
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                _dropShadowMnp.BindTarget(adapter.Target.IDropShadow);
                _dropShadowMnp.IsKnockoutEnabled = check;
            }, Target.Active, Target.Objects);
        }

        private void Event_chkOnlyEffect_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) return;

            bool check = _chkOnlyEffect.Checked;
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                _dropShadowMnp.BindTarget(adapter.Target.IDropShadow);
                _dropShadowMnp.IsOnlyEffectEnabled = check;
            }, Target.Active, Target.Objects);
        }

        private void Event_chkStaticRendering_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) return;

            bool check = _chkStaticRendering.Checked;
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                _dropShadowMnp.BindTarget(adapter.Target.IDropShadow);
                _dropShadowMnp.IsStaticRenderingEnabled = check;

                // 静的レンダリングの場合は自動作成されるキャプチャテクスチャを「初回フレームのみ更新」に設定して負荷を抑えます。
                IPane ownerPane = _dropShadowMnp.IDropShadow.OwnerPane;
                if (ownerPane != null &&
                    ownerPane.OwnerSubScene != null &&
                    ownerPane.OwnerSubScene.ITextureMgr != null)
                {
                    ITextureMgr texMgr = ownerPane.OwnerSubScene.ITextureMgr;

                    CaptureTextureManipulator captureTextureMnp = new CaptureTextureManipulator();
                    ITextureImage tex = texMgr.FindITextureImageByName(TextureMgrHelper.CreateAutoGeneratedCaptureTextureName(ownerPane.PaneName, CaptureTextureUsage.DropShadow));
                    if (tex != null)
                    {
                        captureTextureMnp.BindTarget(tex.ICaptureTexture);
                        captureTextureMnp.CaptureOnlyFirstFrame = check;
                    }
                }
            }, Target.Active, Target.Objects);
        }

        #endregion
    }
}
