﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow
{
    using Adapters;
    using LayoutEditor.Controls;
    using LECore.Manipulator;
    using LECore.Structures;
    using LECore.Structures.Core;
    using src.Controls;
    using System.Collections.Generic;
    using System.Diagnostics;
    using Utility;
    using HVLocation = Tuple<LECore.Structures.HorizontalLocation, LECore.Structures.VerticalLocation>;

    /// <summary>
    /// PropWndPaneBasicPage の概要の説明です。
    /// </summary>
    public class PropWndPaneBasicPage : PropertyPage
    {
        #region デザイナ生成フィールド
        private System.Windows.Forms.GroupBox _grpStringInfo;
        private System.Windows.Forms.Label _lblPaneName;
        private System.Windows.Forms.Label _lblComment;
        private System.Windows.Forms.Label _lblUserData;
        private System.Windows.Forms.Label _lblRotZ;
        private LayoutEditor.Controls.UIRadioButton _radPosCenterCenter;
        private LayoutEditor.Controls.UIRadioButton _radPosLeftCenter;
        private LayoutEditor.Controls.UIRadioButton _radPosRightCenter;
        private LayoutEditor.Controls.UIRadioButton _radPosRightTop;
        private LayoutEditor.Controls.UIRadioButton _radPosCenterTop;
        private LayoutEditor.Controls.UIRadioButton _radPosCenterBottom;
        private System.Windows.Forms.GroupBox _grpPosition;
        private LayoutEditor.Controls.Fvec2EditUpDownPanel _ctlSize;
        private LayoutEditor.Controls.Fvec2EditUpDownPanel _ctlScale;
        private LayoutEditor.Controls.Fvec3EditUpDownPanel _ctlPosition;
        private System.Windows.Forms.GroupBox _grpCenterPosition;
        private System.Windows.Forms.GroupBox _grpEtc;
        private LayoutEditor.Controls.StringTextBox _tbxPaneName;
        private LayoutEditor.Controls.StringTextBox _tbxComment;
        private LayoutEditor.Controls.StringTextBox _tbxUserData;
        private CheckBox _chkInfuenceTransparency;
        private Fvec3EditUpDownPanel _ctlRotate;
        private CheckBox _chkLocationAdjust;
        private LayoutEditor.Controls.DockContentToolTip _ttpPaneBasic;
        private System.ComponentModel.IContainer components;
        private GroupBox _grpTranparency;
        private Label _lblPartsMagnifyMode;
        private UIComboBox _cmbPartsMagnifyMode;
        private CheckBox _chkAvoidPaneTreeCompression;
        private GroupBox _grpCenterInParent;
        private UIRadioButton _radCenterInParentCenterCenter;
        private UIRadioButton _radCenterInParentLeftCenter;
        private UIRadioButton _radCenterInParentRightCenter;
        private UIRadioButton _radCenterInParentLeftBottom;
        private UIRadioButton _radCenterInParentCenterTop;
        private UIRadioButton _radCenterInParentCenterBottom;
        private Label _lblPartsTranparencyNotice;
        private Label _lblPartsCenterNotice;
        private ErrorProvider _erpPaneNameChange;
        private CheckBox _chkExtUserDataAnimEnabled;
        private Fvec3EditUpDownPanel _ctlWorldPosition;
        private Label _lblWorldPosition;
        private UIRadioButton _radPosRightBottom;
        private UIRadioButton _radPosLeftTop;
        private UIRadioButton _radPosLeftBottom;
        private UIRadioButton _radCenterInParentLeftTop;
        private UIRadioButton _radCenterInParentRightBottom;
        private UIRadioButton _radCenterInParentRightTop;
        private src.Controls.AnimationMarkNumericUpDown _nudTranparency;
        private src.Controls.BindAnimationLabel _lblTranparency;
        private src.Controls.BindAnimationLabel _lblPosition;
        private BindAnimationLabel _lblRot;
        private BindAnimationLabel _lblScale;
        private BindAnimationLabel _lblSize;
        private AnimationMarkCheckBox _chkIsAlignmentMarginEnabled;
        private AnimationMarkCheckBox _chkIsAlignmentIgnore;
        private BindAnimationCheckBox _chkCheckBox;
        private Panel _pnlAlignment;
        private AnimationMarkNumericUpDown _nudAlignmentMargin;
        private AnimationMarkNumericUpDown _nudAlignmentMarginV;
        private AnimationMarkCheckBox _chkIsAlignmentMarginEnabledV;
        private src.Controls.AnimationMarkCheckBox _chkVisible;

        #endregion デザイナ生成フィールド

        #region デザイナ生成コード
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(PropWndPaneBasicPage));
            this._grpStringInfo = new System.Windows.Forms.GroupBox();
            this._tbxUserData = new LayoutEditor.Controls.StringTextBox();
            this._tbxComment = new LayoutEditor.Controls.StringTextBox();
            this._tbxPaneName = new LayoutEditor.Controls.StringTextBox();
            this._lblPaneName = new System.Windows.Forms.Label();
            this._lblComment = new System.Windows.Forms.Label();
            this._lblUserData = new System.Windows.Forms.Label();
            this._lblRotZ = new System.Windows.Forms.Label();
            this._grpPosition = new System.Windows.Forms.GroupBox();
            this._lblRot = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblScale = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblSize = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblPosition = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblWorldPosition = new System.Windows.Forms.Label();
            this._ctlWorldPosition = new LayoutEditor.Controls.Fvec3EditUpDownPanel();
            this._ctlRotate = new LayoutEditor.Controls.Fvec3EditUpDownPanel();
            this._ctlSize = new LayoutEditor.Controls.Fvec2EditUpDownPanel();
            this._ctlScale = new LayoutEditor.Controls.Fvec2EditUpDownPanel();
            this._ctlPosition = new LayoutEditor.Controls.Fvec3EditUpDownPanel();
            this._grpCenterPosition = new System.Windows.Forms.GroupBox();
            this._radPosLeftTop = new LayoutEditor.Controls.UIRadioButton();
            this._radPosLeftBottom = new LayoutEditor.Controls.UIRadioButton();
            this._radPosRightBottom = new LayoutEditor.Controls.UIRadioButton();
            this._lblPartsCenterNotice = new System.Windows.Forms.Label();
            this._radPosCenterCenter = new LayoutEditor.Controls.UIRadioButton();
            this._radPosLeftCenter = new LayoutEditor.Controls.UIRadioButton();
            this._radPosRightCenter = new LayoutEditor.Controls.UIRadioButton();
            this._radPosRightTop = new LayoutEditor.Controls.UIRadioButton();
            this._radPosCenterTop = new LayoutEditor.Controls.UIRadioButton();
            this._radPosCenterBottom = new LayoutEditor.Controls.UIRadioButton();
            this._grpEtc = new System.Windows.Forms.GroupBox();
            this._pnlAlignment = new System.Windows.Forms.Panel();
            this._nudAlignmentMarginV = new LayoutEditor.src.Controls.AnimationMarkNumericUpDown();
            this._chkIsAlignmentMarginEnabledV = new LayoutEditor.src.Controls.AnimationMarkCheckBox();
            this._nudAlignmentMargin = new LayoutEditor.src.Controls.AnimationMarkNumericUpDown();
            this._chkIsAlignmentIgnore = new LayoutEditor.src.Controls.AnimationMarkCheckBox();
            this._chkCheckBox = new LayoutEditor.src.Controls.BindAnimationCheckBox();
            this._chkIsAlignmentMarginEnabled = new LayoutEditor.src.Controls.AnimationMarkCheckBox();
            this._chkVisible = new LayoutEditor.src.Controls.AnimationMarkCheckBox();
            this._chkExtUserDataAnimEnabled = new System.Windows.Forms.CheckBox();
            this._lblPartsMagnifyMode = new System.Windows.Forms.Label();
            this._cmbPartsMagnifyMode = new LayoutEditor.Controls.UIComboBox();
            this._chkAvoidPaneTreeCompression = new System.Windows.Forms.CheckBox();
            this._chkLocationAdjust = new System.Windows.Forms.CheckBox();
            this._chkInfuenceTransparency = new System.Windows.Forms.CheckBox();
            this._ttpPaneBasic = new LayoutEditor.Controls.DockContentToolTip(this.components);
            this._lblPartsTranparencyNotice = new System.Windows.Forms.Label();
            this._grpTranparency = new System.Windows.Forms.GroupBox();
            this._lblTranparency = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._nudTranparency = new LayoutEditor.src.Controls.AnimationMarkNumericUpDown();
            this._grpCenterInParent = new System.Windows.Forms.GroupBox();
            this._radCenterInParentRightBottom = new LayoutEditor.Controls.UIRadioButton();
            this._radCenterInParentRightTop = new LayoutEditor.Controls.UIRadioButton();
            this._radCenterInParentLeftTop = new LayoutEditor.Controls.UIRadioButton();
            this._radCenterInParentCenterCenter = new LayoutEditor.Controls.UIRadioButton();
            this._radCenterInParentLeftCenter = new LayoutEditor.Controls.UIRadioButton();
            this._radCenterInParentRightCenter = new LayoutEditor.Controls.UIRadioButton();
            this._radCenterInParentLeftBottom = new LayoutEditor.Controls.UIRadioButton();
            this._radCenterInParentCenterTop = new LayoutEditor.Controls.UIRadioButton();
            this._radCenterInParentCenterBottom = new LayoutEditor.Controls.UIRadioButton();
            this._erpPaneNameChange = new System.Windows.Forms.ErrorProvider(this.components);
            this._grpStringInfo.SuspendLayout();
            this._grpPosition.SuspendLayout();
            this._grpCenterPosition.SuspendLayout();
            this._grpEtc.SuspendLayout();
            this._pnlAlignment.SuspendLayout();
            this._chkIsAlignmentIgnore.SuspendLayout();
            this._grpTranparency.SuspendLayout();
            this._grpCenterInParent.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._erpPaneNameChange)).BeginInit();
            this.SuspendLayout();
            //
            // _grpStringInfo
            //
            this._grpStringInfo.Controls.Add(this._tbxUserData);
            this._grpStringInfo.Controls.Add(this._tbxComment);
            this._grpStringInfo.Controls.Add(this._tbxPaneName);
            this._grpStringInfo.Controls.Add(this._lblPaneName);
            this._grpStringInfo.Controls.Add(this._lblComment);
            this._grpStringInfo.Controls.Add(this._lblUserData);
            resources.ApplyResources(this._grpStringInfo, "_grpStringInfo");
            this._grpStringInfo.Name = "_grpStringInfo";
            this._grpStringInfo.TabStop = false;
            //
            // _tbxUserData
            //
            this._tbxUserData.AccessibleRole = System.Windows.Forms.AccessibleRole.None;
            resources.ApplyResources(this._tbxUserData, "_tbxUserData");
            this._tbxUserData.Name = "_tbxUserData";
            this._tbxUserData.ValueChanged += new System.EventHandler(this.Event_TbxUserData_ValueChanged);
            //
            // _tbxComment
            //
            this._tbxComment.AccessibleRole = System.Windows.Forms.AccessibleRole.None;
            resources.ApplyResources(this._tbxComment, "_tbxComment");
            this._tbxComment.Name = "_tbxComment";
            this._tbxComment.ValueChanged += new System.EventHandler(this.Event_TbxComment_ValueChanged);
            //
            // _tbxPaneName
            //
            this._tbxPaneName.AccessibleRole = System.Windows.Forms.AccessibleRole.None;
            resources.ApplyResources(this._tbxPaneName, "_tbxPaneName");
            this._tbxPaneName.Name = "_tbxPaneName";
            this._tbxPaneName.ValueChanged += new System.EventHandler(this.Event_TbxPaneName_ValueChanged);
            //
            // _lblPaneName
            //
            resources.ApplyResources(this._lblPaneName, "_lblPaneName");
            this._lblPaneName.Name = "_lblPaneName";
            //
            // _lblComment
            //
            resources.ApplyResources(this._lblComment, "_lblComment");
            this._lblComment.Name = "_lblComment";
            //
            // _lblUserData
            //
            resources.ApplyResources(this._lblUserData, "_lblUserData");
            this._lblUserData.Name = "_lblUserData";
            //
            // _lblRotZ
            //
            resources.ApplyResources(this._lblRotZ, "_lblRotZ");
            this._lblRotZ.Name = "_lblRotZ";
            //
            // _grpPosition
            //
            this._grpPosition.Controls.Add(this._lblRot);
            this._grpPosition.Controls.Add(this._lblScale);
            this._grpPosition.Controls.Add(this._lblSize);
            this._grpPosition.Controls.Add(this._lblPosition);
            this._grpPosition.Controls.Add(this._lblWorldPosition);
            this._grpPosition.Controls.Add(this._ctlWorldPosition);
            this._grpPosition.Controls.Add(this._ctlRotate);
            this._grpPosition.Controls.Add(this._ctlSize);
            this._grpPosition.Controls.Add(this._ctlScale);
            this._grpPosition.Controls.Add(this._ctlPosition);
            resources.ApplyResources(this._grpPosition, "_grpPosition");
            this._grpPosition.Name = "_grpPosition";
            this._grpPosition.TabStop = false;
            //
            // _lblRot
            //
            resources.ApplyResources(this._lblRot, "_lblRot");
            this._lblRot.Name = "_lblRot";
            this._lblRot.UseAnimationMark = false;
            this._lblRot.UseContextMenu = false;
            //
            // _lblScale
            //
            resources.ApplyResources(this._lblScale, "_lblScale");
            this._lblScale.Name = "_lblScale";
            this._lblScale.UseAnimationMark = false;
            this._lblScale.UseContextMenu = false;
            //
            // _lblSize
            //
            resources.ApplyResources(this._lblSize, "_lblSize");
            this._lblSize.Name = "_lblSize";
            this._lblSize.UseAnimationMark = false;
            this._lblSize.UseContextMenu = false;
            //
            // _lblPosition
            //
            resources.ApplyResources(this._lblPosition, "_lblPosition");
            this._lblPosition.Name = "_lblPosition";
            this._lblPosition.UseAnimationMark = false;
            this._lblPosition.UseContextMenu = false;
            //
            // _lblWorldPosition
            //
            resources.ApplyResources(this._lblWorldPosition, "_lblWorldPosition");
            this._lblWorldPosition.Name = "_lblWorldPosition";
            //
            // _ctlWorldPosition
            //
            this._ctlWorldPosition.Increment = 1F;
            resources.ApplyResources(this._ctlWorldPosition, "_ctlWorldPosition");
            this._ctlWorldPosition.Name = "_ctlWorldPosition";
            this._ctlWorldPosition.RoundByStepValue = false;
            this._ctlWorldPosition.TabStop = false;
            this._ctlWorldPosition.UseAnimationMark = false;
            this._ctlWorldPosition.XEnabled = false;
            this._ctlWorldPosition.YEnabled = false;
            this._ctlWorldPosition.ZEnabled = false;
            //
            // _ctlRotate
            //
            this._ctlRotate.Increment = 1F;
            resources.ApplyResources(this._ctlRotate, "_ctlRotate");
            this._ctlRotate.Name = "_ctlRotate";
            this._ctlRotate.RoundByStepValue = false;
            this._ctlRotate.UseAnimationMark = true;
            this._ctlRotate.XEnabled = true;
            this._ctlRotate.YEnabled = true;
            this._ctlRotate.ZEnabled = true;
            //
            // _ctlSize
            //
            this._ctlSize.DecimalPlaces = 2;
            this._ctlSize.Increment = 1F;
            this._ctlSize.LabelX = "X :";
            this._ctlSize.LabelY = "Y :";
            this._ctlSize.Link = false;
            resources.ApplyResources(this._ctlSize, "_ctlSize");
            this._ctlSize.Name = "_ctlSize";
            this._ctlSize.RoundByStepValue = false;
            this._ctlSize.TextBoxWidth = 62;
            this._ctlSize.UseAnimationMark = true;
            this._ctlSize.Vertical = false;
            this._ctlSize.XEnabled = true;
            this._ctlSize.YEnabled = true;
            //
            // _ctlScale
            //
            this._ctlScale.DecimalPlaces = 2;
            this._ctlScale.Increment = 0.1F;
            this._ctlScale.LabelX = "X :";
            this._ctlScale.LabelY = "Y :";
            this._ctlScale.Link = true;
            resources.ApplyResources(this._ctlScale, "_ctlScale");
            this._ctlScale.Name = "_ctlScale";
            this._ctlScale.RoundByStepValue = false;
            this._ctlScale.TextBoxWidth = 62;
            this._ctlScale.UseAnimationMark = true;
            this._ctlScale.Vertical = false;
            this._ctlScale.XEnabled = true;
            this._ctlScale.YEnabled = true;
            //
            // _ctlPosition
            //
            this._ctlPosition.Increment = 1F;
            resources.ApplyResources(this._ctlPosition, "_ctlPosition");
            this._ctlPosition.Name = "_ctlPosition";
            this._ctlPosition.RoundByStepValue = false;
            this._ctlPosition.UseAnimationMark = true;
            this._ctlPosition.XEnabled = true;
            this._ctlPosition.YEnabled = true;
            this._ctlPosition.ZEnabled = true;
            //
            // _grpCenterPosition
            //
            this._grpCenterPosition.Controls.Add(this._radPosLeftTop);
            this._grpCenterPosition.Controls.Add(this._radPosLeftBottom);
            this._grpCenterPosition.Controls.Add(this._radPosRightBottom);
            this._grpCenterPosition.Controls.Add(this._lblPartsCenterNotice);
            this._grpCenterPosition.Controls.Add(this._radPosCenterCenter);
            this._grpCenterPosition.Controls.Add(this._radPosLeftCenter);
            this._grpCenterPosition.Controls.Add(this._radPosRightCenter);
            this._grpCenterPosition.Controls.Add(this._radPosRightTop);
            this._grpCenterPosition.Controls.Add(this._radPosCenterTop);
            this._grpCenterPosition.Controls.Add(this._radPosCenterBottom);
            resources.ApplyResources(this._grpCenterPosition, "_grpCenterPosition");
            this._grpCenterPosition.Name = "_grpCenterPosition";
            this._grpCenterPosition.TabStop = false;
            //
            // _radPosLeftTop
            //
            resources.ApplyResources(this._radPosLeftTop, "_radPosLeftTop");
            this._radPosLeftTop.Name = "_radPosLeftTop";
            this._radPosLeftTop.RadioChecked += new System.EventHandler(this._radPosH_RadioChecked);
            //
            // _radPosLeftBottom
            //
            resources.ApplyResources(this._radPosLeftBottom, "_radPosLeftBottom");
            this._radPosLeftBottom.Name = "_radPosLeftBottom";
            this._radPosLeftBottom.RadioChecked += new System.EventHandler(this._radPosH_RadioChecked);
            //
            // _radPosRightBottom
            //
            resources.ApplyResources(this._radPosRightBottom, "_radPosRightBottom");
            this._radPosRightBottom.Name = "_radPosRightBottom";
            this._radPosRightBottom.RadioChecked += new System.EventHandler(this._radPosH_RadioChecked);
            //
            // _lblPartsCenterNotice
            //
            this._lblPartsCenterNotice.BackColor = System.Drawing.SystemColors.Control;
            resources.ApplyResources(this._lblPartsCenterNotice, "_lblPartsCenterNotice");
            this._lblPartsCenterNotice.Name = "_lblPartsCenterNotice";
            //
            // _radPosCenterCenter
            //
            resources.ApplyResources(this._radPosCenterCenter, "_radPosCenterCenter");
            this._radPosCenterCenter.Name = "_radPosCenterCenter";
            this._radPosCenterCenter.RadioChecked += new System.EventHandler(this._radPosH_RadioChecked);
            //
            // _radPosLeftCenter
            //
            resources.ApplyResources(this._radPosLeftCenter, "_radPosLeftCenter");
            this._radPosLeftCenter.Name = "_radPosLeftCenter";
            this._radPosLeftCenter.RadioChecked += new System.EventHandler(this._radPosH_RadioChecked);
            //
            // _radPosRightCenter
            //
            resources.ApplyResources(this._radPosRightCenter, "_radPosRightCenter");
            this._radPosRightCenter.Name = "_radPosRightCenter";
            this._radPosRightCenter.RadioChecked += new System.EventHandler(this._radPosH_RadioChecked);
            //
            // _radPosRightTop
            //
            resources.ApplyResources(this._radPosRightTop, "_radPosRightTop");
            this._radPosRightTop.Name = "_radPosRightTop";
            this._radPosRightTop.RadioChecked += new System.EventHandler(this._radPosH_RadioChecked);
            //
            // _radPosCenterTop
            //
            resources.ApplyResources(this._radPosCenterTop, "_radPosCenterTop");
            this._radPosCenterTop.Name = "_radPosCenterTop";
            this._radPosCenterTop.RadioChecked += new System.EventHandler(this._radPosH_RadioChecked);
            //
            // _radPosCenterBottom
            //
            resources.ApplyResources(this._radPosCenterBottom, "_radPosCenterBottom");
            this._radPosCenterBottom.Name = "_radPosCenterBottom";
            this._radPosCenterBottom.RadioChecked += new System.EventHandler(this._radPosH_RadioChecked);
            //
            // _grpEtc
            //
            this._grpEtc.Controls.Add(this._pnlAlignment);
            this._grpEtc.Controls.Add(this._chkVisible);
            this._grpEtc.Controls.Add(this._chkExtUserDataAnimEnabled);
            this._grpEtc.Controls.Add(this._lblPartsMagnifyMode);
            this._grpEtc.Controls.Add(this._cmbPartsMagnifyMode);
            this._grpEtc.Controls.Add(this._chkAvoidPaneTreeCompression);
            this._grpEtc.Controls.Add(this._chkLocationAdjust);
            resources.ApplyResources(this._grpEtc, "_grpEtc");
            this._grpEtc.Name = "_grpEtc";
            this._grpEtc.TabStop = false;
            //
            // _pnlAlignment
            //
            this._pnlAlignment.Controls.Add(this._nudAlignmentMarginV);
            this._pnlAlignment.Controls.Add(this._chkIsAlignmentMarginEnabledV);
            this._pnlAlignment.Controls.Add(this._nudAlignmentMargin);
            this._pnlAlignment.Controls.Add(this._chkIsAlignmentIgnore);
            this._pnlAlignment.Controls.Add(this._chkIsAlignmentMarginEnabled);
            resources.ApplyResources(this._pnlAlignment, "_pnlAlignment");
            this._pnlAlignment.Name = "_pnlAlignment";
            //
            // _nudAlignmentMarginV
            //
            this._nudAlignmentMarginV.DecimalPlace = 2;
            this._nudAlignmentMarginV.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            resources.ApplyResources(this._nudAlignmentMarginV, "_nudAlignmentMarginV");
            this._nudAlignmentMarginV.Maximum = new decimal(new int[] {
            10000,
            0,
            0,
            0});
            this._nudAlignmentMarginV.Minimum = new decimal(new int[] {
            10000,
            0,
            0,
            -2147483648});
            this._nudAlignmentMarginV.Name = "_nudAlignmentMarginV";
            this._nudAlignmentMarginV.NumericUpDownBackColor = System.Drawing.SystemColors.Window;
            this._nudAlignmentMarginV.NumericUpDownSize = new System.Drawing.Size(61, 19);
            this._nudAlignmentMarginV.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._nudAlignmentMarginV.UseAnimationMark = false;
            this._nudAlignmentMarginV.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            //
            // _chkIsAlignmentMarginEnabledV
            //
            this._chkIsAlignmentMarginEnabledV.CheckBoxBackColor = System.Drawing.SystemColors.Control;
            resources.ApplyResources(this._chkIsAlignmentMarginEnabledV, "_chkIsAlignmentMarginEnabledV");
            this._chkIsAlignmentMarginEnabledV.Checked = false;
            this._chkIsAlignmentMarginEnabledV.Name = "_chkIsAlignmentMarginEnabledV";
            this._chkIsAlignmentMarginEnabledV.UseAnimationMark = false;
            this._chkIsAlignmentMarginEnabledV.CheckedChanged += new System.EventHandler(this._chkIsAlignmentMarginEnabledV_CheckedChanged);
            //
            // _nudAlignmentMargin
            //
            this._nudAlignmentMargin.DecimalPlace = 2;
            this._nudAlignmentMargin.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            resources.ApplyResources(this._nudAlignmentMargin, "_nudAlignmentMargin");
            this._nudAlignmentMargin.Maximum = new decimal(new int[] {
            10000,
            0,
            0,
            0});
            this._nudAlignmentMargin.Minimum = new decimal(new int[] {
            10000,
            0,
            0,
            -2147483648});
            this._nudAlignmentMargin.Name = "_nudAlignmentMargin";
            this._nudAlignmentMargin.NumericUpDownBackColor = System.Drawing.SystemColors.Window;
            this._nudAlignmentMargin.NumericUpDownSize = new System.Drawing.Size(61, 19);
            this._nudAlignmentMargin.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._nudAlignmentMargin.UseAnimationMark = false;
            this._nudAlignmentMargin.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            //
            // _chkIsAlignmentIgnore
            //
            this._chkIsAlignmentIgnore.CheckBoxBackColor = System.Drawing.SystemColors.Control;
            resources.ApplyResources(this._chkIsAlignmentIgnore, "_chkIsAlignmentIgnore");
            this._chkIsAlignmentIgnore.Checked = false;
            this._chkIsAlignmentIgnore.Controls.Add(this._chkCheckBox);
            this._chkIsAlignmentIgnore.Name = "_chkIsAlignmentIgnore";
            this._chkIsAlignmentIgnore.UseAnimationMark = false;
            this._chkIsAlignmentIgnore.CheckedChanged += new System.EventHandler(this._chkIsAlignmentIgnore_CheckedChanged);
            //
            // _chkCheckBox
            //
            resources.ApplyResources(this._chkCheckBox, "_chkCheckBox");
            this._chkCheckBox.BackColor = System.Drawing.SystemColors.Control;
            this._chkCheckBox.Name = "_chkCheckBox";
            this._chkCheckBox.UseAnimationMark = false;
            this._chkCheckBox.UseContextMenu = false;
            this._chkCheckBox.UseVisualStyleBackColor = false;
            //
            // _chkIsAlignmentMarginEnabled
            //
            this._chkIsAlignmentMarginEnabled.CheckBoxBackColor = System.Drawing.SystemColors.Control;
            resources.ApplyResources(this._chkIsAlignmentMarginEnabled, "_chkIsAlignmentMarginEnabled");
            this._chkIsAlignmentMarginEnabled.Checked = false;
            this._chkIsAlignmentMarginEnabled.Name = "_chkIsAlignmentMarginEnabled";
            this._chkIsAlignmentMarginEnabled.UseAnimationMark = false;
            this._chkIsAlignmentMarginEnabled.CheckedChanged += new System.EventHandler(this._chkIsAlignmentMarginEnabled_CheckedChanged);
            //
            // _chkVisible
            //
            this._chkVisible.CheckBoxBackColor = System.Drawing.SystemColors.Control;
            resources.ApplyResources(this._chkVisible, "_chkVisible");
            this._chkVisible.Checked = false;
            this._chkVisible.Name = "_chkVisible";
            this._chkVisible.UseAnimationMark = true;
            this._chkVisible.CheckedChanged += new System.EventHandler(this.Event_chkVisible_CheckedChanged);
            //
            // _chkExtUserDataAnimEnabled
            //
            resources.ApplyResources(this._chkExtUserDataAnimEnabled, "_chkExtUserDataAnimEnabled");
            this._chkExtUserDataAnimEnabled.Name = "_chkExtUserDataAnimEnabled";
            this._chkExtUserDataAnimEnabled.CheckedChanged += new System.EventHandler(this.Event_ChkExtUserDataAnimEnabled_CheckedChanged);
            //
            // _lblPartsMagnifyMode
            //
            resources.ApplyResources(this._lblPartsMagnifyMode, "_lblPartsMagnifyMode");
            this._lblPartsMagnifyMode.Name = "_lblPartsMagnifyMode";
            //
            // _cmbPartsMagnifyMode
            //
            this._cmbPartsMagnifyMode.FormattingEnabled = true;
            resources.ApplyResources(this._cmbPartsMagnifyMode, "_cmbPartsMagnifyMode");
            this._cmbPartsMagnifyMode.Name = "_cmbPartsMagnifyMode";
            this._cmbPartsMagnifyMode.SelectedItemData = null;
            //
            // _chkAvoidPaneTreeCompression
            //
            resources.ApplyResources(this._chkAvoidPaneTreeCompression, "_chkAvoidPaneTreeCompression");
            this._chkAvoidPaneTreeCompression.Name = "_chkAvoidPaneTreeCompression";
            this._chkAvoidPaneTreeCompression.CheckedChanged += new System.EventHandler(this.Event_ChkAvoidPaneTreeCompression_CheckedChanged);
            //
            // _chkLocationAdjust
            //
            resources.ApplyResources(this._chkLocationAdjust, "_chkLocationAdjust");
            this._chkLocationAdjust.Name = "_chkLocationAdjust";
            this._chkLocationAdjust.CheckedChanged += new System.EventHandler(this.Event_ChkLocationAdjust_CheckedChanged);
            //
            // _chkInfuenceTransparency
            //
            resources.ApplyResources(this._chkInfuenceTransparency, "_chkInfuenceTransparency");
            this._chkInfuenceTransparency.Name = "_chkInfuenceTransparency";
            this._chkInfuenceTransparency.CheckedChanged += new System.EventHandler(this.Event_ChkInfuenceTransparency_CheckedChanged);
            //
            // _lblPartsTranparencyNotice
            //
            this._lblPartsTranparencyNotice.BackColor = System.Drawing.SystemColors.Control;
            resources.ApplyResources(this._lblPartsTranparencyNotice, "_lblPartsTranparencyNotice");
            this._lblPartsTranparencyNotice.Name = "_lblPartsTranparencyNotice";
            this._ttpPaneBasic.SetToolTip(this._lblPartsTranparencyNotice, resources.GetString("_lblPartsTranparencyNotice.ToolTip"));
            //
            // _grpTranparency
            //
            this._grpTranparency.Controls.Add(this._lblTranparency);
            this._grpTranparency.Controls.Add(this._nudTranparency);
            this._grpTranparency.Controls.Add(this._lblPartsTranparencyNotice);
            this._grpTranparency.Controls.Add(this._chkInfuenceTransparency);
            resources.ApplyResources(this._grpTranparency, "_grpTranparency");
            this._grpTranparency.Name = "_grpTranparency";
            this._grpTranparency.TabStop = false;
            //
            // _lblTranparency
            //
            resources.ApplyResources(this._lblTranparency, "_lblTranparency");
            this._lblTranparency.Name = "_lblTranparency";
            this._lblTranparency.UseAnimationMark = false;
            this._lblTranparency.UseContextMenu = false;
            //
            // _nudTranparency
            //
            this._nudTranparency.DecimalPlace = 2;
            this._nudTranparency.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            resources.ApplyResources(this._nudTranparency, "_nudTranparency");
            this._nudTranparency.Maximum = new decimal(new int[] {
            10000,
            0,
            0,
            0});
            this._nudTranparency.Minimum = new decimal(new int[] {
            10000,
            0,
            0,
            -2147483648});
            this._nudTranparency.Name = "_nudTranparency";
            this._nudTranparency.NumericUpDownBackColor = System.Drawing.SystemColors.Window;
            this._nudTranparency.NumericUpDownSize = new System.Drawing.Size(61, 19);
            this._nudTranparency.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._nudTranparency.UseAnimationMark = true;
            this._nudTranparency.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            //
            // _grpCenterInParent
            //
            this._grpCenterInParent.Controls.Add(this._radCenterInParentRightBottom);
            this._grpCenterInParent.Controls.Add(this._radCenterInParentRightTop);
            this._grpCenterInParent.Controls.Add(this._radCenterInParentLeftTop);
            this._grpCenterInParent.Controls.Add(this._radCenterInParentCenterCenter);
            this._grpCenterInParent.Controls.Add(this._radCenterInParentLeftCenter);
            this._grpCenterInParent.Controls.Add(this._radCenterInParentRightCenter);
            this._grpCenterInParent.Controls.Add(this._radCenterInParentLeftBottom);
            this._grpCenterInParent.Controls.Add(this._radCenterInParentCenterTop);
            this._grpCenterInParent.Controls.Add(this._radCenterInParentCenterBottom);
            resources.ApplyResources(this._grpCenterInParent, "_grpCenterInParent");
            this._grpCenterInParent.Name = "_grpCenterInParent";
            this._grpCenterInParent.TabStop = false;
            //
            // _radCenterInParentRightBottom
            //
            resources.ApplyResources(this._radCenterInParentRightBottom, "_radCenterInParentRightBottom");
            this._radCenterInParentRightBottom.Name = "_radCenterInParentRightBottom";
            this._radCenterInParentRightBottom.RadioChecked += new System.EventHandler(this._radCenterInParentH_RadioChecked);
            //
            // _radCenterInParentRightTop
            //
            resources.ApplyResources(this._radCenterInParentRightTop, "_radCenterInParentRightTop");
            this._radCenterInParentRightTop.Name = "_radCenterInParentRightTop";
            this._radCenterInParentRightTop.RadioChecked += new System.EventHandler(this._radCenterInParentH_RadioChecked);
            //
            // _radCenterInParentLeftTop
            //
            resources.ApplyResources(this._radCenterInParentLeftTop, "_radCenterInParentLeftTop");
            this._radCenterInParentLeftTop.Name = "_radCenterInParentLeftTop";
            this._radCenterInParentLeftTop.RadioChecked += new System.EventHandler(this._radCenterInParentH_RadioChecked);
            //
            // _radCenterInParentCenterCenter
            //
            resources.ApplyResources(this._radCenterInParentCenterCenter, "_radCenterInParentCenterCenter");
            this._radCenterInParentCenterCenter.Name = "_radCenterInParentCenterCenter";
            this._radCenterInParentCenterCenter.RadioChecked += new System.EventHandler(this._radCenterInParentH_RadioChecked);
            //
            // _radCenterInParentLeftCenter
            //
            resources.ApplyResources(this._radCenterInParentLeftCenter, "_radCenterInParentLeftCenter");
            this._radCenterInParentLeftCenter.Name = "_radCenterInParentLeftCenter";
            this._radCenterInParentLeftCenter.RadioChecked += new System.EventHandler(this._radCenterInParentH_RadioChecked);
            //
            // _radCenterInParentRightCenter
            //
            resources.ApplyResources(this._radCenterInParentRightCenter, "_radCenterInParentRightCenter");
            this._radCenterInParentRightCenter.Name = "_radCenterInParentRightCenter";
            this._radCenterInParentRightCenter.RadioChecked += new System.EventHandler(this._radCenterInParentH_RadioChecked);
            //
            // _radCenterInParentLeftBottom
            //
            resources.ApplyResources(this._radCenterInParentLeftBottom, "_radCenterInParentLeftBottom");
            this._radCenterInParentLeftBottom.Name = "_radCenterInParentLeftBottom";
            this._radCenterInParentLeftBottom.RadioChecked += new System.EventHandler(this._radCenterInParentH_RadioChecked);
            //
            // _radCenterInParentCenterTop
            //
            resources.ApplyResources(this._radCenterInParentCenterTop, "_radCenterInParentCenterTop");
            this._radCenterInParentCenterTop.Name = "_radCenterInParentCenterTop";
            this._radCenterInParentCenterTop.RadioChecked += new System.EventHandler(this._radCenterInParentH_RadioChecked);
            //
            // _radCenterInParentCenterBottom
            //
            resources.ApplyResources(this._radCenterInParentCenterBottom, "_radCenterInParentCenterBottom");
            this._radCenterInParentCenterBottom.Name = "_radCenterInParentCenterBottom";
            this._radCenterInParentCenterBottom.RadioChecked += new System.EventHandler(this._radCenterInParentH_RadioChecked);
            //
            // _erpPaneNameChange
            //
            this._erpPaneNameChange.ContainerControl = this;
            resources.ApplyResources(this._erpPaneNameChange, "_erpPaneNameChange");
            //
            // PropWndPaneBasicPage
            //
            this.Controls.Add(this._grpCenterInParent);
            this.Controls.Add(this._grpTranparency);
            this.Controls.Add(this._grpEtc);
            this.Controls.Add(this._grpCenterPosition);
            this.Controls.Add(this._grpPosition);
            this.Controls.Add(this._grpStringInfo);
            this.Name = "PropWndPaneBasicPage";
            resources.ApplyResources(this, "$this");
            this._grpStringInfo.ResumeLayout(false);
            this._grpStringInfo.PerformLayout();
            this._grpPosition.ResumeLayout(false);
            this._grpPosition.PerformLayout();
            this._grpCenterPosition.ResumeLayout(false);
            this._grpEtc.ResumeLayout(false);
            this._pnlAlignment.ResumeLayout(false);
            this._chkIsAlignmentIgnore.ResumeLayout(false);
            this._chkIsAlignmentIgnore.PerformLayout();
            this._grpTranparency.ResumeLayout(false);
            this._grpTranparency.PerformLayout();
            this._grpCenterInParent.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this._erpPaneNameChange)).EndInit();
            this.ResumeLayout(false);

        }

        #endregion デザイナ生成コード

        #region ----------- フィールド

        PaneGuiAdapterGroup _oldTarget = null;
        bool _isSystemCalled = false;

        #endregion ----------- フィールド

        #region ----------- プロパティ


        #endregion ----------- プロパティ

        #region ----------- 非公開プロパティ

        /// <summary>
        /// 操作対象ペインを操作するクラスを取得します。
        /// </summary>
        PaneManipulator _TargetPaneMpn
        {
            get
            {
                if (this.Target == null)
                {
                    return null;
                }

                // ページの更新等が行われるときには Active は null ではないはず？
                // 確認のために Assert
                Debug.Assert(this.Target.Active != null);

                if (this.Target.Active == null)
                {
                    return null;
                }

                if (_OwnerPane != null)
                {
                    return Target.Active.PartsSubPaneManipulators.FirstOrDefault((mnp) => object.ReferenceEquals(mnp.IPane, _OwnerPane)) as PaneManipulator;
                }
                else
                {
                    return Target.Active.PaneManipulator;
                }
            }
        }

        #endregion ----------- 非公開プロパティ

        /// <summary>
        /// プロパティ初期化。
        /// </summary>
        protected override void InitializeProperty()
        {
            // イベントハンドラを設定します。
            _ctlSize.OnFVec2Edit += _ctlSize_OnFVec2Edit;
            _ctlScale.OnFVec2Edit += _ctlScale_OnFVec2Edit;
            _ctlPosition.OnFVec3Edit += _ctlPosition_OnFVec3Edit;
            _ctlRotate.OnFVec3Edit += _ctlRotate_OnFVec3Edit;

            // ViewManagerへのメッセージハンドラを設定します
            _ctlSize.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _ctlPosition.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _ctlScale.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _ctlRotate.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _nudTranparency.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _chkVisible.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);

            _nudTranparency.ValueChanged += new EventHandler(_nudTransparency_ValueChanged);

            _nudAlignmentMargin.ValueChanged += _nudAlignmentMargin_ValueChanged;
            _nudAlignmentMarginV.ValueChanged += _nudAlignmentMarginV_ValueChanged;

            _radPosLeftTop.Tag = new HVLocation(HorizontalLocation.Left, VerticalLocation.Top);
            _radPosLeftCenter.Tag = new HVLocation(HorizontalLocation.Left, VerticalLocation.Center);
            _radPosLeftBottom.Tag = new HVLocation(HorizontalLocation.Left, VerticalLocation.Bottom);
            _radPosCenterTop.Tag = new HVLocation(HorizontalLocation.Center, VerticalLocation.Top);
            _radPosCenterCenter.Tag = new HVLocation(HorizontalLocation.Center, VerticalLocation.Center);
            _radPosCenterBottom.Tag = new HVLocation(HorizontalLocation.Center, VerticalLocation.Bottom);
            _radPosRightTop.Tag = new HVLocation(HorizontalLocation.Right, VerticalLocation.Top);
            _radPosRightCenter.Tag = new HVLocation(HorizontalLocation.Right, VerticalLocation.Center);
            _radPosRightBottom.Tag = new HVLocation(HorizontalLocation.Right, VerticalLocation.Bottom);

            _radCenterInParentLeftTop.Tag = new HVLocation(HorizontalLocation.Left, VerticalLocation.Top);
            _radCenterInParentLeftCenter.Tag = new HVLocation(HorizontalLocation.Left, VerticalLocation.Center);
            _radCenterInParentLeftBottom.Tag = new HVLocation(HorizontalLocation.Left, VerticalLocation.Bottom);
            _radCenterInParentCenterTop.Tag = new HVLocation(HorizontalLocation.Center, VerticalLocation.Top);
            _radCenterInParentCenterCenter.Tag = new HVLocation(HorizontalLocation.Center, VerticalLocation.Center);
            _radCenterInParentCenterBottom.Tag = new HVLocation(HorizontalLocation.Center, VerticalLocation.Bottom);
            _radCenterInParentRightTop.Tag = new HVLocation(HorizontalLocation.Right, VerticalLocation.Top);
            _radCenterInParentRightCenter.Tag = new HVLocation(HorizontalLocation.Right, VerticalLocation.Center);
            _radCenterInParentRightBottom.Tag = new HVLocation(HorizontalLocation.Right, VerticalLocation.Bottom);

            _cmbPartsMagnifyMode.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_PANEBASIC_PARTSMAG_NONE"),   PartsMagnifyInfluence.None));
            _cmbPartsMagnifyMode.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_PANEBASIC_PARTSMAG_SCALEMAGNIFY"), PartsMagnifyInfluence.ScaleMagnify));
            _cmbPartsMagnifyMode.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_PANEBASIC_PARTSMAG_ADJUSTTOPARTSBOUND"), PartsMagnifyInfluence.AdjustToPartsBound));
            _cmbPartsMagnifyMode.SelectedIndexChanged += Event_CmbPartsMagnifyMode_SelectedIndexChanged;

            _tbxPaneName.InitializeTextValidator(PaneHelper.CheckPaneNameValid);
            _tbxUserData.InitializeTextValidator(PaneHelper.CheckUserDataValid);
        }

        /// <summary>
        /// GUIの値を更新します。
        /// ハンドラによる、参照対象の更新が起きないように
        /// IsGUIUpdating フラグを設定しています。
        /// </summary>
        protected override void UpdateProperty()
        {
            // ターゲットを参照してUIを更新する
            // 対象が無い場合は何もしません。
            if (_TargetPaneMpn == null || _TargetPaneMpn.IPane == null)
            {
                return;
            }

            IPane pane = _TargetPaneMpn.IPane;

            // アニメーションマークとコンテキストメニューの有効無効
            bool bUse = CanUseAnimationMark(pane?.OwnerSubScene);
            IEnumerable<IAnimationMarkUsable> animCtrlList = GetAnimationMarkUsableControl();
            foreach (IAnimationMarkUsable ctrl in animCtrlList)
            {
                ctrl.UseAnimationMark = bUse;
            }

            // ペイン名
            _tbxPaneName.SetValue(pane.PaneName);
            _tbxComment.SetValue(pane.UserCommentString);
            _tbxUserData.SetValue(pane.UserData);

            // サイズ
            _ctlSize.FVec2Value = new FVec2(pane.Size);
            var sizeMode = Target.PaneSizeMode;
            _ctlSize.XEnabled = (sizeMode & PaneSizeMode.HEnabled) != 0;
            _ctlSize.YEnabled = (sizeMode & PaneSizeMode.VEnabled) != 0;

            // 位置
            _ctlPosition.FVec3Value = pane.Trans;
            _ctlWorldPosition.FVec3Value = new FVec3(pane.XInWorld4x4, pane.YInWorld4x4, pane.ZInWorld4x4);

            // スケール
            _ctlScale.FVec2Value = new FVec2(pane.Scale);

            // 回転
            _ctlRotate.FVec3Value = pane.RotAng;

            // 透明度
            _nudTranparency.Value = pane.Transparency;

            // 中心位置
            bool isPartsPane = pane.PaneKind == PaneKind.Parts;
            HVLocation posLocation = new HVLocation(pane.BasePosTypeH, pane.BasePosTypeV);
            _lblPartsCenterNotice.Visible = isPartsPane;
            _radPosLeftTop.SetCheckedByTag(posLocation);
            _radPosLeftCenter.SetCheckedByTag(posLocation);
            _radPosLeftBottom.SetCheckedByTag(posLocation);
            _radPosCenterTop.SetCheckedByTag(posLocation);
            _radPosCenterCenter.SetCheckedByTag(posLocation);
            _radPosCenterBottom.SetCheckedByTag(posLocation);
            _radPosRightTop.SetCheckedByTag(posLocation);
            _radPosRightCenter.SetCheckedByTag(posLocation);
            _radPosRightBottom.SetCheckedByTag(posLocation);

            _radPosLeftTop.Enabled = !isPartsPane;
            _radPosLeftCenter.Enabled = !isPartsPane;
            _radPosLeftBottom.Enabled = !isPartsPane;
            _radPosCenterTop.Enabled = !isPartsPane;
            _radPosCenterCenter.Enabled = !isPartsPane;
            _radPosCenterBottom.Enabled = !isPartsPane;
            _radPosRightTop.Enabled = !isPartsPane;
            _radPosRightCenter.Enabled = !isPartsPane;
            _radPosRightBottom.Enabled = !isPartsPane;

            // 親ペインでの原点位置
            HVLocation centerInParentLocation = new HVLocation(pane.ParentBasePosTypeH, pane.ParentBasePosTypeV);
            _radCenterInParentLeftTop.SetCheckedByTag(centerInParentLocation);
            _radCenterInParentLeftCenter.SetCheckedByTag(centerInParentLocation);
            _radCenterInParentLeftBottom.SetCheckedByTag(centerInParentLocation);
            _radCenterInParentCenterTop.SetCheckedByTag(centerInParentLocation);
            _radCenterInParentCenterCenter.SetCheckedByTag(centerInParentLocation);
            _radCenterInParentCenterBottom.SetCheckedByTag(centerInParentLocation);
            _radCenterInParentRightTop.SetCheckedByTag(centerInParentLocation);
            _radCenterInParentRightCenter.SetCheckedByTag(centerInParentLocation);
            _radCenterInParentRightBottom.SetCheckedByTag(centerInParentLocation);

            _grpCenterInParent.Enabled = !(pane.Parent as IPane).IsRootPane();

            // 可視フラグ
            _chkVisible.Checked = pane.Visible;
            _lblPartsTranparencyNotice.Visible = pane.PaneKind == PaneKind.Parts;
            // 透明度を子供に伝播する
            _chkInfuenceTransparency.Checked = pane.InfluenceChildrenTransparency;
            // 位置調整の対象にする
            _chkLocationAdjust.Checked = pane.LocationAdjust;

            // 整列マージン
            var parent = pane.Parent as IPane;
            var alignment = (parent == null || parent.IPaneExParamater == null || parent.IsRootPane()) ? null : parent.IPaneExParamater as IAlignment;
            bool isAlignmentHorizontalMargin = alignment != null && alignment.IsAlignmentHorizontalEnabled;
            bool isAlignmentVerticalMargin = alignment != null && alignment.IsAlignmentVerticalEnabled;
            _chkIsAlignmentMarginEnabled.Checked = pane.IsAlignmentHorizontalMarginEnabled;
            _chkIsAlignmentMarginEnabledV.Checked = pane.IsAlignmentVerticalMarginEnabled;
            _chkIsAlignmentMarginEnabled.Enabled = isAlignmentHorizontalMargin;
            _chkIsAlignmentMarginEnabledV.Enabled = isAlignmentVerticalMargin;
            _nudAlignmentMargin.Value = (Decimal)pane.AlignmentHorizontalMargin;
            _nudAlignmentMarginV.Value = (Decimal)pane.AlignmentVerticalMargin;
            _nudAlignmentMargin.Enabled = pane.IsAlignmentHorizontalMarginEnabled && isAlignmentHorizontalMargin;
            _nudAlignmentMarginV.Enabled = pane.IsAlignmentVerticalMarginEnabled && isAlignmentVerticalMargin;
            _chkIsAlignmentIgnore.Checked = pane.IsAlignmentIgnore;
            // 部品ペインとして利用される場合がある為、 Ignore を抑制する事は出来ない。
            //_chkIsAlignmentIgnore.Enabled = true;
            var appSettings = Owner?.Owner?.AppSetting;
            _pnlAlignment.Visible = appSettings == null || appSettings.ProjectSettings.AlignmentPaneEnabled;

            // 圧縮禁止
            _chkAvoidPaneTreeCompression.Checked = pane.AvoidPaneTreeCompression;
            // 拡張ユーザー情報のアニメーションを有効にする
            _chkExtUserDataAnimEnabled.Checked = pane.ExtUserDataAnimEnabled;

            // 部品サイズ調整を無視する
            _cmbPartsMagnifyMode.SetSelectedByData(pane.PartsMagnifyInfluence);

            // 同時編集
            Color color = GetMultiEditColor();
            _ctlSize.TextBoxBackColor = color;
            _ctlPosition.TextBoxBackColor = color;
            _ctlScale.TextBoxBackColor = color;
            _ctlRotate.TextBoxBackColor = color;
            _nudTranparency.NumericUpDownBackColor = color;
            _nudAlignmentMargin.NumericUpDownBackColor = color;
            _nudAlignmentMarginV.NumericUpDownBackColor = color;

            color = GetMultiEditPanelColor();
            _grpCenterPosition.BackColor = color;
            //_pnlPositionH.BackColor = color;
            //_pnlPositionV.BackColor = color;
            _chkVisible.CheckBoxBackColor = color;
            _chkLocationAdjust.BackColor = color;
            _chkAvoidPaneTreeCompression.BackColor = color;
            _chkExtUserDataAnimEnabled.BackColor = color;
            _lblPartsMagnifyMode.BackColor = color;
            _chkIsAlignmentMarginEnabled.CheckBoxBackColor = color;
            _nudAlignmentMargin.BackColor = color;
            _chkIsAlignmentMarginEnabledV.CheckBoxBackColor = color;
            _nudAlignmentMarginV.BackColor = color;
            _chkIsAlignmentIgnore.CheckBoxBackColor = color;

            color = GetMultiEditPanelColor(!_grpCenterInParent.Enabled);
            _grpCenterInParent.BackColor = color;

            bool capturePaneDisabled = !PaneHelper.IsTextureCapturedPane(_TargetPaneMpn.IPane);
            bool haveCaptureTexturePane = PaneHelper.HasCapturingPaneUnderTree(_TargetPaneMpn.IPane);

            // キャプチャペインで対応していない要素を無効化する
            _grpCenterPosition.Enabled = capturePaneDisabled;
            _grpTranparency.Enabled = capturePaneDisabled;
            _chkVisible.Enabled = capturePaneDisabled;

            // 回転とスケールは子供にキャプチャしているペインがある場合も無効
            _ctlScale.Enabled = capturePaneDisabled && !haveCaptureTexturePane;
            _ctlRotate.Enabled = capturePaneDisabled && !haveCaptureTexturePane;
            _lblScale.Enabled = capturePaneDisabled && !haveCaptureTexturePane;
            _lblRot.Enabled = capturePaneDisabled && !haveCaptureTexturePane;

            // アニメーションマークで利用するアトリビュートを関連付け
            _ctlSize.SetTargetAttribute(PaneGuiAdapterGroupHelper.GetSizeIAttr(Target));
            _ctlPosition.SetTargetAttribute(PaneGuiAdapterGroupHelper.GetTransIAttr(Target));
            _ctlScale.SetTargetAttribute(PaneGuiAdapterGroupHelper.GetScaleIAttr(Target));
            _ctlRotate.SetTargetAttribute(PaneGuiAdapterGroupHelper.GetRotAngIAttr(Target));
            _nudTranparency.SetTargetAttribute(PaneGuiAdapterGroupHelper.GetTransparencyIAttr(Target));
            _chkVisible.SetTargetAttribute(PaneGuiAdapterGroupHelper.GetVisibleIAttr(Target));

            // アニメーションマークの更新
            foreach (IAnimationMarkUsable ctrl in animCtrlList)
            {
                ctrl.UpdateAnimationMark();
            }

            // 連動ボタンの更新
            if (_oldTarget != Target)
            {
                _oldTarget = Target;
                UpdateLinkButton(_TargetPaneMpn.IPane);
            }
        }

        /// <summary>
        /// 連動ボタンを更新します
        /// </summary>
        private void UpdateLinkButton(IPane pane)
        {
            if (pane == null) return;

            _ctlScale.UpdateLinkButton(pane.Scale.X == pane.Scale.Y);
        }

        public PropWndPaneBasicPage()
        {
            InitializeComponent();

            // コンテキストメニューを追加する
            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(_lblPosition, _ctlPosition.AnimationMarkArray);
            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(_lblSize, _ctlSize.AnimationMarkArray);
            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(_lblScale, _ctlScale.AnimationMarkArray);
            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(_lblRot, _ctlRotate.AnimationMarkArray);

            // アニメーションマークを関連付ける
            _lblTranparency.BindAnimationMark(_nudTranparency.AnimationMarkInst);
        }

        /// <summary>
        /// インスタンス作成。
        /// </summary>
        public static PropertyPage CreateInstance(object arg)
        {
            var page = new PropWndPaneBasicPage();
            page._OwnerPane = arg as IPane;

            return page;
        }

        /// <summary>
        /// ページの表示内容と関係しているペインです。
        /// peneAdapterからマテリアル操作クラスを取得する際のキーとして利用します。
        /// </summary>
        private IPane _OwnerPane
        {
            get;
            set;
        }

        #region GUIハンドラ

        #region テキストボックス更新
        /// <summary>
        /// テキストボックス更新：ペイン名
        /// </summary>
        private void Event_TbxPaneName_ValueChanged(object sender, EventArgs e)
        {
            StringTextBox stb = sender as StringTextBox;
            string inputName = stb.Text;
            if (inputName != string.Empty)
            {
                // 重複しない名前を求めて設定します。
                string currentName = _TargetPaneMpn.IPane.PaneName;
                ISubScene subScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
                string newName = subScene.GetUniqueNewPaneName(_TargetPaneMpn.IPane, currentName, inputName);

                if (PaneHelper.CheckPaneNameValid(newName))
                {
                    _TargetPaneMpn.PaneName = newName;

                    if (inputName != newName)
                    {

                        _erpPaneNameChange.SetError(stb, StringResMgr.Get("WARN_CANSEL_PANENAMECHANGE"));
                    }
                    else
                    {
                        _erpPaneNameChange.SetError(stb, string.Empty);
                    }

                    return;
                }
                else
                {
                    if (inputName != newName)
                    {
                        _erpPaneNameChange.SetError(stb, StringResMgr.Get("WARN_CANSEL_PANENAMECHANGE"));
                    }
                    else
                    {
                        _erpPaneNameChange.SetError(stb, string.Empty);
                    }
                }
            }

            // 不正な入力なので、以前のデータに戻します。
            stb.SetValue(_TargetPaneMpn.IPane.PaneName);
        }

        /// <summary>
        /// テキストボックス更新：ユーザコメント
        /// </summary>
        private void Event_TbxComment_ValueChanged(object sender, EventArgs e)
        {
            StringTextBox stb = sender as StringTextBox;
            if (_TargetPaneMpn.IPane.UserCommentString != stb.Text)
            {
                _TargetPaneMpn.UserCommentString = stb.Text;
            }
        }

        /// <summary>
        /// テキストボックス更新：ユーザデータ
        /// </summary>
        private void Event_TbxUserData_ValueChanged(object sender, EventArgs e)
        {
            StringTextBox stb = sender as StringTextBox;

            if (_TargetPaneMpn.IPane.UserData != stb.Text)
            {
                // 英数字以外が使用されていないか確認します。
                if (PaneHelper.CheckUserDataValid(stb.Text))
                {
                    _TargetPaneMpn.UserData = stb.Text;
                }
                else
                {
                    // 不正な入力なので、以前のデータに戻します。
                    stb.SetValue(_TargetPaneMpn.IPane.UserData);
                }
            }
        }

        #endregion テキストボックス更新

        /// <summary>
        /// サイズ更新ハンドラ
        /// </summary>
        private void _ctlSize_OnFVec2Edit(object sender, FVec2EditEventArgs args)
        {
            if (IsGUIUpdating) { return; }

            EditVec2(Target, args,
                      delegate(PaneManipulator paneMnp)
                      {
                          FVec2 vec2 = new FVec2();
                          vec2.X = paneMnp.IPane.Size.X;
                          vec2.Y = paneMnp.IPane.Size.Y;
                          return vec2;
                      },
                      delegate(PaneManipulator paneMnp, FVec2 vec2)
                      {
                          paneMnp.Size = new FVec3(vec2);
                      });
        }

        /// <summary>
        /// スケール更新ハンドラ
        /// </summary>
        private void _ctlScale_OnFVec2Edit(object sender, FVec2EditEventArgs args)
        {
            if (IsGUIUpdating) { return; }

            EditVec2(Target, args,
                      delegate(PaneManipulator paneMnp)
                      {
                          FVec2 vec2 = new FVec2();
                          vec2.X = paneMnp.IPane.Scale.X;
                          vec2.Y = paneMnp.IPane.Scale.Y;
                          return vec2;
                      },
                      delegate(PaneManipulator paneMnp, FVec2 vec2)
                      {
                          paneMnp.Scale = new FVec3(vec2);
                      });
        }

        /// <summary>
        /// 位置更新ハンドラ
        /// </summary>
        private void _ctlPosition_OnFVec3Edit(object sender, FVec3EditEventArgs args)
        {
            if (IsGUIUpdating) { return; }

            EditVec3(Target, args,
                      delegate(PaneManipulator paneMnp)
                      {
                          return paneMnp.IPane.Trans;
                      },
                      delegate(PaneManipulator paneMnp, FVec3 vec3)
                      {
                          paneMnp.TransAffectsChildren = AppSetting.TransAffectHierarchy;
                          paneMnp.Trans = vec3;
                      });
        }

        /// <summary>
        /// 角度更新ハンドラ
        /// </summary>
        void _ctlRotate_OnFVec3Edit(object sender, FVec3EditEventArgs args)
        {
            if (IsGUIUpdating) { return; }

            EditVec3(Target, args,
                      delegate(PaneManipulator paneMnp)
                      {
                          return paneMnp.IPane.RotAng;
                      },
                      delegate(PaneManipulator paneMnp, FVec3 vec3)
                      {
                          paneMnp.RotAng = vec3;
                      });
        }

        /// <summary>
        /// 透明度更新ハンドラ
        /// </summary>
        private void _nudTransparency_ValueChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            NumericUpDown nud = sender as NumericUpDown;
            byte transparency = UIHelper.ClampDecimalToByte(nud.Value);

            EditValue<byte>(Target, transparency,
                             new SetValueHandler<byte>(delegate(PaneManipulator paneMnp, byte value)
                             {
                                 paneMnp.Transparency = value;
                             }));
        }

        /// <summary>
        /// Z軸回転角更新ハンドラ
        /// </summary>
        private void _nudRot_ValueChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            NumericUpDown numericUpDown = sender as NumericUpDown;

            float newRot = Convert.ToSingle(numericUpDown.Value);
            if (_TargetPaneMpn.IPane.RotAngleZ != newRot)
            {
                _TargetPaneMpn.RotAngleZ = newRot;
            }
        }

        /// <summary>
        /// 可視・不可視更新ハンドラ
        /// </summary>
        private void Event_chkVisible_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            CheckBox checkBox = sender as CheckBox;

            bool check = checkBox.Checked;
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                if (adapter.Target.Visible != check)
                {
                    adapter.PaneManipulator.Visible = check;
                }
            }, Target.Active, Target.Objects);
        }

        /// <summary>
        /// 子供の透明度に影響を与える：ハンドラ
        /// </summary>
        private void Event_ChkInfuenceTransparency_CheckedChanged(object sender, EventArgs e)
        {
            _TargetPaneMpn.InfluenceChildrenTransparency = _chkInfuenceTransparency.Checked;
        }

        private void Event_ChkLocationAdjust_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            CheckBox checkBox = sender as CheckBox;

            bool check = checkBox.Checked;
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                if (adapter.Target.LocationAdjust != check)
                {
                    adapter.PaneManipulator.LocationAdjust = check;
                }
            }, Target.Active, Target.Objects);
        }

        private void _nudAlignmentMargin_ValueChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            NumericUpDown nud = sender as NumericUpDown;

            EditValue<float>(Target, (float)nud.Value,
                new SetValueHandler<float>(delegate (PaneManipulator paneMnp, float value)
                {
                    paneMnp.AlignmentHorizontalMargin = value;
                }));
        }

        private void _nudAlignmentMarginV_ValueChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            NumericUpDown nud = sender as NumericUpDown;

            EditValue<float>(Target, (float)nud.Value,
                new SetValueHandler<float>(delegate (PaneManipulator paneMnp, float value)
                {
                    paneMnp.AlignmentVerticalMargin = value;
                }));
        }

        private void _chkIsAlignmentMarginEnabled_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            CheckBox checkBox = sender as CheckBox;

            bool check = checkBox.Checked;
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                if (adapter.Target.IsAlignmentHorizontalMarginEnabled != check)
                {
                    adapter.PaneManipulator.IsAlignmentHorizontalMarginEnabled = check;
                }
            }, Target.Active, Target.Objects);
        }

        private void _chkIsAlignmentMarginEnabledV_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            CheckBox checkBox = sender as CheckBox;

            bool check = checkBox.Checked;
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                if (adapter.Target.IsAlignmentVerticalMarginEnabled != check)
                {
                    adapter.PaneManipulator.IsAlignmentVerticalMarginEnabled = check;
                }
            }, Target.Active, Target.Objects);
        }

        private void _chkIsAlignmentIgnore_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            CheckBox checkBox = sender as CheckBox;

            bool check = checkBox.Checked;
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                if (adapter.Target.IsAlignmentIgnore != check)
                {
                    adapter.PaneManipulator.IsAlignmentIgnore = check;
                }
            }, Target.Active, Target.Objects);
        }

        /// <summary>
        /// 階層圧縮禁止：ハンドラ
        /// </summary>
        private void Event_ChkAvoidPaneTreeCompression_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            CheckBox checkBox = sender as CheckBox;

            bool check = checkBox.Checked;
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                if (adapter.Target.AvoidPaneTreeCompression != check)
                {
                    adapter.PaneManipulator.AvoidPaneTreeCompression = check;
                }
            }, Target.Active, Target.Objects);
        }

        /// <summary>
        /// 拡張ユーザー情報のアニメーションを有効にする：ハンドラ
        /// </summary>
        private void Event_ChkExtUserDataAnimEnabled_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }
            if (_isSystemCalled) { return; }

            CheckBox checkBox = sender as CheckBox;

            bool check = checkBox.Checked;
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                if (adapter.Target.ExtUserDataAnimEnabled != check)
                {
                    // アニメーションタイプの拡張ユーザー情報が既に作られているか調べる
                    IUserDataElement[] elementSet = adapter.Target.IUserDataHolder.UserDataElementSet;
                    bool hasExtUserDataAnim = elementSet.Any(element => element.IAnmAttribute != null);

                    // 拡張ユーザー情報のアニメーションを無効にしたとき、作成済みの拡張ユーザー情報のアニメーションを削除する
                    if (check == false && hasExtUserDataAnim)
                    {
                        // 確認ダイアログを表示
                        string title = StringResMgr.Get("PROPERTY_MSG_DLG_TITLE");
                        string message = String.Format(StringResMgr.Get("PROPERTY_MSG_EXT_USER_DATA_ANIM_REMOVE"), adapter.Target.PaneName);
                        DialogResult resMsg = MessageBox.Show(message, title, MessageBoxButtons.OKCancel, MessageBoxIcon.Question);

                        // キャンセル処理
                        if (resMsg != DialogResult.OK)
                        {
                            if (adapter == Target.Active)
                            {
                                _isSystemCalled = true;
                                _chkExtUserDataAnimEnabled.Checked = true;
                                _isSystemCalled = false;
                            }
                            return;
                        }

                        // フラグの状態を変更
                        adapter.PaneManipulator.ExtUserDataAnimEnabled = check;

                        // 拡張ユーザー情報のマニピュレータを作成
                        UserDataHolderManipulator userDataManipulator = new UserDataHolderManipulator();
                        userDataManipulator.BindTarget(adapter.Target.IUserDataHolder);

                        // 作成済みの拡張ユーザー情報のアニメーションを削除
                        userDataManipulator.RemoveAllAnimElement();
                    }
                    else
                    {
                        // 拡張ユーザー情報を削除する必要がないとき、フラグの状態変更だけを行う
                        adapter.PaneManipulator.ExtUserDataAnimEnabled = check;
                    }
                }
            }, Target.Active, Target.Objects);
        }

        /// <summary>
        /// 部品倍率モード変更
        /// </summary>
        private void Event_CmbPartsMagnifyMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            UIComboBox comboBox = sender as UIComboBox;

            PartsMagnifyInfluence selectedItemData = (PartsMagnifyInfluence)comboBox.SelectedItemData;
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                if (adapter.Target.PartsMagnifyInfluence != selectedItemData)
                {
                    adapter.PaneManipulator.PartsMagnifyInfluence = selectedItemData;
                }
            }, Target.Active, Target.Objects);
        }

        /// <summary>
        /// 中心位置：水平方向更新ハンドラ
        /// </summary>
        private void _radPosH_RadioChecked(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            UIRadioButton rb = sender as UIRadioButton;
            HVLocation newValue = (HVLocation)rb.Tag;
            EditValue<HVLocation>(Target, newValue,
                (paneMnp, val) => {
                    paneMnp.BasePosTypeH = val.Item1; paneMnp.BasePosTypeV = val.Item2;
                });
        }

        /// <summary>
        /// 中心位置：水平方向更新ハンドラ
        /// </summary>
        private void _radCenterInParentH_RadioChecked(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            UIRadioButton rb = sender as UIRadioButton;
            HVLocation newValue = (HVLocation)rb.Tag;
            EditValue<HVLocation>(Target, newValue,
                (paneMnp, val) => {
                    paneMnp.ParentBasePosTypeH = val.Item1; paneMnp.ParentBasePosTypeV = val.Item2;
            });
        }

        /// <summary>
        ///
        /// </summary>
        delegate FVec2 GetVec2Handler(PaneManipulator paneMnp);
        delegate void SetVec2Handler(PaneManipulator paneMnp, FVec2 vec2);
        private void EditVec2(PaneGuiAdapterGroup target, FVec2EditEventArgs args, GetVec2Handler getter, SetVec2Handler setter)
        {
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                EditVec2(adapter.PaneManipulator, args, getter, setter);
            }, target.Active, target.Objects);
        }

        /// <summary>
        ///
        /// </summary>
        delegate FVec3 GetVec3Handler(PaneManipulator paneMnp);
        delegate void SetVec3Handler(PaneManipulator paneMnp, FVec3 vec3);
        private void EditVec3(PaneGuiAdapterGroup target, FVec3EditEventArgs args, GetVec3Handler getter, SetVec3Handler setter)
        {
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                EditVec3(adapter.PaneManipulator, args, getter, setter);
            }, target.Active, target.Objects);
        }

        /// <summary>
        ///
        /// </summary>
        private void EditVec2(PaneManipulator paneMnp, FVec2EditEventArgs args, GetVec2Handler getter, SetVec2Handler setter)
        {
            FVec2 vec2 = getter(paneMnp);

            switch (args.Name)
            {
                case "X":
                    if (vec2.X != args.Value.X)
                    {
                        vec2.X = args.Value.X;
                        setter(paneMnp, vec2);
                    }
                    break;

                case "Y":
                    if (vec2.Y != args.Value.Y)
                    {
                        vec2.Y = args.Value.Y;
                        setter(paneMnp, vec2);
                    }
                    break;

                case "XY":
                    if (vec2.X != args.Value.X || vec2.Y != args.Value.Y)
                    {
                        vec2.X = args.Value.X;
                        vec2.Y = args.Value.Y;
                        setter(paneMnp, vec2);
                    }
                    break;
            }
        }

        /// <summary>
        ///
        /// </summary>
        private void EditVec3(PaneManipulator paneMnp, FVec3EditEventArgs args, GetVec3Handler getter, SetVec3Handler setter)
        {
            FVec3 vec3 = getter(paneMnp);

            switch (args.Name)
            {
                case "X":
                    if (vec3.X != args.Value.X)
                    {
                        vec3.X = args.Value.X;
                        setter(paneMnp, vec3);
                    }
                    break;

                case "Y":
                    if (vec3.Y != args.Value.Y)
                    {
                        vec3.Y = args.Value.Y;
                        setter(paneMnp, vec3);
                    }
                    break;

                case "Z":
                    if (vec3.Z != args.Value.Z)
                    {
                        vec3.Z = args.Value.Z;
                        setter(paneMnp, vec3);
                    }
                    break;
            }
        }

        /// <summary>
        ///
        /// </summary>
        delegate void SetValueHandler<T>(PaneManipulator paneMnp, T value);
        private void EditValue<T>(PaneGuiAdapterGroup target, T value, SetValueHandler<T> setter)
        {
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                setter(adapter.PaneManipulator, value);
            }, target.Active, target.Objects);
        }
        #endregion

        /// <summary>
        /// アニメーションマークが利用可能なコントロールの一覧を取得する。
        /// </summary>
        protected override IEnumerable<IAnimationMarkUsable> GetAnimationMarkUsableControl()
        {
            List<IAnimationMarkUsable> list = new List<IAnimationMarkUsable>();

            list.Add(_lblPosition);
            list.Add(_lblSize);
            list.Add(_lblScale);
            list.Add(_lblRot);
            list.Add(_lblTranparency);
            list.Add(_ctlSize);
            list.Add(_ctlPosition);
            list.Add(_ctlScale);
            list.Add(_ctlRotate);
            list.Add(_nudTranparency);
            list.Add(_chkVisible);

            return list;
        }
    }
}
