﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

using LayoutEditor.Controls;
using LayoutEditor.Utility;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.TextureControls
{
    using App = LayoutEditor;
    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters;
    using LECore.Structures.LECoreInterface;

    /// <summary>
    /// テクスチャ選択パネルクラス。
    /// </summary>
    public sealed class TextureSelectPanel : UserControl
    {
        #region デザイナ変数

    private App.Controls.ThumbnailListBox lbxTexture;
        private System.Windows.Forms.Label labTexFormatT;
        private System.Windows.Forms.Label labTexFormat;
        private System.Windows.Forms.Label labTexSizeT;
        private System.Windows.Forms.Label labTexSize;
        private System.Windows.Forms.Label labTexMipmapLvT;
        private System.Windows.Forms.Label labTexMipmapLv;
        private System.Windows.Forms.Label labTexDataSizeT;
    private System.Windows.Forms.Label labTexDataSize;
    private System.Windows.Forms.Label labTexture;
    private System.Windows.Forms.Panel pnlTexture;
        private System.ComponentModel.Container components = null;
        #endregion

        #region デザイナコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
      System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(TextureSelectPanel));
      this.labTexture = new System.Windows.Forms.Label();
      this.labTexFormatT = new System.Windows.Forms.Label();
      this.labTexFormat = new System.Windows.Forms.Label();
      this.labTexSizeT = new System.Windows.Forms.Label();
      this.labTexSize = new System.Windows.Forms.Label();
      this.labTexMipmapLvT = new System.Windows.Forms.Label();
      this.labTexMipmapLv = new System.Windows.Forms.Label();
      this.labTexDataSizeT = new System.Windows.Forms.Label();
      this.labTexDataSize = new System.Windows.Forms.Label();
      this.pnlTexture = new System.Windows.Forms.Panel();
      this.lbxTexture = new LayoutEditor.Controls.ThumbnailListBox();
      this.pnlTexture.SuspendLayout();
      this.SuspendLayout();
      //
      // labTexture
      //
      resources.ApplyResources(this.labTexture, "labTexture");
      this.labTexture.Name = "labTexture";
      //
      // labTexFormatT
      //
      resources.ApplyResources(this.labTexFormatT, "labTexFormatT");
      this.labTexFormatT.Name = "labTexFormatT";
      //
      // labTexFormat
      //
      resources.ApplyResources(this.labTexFormat, "labTexFormat");
      this.labTexFormat.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
      this.labTexFormat.Name = "labTexFormat";
      //
      // labTexSizeT
      //
      resources.ApplyResources(this.labTexSizeT, "labTexSizeT");
      this.labTexSizeT.Name = "labTexSizeT";
      //
      // labTexSize
      //
      resources.ApplyResources(this.labTexSize, "labTexSize");
      this.labTexSize.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
      this.labTexSize.Name = "labTexSize";
      //
      // labTexMipmapLvT
      //
      resources.ApplyResources(this.labTexMipmapLvT, "labTexMipmapLvT");
      this.labTexMipmapLvT.Name = "labTexMipmapLvT";
      //
      // labTexMipmapLv
      //
      resources.ApplyResources(this.labTexMipmapLv, "labTexMipmapLv");
      this.labTexMipmapLv.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
      this.labTexMipmapLv.Name = "labTexMipmapLv";
      //
      // labTexDataSizeT
      //
      resources.ApplyResources(this.labTexDataSizeT, "labTexDataSizeT");
      this.labTexDataSizeT.Name = "labTexDataSizeT";
      //
      // labTexDataSize
      //
      resources.ApplyResources(this.labTexDataSize, "labTexDataSize");
      this.labTexDataSize.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
      this.labTexDataSize.Name = "labTexDataSize";
      //
      // pnlTexture
      //
      this.pnlTexture.Controls.Add(this.labTexture);
      this.pnlTexture.Controls.Add(this.lbxTexture);
      this.pnlTexture.Controls.Add(this.labTexMipmapLvT);
      this.pnlTexture.Controls.Add(this.labTexFormat);
      this.pnlTexture.Controls.Add(this.labTexDataSize);
      this.pnlTexture.Controls.Add(this.labTexSizeT);
      this.pnlTexture.Controls.Add(this.labTexSize);
      this.pnlTexture.Controls.Add(this.labTexDataSizeT);
      this.pnlTexture.Controls.Add(this.labTexMipmapLv);
      this.pnlTexture.Controls.Add(this.labTexFormatT);
      resources.ApplyResources(this.pnlTexture, "pnlTexture");
      this.pnlTexture.Name = "pnlTexture";
      //
      // lbxTexture
      //
      resources.ApplyResources(this.lbxTexture, "lbxTexture");
      this.lbxTexture.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
      this.lbxTexture.Name = "lbxTexture";
      this.lbxTexture.SelectedItemData = null;
      //
      // TextureSelectPanel
      //
      this.Controls.Add(this.pnlTexture);
      resources.ApplyResources(this, "$this");
      this.Name = "TextureSelectPanel";
      this.pnlTexture.ResumeLayout(false);
      this.ResumeLayout(false);

        }
        #endregion

        private Texture _texture = null;
#if false
        private Palette _palette = null;
#endif

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public TextureSelectPanel()
        {
            InitializeComponent();

            // イベント登録
            lbxTexture.SelectedIndexChanged += new EventHandler(Event_LbxTexture_SelectedIndexChanged);

            // 背景色を決定します。
            lbxTexture.GetItemBackGroundColor += new Func<UIListControlItem, Color>((item) =>
            {
                var texture = (Texture)item.Data;

                // 動的テクスチャは背景色を変える。
                if (texture.SourceType == TextureSourceType.Dynamic)
                {
                    return LECore.AppConstants.ActiveCatpureTextureBackColor;
                }

                return Color.Empty;
            });
        }

        /// <summary>
        /// テクスチャ項目数。
        /// </summary>
        public int NumTextureItems
        {
            get { return lbxTexture.Items.Count; }
        }

#if false
        /// <summary>
        /// パレット項目数。
        /// </summary>
        public int NumPaletteItems
        {
            get { return lbxPalette.Items.Count; }
        }
#endif

        /// <summary>
        /// 選択テクスチャ。
        /// </summary>
        [Browsable(false)]
        public Texture SelectedTexture
        {
            get { return _texture;                     }
            set { lbxTexture.SelectedItemData = value; }
        }

#if false
        /// <summary>
        /// 選択パレット。
        /// </summary>
        [Browsable(false)]
        public Palette SelectedPalette
        {
            get
            {
                // テクスチャがＣＩフォーマットの時のみ
                if (_texture != null && _texture.IsCIFormat)
                {
                    return _palette;
                }
                return null;
            }
            set { lbxPalette.SelectedItemData = value; }
        }
#endif

        /// <summary>
        /// テクスチャ項目追加。
        /// </summary>
        public void AddTextureItem(Texture texture)
        {
            lbxTexture.AddItem(texture);

            // 未選択なら選択
            if (_texture == null)
            {
                this.SelectedTexture = texture;
            }
        }

#if false
        /// <summary>
        /// パレット項目追加。
        /// </summary>
        public void AddPaletteItem(Palette palette)
        {
            lbxPalette.AddItem(palette);

            // 未選択なら選択
            if (_palette == null)
            {
                this.SelectedPalette = palette;
            }
        }
#endif

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void OnResize(EventArgs e)
        {
#if false
            // 領域を左右均等にする
            if (this.ClientSize.Width > 0)
            {
                pnlPalette.Width = this.ClientSize.Width / 2;
            }
#endif
            base.OnResize(e);
        }

        /// <summary>
        /// コンポーネント更新。
        /// </summary>
        private void UpdateComponent()
        {
            // テクスチャ
            if (_texture != null)
            {
                labTexFormat.Text   = _texture.FormatText;
                labTexSize.Text     = _texture.SizeText;
                labTexMipmapLv.Text = _texture.MipmapLevelText;
                labTexDataSize.Text = _texture.DataSize.KBytesText;

#if false
                // パレットパネルの有効状態
                pnlPalette.Enabled = _texture.IsCIFormat;
#endif
            }

#if false
            // パレット
            if (pnlPalette.Enabled)
            {
                if (_palette != null)
                {
                    labPalFormat.Text    = _palette.FormatText;
                    labPalColorSize.Text = _palette.ColorSize.ToString();
                    labPalDataSize.Text  = _palette.DataSize.KBytesText;
                }
            }
            else
            {
                labPalFormat.Text    = string.Empty;
                labPalColorSize.Text = string.Empty;
                labPalDataSize.Text  = string.Empty;
            }
#endif
        }

        /// <summary>
        /// イベントハンドラ。
        /// </summary>
        private void Event_LbxTexture_SelectedIndexChanged(object sender, EventArgs e)
        {
            _texture = (Texture)lbxTexture.SelectedItemData;
            UpdateComponent();
        }

#if false
        /// <summary>
        /// イベントハンドラ。
        /// </summary>
        private void Event_LbxPalette_SelectedIndexChanged(object sender, EventArgs e)
        {
            _palette = (Palette)lbxPalette.SelectedItemData;
            UpdateComponent();
        }
#endif
    }
}
