﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

using LayoutEditor.Controls;
using LayoutEditor.Utility;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.TextureControls
{
    using App = LayoutEditor;
   using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters ;
    using LECore.Structures;

    /// <summary>
    /// テクスチャ追加ダイアログタイプ選択ページクラス。
    /// </summary>
    public sealed class TextureAddTypePage : UserControl
    {
        #region デザイナ変数

        private App.Controls.UIRadioButton radStandard;
        private System.Windows.Forms.Label labStandard;
        private LayoutEditor.Controls.UIRadioButton radIndirectWarp;
        private System.Windows.Forms.Label labIndirectWarp;
        private System.ComponentModel.Container components = null;
        #endregion

        #region デザイナコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager( typeof( TextureAddTypePage ) );
            this.radStandard = new LayoutEditor.Controls.UIRadioButton();
            this.labStandard = new System.Windows.Forms.Label();
            this.radIndirectWarp = new LayoutEditor.Controls.UIRadioButton();
            this.labIndirectWarp = new System.Windows.Forms.Label();
            this.SuspendLayout();
            //
            // radStandard
            //
            resources.ApplyResources( this.radStandard, "radStandard" );
            this.radStandard.Name = "radStandard";
            //
            // labStandard
            //
            resources.ApplyResources( this.labStandard, "labStandard" );
            this.labStandard.Name = "labStandard";
            //
            // radIndirectWarp
            //
            resources.ApplyResources( this.radIndirectWarp, "radIndirectWarp" );
            this.radIndirectWarp.Name = "radIndirectWarp";
            //
            // labIndirectWarp
            //
            resources.ApplyResources( this.labIndirectWarp, "labIndirectWarp" );
            this.labIndirectWarp.Name = "labIndirectWarp";
            //
            // TextureAddTypePage
            //
            this.Controls.Add( this.labStandard );
            this.Controls.Add( this.radStandard );
            this.Controls.Add( this.radIndirectWarp );
            this.Controls.Add( this.labIndirectWarp );
            resources.ApplyResources( this, "$this" );
            this.Name = "TextureAddTypePage";
            this.ResumeLayout( false );

        }
        #endregion

        // テクスジェンメソッド
        private LETexGenMethod _method = LETexGenMethod.UV0;
       // テクスチャ種類：(大別すれば、通常かインダイレクトか)
       private TexMapKind       _texMapKind = TexMapKind.Normal;


        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public TextureAddTypePage(MaterialGUIAdapter material)
        {
            InitializeComponent();

            // 初期化
            radStandard.Tag = material.HasVtxTexCoords ? LETexGenMethod.UV0 : LETexGenMethod.OrthogonalProjection;
            radIndirectWarp.Tag  = TexMapKind.IndirectWarpTexture;

            // イベント登録
            radStandard.RadioChecked         += new EventHandler(Event_Rad_RadioChecked);
            radIndirectWarp.RadioChecked     += new EventHandler(Event_Rad_IndirectRadioChecked);

            // 初期設定
            if (material.TexMapList.CanAddStandardTexMap(material))
            {
                radStandard.Checked = true;
            }
            else
            {
                radStandard.Enabled = false;
                labStandard.Enabled = false;
            }



           // インダイレクト系テクスチャが登録不可能ならば無効化します。
           bool bIndirectEnable = material.TexMapList.CanAddToonIndirectTexMap();
           radIndirectWarp.Enabled = bIndirectEnable;
           labIndirectWarp.Enabled = bIndirectEnable;
        }

        /// <summary>
        /// 座標生成方法。
        /// </summary>
        public LETexGenMethod Method
        {
            get { return _method; }
        }

        /// <summary>
        /// テクスチャ種類
        /// </summary>
        public TexMapKind Kind
        {
            get { return _texMapKind; }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        /// <summary>
        /// イベントハンドラ。
        /// </summary>
        private void Event_Rad_RadioChecked(object sender, EventArgs e)
        {
            _method = (LETexGenMethod)((RadioButton)sender).Tag;
          _texMapKind = TexMapKind.Normal;
        }

        /// <summary>
        /// インダイレクト系のラジオボタン選択ハンドラ
        /// </summary>
        private void Event_Rad_IndirectRadioChecked(object sender, EventArgs e)
        {
            _method = LETexGenMethod.UV0;
            _texMapKind = (TexMapKind)((RadioButton)sender).Tag;
        }

    }
}
