﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.MaterialPages.TevControls
{
    using LayoutEditor.Controls;
    using LayoutEditor.Utility;
    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters ;
    using LECore.Structures.Nsrif.Attributes;
    using LECore.Structures;
    using App = LayoutEditor;

    /// <summary>
    /// ＴＥＶインダイレクトステージパネルクラス。
    /// </summary>
    public sealed class TevIndirectStagePanel : UserControl
    {
        #region デザイナ変数

        private LayoutEditor.Controls.ConnectionImagePanel ctlToLod;
        private LayoutEditor.Controls.ConnectionImagePanel ctlToWrap;
        private LayoutEditor.Controls.ConnectionImagePanel ctlProcToLod;
        private LayoutEditor.Controls.ConnectionImagePanel ctlLodToOut;
        private LayoutEditor.Controls.ConnectionImagePanel ctlProcToOut;
        private LayoutEditor.Controls.ConnectionImagePanel ctlBiasToMtx;
        private LayoutEditor.Controls.ConnectionImagePanel ctlMtxToProc;
        private LayoutEditor.Controls.ConnectionImagePanel ctlFmtToBias;
        private LayoutEditor.Controls.ConnectionImagePanel ctlToFmt;
        private LayoutEditor.Controls.ConnectionImagePanel ctlWrapToProc;
        private LayoutEditor.Controls.ConnectionImagePanel crlFmtToBump;
        private LayoutEditor.Controls.ConnectionImagePanel ctlBumpToOut;
        private System.Windows.Forms.Label lblFmt;
        private System.Windows.Forms.Label lblBias;
        private System.Windows.Forms.Label lblMtxScale;
        private System.Windows.Forms.Label lblBumpAlpha;
        private System.Windows.Forms.Label lblTexWrap;
        private System.Windows.Forms.Label lblTexCoordST;
        private System.Windows.Forms.Label lblLod;
        private LayoutEditor.Controls.ConnectionImagePanel ctlTexCoordSTToMtx;
        private System.Windows.Forms.Panel plnProc;
        private LayoutEditor.Controls.UIComboBox cmbBias;
        private LayoutEditor.Controls.UIComboBox cmbMtxScale;
        private LayoutEditor.Controls.UIComboBox cmbFmt;
        private LayoutEditor.Controls.UIComboBox cmbAddPrev;
        private LayoutEditor.Controls.UIComboBox cmbBumpAlpha;
        private LayoutEditor.Controls.UIComboBox cmbTexWrapS;
        private LayoutEditor.Controls.UIComboBox cmbTexWrapT;
        private LayoutEditor.Controls.UIComboBox cmbLod;
        private System.Windows.Forms.Label lblAddPrev;
        private LayoutEditor.Controls.ConnectionImagePanel ctlProcToAddPrev;
        private LayoutEditor.Controls.ConnectionImagePanel ctlAddPrevToProc;
        private System.Windows.Forms.Label lblIndirectTexInput;
        private System.Windows.Forms.Label _lblTargetStage;
        private System.Windows.Forms.Button btnRestoreToDirect;
        private LayoutEditor.Controls.UIComboBox cmbIndStage;
        private System.ComponentModel.Container components = null;
        #endregion

        #region デザイナコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager( typeof( TevIndirectStagePanel ) );
            this.lblFmt = new System.Windows.Forms.Label();
            this.lblBias = new System.Windows.Forms.Label();
            this.lblMtxScale = new System.Windows.Forms.Label();
            this.lblBumpAlpha = new System.Windows.Forms.Label();
            this.lblTexWrap = new System.Windows.Forms.Label();
            this.lblIndirectTexInput = new System.Windows.Forms.Label();
            this.lblTexCoordST = new System.Windows.Forms.Label();
            this.plnProc = new System.Windows.Forms.Panel();
            this.lblAddPrev = new System.Windows.Forms.Label();
            this.lblLod = new System.Windows.Forms.Label();
            this.ctlToLod = new LayoutEditor.Controls.ConnectionImagePanel();
            this.ctlToWrap = new LayoutEditor.Controls.ConnectionImagePanel();
            this.ctlProcToLod = new LayoutEditor.Controls.ConnectionImagePanel();
            this.ctlLodToOut = new LayoutEditor.Controls.ConnectionImagePanel();
            this.ctlProcToOut = new LayoutEditor.Controls.ConnectionImagePanel();
            this.ctlBiasToMtx = new LayoutEditor.Controls.ConnectionImagePanel();
            this.ctlProcToAddPrev = new LayoutEditor.Controls.ConnectionImagePanel();
            this.ctlMtxToProc = new LayoutEditor.Controls.ConnectionImagePanel();
            this.ctlFmtToBias = new LayoutEditor.Controls.ConnectionImagePanel();
            this.ctlToFmt = new LayoutEditor.Controls.ConnectionImagePanel();
            this.ctlWrapToProc = new LayoutEditor.Controls.ConnectionImagePanel();
            this.ctlAddPrevToProc = new LayoutEditor.Controls.ConnectionImagePanel();
            this.crlFmtToBump = new LayoutEditor.Controls.ConnectionImagePanel();
            this.ctlBumpToOut = new LayoutEditor.Controls.ConnectionImagePanel();
            this.ctlTexCoordSTToMtx = new LayoutEditor.Controls.ConnectionImagePanel();
            this.cmbBias = new LayoutEditor.Controls.UIComboBox();
            this.cmbMtxScale = new LayoutEditor.Controls.UIComboBox();
            this.cmbFmt = new LayoutEditor.Controls.UIComboBox();
            this.cmbAddPrev = new LayoutEditor.Controls.UIComboBox();
            this.cmbBumpAlpha = new LayoutEditor.Controls.UIComboBox();
            this.cmbTexWrapS = new LayoutEditor.Controls.UIComboBox();
            this.cmbTexWrapT = new LayoutEditor.Controls.UIComboBox();
            this.cmbLod = new LayoutEditor.Controls.UIComboBox();
            this.btnRestoreToDirect = new System.Windows.Forms.Button();
            this._lblTargetStage = new System.Windows.Forms.Label();
            this.cmbIndStage = new LayoutEditor.Controls.UIComboBox();
            this.SuspendLayout();
            //
            // lblFmt
            //
            resources.ApplyResources( this.lblFmt, "lblFmt" );
            this.lblFmt.Name = "lblFmt";
            //
            // lblBias
            //
            resources.ApplyResources( this.lblBias, "lblBias" );
            this.lblBias.Name = "lblBias";
            //
            // lblMtxScale
            //
            resources.ApplyResources( this.lblMtxScale, "lblMtxScale" );
            this.lblMtxScale.Name = "lblMtxScale";
            //
            // lblBumpAlpha
            //
            resources.ApplyResources( this.lblBumpAlpha, "lblBumpAlpha" );
            this.lblBumpAlpha.Name = "lblBumpAlpha";
            //
            // lblTexWrap
            //
            resources.ApplyResources( this.lblTexWrap, "lblTexWrap" );
            this.lblTexWrap.Name = "lblTexWrap";
            //
            // lblIndirectTexInput
            //
            resources.ApplyResources( this.lblIndirectTexInput, "lblIndirectTexInput" );
            this.lblIndirectTexInput.Name = "lblIndirectTexInput";
            //
            // lblTexCoordST
            //
            resources.ApplyResources( this.lblTexCoordST, "lblTexCoordST" );
            this.lblTexCoordST.Name = "lblTexCoordST";
            //
            // plnProc
            //
            this.plnProc.BackColor = System.Drawing.SystemColors.ActiveCaptionText;
            this.plnProc.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            resources.ApplyResources( this.plnProc, "plnProc" );
            this.plnProc.Name = "plnProc";
            //
            // lblAddPrev
            //
            resources.ApplyResources( this.lblAddPrev, "lblAddPrev" );
            this.lblAddPrev.Name = "lblAddPrev";
            //
            // lblLod
            //
            resources.ApplyResources( this.lblLod, "lblLod" );
            this.lblLod.Name = "lblLod";
            //
            // ctlToLod
            //
            this.ctlToLod.BackColor = System.Drawing.Color.Transparent;
            this.ctlToLod.DrawOrder = LayoutEditor.Controls.ConnectionImagePanel.LineDrawOrder.VerticalFast;
            this.ctlToLod.EndCap = System.Drawing.Drawing2D.LineCap.ArrowAnchor;
            this.ctlToLod.EndPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Right;
            this.ctlToLod.EndPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            this.ctlToLod.LineActive = true;
            this.ctlToLod.LineColor = System.Drawing.Color.Black;
            this.ctlToLod.LineWidth = 5F;
            resources.ApplyResources( this.ctlToLod, "ctlToLod" );
            this.ctlToLod.Name = "ctlToLod";
            this.ctlToLod.StartCap = System.Drawing.Drawing2D.LineCap.Flat;
            this.ctlToLod.StartPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Left;
            this.ctlToLod.StartPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Bottom;
            //
            // ctlToWrap
            //
            this.ctlToWrap.BackColor = System.Drawing.Color.Transparent;
            this.ctlToWrap.DrawOrder = LayoutEditor.Controls.ConnectionImagePanel.LineDrawOrder.VerticalFast;
            this.ctlToWrap.EndCap = System.Drawing.Drawing2D.LineCap.ArrowAnchor;
            this.ctlToWrap.EndPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Right;
            this.ctlToWrap.EndPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            this.ctlToWrap.LineActive = true;
            this.ctlToWrap.LineColor = System.Drawing.Color.Black;
            this.ctlToWrap.LineWidth = 5F;
            resources.ApplyResources( this.ctlToWrap, "ctlToWrap" );
            this.ctlToWrap.Name = "ctlToWrap";
            this.ctlToWrap.StartCap = System.Drawing.Drawing2D.LineCap.Flat;
            this.ctlToWrap.StartPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Left;
            this.ctlToWrap.StartPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            //
            // ctlProcToLod
            //
            this.ctlProcToLod.BackColor = System.Drawing.Color.Transparent;
            this.ctlProcToLod.DrawOrder = LayoutEditor.Controls.ConnectionImagePanel.LineDrawOrder.HorizontalFast;
            this.ctlProcToLod.EndCap = System.Drawing.Drawing2D.LineCap.ArrowAnchor;
            this.ctlProcToLod.EndPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Right;
            this.ctlProcToLod.EndPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            this.ctlProcToLod.LineActive = true;
            this.ctlProcToLod.LineColor = System.Drawing.Color.Black;
            this.ctlProcToLod.LineWidth = 5F;
            resources.ApplyResources( this.ctlProcToLod, "ctlProcToLod" );
            this.ctlProcToLod.Name = "ctlProcToLod";
            this.ctlProcToLod.StartCap = System.Drawing.Drawing2D.LineCap.Flat;
            this.ctlProcToLod.StartPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Left;
            this.ctlProcToLod.StartPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Bottom;
            //
            // ctlLodToOut
            //
            this.ctlLodToOut.BackColor = System.Drawing.Color.Transparent;
            this.ctlLodToOut.DrawOrder = LayoutEditor.Controls.ConnectionImagePanel.LineDrawOrder.VerticalFast;
            this.ctlLodToOut.EndCap = System.Drawing.Drawing2D.LineCap.ArrowAnchor;
            this.ctlLodToOut.EndPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Right;
            this.ctlLodToOut.EndPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            this.ctlLodToOut.LineActive = true;
            this.ctlLodToOut.LineColor = System.Drawing.Color.Black;
            this.ctlLodToOut.LineWidth = 5F;
            resources.ApplyResources( this.ctlLodToOut, "ctlLodToOut" );
            this.ctlLodToOut.Name = "ctlLodToOut";
            this.ctlLodToOut.StartCap = System.Drawing.Drawing2D.LineCap.Flat;
            this.ctlLodToOut.StartPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Left;
            this.ctlLodToOut.StartPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            //
            // ctlProcToOut
            //
            this.ctlProcToOut.BackColor = System.Drawing.Color.Transparent;
            this.ctlProcToOut.DrawOrder = LayoutEditor.Controls.ConnectionImagePanel.LineDrawOrder.VerticalFast;
            this.ctlProcToOut.EndCap = System.Drawing.Drawing2D.LineCap.ArrowAnchor;
            this.ctlProcToOut.EndPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Right;
            this.ctlProcToOut.EndPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            this.ctlProcToOut.LineActive = true;
            this.ctlProcToOut.LineColor = System.Drawing.Color.Black;
            this.ctlProcToOut.LineWidth = 5F;
            resources.ApplyResources( this.ctlProcToOut, "ctlProcToOut" );
            this.ctlProcToOut.Name = "ctlProcToOut";
            this.ctlProcToOut.StartCap = System.Drawing.Drawing2D.LineCap.Flat;
            this.ctlProcToOut.StartPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Left;
            this.ctlProcToOut.StartPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            //
            // ctlBiasToMtx
            //
            this.ctlBiasToMtx.BackColor = System.Drawing.Color.Transparent;
            this.ctlBiasToMtx.DrawOrder = LayoutEditor.Controls.ConnectionImagePanel.LineDrawOrder.VerticalFast;
            this.ctlBiasToMtx.EndCap = System.Drawing.Drawing2D.LineCap.ArrowAnchor;
            this.ctlBiasToMtx.EndPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Right;
            this.ctlBiasToMtx.EndPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            this.ctlBiasToMtx.LineActive = true;
            this.ctlBiasToMtx.LineColor = System.Drawing.Color.Black;
            this.ctlBiasToMtx.LineWidth = 5F;
            resources.ApplyResources( this.ctlBiasToMtx, "ctlBiasToMtx" );
            this.ctlBiasToMtx.Name = "ctlBiasToMtx";
            this.ctlBiasToMtx.StartCap = System.Drawing.Drawing2D.LineCap.Flat;
            this.ctlBiasToMtx.StartPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Left;
            this.ctlBiasToMtx.StartPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            //
            // ctlProcToAddPrev
            //
            this.ctlProcToAddPrev.BackColor = System.Drawing.Color.Transparent;
            this.ctlProcToAddPrev.DrawOrder = LayoutEditor.Controls.ConnectionImagePanel.LineDrawOrder.HorizontalFast;
            this.ctlProcToAddPrev.EndCap = System.Drawing.Drawing2D.LineCap.ArrowAnchor;
            this.ctlProcToAddPrev.EndPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Right;
            this.ctlProcToAddPrev.EndPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Bottom;
            this.ctlProcToAddPrev.LineActive = true;
            this.ctlProcToAddPrev.LineColor = System.Drawing.Color.Black;
            this.ctlProcToAddPrev.LineWidth = 5F;
            resources.ApplyResources( this.ctlProcToAddPrev, "ctlProcToAddPrev" );
            this.ctlProcToAddPrev.Name = "ctlProcToAddPrev";
            this.ctlProcToAddPrev.StartCap = System.Drawing.Drawing2D.LineCap.Flat;
            this.ctlProcToAddPrev.StartPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Left;
            this.ctlProcToAddPrev.StartPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            //
            // ctlMtxToProc
            //
            this.ctlMtxToProc.BackColor = System.Drawing.Color.Transparent;
            this.ctlMtxToProc.DrawOrder = LayoutEditor.Controls.ConnectionImagePanel.LineDrawOrder.VerticalFast;
            this.ctlMtxToProc.EndCap = System.Drawing.Drawing2D.LineCap.ArrowAnchor;
            this.ctlMtxToProc.EndPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Right;
            this.ctlMtxToProc.EndPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            this.ctlMtxToProc.LineActive = true;
            this.ctlMtxToProc.LineColor = System.Drawing.Color.Black;
            this.ctlMtxToProc.LineWidth = 5F;
            resources.ApplyResources( this.ctlMtxToProc, "ctlMtxToProc" );
            this.ctlMtxToProc.Name = "ctlMtxToProc";
            this.ctlMtxToProc.StartCap = System.Drawing.Drawing2D.LineCap.Flat;
            this.ctlMtxToProc.StartPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Left;
            this.ctlMtxToProc.StartPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            //
            // ctlFmtToBias
            //
            this.ctlFmtToBias.BackColor = System.Drawing.Color.Transparent;
            this.ctlFmtToBias.DrawOrder = LayoutEditor.Controls.ConnectionImagePanel.LineDrawOrder.VerticalFast;
            this.ctlFmtToBias.EndCap = System.Drawing.Drawing2D.LineCap.ArrowAnchor;
            this.ctlFmtToBias.EndPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Right;
            this.ctlFmtToBias.EndPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            this.ctlFmtToBias.LineActive = true;
            this.ctlFmtToBias.LineColor = System.Drawing.Color.Black;
            this.ctlFmtToBias.LineWidth = 5F;
            resources.ApplyResources( this.ctlFmtToBias, "ctlFmtToBias" );
            this.ctlFmtToBias.Name = "ctlFmtToBias";
            this.ctlFmtToBias.StartCap = System.Drawing.Drawing2D.LineCap.Flat;
            this.ctlFmtToBias.StartPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Left;
            this.ctlFmtToBias.StartPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            //
            // ctlToFmt
            //
            this.ctlToFmt.BackColor = System.Drawing.Color.Transparent;
            this.ctlToFmt.DrawOrder = LayoutEditor.Controls.ConnectionImagePanel.LineDrawOrder.VerticalFast;
            this.ctlToFmt.EndCap = System.Drawing.Drawing2D.LineCap.ArrowAnchor;
            this.ctlToFmt.EndPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Right;
            this.ctlToFmt.EndPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            this.ctlToFmt.LineActive = true;
            this.ctlToFmt.LineColor = System.Drawing.Color.Black;
            this.ctlToFmt.LineWidth = 5F;
            resources.ApplyResources( this.ctlToFmt, "ctlToFmt" );
            this.ctlToFmt.Name = "ctlToFmt";
            this.ctlToFmt.StartCap = System.Drawing.Drawing2D.LineCap.Flat;
            this.ctlToFmt.StartPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Left;
            this.ctlToFmt.StartPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            //
            // ctlWrapToProc
            //
            this.ctlWrapToProc.BackColor = System.Drawing.Color.Transparent;
            this.ctlWrapToProc.DrawOrder = LayoutEditor.Controls.ConnectionImagePanel.LineDrawOrder.VerticalFast;
            this.ctlWrapToProc.EndCap = System.Drawing.Drawing2D.LineCap.ArrowAnchor;
            this.ctlWrapToProc.EndPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Right;
            this.ctlWrapToProc.EndPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Bottom;
            this.ctlWrapToProc.LineActive = true;
            this.ctlWrapToProc.LineColor = System.Drawing.Color.Black;
            this.ctlWrapToProc.LineWidth = 5F;
            resources.ApplyResources( this.ctlWrapToProc, "ctlWrapToProc" );
            this.ctlWrapToProc.Name = "ctlWrapToProc";
            this.ctlWrapToProc.StartCap = System.Drawing.Drawing2D.LineCap.Flat;
            this.ctlWrapToProc.StartPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Left;
            this.ctlWrapToProc.StartPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            //
            // ctlAddPrevToProc
            //
            this.ctlAddPrevToProc.BackColor = System.Drawing.Color.Transparent;
            this.ctlAddPrevToProc.DrawOrder = LayoutEditor.Controls.ConnectionImagePanel.LineDrawOrder.VerticalFast;
            this.ctlAddPrevToProc.EndCap = System.Drawing.Drawing2D.LineCap.ArrowAnchor;
            this.ctlAddPrevToProc.EndPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Right;
            this.ctlAddPrevToProc.EndPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            this.ctlAddPrevToProc.LineActive = true;
            this.ctlAddPrevToProc.LineColor = System.Drawing.Color.Black;
            this.ctlAddPrevToProc.LineWidth = 5F;
            resources.ApplyResources( this.ctlAddPrevToProc, "ctlAddPrevToProc" );
            this.ctlAddPrevToProc.Name = "ctlAddPrevToProc";
            this.ctlAddPrevToProc.StartCap = System.Drawing.Drawing2D.LineCap.Flat;
            this.ctlAddPrevToProc.StartPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Left;
            this.ctlAddPrevToProc.StartPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Bottom;
            //
            // crlFmtToBump
            //
            this.crlFmtToBump.BackColor = System.Drawing.Color.Transparent;
            this.crlFmtToBump.DrawOrder = LayoutEditor.Controls.ConnectionImagePanel.LineDrawOrder.VerticalFast;
            this.crlFmtToBump.EndCap = System.Drawing.Drawing2D.LineCap.ArrowAnchor;
            this.crlFmtToBump.EndPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Right;
            this.crlFmtToBump.EndPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Bottom;
            this.crlFmtToBump.LineActive = true;
            this.crlFmtToBump.LineColor = System.Drawing.Color.Black;
            this.crlFmtToBump.LineWidth = 5F;
            resources.ApplyResources( this.crlFmtToBump, "crlFmtToBump" );
            this.crlFmtToBump.Name = "crlFmtToBump";
            this.crlFmtToBump.StartCap = System.Drawing.Drawing2D.LineCap.Flat;
            this.crlFmtToBump.StartPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Left;
            this.crlFmtToBump.StartPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            //
            // ctlBumpToOut
            //
            this.ctlBumpToOut.BackColor = System.Drawing.Color.Transparent;
            this.ctlBumpToOut.DrawOrder = LayoutEditor.Controls.ConnectionImagePanel.LineDrawOrder.VerticalFast;
            this.ctlBumpToOut.EndCap = System.Drawing.Drawing2D.LineCap.ArrowAnchor;
            this.ctlBumpToOut.EndPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Right;
            this.ctlBumpToOut.EndPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            this.ctlBumpToOut.LineActive = true;
            this.ctlBumpToOut.LineColor = System.Drawing.Color.Black;
            this.ctlBumpToOut.LineWidth = 5F;
            resources.ApplyResources( this.ctlBumpToOut, "ctlBumpToOut" );
            this.ctlBumpToOut.Name = "ctlBumpToOut";
            this.ctlBumpToOut.StartCap = System.Drawing.Drawing2D.LineCap.Flat;
            this.ctlBumpToOut.StartPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Left;
            this.ctlBumpToOut.StartPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            //
            // ctlTexCoordSTToMtx
            //
            this.ctlTexCoordSTToMtx.BackColor = System.Drawing.Color.Transparent;
            this.ctlTexCoordSTToMtx.DrawOrder = LayoutEditor.Controls.ConnectionImagePanel.LineDrawOrder.VerticalFast;
            this.ctlTexCoordSTToMtx.EndCap = System.Drawing.Drawing2D.LineCap.ArrowAnchor;
            this.ctlTexCoordSTToMtx.EndPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Right;
            this.ctlTexCoordSTToMtx.EndPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Bottom;
            this.ctlTexCoordSTToMtx.LineActive = true;
            this.ctlTexCoordSTToMtx.LineColor = System.Drawing.Color.Black;
            this.ctlTexCoordSTToMtx.LineWidth = 5F;
            resources.ApplyResources( this.ctlTexCoordSTToMtx, "ctlTexCoordSTToMtx" );
            this.ctlTexCoordSTToMtx.Name = "ctlTexCoordSTToMtx";
            this.ctlTexCoordSTToMtx.StartCap = System.Drawing.Drawing2D.LineCap.Flat;
            this.ctlTexCoordSTToMtx.StartPointH = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeH.Left;
            this.ctlTexCoordSTToMtx.StartPointV = LayoutEditor.Controls.ConnectionImagePanel.PositionTypeV.Top;
            //
            // cmbBias
            //
            this.cmbBias.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            resources.ApplyResources( this.cmbBias, "cmbBias" );
            this.cmbBias.Name = "cmbBias";
            this.cmbBias.SelectedItemData = null;
            //
            // cmbMtxScale
            //
            this.cmbMtxScale.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            resources.ApplyResources( this.cmbMtxScale, "cmbMtxScale" );
            this.cmbMtxScale.Name = "cmbMtxScale";
            this.cmbMtxScale.SelectedItemData = null;
            //
            // cmbFmt
            //
            this.cmbFmt.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            resources.ApplyResources( this.cmbFmt, "cmbFmt" );
            this.cmbFmt.Name = "cmbFmt";
            this.cmbFmt.SelectedItemData = null;
            //
            // cmbAddPrev
            //
            this.cmbAddPrev.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            resources.ApplyResources( this.cmbAddPrev, "cmbAddPrev" );
            this.cmbAddPrev.Name = "cmbAddPrev";
            this.cmbAddPrev.SelectedItemData = null;
            //
            // cmbBumpAlpha
            //
            this.cmbBumpAlpha.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            resources.ApplyResources( this.cmbBumpAlpha, "cmbBumpAlpha" );
            this.cmbBumpAlpha.Name = "cmbBumpAlpha";
            this.cmbBumpAlpha.SelectedItemData = null;
            //
            // cmbTexWrapS
            //
            this.cmbTexWrapS.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            resources.ApplyResources( this.cmbTexWrapS, "cmbTexWrapS" );
            this.cmbTexWrapS.Name = "cmbTexWrapS";
            this.cmbTexWrapS.SelectedItemData = null;
            //
            // cmbTexWrapT
            //
            this.cmbTexWrapT.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            resources.ApplyResources( this.cmbTexWrapT, "cmbTexWrapT" );
            this.cmbTexWrapT.Name = "cmbTexWrapT";
            this.cmbTexWrapT.SelectedItemData = null;
            //
            // cmbLod
            //
            this.cmbLod.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            resources.ApplyResources( this.cmbLod, "cmbLod" );
            this.cmbLod.Name = "cmbLod";
            this.cmbLod.SelectedItemData = null;
            //
            // btnRestoreToDirect
            //
            resources.ApplyResources( this.btnRestoreToDirect, "btnRestoreToDirect" );
            this.btnRestoreToDirect.Name = "btnRestoreToDirect";
            this.btnRestoreToDirect.Click += new System.EventHandler( this.Event_BtnRestoreToDirect_Click );
            //
            // _lblTargetStage
            //
            resources.ApplyResources( this._lblTargetStage, "_lblTargetStage" );
            this._lblTargetStage.Name = "_lblTargetStage";
            //
            // cmbIndStage
            //
            resources.ApplyResources( this.cmbIndStage, "cmbIndStage" );
            this.cmbIndStage.Name = "cmbIndStage";
            this.cmbIndStage.SelectedItemData = null;
            //
            // TevIndirectStagePanel
            //
            this.BackColor = System.Drawing.Color.AntiqueWhite;
            this.Controls.Add( this.cmbIndStage );
            this.Controls.Add( this._lblTargetStage );
            this.Controls.Add( this.btnRestoreToDirect );
            this.Controls.Add( this.cmbLod );
            this.Controls.Add( this.cmbTexWrapT );
            this.Controls.Add( this.cmbTexWrapS );
            this.Controls.Add( this.cmbBumpAlpha );
            this.Controls.Add( this.cmbAddPrev );
            this.Controls.Add( this.cmbFmt );
            this.Controls.Add( this.cmbMtxScale );
            this.Controls.Add( this.cmbBias );
            this.Controls.Add( this.lblLod );
            this.Controls.Add( this.lblAddPrev );
            this.Controls.Add( this.plnProc );
            this.Controls.Add( this.lblTexCoordST );
            this.Controls.Add( this.lblTexWrap );
            this.Controls.Add( this.lblBumpAlpha );
            this.Controls.Add( this.lblMtxScale );
            this.Controls.Add( this.lblBias );
            this.Controls.Add( this.lblFmt );
            this.Controls.Add( this.lblIndirectTexInput );
            this.Controls.Add( this.ctlProcToLod );
            this.Controls.Add( this.ctlLodToOut );
            this.Controls.Add( this.ctlProcToOut );
            this.Controls.Add( this.ctlBiasToMtx );
            this.Controls.Add( this.ctlProcToAddPrev );
            this.Controls.Add( this.ctlMtxToProc );
            this.Controls.Add( this.ctlFmtToBias );
            this.Controls.Add( this.ctlWrapToProc );
            this.Controls.Add( this.ctlAddPrevToProc );
            this.Controls.Add( this.crlFmtToBump );
            this.Controls.Add( this.ctlBumpToOut );
            this.Controls.Add( this.ctlTexCoordSTToMtx );
            this.Controls.Add( this.ctlToWrap );
            this.Controls.Add( this.ctlToLod );
            this.Controls.Add( this.ctlToFmt );
            resources.ApplyResources( this, "$this" );
            this.Name = "TevIndirectStagePanel";
            this.ResumeLayout( false );

        }
        #endregion


        // 編集用データ
        //private readonly TevIndirectStage _data = new TevIndirectStage();

        /// <summary>データ変更イベント。</summary>
        public event EventHandler DataChanged = null;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public TevIndirectStagePanel()
        {
            InitializeComponent();
        }

        /// <summary>
        /// データ。
        /// </summary>
        public TevIndirectStage Data
        {
          get { return _data; }
          set
          {
            // 設定をコピー
            _data.Set(value);

            // プロパティ更新
            UpdateProperty();
          }
        }


        /// <summary>
        /// コンボボックス項目の設定：テクスチャラップ
        /// </summary>
        void AddItemToComboBoxWrapTex_( string strID, AttrTevIndWrap wrapMode )
        {
            cmbTexWrapS.AddItem( strID, wrapMode, true );
            cmbTexWrapT.AddItem( strID, wrapMode, true );
        }

        /// <summary>
        /// プロパティ初期化。
        /// </summary>
        public void InitializeProperty()
        {
            // ----------------- ハンドラ登録
            cmbIndStage.SelectedIndexChanged +=new EventHandler(Event_CmbIndStage_SelectedIndexChanged);
            cmbTexWrapS.SelectedIndexChanged += new EventHandler( Event_CmbTexWrapS_SelectedIndexChanged );
            cmbTexWrapT.SelectedIndexChanged += new EventHandler( Event_CmbTexWrapT_SelectedIndexChanged );
            cmbLod.SelectedIndexChanged += new EventHandler(Event_CmbLod_SelectedIndexChanged);
            cmbBias.SelectedIndexChanged +=new EventHandler(Event_CmbBias_SelectedIndexChanged);
            cmbMtxScale.SelectedIndexChanged +=new EventHandler(Event_CmbMtxScale_SelectedIndexChanged);
            cmbFmt.SelectedIndexChanged +=new EventHandler(Event_CmbFmt_SelectedIndexChanged);
            cmbAddPrev.SelectedIndexChanged +=new EventHandler(Event_CmbAddPrev_SelectedIndexChanged);
            cmbBumpAlpha.SelectedIndexChanged += new EventHandler(Event_CmbBumpAlpha_SelectedIndexChanged);



            // ----------------- コンボボックス項目の設定
            // インダイレクトステージ
            // 対象インダイレクトステージ
            cmbIndStage.AddItem("PROP_MAT_TEV_STAGE_IND_STAGE0", 0, true);
            cmbIndStage.AddItem("PROP_MAT_TEV_STAGE_IND_STAGE1", 1, true);
            cmbIndStage.AddItem("PROP_MAT_TEV_STAGE_IND_STAGE2", 2, true);
            cmbIndStage.AddItem("PROP_MAT_TEV_STAGE_IND_STAGE3", 3, true);

            // テクスチャラップ
            AddItemToComboBoxWrapTex_( "PROP_MAT_TEV_STAGE_IND_ITW_OFF", AttrTevIndWrap.ItwOff );
            AddItemToComboBoxWrapTex_( "PROP_MAT_TEV_STAGE_IND_ITW_256", AttrTevIndWrap.Itw256 );
            AddItemToComboBoxWrapTex_( "PROP_MAT_TEV_STAGE_IND_ITW_128", AttrTevIndWrap.Itw128 );
            AddItemToComboBoxWrapTex_( "PROP_MAT_TEV_STAGE_IND_ITW_64", AttrTevIndWrap.Itw64 );
            AddItemToComboBoxWrapTex_( "PROP_MAT_TEV_STAGE_IND_ITW_32", AttrTevIndWrap.Itw32 );
            AddItemToComboBoxWrapTex_( "PROP_MAT_TEV_STAGE_IND_ITW_16", AttrTevIndWrap.Itw16 );
            AddItemToComboBoxWrapTex_( "PROP_MAT_TEV_STAGE_IND_ITW_0", AttrTevIndWrap.Itw0 );
            // LOD
            cmbLod.AddItem( "PROP_MAT_TEV_STAGE_IND_LOD_TRUE", true, true );
            cmbLod.AddItem( "PROP_MAT_TEV_STAGE_IND_LOD_FALSE", false, true );
            // バイアス
            cmbBias.AddItem( "PROP_MAT_TEV_STAGE_IND_ITB_NONE", AttrTevIndBias.ItbNone , true );
            cmbBias.AddItem( "PROP_MAT_TEV_STAGE_IND_ITB_S", AttrTevIndBias.ItbS , true );
            cmbBias.AddItem( "PROP_MAT_TEV_STAGE_IND_ITB_T", AttrTevIndBias.ItbT, true );
            cmbBias.AddItem( "PROP_MAT_TEV_STAGE_IND_ITB_U", AttrTevIndBias.ItbU, true );
            cmbBias.AddItem( "PROP_MAT_TEV_STAGE_IND_ITB_ST", AttrTevIndBias.ItbST, true );
            cmbBias.AddItem( "PROP_MAT_TEV_STAGE_IND_ITB_SU", AttrTevIndBias.ItbSU, true );
            cmbBias.AddItem( "PROP_MAT_TEV_STAGE_IND_ITB_TU", AttrTevIndBias.ItbTU, true );
            cmbBias.AddItem( "PROP_MAT_TEV_STAGE_IND_ITB_STU", AttrTevIndBias.ItbSTU, true );
            // 行列・スケール
            cmbMtxScale.AddItem( "PROP_MAT_TEV_STAGE_IND_ITM_OFF", AttrTevIndMatrix.ItmOff, true );
            cmbMtxScale.AddItem( "PROP_MAT_TEV_STAGE_IND_ITM_0", AttrTevIndMatrix.Itm0, true );
            cmbMtxScale.AddItem( "PROP_MAT_TEV_STAGE_IND_ITM_1", AttrTevIndMatrix.Itm1, true );
            cmbMtxScale.AddItem( "PROP_MAT_TEV_STAGE_IND_ITM_2", AttrTevIndMatrix.Itm2, true );
            cmbMtxScale.AddItem( "PROP_MAT_TEV_STAGE_IND_ITM_S0", AttrTevIndMatrix.ItmS0, true );
            cmbMtxScale.AddItem( "PROP_MAT_TEV_STAGE_IND_ITM_S1", AttrTevIndMatrix.ItmS1, true );
            cmbMtxScale.AddItem( "PROP_MAT_TEV_STAGE_IND_ITM_S2", AttrTevIndMatrix.ItmS2, true );
            cmbMtxScale.AddItem( "PROP_MAT_TEV_STAGE_IND_ITM_T0", AttrTevIndMatrix.ItmT0, true );
            cmbMtxScale.AddItem( "PROP_MAT_TEV_STAGE_IND_ITM_T1", AttrTevIndMatrix.ItmT1, true );
            cmbMtxScale.AddItem( "PROP_MAT_TEV_STAGE_IND_ITM_T2", AttrTevIndMatrix.ItmT2, true );
            // フォーマット
            cmbFmt.AddItem( "PROP_MAT_TEV_STAGE_IND_ITF_8", AttrTevIndFormat.Itf8, true );
            cmbFmt.AddItem( "PROP_MAT_TEV_STAGE_IND_ITF_5", AttrTevIndFormat.Itf5, true );
            cmbFmt.AddItem( "PROP_MAT_TEV_STAGE_IND_ITF_4", AttrTevIndFormat.Itf4, true );
            cmbFmt.AddItem( "PROP_MAT_TEV_STAGE_IND_ITF_3", AttrTevIndFormat.Itf3, true );
            // フィードバック
            cmbAddPrev.AddItem( "PROP_MAT_TEV_STAGE_IND_ADD_TRUE", true, true );
            cmbAddPrev.AddItem( "PROP_MAT_TEV_STAGE_IND_ADD_FALSE", false, true );
            // バンプアルファ
            cmbBumpAlpha.AddItem( "PROP_MAT_TEV_STAGE_IND_ITBA_OFF", AttrTevIndAlpha.ItbaOff , true );
            cmbBumpAlpha.AddItem( "PROP_MAT_TEV_STAGE_IND_ITBA_S", AttrTevIndAlpha.ItbaS, true );
            cmbBumpAlpha.AddItem( "PROP_MAT_TEV_STAGE_IND_ITBA_T", AttrTevIndAlpha.ItbaT, true );
            cmbBumpAlpha.AddItem( "PROP_MAT_TEV_STAGE_IND_ITBA_U", AttrTevIndAlpha.ItbaU, true );


            // ----------------- オーナードローの設定
            cmbTexWrapS.DrawItem     += OwnerDrawUtil.UIComboItemDrawHandler;
            cmbTexWrapT.DrawItem     += OwnerDrawUtil.UIComboItemDrawHandler;
            cmbLod.DrawItem          += OwnerDrawUtil.UIComboItemDrawHandler;
            cmbBias.DrawItem         += OwnerDrawUtil.UIComboItemDrawHandler;
            cmbMtxScale.DrawItem     += OwnerDrawUtil.UIComboItemDrawHandler;
            cmbFmt.DrawItem          += OwnerDrawUtil.UIComboItemDrawHandler;
            cmbAddPrev.DrawItem      += OwnerDrawUtil.UIComboItemDrawHandler;
            cmbBumpAlpha.DrawItem    += OwnerDrawUtil.UIComboItemDrawHandler;



            // ----------------- ドロップダウン領域のサイズの指定
            const int DropDownWidth = 300;
            const int DropDownWidthWide = 350;

            cmbTexWrapS.DropDownWidth  = DropDownWidth;
            cmbTexWrapT.DropDownWidth  = DropDownWidth;
            cmbLod.DropDownWidth       = DropDownWidth;
            cmbBias.DropDownWidth      = DropDownWidth;
            cmbMtxScale.DropDownWidth  = DropDownWidthWide;
            cmbFmt.DropDownWidth       = DropDownWidthWide;
            cmbAddPrev.DropDownWidth = DropDownWidth;
            cmbBumpAlpha.DropDownWidth = DropDownWidth;
        }

        /// <summary>
        /// プロパティ更新。
        /// </summary>
        public void UpdateProperty()
        {
            // UIへパラメータを設定します。
            cmbIndStage.SetSelectedItemData( _data.IndStage );
            cmbTexWrapS.SetSelectedItemData( _data.WrapS );
            cmbTexWrapT.SetSelectedItemData( _data.WrapT );
            cmbLod.SetSelectedItemData( _data.UtcLod );
            cmbBias.SetSelectedItemData( _data.BiasSel );
            cmbMtxScale.SetSelectedItemData( _data.MatrixSel );
            cmbFmt.SetSelectedItemData( _data.Format );
            cmbAddPrev.SetSelectedItemData( _data.AddPrev );
            cmbBumpAlpha.SetSelectedItemData( _data.AlphaSel );

            // 矢印結線の状態を更新します。
            UpdateProperty_LodLines_();
            UpdateProperty_MtxScaleLines_();
            UpdateProperty_UsePrevLines_();
            UpdateProperty_BumpLines_();
        }

        /// <summary>
        /// データ変更ハンドラ。
        /// </summary>
        private void OnDataChanged(EventArgs e)
        {
            if (this.DataChanged != null)
            {
                this.DataChanged(this, e);
            }
        }

        #region オーバーライド
        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }
        #endregion

        #region 矢印結線の状態更新
        /// <summary>
        /// LOD 線 状態更新
        /// </summary>
        void UpdateProperty_LodLines_()
        {
            // 矢印の状態を更新します。
            ctlToLod.LineActive     = !_data.UtcLod;
            ctlProcToLod.LineActive = _data.UtcLod;
        }

        /// <summary>
        /// マトリクススケー 線 状態更新
        /// </summary>
        void UpdateProperty_MtxScaleLines_()
        {
            // 矢印の状態を更新します。
            bool bUseDinamicTex =
                _data.MatrixSel == AttrTevIndMatrix.ItmS0 ||
                _data.MatrixSel == AttrTevIndMatrix.ItmS1 ||
                _data.MatrixSel == AttrTevIndMatrix.ItmS2 ||
                _data.MatrixSel == AttrTevIndMatrix.ItmT0 ||
                _data.MatrixSel == AttrTevIndMatrix.ItmT1 ||
                _data.MatrixSel == AttrTevIndMatrix.ItmT2;

            ctlTexCoordSTToMtx.LineActive = bUseDinamicTex;
        }

        /// <summary>
        /// 前結果を使用するか 線 状態更新
        /// </summary>
        void UpdateProperty_UsePrevLines_()
        {
            // 矢印の状態を更新します。
            ctlProcToAddPrev.LineActive = _data.AddPrev;
            ctlAddPrevToProc.LineActive = _data.AddPrev;
        }

        /// <summary>
        /// バンプアルファ 線 状態更新
        /// </summary>
        void UpdateProperty_BumpLines_()
        {
            // 矢印の状態を更新します。
            bool bUseAplha = _data.AlphaSel != AttrTevIndAlpha.ItbaOff;
            ctlBumpToOut.LineActive = bUseAplha;
            crlFmtToBump.LineActive = bUseAplha;
        }
        #endregion 矢印結線の状態更新

        #region イベントハンドラ
        /// <summary>
        /// インダイレクトステージ
        /// </summary>
        private void Event_CmbIndStage_SelectedIndexChanged(object sender, EventArgs e)
        {
            UIComboBox cmb = sender as UIComboBox;
            _data.IndStage = (int)cmb.SelectedItemData;

            OnDataChanged(EventArgs.Empty);
        }

        /// <summary>
        /// ダイレクト設定に戻す ボタン 更新ハンドラ
        /// </summary>
        private void Event_BtnRestoreToDirect_Click(object sender, System.EventArgs e)
        {
            Data.SetDirect();
            OnDataChanged(EventArgs.Empty);
        }

        /// <summary>
        /// WrapS コンボボックス 更新ハンドラ
        /// </summary>
        private void Event_CmbTexWrapS_SelectedIndexChanged(object sender, EventArgs e)
        {
            _data.WrapS = (AttrTevIndWrap)cmbTexWrapS.SelectedItemData;
            OnDataChanged(EventArgs.Empty);
        }

        /// <summary>
        /// WrapT コンボボックス 更新ハンドラ
        /// </summary>
        private void Event_CmbTexWrapT_SelectedIndexChanged(object sender, EventArgs e)
        {
            _data.WrapT = (AttrTevIndWrap)cmbTexWrapT.SelectedItemData;
            OnDataChanged(EventArgs.Empty);
        }

        /// <summary>
        /// LOD コンボボックス 更新ハンドラ
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Event_CmbLod_SelectedIndexChanged(object sender, EventArgs e)
        {
            _data.UtcLod = (bool)cmbLod.SelectedItemData;

            // 矢印の状態を更新します。
            UpdateProperty_LodLines_();

            OnDataChanged(EventArgs.Empty);
        }

        /// <summary>
        /// バイアス コンボボックス 更新ハンドラ
        /// </summary>
        private void Event_CmbBias_SelectedIndexChanged(object sender, EventArgs e)
        {
            _data.BiasSel = (AttrTevIndBias)cmbBias.SelectedItemData;
            OnDataChanged(EventArgs.Empty);
        }



        /// <summary>
        /// マトリクススケール コンボボックス 更新ハンドラ
        /// </summary>
        private void Event_CmbMtxScale_SelectedIndexChanged(object sender, EventArgs e)
        {
            _data.MatrixSel = (AttrTevIndMatrix)cmbMtxScale.SelectedItemData;

            // 矢印の状態を更新します。
            UpdateProperty_MtxScaleLines_();


            OnDataChanged(EventArgs.Empty);
        }

        /// <summary>
        /// フォーマット コンボボックス 更新ハンドラ
        /// </summary>
        private void Event_CmbFmt_SelectedIndexChanged(object sender, EventArgs e)
        {
            _data.Format = (AttrTevIndFormat)cmbFmt.SelectedItemData;
            OnDataChanged(EventArgs.Empty);
        }

        /// <summary>
        /// 前結果を使用するか コンボボックス 更新ハンドラ
        /// </summary>
        private void Event_CmbAddPrev_SelectedIndexChanged(object sender, EventArgs e)
        {
            _data.AddPrev = (bool)cmbAddPrev.SelectedItemData;

            // 矢印の状態を更新します。
            UpdateProperty_UsePrevLines_();

            OnDataChanged(EventArgs.Empty);
        }

        /// <summary>
        /// バンプアルファ コンボボックス 更新ハンドラ
        /// </summary>
        private void Event_CmbBumpAlpha_SelectedIndexChanged(object sender, EventArgs e)
        {
            _data.AlphaSel = (AttrTevIndAlpha)cmbBumpAlpha.SelectedItemData;

            // 矢印の状態を更新します。
            UpdateProperty_BumpLines_();

            OnDataChanged(EventArgs.Empty);
        }

        #endregion




    }
}
