﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;



namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.MaterialPages
{
    using LayoutEditor.Controls;
    using LayoutEditor.Utility;
    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters ;
    using LECore.Structures.Nsrif.Attributes;

    using App = LayoutEditor;

    /// <summary>
    /// マテリアルＰＥページクラス。
    /// </summary>
    public sealed class MaterialPEPage : MaterialPage
    {
        #region デザイナ変数

        private System.Windows.Forms.Button btnPresetOpa;
        private System.Windows.Forms.Button btnPresetEdge;
        private System.Windows.Forms.Button btnPresetXlu;
        private System.Windows.Forms.GroupBox grpBlend;
        private System.Windows.Forms.GroupBox grpAComp;
        private App.Controls.IntEditSlider ctlACRef0;
        private App.Controls.IntEditSlider ctlACRef1;
        private App.Controls.UIComboBox cmbACComp0;
        private App.Controls.UIComboBox cmbACComp1;
        private App.Controls.UIComboBox cmbACOp;
        private System.Windows.Forms.Label labState;
        private System.Windows.Forms.Label labStateT;
        private LayoutEditor.Forms.ToolWindows.PropertyEditWindow.MaterialPages.PEControls.PEBlendPanel ctlBlend;
        private System.Windows.Forms.Label lblAC1;
        private System.Windows.Forms.Label lblAC0;
        private System.Windows.Forms.Label lblACOp;
        private System.Windows.Forms.Label lblACComp;
        private System.Windows.Forms.Label lblACRef;
        private System.Windows.Forms.Label lblACRefMin;
        private System.Windows.Forms.Label lblACRefMax;
        private Button _btnPresetAdd;
        private Button _btnPresetSub;
        private Button _btnPresetMul;
        private System.ComponentModel.Container components = null;
        #endregion

        #region デザイナコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager( typeof( MaterialPEPage ) );
            LECore.Structures.PEBlend peBlend1 = new LECore.Structures.PEBlend();
            this.grpAComp = new System.Windows.Forms.GroupBox();
            this.lblACRefMax = new System.Windows.Forms.Label();
            this.lblACRefMin = new System.Windows.Forms.Label();
            this.cmbACOp = new LayoutEditor.Controls.UIComboBox();
            this.lblAC1 = new System.Windows.Forms.Label();
            this.lblAC0 = new System.Windows.Forms.Label();
            this.lblACOp = new System.Windows.Forms.Label();
            this.cmbACComp1 = new LayoutEditor.Controls.UIComboBox();
            this.cmbACComp0 = new LayoutEditor.Controls.UIComboBox();
            this.lblACComp = new System.Windows.Forms.Label();
            this.ctlACRef1 = new LayoutEditor.Controls.IntEditSlider();
            this.ctlACRef0 = new LayoutEditor.Controls.IntEditSlider();
            this.lblACRef = new System.Windows.Forms.Label();
            this.grpBlend = new System.Windows.Forms.GroupBox();
            this.ctlBlend = new LayoutEditor.Forms.ToolWindows.PropertyEditWindow.MaterialPages.PEControls.PEBlendPanel();
            this.btnPresetOpa = new System.Windows.Forms.Button();
            this.btnPresetEdge = new System.Windows.Forms.Button();
            this.btnPresetXlu = new System.Windows.Forms.Button();
            this.labState = new System.Windows.Forms.Label();
            this.labStateT = new System.Windows.Forms.Label();
            this._btnPresetAdd = new System.Windows.Forms.Button();
            this._btnPresetSub = new System.Windows.Forms.Button();
            this._btnPresetMul = new System.Windows.Forms.Button();
            this.grpAComp.SuspendLayout();
            this.grpBlend.SuspendLayout();
            this.SuspendLayout();
            //
            // grpAComp
            //
            this.grpAComp.Controls.Add( this.lblACRefMax );
            this.grpAComp.Controls.Add( this.lblACRefMin );
            this.grpAComp.Controls.Add( this.cmbACOp );
            this.grpAComp.Controls.Add( this.lblAC1 );
            this.grpAComp.Controls.Add( this.lblAC0 );
            this.grpAComp.Controls.Add( this.lblACOp );
            this.grpAComp.Controls.Add( this.cmbACComp1 );
            this.grpAComp.Controls.Add( this.cmbACComp0 );
            this.grpAComp.Controls.Add( this.lblACComp );
            this.grpAComp.Controls.Add( this.ctlACRef1 );
            this.grpAComp.Controls.Add( this.ctlACRef0 );
            this.grpAComp.Controls.Add( this.lblACRef );
            this.grpAComp.FlatStyle = System.Windows.Forms.FlatStyle.System;
            resources.ApplyResources( this.grpAComp, "grpAComp" );
            this.grpAComp.Name = "grpAComp";
            this.grpAComp.TabStop = false;
            //
            // lblACRefMax
            //
            resources.ApplyResources( this.lblACRefMax, "lblACRefMax" );
            this.lblACRefMax.Name = "lblACRefMax";
            //
            // lblACRefMin
            //
            resources.ApplyResources( this.lblACRefMin, "lblACRefMin" );
            this.lblACRefMin.Name = "lblACRefMin";
            //
            // cmbACOp
            //
            resources.ApplyResources( this.cmbACOp, "cmbACOp" );
            this.cmbACOp.Name = "cmbACOp";
            this.cmbACOp.SelectedItemData = null;
            //
            // lblAC1
            //
            resources.ApplyResources( this.lblAC1, "lblAC1" );
            this.lblAC1.Name = "lblAC1";
            //
            // lblAC0
            //
            resources.ApplyResources( this.lblAC0, "lblAC0" );
            this.lblAC0.Name = "lblAC0";
            //
            // lblACOp
            //
            resources.ApplyResources( this.lblACOp, "lblACOp" );
            this.lblACOp.Name = "lblACOp";
            //
            // cmbACComp1
            //
            resources.ApplyResources( this.cmbACComp1, "cmbACComp1" );
            this.cmbACComp1.Name = "cmbACComp1";
            this.cmbACComp1.SelectedItemData = null;
            //
            // cmbACComp0
            //
            resources.ApplyResources( this.cmbACComp0, "cmbACComp0" );
            this.cmbACComp0.Name = "cmbACComp0";
            this.cmbACComp0.SelectedItemData = null;
            //
            // lblACComp
            //
            resources.ApplyResources( this.lblACComp, "lblACComp" );
            this.lblACComp.Name = "lblACComp";
            //
            // ctlACRef1
            //
            resources.ApplyResources( this.ctlACRef1, "ctlACRef1" );
            this.ctlACRef1.MaxValue = 255;
            this.ctlACRef1.MinValue = 0;
            this.ctlACRef1.Name = "ctlACRef1";
            this.ctlACRef1.ShowRangeLabel = false;
            this.ctlACRef1.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size56;
            //
            // ctlACRef0
            //
            resources.ApplyResources( this.ctlACRef0, "ctlACRef0" );
            this.ctlACRef0.MaxValue = 255;
            this.ctlACRef0.MinValue = 0;
            this.ctlACRef0.Name = "ctlACRef0";
            this.ctlACRef0.ShowRangeLabel = false;
            this.ctlACRef0.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size56;
            //
            // lblACRef
            //
            resources.ApplyResources( this.lblACRef, "lblACRef" );
            this.lblACRef.Name = "lblACRef";
            //
            // grpBlend
            //
            this.grpBlend.Controls.Add( this.ctlBlend );
            this.grpBlend.FlatStyle = System.Windows.Forms.FlatStyle.System;
            resources.ApplyResources( this.grpBlend, "grpBlend" );
            this.grpBlend.Name = "grpBlend";
            this.grpBlend.TabStop = false;
            //
            // ctlBlend
            //
            peBlend1.DstFactor = LECore.Structures.Nsrif.Attributes.AttrBlendFactor.InvSrcAlpha;
            peBlend1.LogicOp = LECore.Structures.Nsrif.Attributes.AttrLogicOp.Copy;
            peBlend1.SrcFactor = LECore.Structures.Nsrif.Attributes.AttrBlendFactor.SrcAlpha;
            peBlend1.Type = LECore.Structures.Nsrif.Attributes.AttrBlendType.None;
            this.ctlBlend.Data = peBlend1;
            resources.ApplyResources( this.ctlBlend, "ctlBlend" );
            this.ctlBlend.Name = "ctlBlend";
            //
            // btnPresetOpa
            //
            resources.ApplyResources( this.btnPresetOpa, "btnPresetOpa" );
            this.btnPresetOpa.Name = "btnPresetOpa";
            //
            // btnPresetEdge
            //
            resources.ApplyResources( this.btnPresetEdge, "btnPresetEdge" );
            this.btnPresetEdge.Name = "btnPresetEdge";
            //
            // btnPresetXlu
            //
            resources.ApplyResources( this.btnPresetXlu, "btnPresetXlu" );
            this.btnPresetXlu.Name = "btnPresetXlu";
            //
            // labState
            //
            this.labState.BackColor = System.Drawing.SystemColors.Window;
            this.labState.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            resources.ApplyResources( this.labState, "labState" );
            this.labState.ForeColor = System.Drawing.Color.Blue;
            this.labState.Name = "labState";
            //
            // labStateT
            //
            resources.ApplyResources( this.labStateT, "labStateT" );
            this.labStateT.Name = "labStateT";
            //
            // _btnPresetAdd
            //
            resources.ApplyResources( this._btnPresetAdd, "_btnPresetAdd" );
            this._btnPresetAdd.Name = "_btnPresetAdd";
            this._btnPresetAdd.Click += new System.EventHandler( this.Event_BtnPresetAdd_Click );
            //
            // _btnPresetSub
            //
            resources.ApplyResources( this._btnPresetSub, "_btnPresetSub" );
            this._btnPresetSub.Name = "_btnPresetSub";
            this._btnPresetSub.Click += new System.EventHandler( this.Event_BtnPresetSub_Click );
            //
            // _btnPresetMul
            //
            resources.ApplyResources( this._btnPresetMul, "_btnPresetMul" );
            this._btnPresetMul.Name = "_btnPresetMul";
            this._btnPresetMul.Click += new System.EventHandler( this.Event_BtnPresetMul_Click );
            //
            // MaterialPEPage
            //
            this.Controls.Add( this._btnPresetMul );
            this.Controls.Add( this._btnPresetSub );
            this.Controls.Add( this._btnPresetAdd );
            this.Controls.Add( this.labStateT );
            this.Controls.Add( this.labState );
            this.Controls.Add( this.btnPresetXlu );
            this.Controls.Add( this.btnPresetEdge );
            this.Controls.Add( this.btnPresetOpa );
            this.Controls.Add( this.grpBlend );
            this.Controls.Add( this.grpAComp );
            resources.ApplyResources( this, "$this" );
            this.Name = "MaterialPEPage";
            this.grpAComp.ResumeLayout( false );
            this.grpAComp.PerformLayout();
            this.grpBlend.ResumeLayout( false );
            this.ResumeLayout( false );

        }
        #endregion

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public MaterialPEPage()
        {
            InitializeComponent();
        }

        /// <summary>
        /// インスタンス作成。
        /// </summary>
        public static ObjPropertyPage CreateInstance(object arg)
        {
            ObjPropertyPage page = new MaterialPEPage();
            return page;
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        public override PropertyPageID PageID
        {
            get { return PropertyPageID.MaterialPE; }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void InitializeProperty()
        {
            // プリセット
            btnPresetOpa.Click  += new EventHandler(Event_BtnPresetOpa_Click);
            btnPresetEdge.Click += new EventHandler(Event_BtnPresetEdge_Click);
            btnPresetXlu.Click  += new EventHandler(Event_BtnPresetXlu_Click);

            // アルファコンペア
            cmbACComp0.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_MAT_PE_ACF_NEVER"),   AttrCompareFunc.Never));
            cmbACComp0.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_MAT_PE_ACF_LESS"),    AttrCompareFunc.Less));
            cmbACComp0.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_MAT_PE_ACF_LEQUAL"),  AttrCompareFunc.Lequal));
            cmbACComp0.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_MAT_PE_ACF_EQUAL"),   AttrCompareFunc.Equal));
            cmbACComp0.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_MAT_PE_ACF_NEQUAL"),  AttrCompareFunc.Nequal));
            cmbACComp0.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_MAT_PE_ACF_GEQUAL"),  AttrCompareFunc.Gequal));
            cmbACComp0.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_MAT_PE_ACF_GREATER"), AttrCompareFunc.Greater));
            cmbACComp0.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_MAT_PE_ACF_ALWAYS"),  AttrCompareFunc.Always));

            cmbACComp1.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_MAT_PE_ACF_NEVER"),   AttrCompareFunc.Never));
            cmbACComp1.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_MAT_PE_ACF_LESS"),    AttrCompareFunc.Less));
            cmbACComp1.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_MAT_PE_ACF_LEQUAL"),  AttrCompareFunc.Lequal));
            cmbACComp1.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_MAT_PE_ACF_EQUAL"),   AttrCompareFunc.Equal));
            cmbACComp1.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_MAT_PE_ACF_NEQUAL"),  AttrCompareFunc.Nequal));
            cmbACComp1.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_MAT_PE_ACF_GEQUAL"),  AttrCompareFunc.Gequal));
            cmbACComp1.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_MAT_PE_ACF_GREATER"), AttrCompareFunc.Greater));
            cmbACComp1.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_MAT_PE_ACF_ALWAYS"),  AttrCompareFunc.Always));

            cmbACOp.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_MAT_PE_ACO_AND"),  AttrAlphaOp.And));
            cmbACOp.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_MAT_PE_ACO_OR"),   AttrAlphaOp.Or));
            cmbACOp.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_MAT_PE_ACO_XOR"),  AttrAlphaOp.Xor));
            cmbACOp.Items.Add(new UIListControlItem(StringResMgr.Get("PROP_MAT_PE_ACO_XNOR"), AttrAlphaOp.Xnor));

            ctlACRef0.ValueEdit += new ValueEditEventHandler(Event_CtlACRef0_ValueEdit);
            ctlACRef1.ValueEdit += new ValueEditEventHandler(Event_CtlACRef1_ValueEdit);
            cmbACComp0.SelectedIndexChanged += new EventHandler(Event_CmbACComp0_SelectedIndexChanged);
            cmbACComp1.SelectedIndexChanged += new EventHandler(Event_CmbACComp1_SelectedIndexChanged);
            cmbACOp.SelectedIndexChanged += new EventHandler(Event_CmbACOp_SelectedIndexChanged);

            // ブレンド
            ctlBlend.InitializeProperty();
            ctlBlend.DataChanged += new EventHandler(Event_CtlBlend_DataChanged);
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void UpdateProperty()
        {
            PEData data = this.ActiveTarget.PEData;

            // 現在の設定
            UpdateStateText();

            // アルファコンペア
            LECore.Structures.PEACompare ac = data.ACompare;

            // Ｚ処理
            LECore.Structures.PEZCompare zc = data.ZCompare;

            // ブレンド
            ctlBlend.Data = data.Blend;
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void Dispose( bool disposing )
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region コピー＆ペースト
        /// <summary>
        /// コピーが可能か。
        /// </summary>
        public override bool CanCopy(){ return true; }

        /// <summary>
        /// コピー。
        /// </summary>
        public override Object Copy()
        {
            return Copy(ActiveTarget);
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public static Object Copy(MaterialGUIAdapter target)
        {
            return new PEData(target.PEData);
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public override void Paste(Object pasteObject)
        {
            Paste(ActiveTarget, pasteObject);
            UpdateProperty();
            NotifyPropertyChanged();
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public static void Paste(MaterialGUIAdapter destination, Object pasteObject)
        {
            Debug.Assert(pasteObject is PEData);
            PEData source = (PEData)pasteObject;
            destination.PEData.Set(source);

            // MCS
            //			MaterialPEData.Send(destination, destination.PEData);
        }
        #endregion

        /// <summary>
        /// 状態テキスト更新。
        /// </summary>
        private void UpdateStateText()
        {
            PEData data = this.ActiveTarget.PEData;
            labState.Text = data.StateText;
        }

        #region イベントハンドラ

        void SetPresetPESetting_( PEData presetData )
        {
            this.ActiveTarget.PEData.Set( presetData );
            UpdateProperty();
            NotifyPropertyChanged();

            // MCS
            //			MaterialPEData.Send(ActiveTarget, ActiveTarget.PEData);
        }

        // プリセット
        private void Event_BtnPresetOpa_Click(object sender, EventArgs e)
        {
            SetPresetPESetting_( PEData.Opa );
        }

        private void Event_BtnPresetEdge_Click(object sender, EventArgs e)
        {
            SetPresetPESetting_( PEData.Edge );
        }

        private void Event_BtnPresetXlu_Click(object sender, EventArgs e)
        {
            SetPresetPESetting_( PEData.Xlu );
        }

        private void Event_BtnPresetAdd_Click( object sender, EventArgs e )
        {
            SetPresetPESetting_( PEData.Add );
        }

        private void Event_BtnPresetMul_Click( object sender, EventArgs e )
        {
            SetPresetPESetting_( PEData.Mul );
        }

        private void Event_BtnPresetSub_Click( object sender, EventArgs e )
        {
            SetPresetPESetting_( PEData.Sub );
        }

        // 描画順序
        private void Event_RadDM_RadioChecked(object sender, EventArgs e)
        {
            this.ActiveTarget.PEData.DrawMode = (AttrTransparencyMode)((RadioButton)sender).Tag;
            UpdateStateText();
            NotifyPropertyChanged();

            // MCS
            //			MaterialTransparencyMode.Send(
            //				ActiveTarget, ActiveTarget.PEData.DrawMode);
        }

        // アルファコンペア
        private void Event_CtlACRef0_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (e.EditFixed)
            {
                //this.ActiveTarget.PEData.ACompare.Ref0 = ctlACRef0.Value;
                UpdateStateText();
                NotifyPropertyChanged();

                //				// MCS
                //				MaterialPEAlphaCompare.Send(
                //					ActiveTarget, ActiveTarget.PEData.ACompare);
            }
            else
            {
                //				// MCS
                //				PEACompare aCompare = new PEACompare(ActiveTarget.PEData.ACompare);
                //				aCompare.Ref0 = ctlACRef0.Value;
                //				MaterialPEAlphaCompare.Send(ActiveTarget, aCompare);
            }

        }

        private void Event_CtlACRef1_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (e.EditFixed)
            {
                //this.ActiveTarget.PEData.ACompare.Ref1 = ctlACRef1.Value;
                UpdateStateText();
                NotifyPropertyChanged();

                //				// MCS
                //				MaterialPEAlphaCompare.Send(
                //					ActiveTarget, ActiveTarget.PEData.ACompare);
            }
            else
            {
                // MCS
                //				PEACompare aCompare = new PEACompare(ActiveTarget.PEData.ACompare);
                //				aCompare.Ref1 = ctlACRef1.Value;
                //				MaterialPEAlphaCompare.Send(ActiveTarget, aCompare);
            }
        }

        private void Event_CmbACComp0_SelectedIndexChanged(object sender, EventArgs e)
        {
            //this.ActiveTarget.PEData.ACompare.Comp0 = (AttrCompareFunc)cmbACComp0.SelectedItemData;
            UpdateStateText();
            NotifyPropertyChanged();

            // MCS
            //			MaterialPEAlphaCompare.Send(
            //				ActiveTarget, ActiveTarget.PEData.ACompare);
        }

        private void Event_CmbACComp1_SelectedIndexChanged(object sender, EventArgs e)
        {
            //this.ActiveTarget.PEData.ACompare.Comp1 = (AttrCompareFunc)cmbACComp1.SelectedItemData;
            UpdateStateText();
            NotifyPropertyChanged();

            // MCS
            //			MaterialPEAlphaCompare.Send(
            //				ActiveTarget, ActiveTarget.PEData.ACompare);
        }

        private void Event_CmbACOp_SelectedIndexChanged(object sender, EventArgs e)
        {
            this.ActiveTarget.PEData.ACompare.Op = (AttrAlphaOp)cmbACOp.SelectedItemData;
            UpdateStateText();
            NotifyPropertyChanged();

            // MCS
            //			MaterialPEAlphaCompare.Send(
            //				ActiveTarget, ActiveTarget.PEData.ACompare);
        }

        // Ｚ処理
        private void Event_ChkZCEnable_CheckedChanged(object sender, EventArgs e)
        {
            //this.ActiveTarget.PEData.ZCompare.Enable = chkZCEnable.Checked;
            //UpdateProperty();
            //NotifyPropertyChanged();

            // MCS
            //			MaterialPEZCompare.Send(
            //				ActiveTarget, ActiveTarget.PEData.ZCompare);
        }

        private void Event_ChkZCBefTex_CheckedChanged(object sender, EventArgs e)
        {
            //this.ActiveTarget.PEData.ZCompare.BeforeTex = chkZCBefTex.Checked;
            //UpdateStateText();
            //NotifyPropertyChanged();

            // MCS
            //			MaterialPEZCompare.Send(
            //				ActiveTarget, ActiveTarget.PEData.ZCompare);
        }

        private void Event_ChkZCUpdate_CheckedChanged(object sender, EventArgs e)
        {
            //this.ActiveTarget.PEData.ZCompare.Update = chkZCUpdate.Checked;
            //UpdateStateText();
            //NotifyPropertyChanged();

            // MCS
            //			MaterialPEZCompare.Send(
            //				ActiveTarget, ActiveTarget.PEData.ZCompare);
        }

        private void Event_CmbZCFunc_SelectedIndexChanged(object sender, EventArgs e)
        {
            //this.ActiveTarget.PEData.ZCompare.Func = (AttrCompareFunc)cmbZCFunc.SelectedItemData;
            //UpdateStateText();
            //NotifyPropertyChanged();

            // MCS
            //			MaterialPEZCompare.Send(
            //				ActiveTarget, ActiveTarget.PEData.ZCompare);
        }

        // ブレンド
        private void Event_CtlBlend_DataChanged(object sender, EventArgs e)
        {
            LECore.DbgConsole.WriteLine("Blend_DataChanged");
            LECore.DbgConsole.WriteLine(ctlBlend.Data.ToString());

            this.ActiveTarget.PEData.Blend.Set(ctlBlend.Data);
            NotifyPropertyChanged();

            // MCS
            // MaterialPEBlendMode.Send(ActiveTarget, ActiveTarget.PEData.Blend);
        }
        #endregion
    }
}
