﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Diagnostics;
using System.Windows.Forms;


using LECore;
using LECore.Structures.Nsrif.Attributes;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.MaterialPages
{

    using Utility;
    using Adapters;

    using LayoutEditor.Controls;

    /// <summary>
    /// インダイレクト行列を編集するページ
    /// </summary>
    public class MaterialIndirectStagePage : MaterialPage
    {
        #region デザイナ生成コード
        private System.Windows.Forms.Label _lblNotice;
        private LayoutEditor.Controls.UIRadioButton _radIndStage1;
        private LayoutEditor.Controls.UIRadioButton _radIndStage2;
        private System.Windows.Forms.GroupBox _grpStage;
        private LayoutEditor.Controls.UIRadioButton _radIndStage0;
        private System.Windows.Forms.GroupBox _grpTexCoordScale;
        private System.Windows.Forms.Label _lblScaleS;
        private System.Windows.Forms.GroupBox _grpTextureOrder;
        private System.Windows.Forms.Label _lblTexCoord;
        private LayoutEditor.Controls.IntTextBox _tbxNumStages;
        private System.Windows.Forms.Label _labNumStages;
        private LayoutEditor.Controls.UIRadioButton _radIndStage3;
        private LayoutEditor.Controls.UIComboBox _cmbScaleT;
        private LayoutEditor.Controls.UIComboBox _cmbScaleS;
        private System.Windows.Forms.Label _lblTextureOrderHint;
        private System.Windows.Forms.Label _lblTexMapImage;
        private LayoutEditor.Controls.UIComboBox _cmbTexMapImage;
        private LayoutEditor.Controls.UIComboBox _cmbTexCoord;
        private System.Windows.Forms.Label _lblScaleT;

        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager( typeof( MaterialIndirectStagePage ) );
            this._radIndStage1 = new LayoutEditor.Controls.UIRadioButton();
            this._radIndStage2 = new LayoutEditor.Controls.UIRadioButton();
            this._grpStage = new System.Windows.Forms.GroupBox();
            this._radIndStage3 = new LayoutEditor.Controls.UIRadioButton();
            this._radIndStage0 = new LayoutEditor.Controls.UIRadioButton();
            this._grpTexCoordScale = new System.Windows.Forms.GroupBox();
            this._cmbScaleT = new LayoutEditor.Controls.UIComboBox();
            this._cmbScaleS = new LayoutEditor.Controls.UIComboBox();
            this._lblScaleT = new System.Windows.Forms.Label();
            this._lblScaleS = new System.Windows.Forms.Label();
            this._lblNotice = new System.Windows.Forms.Label();
            this._grpTextureOrder = new System.Windows.Forms.GroupBox();
            this._lblTextureOrderHint = new System.Windows.Forms.Label();
            this._lblTexMapImage = new System.Windows.Forms.Label();
            this._lblTexCoord = new System.Windows.Forms.Label();
            this._cmbTexMapImage = new LayoutEditor.Controls.UIComboBox();
            this._cmbTexCoord = new LayoutEditor.Controls.UIComboBox();
            this._tbxNumStages = new LayoutEditor.Controls.IntTextBox();
            this._labNumStages = new System.Windows.Forms.Label();
            this._grpStage.SuspendLayout();
            this._grpTexCoordScale.SuspendLayout();
            this._grpTextureOrder.SuspendLayout();
            this.SuspendLayout();
            //
            // _radIndStage1
            //
            resources.ApplyResources( this._radIndStage1, "_radIndStage1" );
            this._radIndStage1.Name = "_radIndStage1";
            this._radIndStage1.CheckedChanged += new System.EventHandler( this.Event_RadIndStage_CheckedChanged );
            //
            // _radIndStage2
            //
            resources.ApplyResources( this._radIndStage2, "_radIndStage2" );
            this._radIndStage2.Name = "_radIndStage2";
            this._radIndStage2.CheckedChanged += new System.EventHandler( this.Event_RadIndStage_CheckedChanged );
            //
            // _grpStage
            //
            this._grpStage.Controls.Add( this._radIndStage3 );
            this._grpStage.Controls.Add( this._radIndStage2 );
            this._grpStage.Controls.Add( this._radIndStage1 );
            this._grpStage.Controls.Add( this._radIndStage0 );
            resources.ApplyResources( this._grpStage, "_grpStage" );
            this._grpStage.Name = "_grpStage";
            this._grpStage.TabStop = false;
            //
            // _radIndStage3
            //
            resources.ApplyResources( this._radIndStage3, "_radIndStage3" );
            this._radIndStage3.Name = "_radIndStage3";
            this._radIndStage3.CheckedChanged += new System.EventHandler( this.Event_RadIndStage_CheckedChanged );
            //
            // _radIndStage0
            //
            resources.ApplyResources( this._radIndStage0, "_radIndStage0" );
            this._radIndStage0.Name = "_radIndStage0";
            this._radIndStage0.CheckedChanged += new System.EventHandler( this.Event_RadIndStage_CheckedChanged );
            //
            // _grpTexCoordScale
            //
            this._grpTexCoordScale.Controls.Add( this._cmbScaleT );
            this._grpTexCoordScale.Controls.Add( this._cmbScaleS );
            this._grpTexCoordScale.Controls.Add( this._lblScaleT );
            this._grpTexCoordScale.Controls.Add( this._lblScaleS );
            resources.ApplyResources( this._grpTexCoordScale, "_grpTexCoordScale" );
            this._grpTexCoordScale.Name = "_grpTexCoordScale";
            this._grpTexCoordScale.TabStop = false;
            //
            // _cmbScaleT
            //
            this._cmbScaleT.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            this._cmbScaleT.DropDownWidth = 288;
            resources.ApplyResources( this._cmbScaleT, "_cmbScaleT" );
            this._cmbScaleT.Name = "_cmbScaleT";
            this._cmbScaleT.SelectedItemData = null;
            this._cmbScaleT.SelectedIndexChanged += new System.EventHandler( this.Event_CmbScaleT_SelectedIndexChanged );
            //
            // _cmbScaleS
            //
            this._cmbScaleS.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            this._cmbScaleS.DropDownWidth = 288;
            resources.ApplyResources( this._cmbScaleS, "_cmbScaleS" );
            this._cmbScaleS.Name = "_cmbScaleS";
            this._cmbScaleS.SelectedItemData = null;
            this._cmbScaleS.SelectedIndexChanged += new System.EventHandler( this.Event_CmbScaleS_SelectedIndexChanged );
            //
            // _lblScaleT
            //
            resources.ApplyResources( this._lblScaleT, "_lblScaleT" );
            this._lblScaleT.Name = "_lblScaleT";
            //
            // _lblScaleS
            //
            resources.ApplyResources( this._lblScaleS, "_lblScaleS" );
            this._lblScaleS.Name = "_lblScaleS";
            //
            // _lblNotice
            //
            this._lblNotice.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            resources.ApplyResources( this._lblNotice, "_lblNotice" );
            this._lblNotice.Name = "_lblNotice";
            //
            // _grpTextureOrder
            //
            this._grpTextureOrder.Controls.Add( this._lblTextureOrderHint );
            this._grpTextureOrder.Controls.Add( this._lblTexMapImage );
            this._grpTextureOrder.Controls.Add( this._lblTexCoord );
            this._grpTextureOrder.Controls.Add( this._cmbTexMapImage );
            this._grpTextureOrder.Controls.Add( this._cmbTexCoord );
            resources.ApplyResources( this._grpTextureOrder, "_grpTextureOrder" );
            this._grpTextureOrder.Name = "_grpTextureOrder";
            this._grpTextureOrder.TabStop = false;
            //
            // _lblTextureOrderHint
            //
            this._lblTextureOrderHint.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            resources.ApplyResources( this._lblTextureOrderHint, "_lblTextureOrderHint" );
            this._lblTextureOrderHint.Name = "_lblTextureOrderHint";
            //
            // _lblTexMapImage
            //
            resources.ApplyResources( this._lblTexMapImage, "_lblTexMapImage" );
            this._lblTexMapImage.Name = "_lblTexMapImage";
            //
            // _lblTexCoord
            //
            resources.ApplyResources( this._lblTexCoord, "_lblTexCoord" );
            this._lblTexCoord.Name = "_lblTexCoord";
            //
            // _cmbTexMapImage
            //
            this._cmbTexMapImage.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            this._cmbTexMapImage.DropDownWidth = 288;
            resources.ApplyResources( this._cmbTexMapImage, "_cmbTexMapImage" );
            this._cmbTexMapImage.Name = "_cmbTexMapImage";
            this._cmbTexMapImage.SelectedItemData = null;
            //
            // _cmbTexCoord
            //
            this._cmbTexCoord.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            this._cmbTexCoord.DropDownWidth = 288;
            resources.ApplyResources( this._cmbTexCoord, "_cmbTexCoord" );
            this._cmbTexCoord.Name = "_cmbTexCoord";
            this._cmbTexCoord.SelectedItemData = null;
            this._cmbTexCoord.SelectedIndexChanged += new System.EventHandler( this.Event_CmbTexCoord_SelectedIndexChanged );
            //
            // _tbxNumStages
            //
            resources.ApplyResources( this._tbxNumStages, "_tbxNumStages" );
            this._tbxNumStages.MaxValue = 4;
            this._tbxNumStages.MinValue = 0;
            this._tbxNumStages.Name = "_tbxNumStages";
            this._tbxNumStages.ValueChanged += new System.EventHandler( this.Event_TbxNumStages_ValueChanged );
            //
            // _labNumStages
            //
            resources.ApplyResources( this._labNumStages, "_labNumStages" );
            this._labNumStages.Name = "_labNumStages";
            //
            // MaterialIndirectStagePage
            //
            this.Controls.Add( this._tbxNumStages );
            this.Controls.Add( this._labNumStages );
            this.Controls.Add( this._lblNotice );
            this.Controls.Add( this._grpTexCoordScale );
            this.Controls.Add( this._grpStage );
            this.Controls.Add( this._grpTextureOrder );
            this.Name = "MaterialIndirectStagePage";
            resources.ApplyResources( this, "$this" );
            this._grpStage.ResumeLayout( false );
            this._grpTexCoordScale.ResumeLayout( false );
            this._grpTexCoordScale.PerformLayout();
            this._grpTextureOrder.ResumeLayout( false );
            this._grpTextureOrder.PerformLayout();
            this.ResumeLayout( false );
            this.PerformLayout();

        }

        #endregion デザイナ生成コード


        /// <summary>
        /// 操作対象ステージ
        /// </summary>
        TexIndirectStage            _targetTexIndStage = null;
        int                         _stageNo = 0;

        ///
        UIRadioButton[]               _stageButtons = new UIRadioButton[TexIndirectStageList.NumTexIndirectStages];

        /// <summary>
        /// 操作対象ステージ
        /// </summary>
        TexIndirectStage  _TargetTexIndStage
        {
            set
            {
                if( _targetTexIndStage != value )
                {
                    _targetTexIndStage = value;
                    // UI 更新
                    this.UpdateProperty();
                }
            }

            get
            {
                return _targetTexIndStage;
            }
        }





        /// <summary>
        /// コンストラクタ
        /// </summary>
        public MaterialIndirectStagePage()
        {
            InitializeComponent();
        }

        /// <summary>
        /// インスタンス作成。
        /// </summary>
        public static ObjPropertyPage CreateInstance(object arg)
        {
            ObjPropertyPage page = new MaterialIndirectStagePage();
            return page;
        }

        /// <summary>
        /// プロパティ初期化。
        /// </summary>
        protected override void InitializeProperty()
        {
            TexIndirectStageList indStages = ActiveTarget.TexIndirectStageList;

            // 対象ステージ：ラジオボタン
            _radIndStage0.Tag = 0;
            _radIndStage1.Tag = 1;
            _radIndStage2.Tag = 2;
            _radIndStage3.Tag = 3;
            _radIndStage0.SetChecked( true );
            _stageButtons[0] = _radIndStage0;
            _stageButtons[1] = _radIndStage1;
            _stageButtons[2] = _radIndStage2;
            _stageButtons[3] = _radIndStage3;


            // テクスチャ画像
            _cmbTexMapImage.AddItem("PROP_MAT_TEV_STAGE_TEXORDER_NULL", -1, true);
            _cmbTexMapImage.AddItem("PROP_MAT_TEV_STAGE_TEXORDER_0",     0, true);
            _cmbTexMapImage.AddItem("PROP_MAT_TEV_STAGE_TEXORDER_1",     1, true);
            _cmbTexMapImage.AddItem("PROP_MAT_TEV_STAGE_TEXORDER_2",     2, true);
            _cmbTexMapImage.AddItem("PROP_MAT_TEV_STAGE_TEXORDER_3",     3, true);
            _cmbTexMapImage.AddItem("PROP_MAT_TEV_STAGE_TEXORDER_4",     4, true);
            _cmbTexMapImage.AddItem("PROP_MAT_TEV_STAGE_TEXORDER_5",     5, true);
            _cmbTexMapImage.AddItem("PROP_MAT_TEV_STAGE_TEXORDER_6",     6, true);
            _cmbTexMapImage.AddItem("PROP_MAT_TEV_STAGE_TEXORDER_7",     7, true);
            _cmbTexMapImage.SelectedIndexChanged +=new EventHandler(Event_CmbTexMapImage_SelectedIndexChanged);
            _cmbTexMapImage.DrawItem += new DrawItemEventHandler(Event_CmbTexMapImage_DrawItem);
            _cmbTexMapImage.SetSelectedIndex( 0 );

            // TexMapOrder
            _cmbTexCoord.AddItem("PROP_MAT_TEX_MAP_METHOD_UV0", 0, true);
            _cmbTexCoord.AddItem("PROP_MAT_TEX_MAP_METHOD_UV1", 1, true);
            _cmbTexCoord.AddItem("PROP_MAT_TEX_MAP_METHOD_UV2", 2, true);
            _cmbTexCoord.AddItem("PROP_MAT_TEX_MAP_METHOD_UV3", 3, true);
            _cmbTexCoord.AddItem("PROP_MAT_TEX_MAP_METHOD_UV4", 4, true);
            _cmbTexCoord.AddItem("PROP_MAT_TEX_MAP_METHOD_UV5", 5, true);
            _cmbTexCoord.AddItem("PROP_MAT_TEX_MAP_METHOD_UV6", 6, true);
            _cmbTexCoord.AddItem("PROP_MAT_TEX_MAP_METHOD_UV7", 7, true);
            _cmbTexCoord.SetSelectedIndex( 0 );
            _cmbTexCoord.DrawItem += OwnerDrawUtil.UIComboItemDrawHandler;

            // TexCoord Scale S
            _cmbScaleS.AddItem("PROP_MAT_IND_TEXCOORD_SCALE_S_1", AttrIndScale.Its1, true);
            _cmbScaleS.AddItem("PROP_MAT_IND_TEXCOORD_SCALE_S_2", AttrIndScale.Its2, true);
            _cmbScaleS.AddItem("PROP_MAT_IND_TEXCOORD_SCALE_S_4", AttrIndScale.Its4, true);
            _cmbScaleS.AddItem("PROP_MAT_IND_TEXCOORD_SCALE_S_8", AttrIndScale.Its8, true);
            _cmbScaleS.AddItem("PROP_MAT_IND_TEXCOORD_SCALE_S_16", AttrIndScale.Its16, true);
            _cmbScaleS.AddItem("PROP_MAT_IND_TEXCOORD_SCALE_S_32", AttrIndScale.Its32, true);
            _cmbScaleS.AddItem("PROP_MAT_IND_TEXCOORD_SCALE_S_64", AttrIndScale.Its64, true);
            _cmbScaleS.AddItem("PROP_MAT_IND_TEXCOORD_SCALE_S_128", AttrIndScale.Its128, true);
            _cmbScaleS.AddItem("PROP_MAT_IND_TEXCOORD_SCALE_S_256", AttrIndScale.Its256, true);
            _cmbScaleS.SetSelectedIndex( 0 );
            _cmbScaleS.DrawItem += OwnerDrawUtil.UIComboItemDrawHandler;


             // TexCoord Scale T
            _cmbScaleT.AddItem("PROP_MAT_IND_TEXCOORD_SCALE_T_1", AttrIndScale.Its1, true);
            _cmbScaleT.AddItem("PROP_MAT_IND_TEXCOORD_SCALE_T_2", AttrIndScale.Its2, true);
            _cmbScaleT.AddItem("PROP_MAT_IND_TEXCOORD_SCALE_T_4", AttrIndScale.Its4, true);
            _cmbScaleT.AddItem("PROP_MAT_IND_TEXCOORD_SCALE_T_8", AttrIndScale.Its8, true);
            _cmbScaleT.AddItem("PROP_MAT_IND_TEXCOORD_SCALE_T_16", AttrIndScale.Its16, true);
            _cmbScaleT.AddItem("PROP_MAT_IND_TEXCOORD_SCALE_T_32", AttrIndScale.Its32, true);
            _cmbScaleT.AddItem("PROP_MAT_IND_TEXCOORD_SCALE_T_64", AttrIndScale.Its64, true);
            _cmbScaleT.AddItem("PROP_MAT_IND_TEXCOORD_SCALE_T_128", AttrIndScale.Its128, true);
            _cmbScaleT.AddItem("PROP_MAT_IND_TEXCOORD_SCALE_T_256", AttrIndScale.Its256, true);
            _cmbScaleT.SetSelectedIndex( 0 );
            _cmbScaleT.DrawItem += OwnerDrawUtil.UIComboItemDrawHandler;
        }

        /// <summary>
        /// プロパティ更新。
        /// </summary>
        protected override void UpdateProperty()
        {
            TexIndirectStageList stages = this.ActiveTarget.TexIndirectStageList;

            // ステージ番号調整
            if ( _stageNo >= stages.NumStageUsed )
            {
                _stageNo = 0;
            }

            // 操作対象ステージ
            if( stages.NumStageUsed != 0 )
            {
                _targetTexIndStage =  ActiveTarget.TexIndirectStageList[_stageNo];
            }
            else
            {
                _targetTexIndStage = null;
            }

            //-----------------------------------------------------------------
            // ステージ選択
            //-----------------------------------------------------------------

            // ステージ数
            _tbxNumStages.SetValue( stages.NumStageUsed );

            // ステージ番号
            for (int i = 0; i < _stageButtons.Length; i++)
            {
                UIRadioButton button = _stageButtons[i];

                button.SetCheckedByTag( _stageNo );
                button.Enabled = i < stages.NumStageUsed;

                if ( i < stages.NumStageUsed )
                {
                    button.Font = LayoutEditor.AppMain.GuiFontBold;
                    if (i == _stageNo) { button.ForeColor = Color.Red;                }
                    else               { button.ForeColor = SystemColors.ControlText; }
                }
                else
                {
                    button.Font      = this.Font;
                    button.ForeColor = SystemColors.ControlText;
                }
            }

            // コンボボックスの設定。
            if( _TargetTexIndStage != null )
            {
                _cmbTexMapImage.Enabled = true;
                _cmbTexCoord.Enabled = true;
                _cmbScaleS.Enabled = true;
                _cmbScaleT.Enabled = true;

                _cmbTexMapImage.SetSelectedItemData( _TargetTexIndStage.tex_map );
                _cmbTexCoord.SetSelectedItemData( _TargetTexIndStage.tex_coord );
                _cmbScaleS.SetSelectedItemData( _TargetTexIndStage.scale_s );
                _cmbScaleT.SetSelectedItemData( _TargetTexIndStage.scale_t );
            }
            else
            {
                _cmbTexMapImage.Enabled = false;
                _cmbTexCoord.Enabled = false;
                _cmbScaleS.Enabled = false;
                _cmbScaleT.Enabled = false;

                _cmbTexMapImage.SelectedIndex = -1;
                _cmbTexCoord.SelectedIndex = -1;
                _cmbScaleS.SelectedIndex = -1;
                _cmbScaleT.SelectedIndex = -1;
            }

        }

        #region イベントハンドラ

        /// <summary>
        /// ステージ数：テキストボックス
        /// </summary>
        private void Event_TbxNumStages_ValueChanged(object sender, System.EventArgs e)
        {
            IntTextBox     tbx = sender as IntTextBox;

            int newNumStages     = tbx.Value;
            int currentNumStages = ActiveTarget.TexIndirectStageList.NumStageUsed;

            if( newNumStages != currentNumStages )
            {
                if( newNumStages < currentNumStages )
                {
                    _stageNo = 0;
                }
                ActiveTarget.TexIndirectStageList.NumStageUsed = newNumStages;
                NotifyPropertyChanged();
            }
        }

        /// <summary>
        /// 対象ステージチェックボックス
        /// </summary>
        private void Event_RadIndStage_CheckedChanged(object sender, System.EventArgs e)
        {
            RadioButton         rad            = sender   as RadioButton;
            int                 newStageIndex = (int)rad.Tag;

            // 番号変更
            if( _stageNo != newStageIndex )
            {
                _stageNo           = newStageIndex;
                _targetTexIndStage = ActiveTarget.TexIndirectStageList[_stageNo];
                NotifyPropertyChanged();
            }
        }

        /// <summary>
        /// テクスチャ画像：コンボボックス
        /// </summary>
        private void Event_CmbTexMapImage_SelectedIndexChanged(object sender, EventArgs e)
        {
            UIComboBox   cmb            = sender as UIComboBox;
            int          newTexImageIdx = (int)cmb.SelectedItemData;
            if( _targetTexIndStage.tex_map != newTexImageIdx )
            {
                _targetTexIndStage.tex_map = newTexImageIdx;
                NotifyPropertyChanged();
            }
        }

        /// <summary>
        /// テクスチャ座標：コンボボックス
        /// </summary>
        private void Event_CmbTexCoord_SelectedIndexChanged(object sender, System.EventArgs e)
        {
            UIComboBox cmb = sender as UIComboBox;
            int newTexCoord = (int)cmb.SelectedItemData;
            if( _targetTexIndStage.tex_coord != newTexCoord )
            {
                _targetTexIndStage.tex_coord = newTexCoord;
                NotifyPropertyChanged();
            }
        }

        /// <summary>
        /// テクスチャ座標スケールS：コンボボックス
        /// </summary>
        private void Event_CmbScaleS_SelectedIndexChanged(object sender, System.EventArgs e)
        {
            UIComboBox cmb = sender as UIComboBox;
            AttrIndScale     newTexCoordScale = (AttrIndScale)cmb.SelectedItemData;
            if( _targetTexIndStage.scale_s != newTexCoordScale )
            {
                _targetTexIndStage.scale_s = newTexCoordScale;
                NotifyPropertyChanged();
            }
        }

        /// <summary>
        /// テクスチャ座標スケールT：コンボボックス
        /// </summary>
        private void Event_CmbScaleT_SelectedIndexChanged(object sender, System.EventArgs e)
        {
            UIComboBox cmb = sender as UIComboBox;
            AttrIndScale     newTexCoordScale = (AttrIndScale)cmb.SelectedItemData;
            if( _targetTexIndStage.scale_t != newTexCoordScale )
            {
                _targetTexIndStage.scale_t = newTexCoordScale;
                NotifyPropertyChanged();
            }
        }


        #region CmbTexMapImage_DrawItem オーナー描画

        /// <summary>
        /// 画像を描画する
        /// </summary>
        void Event_CmbTexMapImage_DrawItem_DrawImage_( DrawItemEventArgs e, TexImage texImage )
        {
            Rectangle rect	= e.Bounds;
            rect.Inflate( -1, -1 );
            rect.Size	= new Size( rect.Height, rect.Height );
            if( texImage != null )
            {
                texImage.DrawColorImage( e.Graphics, rect, true );
                GraphicsUtil.DrawRectangle(e.Graphics, Pens.Black, rect);
            }
            else
            {
                // X印を描画
                e.Graphics.DrawLine( Pens.Gray, rect.X, rect.Y, rect.Right-1, rect.Bottom-1 );
                e.Graphics.DrawLine( Pens.Gray, rect.X, rect.Bottom-1, rect.Right-1, rect.Y );
                GraphicsUtil.DrawRectangle(e.Graphics, Pens.Gray, rect);
            }
        }

        /// <summary>
        /// 文字列を描画する
        /// </summary>
        void Event_CmbTexMapImage_DrawItem_DrawString_( DrawItemEventArgs e, TexImage texImage, string itemText  )
        {
            // テキスト
            using (StringFormat sf = new StringFormat())
            {
                Rectangle rect = new Rectangle( e.Bounds.X + e.Bounds.Height, e.Bounds.Y, e.Bounds.Width - e.Bounds.Height, e.Bounds.Height );
                sf.Alignment     = StringAlignment.Near;
                sf.LineAlignment = StringAlignment.Center;
                sf.Trimming      = StringTrimming.EllipsisCharacter;
                sf.FormatFlags  |= StringFormatFlags.NoWrap;

                Brush brush;
                if      (texImage == null && e.Index > 0)         { brush = Brushes.Gray;                }
                else if ((e.State & DrawItemState.Selected) != 0) { brush = SystemBrushes.HighlightText; }
                else                                              { brush = SystemBrushes.WindowText;    }

                if( texImage != null )
                {
                    itemText += " (";
                    itemText += texImage.Texture.Name;
                    itemText += ")";
                }
                e.Graphics.DrawString(itemText, e.Font, brush, rect, sf);
            }
        }

        /// <summary>
        ///
        /// </summary>
        void Event_CmbTexMapImage_DrawItem(object sender, DrawItemEventArgs e)
        {
            e.DrawBackground();

            if (e.Index >= 0)
            {
                UIListControlItem item     = (UIListControlItem)((ComboBox)sender).Items[e.Index];
                string            itemText = item.Text;
                int               itemData = (int)item.Data;

                // テクスチャイメージ
                TexImage texImage = this.ActiveTarget.TexMapList.SearchTexImageByTexMapID(itemData);

                // 描画処理
                Event_CmbTexMapImage_DrawItem_DrawImage_( e, texImage );

                // テキスト
                Event_CmbTexMapImage_DrawItem_DrawString_( e, texImage, itemText );
            }
            e.DrawFocusRectangle();
        }
        #endregion CmbTexMapImage_DrawItem オーナー描画

        #endregion イベントハンドラ




    }

}
