﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace LayoutEditor.src.Forms.ToolWindows.PropertyEditWindow.Material
{
    public partial class LoadMovieDlg : Form
    {
        string _defaultOutputDirectory;

        public LoadMovieDlg(string defaultOutputDirectory)
        {
            _defaultOutputDirectory = defaultOutputDirectory;

            InitializeComponent();
        }

        // 入力ファイル名を取得
        public string GetInputFileName()
        {
            return _tbxInputPath.Text;
        }

        // 出力ディレクトリ名を取得
        public string GetOutputDirName()
        {
            return _tbxOutputDir.Text;
        }

        // 動画の開始フレームを取得
        public int GetBeginFrame()
        {
            return _chkBeginFrameEnabled.Checked ? _tbxBeginFrame.Value : 0;
        }

        // 動画の終了フレームを取得
        public int GetEndFrame()
        {
            return _chkEndFrameEnabled.Checked ? _tbxEndFrame.Value : int.MaxValue;
        }

        // アニメーションの作成開始フレームを取得
        public int GetFirstFrameOfAnim()
        {
            int value = _tbxFirstFrameOfAnim.Value;
            if (value < 0)
            {
                value = 0;
            }
            return value;
        }

        // アニメーションのキー間隔を取得
        public int GetStepFrameOfAnim()
        {
            int value = _tbxStepFrameOfAnim.Value;
            if (value < 1)
            {
                value = 1;
            }
            return value;
        }

        // アルファが有効化どうかを取得
        public bool GetAlphaEnabled()
        {
            return _chkAlphaEnabled.Checked;
        }

        // テクスチャ名の連番の桁数の取得
        public int GetPaddingNum()
        {
            int value = _tbxPadding.Value;
            if (value < 1)
            {
                value = 1;
            }
            if (value > 10)
            {
                value = 10;
            }
            return value;
        }

        // アンダースコアの有無の取得
        public bool GetUnderscoreEnabled()
        {
            return _chkUnderscore.Checked;
        }

        // 入力ファイル名の選択
        private void _btnInputPath_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog = new OpenFileDialog();
            openFileDialog.Filter = "Movie files (*.*)|*.*";
            openFileDialog.RestoreDirectory = true;
            openFileDialog.Multiselect = false;
            if (openFileDialog.ShowDialog() == DialogResult.OK)
            {
                _tbxInputPath.Text = openFileDialog.FileName;
                if (_defaultOutputDirectory == null)
                {
                    _tbxOutputDir.Text = System.IO.Path.ChangeExtension(openFileDialog.FileName, null) + "_textures";
                }
            }
        }

        // 出力ディレクトリ名の選択
        private void _btnOutputDir_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog folderBrowserDialog = new FolderBrowserDialog();
            folderBrowserDialog.SelectedPath = _tbxOutputDir.Text;
            if (folderBrowserDialog.ShowDialog() == DialogResult.OK)
            {
                _tbxOutputDir.Text = folderBrowserDialog.SelectedPath;
            }
        }

        // 動画の開始フレームの指定のチェック変更
        private void _chkBeginFrameEnabled_CheckedChanged(object sender, EventArgs e)
        {
            _tbxBeginFrame.Enabled = _chkBeginFrameEnabled.Checked;
        }

        // 動画の終了フレームの指定のチェック変更
        private void _chkEndFrameEnabled_CheckedChanged(object sender, EventArgs e)
        {
            _tbxEndFrame.Enabled = _chkEndFrameEnabled.Checked;
        }

        // フォームのロード
        private void LoadMovieDlg_Load(object sender, EventArgs e)
        {
            if (_defaultOutputDirectory != null)
            {
                // デフォルトの出力ディレクトリが指定されている場合は設定する
                _tbxOutputDir.Text = _defaultOutputDirectory;
            }
        }
    }
}
