﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Windows.Forms;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.FragmentOperationControls
{
    using LECore.Structures;
    using LECore.Structures.Nsrif.Attributes;

    public partial class FragmentOperationCalcBlendPanel : UserControl
    {
        // 参照データ
        private PEBlend _refData = null;

        /// <summary>データ変更イベント。</summary>
        public event EventHandler DataChanged = null;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public FragmentOperationCalcBlendPanel()
        {
            InitializeComponent();
        }

        /// <summary>
        /// 参照データ。
        /// </summary>
        public PEBlend RefData
        {
            set { _refData = value; }
        }

        /// <summary>
        /// プロパティ初期化。
        /// </summary>
        public void InitializeProperty()
        {
            // srcFactor
            cmbSrcFactor.Items.Clear();
            cmbSrcFactor.AddItem("PROP_MAT_PE_BF_ZERO",        AttrBlendFactor.V0, true);
            cmbSrcFactor.AddItem("PROP_MAT_PE_BF_ONE",         AttrBlendFactor.V1_0, true);
            cmbSrcFactor.AddItem("PROP_MAT_PE_BF_DSTCOLOR",    AttrBlendFactor.DstClr, true);
            cmbSrcFactor.AddItem("PROP_MAT_PE_BF_INVDSTCOLOR", AttrBlendFactor.InvDstClr, true);
            cmbSrcFactor.AddItem("PROP_MAT_PE_BF_DSTALPHA", AttrBlendFactor.DstAlpha, true);
            cmbSrcFactor.AddItem("PROP_MAT_PE_BF_INVDSTALPHA", AttrBlendFactor.InvDstAlpha, true);
            cmbSrcFactor.AddItem("PROP_MAT_PE_BF_SRCCOLOR", AttrBlendFactor.SrcClr, true);
            cmbSrcFactor.AddItem("PROP_MAT_PE_BF_INVSRCCOLOR", AttrBlendFactor.InvSrcClr, true);
            cmbSrcFactor.AddItem("PROP_MAT_PE_BF_SRCALPHA", AttrBlendFactor.SrcAlpha, true);
            cmbSrcFactor.AddItem("PROP_MAT_PE_BF_INVSRCALPHA", AttrBlendFactor.InvSrcAlpha, true);
            cmbSrcFactor.SelectedIndexChanged += Event_CmbSrcFactor_SelectedIndexChanged;

            // dstFactor
            cmbDstFactor.Items.Clear();
            cmbDstFactor.AddItem("PROP_MAT_PE_BF_ZERO", AttrBlendFactor.V0, true);
            cmbDstFactor.AddItem("PROP_MAT_PE_BF_ONE", AttrBlendFactor.V1_0, true);
            cmbDstFactor.AddItem("PROP_MAT_PE_BF_DSTCOLOR", AttrBlendFactor.DstClr, true);
            cmbDstFactor.AddItem("PROP_MAT_PE_BF_INVDSTCOLOR", AttrBlendFactor.InvDstClr, true);
            cmbDstFactor.AddItem("PROP_MAT_PE_BF_DSTALPHA", AttrBlendFactor.DstAlpha, true);
            cmbDstFactor.AddItem("PROP_MAT_PE_BF_INVDSTALPHA", AttrBlendFactor.InvDstAlpha, true);
            cmbDstFactor.AddItem("PROP_MAT_PE_BF_SRCCOLOR", AttrBlendFactor.SrcClr, true);
            cmbDstFactor.AddItem("PROP_MAT_PE_BF_INVSRCCOLOR", AttrBlendFactor.InvSrcClr, true);
            cmbDstFactor.AddItem("PROP_MAT_PE_BF_SRCALPHA", AttrBlendFactor.SrcAlpha, true);
            cmbDstFactor.AddItem("PROP_MAT_PE_BF_INVSRCALPHA", AttrBlendFactor.InvSrcAlpha, true);
            cmbDstFactor.SelectedIndexChanged += Event_CmbDstFactor_SelectedIndexChanged;

            //operation
            cmbOperation.Items.Clear();
            cmbOperation.AddItem("PROP_MAT_PE_BF_ADD",    AttrBlendOp.Add, true);
            cmbOperation.AddItem("PROP_MAT_PE_BF_SUB",    AttrBlendOp.Subtract, true);
            cmbOperation.AddItem("PROP_MAT_PE_BF_INVSUB", AttrBlendOp.ReverseSubtract, true);
            cmbOperation.AddItem("PROP_MAT_PE_BF_SELECTMIN", AttrBlendOp.SelectMin, true);
            cmbOperation.AddItem("PROP_MAT_PE_BF_SELECTMAX", AttrBlendOp.SelectMax, true);
            cmbOperation.SelectedIndexChanged += Event_CmbOperation_SelectedIndexChanged;
        }

        /// <summary>
        /// プロパティ更新。
        /// </summary>
        public void UpdateProperty()
        {
            cmbSrcFactor.SetSelectedItemData(_refData.SrcFactor);
            cmbDstFactor.SetSelectedItemData(_refData.DstFactor);
            cmbOperation.SetSelectedItemData(_refData.BlendOp);
        }

        /// <summary>
        /// データ変更ハンドラ。
        /// </summary>
        private void OnDataChanged(EventArgs e)
        {
            if (this.DataChanged != null)
            {
                this.DataChanged(this, e);
            }
        }

        #region イベントハンドラ
        // srcFactor
        private void Event_CmbSrcFactor_SelectedIndexChanged(object sender, EventArgs e)
        {
            _refData.SrcFactor = (AttrBlendFactor)cmbSrcFactor.SelectedItemData;
            OnDataChanged(EventArgs.Empty);
        }

        // dstFactor
        private void Event_CmbDstFactor_SelectedIndexChanged(object sender, EventArgs e)
        {
            _refData.DstFactor = (AttrBlendFactor)cmbDstFactor.SelectedItemData;
            OnDataChanged(EventArgs.Empty);
        }

        // operation
        private void Event_CmbOperation_SelectedIndexChanged(object sender, EventArgs e)
        {
            _refData.BlendOp = (AttrBlendOp)cmbOperation.SelectedItemData;
            OnDataChanged(EventArgs.Empty);
        }
        #endregion
    }
}
