﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.ComponentModel;
using System.Collections;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Imaging;
using System.Windows.Forms;
using System.Windows.Forms.Design;




using LECore.Win32;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.ColorControls
{
    using Utility;
    /// <summary>
    /// シェーディングボックスクラス。
    /// </summary>
    public class ShadingBox : Control
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public ShadingBox()
        {
            base.SetStyle(ControlStyles.Opaque, true);
            base.SetStyle(ControlStyles.DoubleBuffer, true);
            base.SetStyle(ControlStyles.Selectable, false);
            base.TabStop = false;
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override CreateParams CreateParams
        {
            get
            {
                CreateParams cp = base.CreateParams;
                cp.ExStyle |= LECore.Win32.WS_EX.WS_EX_STATICEDGE;
                return cp;
            }
        }
    }

    /// <summary>
    /// カラーシェーディングボックス。
    /// </summary>
    public sealed class ColorShadingBox : ShadingBox
    {
        private MaterialColorShadingInfo _shadingInfo = null;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public ColorShadingBox()
        {
        }

        /// <summary>
        /// シェーディング情報。
        /// </summary>
        public MaterialColorShadingInfo ShadingInfo
        {
            get { return _shadingInfo; }
            set
            {
                _shadingInfo = value;
                Invalidate();
            }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void OnPaint(PaintEventArgs e)
        {
            // 背景
            e.Graphics.Clear(SystemColors.Control);

            // 描画
            if (_shadingInfo != null)
            {
                MaterialColorShader.DrawColor(e.Graphics, this.ClientRectangle, _shadingInfo);
            }
            base.OnPaint(e);
        }
    }

    /// <summary>
    /// アルファシェーディングボックス。
    /// </summary>
    public sealed class AlphaShadingBox : ShadingBox
    {
        private MaterialAlphaShadingInfo _shadingInfo = null;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public AlphaShadingBox()
        {
        }

        /// <summary>
        /// シェーディング情報。
        /// </summary>
        public MaterialAlphaShadingInfo ShadingInfo
        {
            get { return _shadingInfo; }
            set
            {
                _shadingInfo = value;
                Invalidate();
            }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void OnPaint(PaintEventArgs e)
        {
            // 背景
            e.Graphics.Clear(SystemColors.Control);

            // 描画
            if (_shadingInfo != null)
            {
                MaterialColorShader.DrawAlpha(e.Graphics, this.ClientRectangle, _shadingInfo);
            }
            base.OnPaint(e);
        }
    }
}
