﻿using LayoutEditor.Controls;
using LayoutEditor.Utility;
using LECore.Manipulator;
using LECore.Structures;
using LECore.Win32;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace LayoutEditor.Forms.ToolWindows.LayoutSettingWindow
{
    public partial class LayoutSettingWindow : LEToolWindow
    {
        private string defaultTitle;
        public LayoutSettingWindow()
        {
            InitializeComponent();
            defaultTitle = Text;
        }

        protected override void OnResize(EventArgs e)
        {
            if (layoutSettingPanel != null)
            {
                layoutSettingPanel.SetCalculationPageSize();
            }
            base.OnResize(e);
        }

        public override void OnSceneModifyHandler(object sender, LECore.Structures.SceneModifyEventArgs e)
        {
            switch (e.Target)
            {
                case SceneModifyEventArgs.Kind.CurrentSubSceneChanged:
                    layoutSettingPanel.UpdateProperty();
                    if (LECore.LayoutEditorCore.Scene.CurrentISubScene == null)
                    {
                        Text = defaultTitle;
                    }
                    break;
                case SceneModifyEventArgs.Kind.SubScenePropertyModify:
                    layoutSettingPanel.UpdateProperty();
                    break;
            }
            base.OnSceneModifyHandler(sender, e);
        }

        public override Keys CustomShortcut
        {
            get
            {
                return Keys.Alt | Keys.F6;
            }
        }

        public override string LEWindowName
        {
            get
            {
                return defaultTitle;
            }
        }

        /// <summary>
        /// 名前の更新
        /// </summary>
        public void UpdateLayoutFilePath(LayoutWindow.LayoutWindow.TargetSubSceneSaveState state)
        {
            if (state != null && state.ISubScene == LECore.LayoutEditorCore.Scene.CurrentISubScene)
            {
                var fileName = state.LastSavedFileName;
                if (fileName != null)
                {
                    Text = defaultTitle + " - " + fileName;
                }
                else
                {
                    Text = defaultTitle;
                }
            }
            else if (LECore.LayoutEditorCore.Scene.CurrentISubScene == null)
            {
                Text = defaultTitle;
            }
        }

    }
}
