﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using LayoutEditor.Utility;
using LayoutEditor.Controls;
using LECore.Win32;

namespace LayoutEditor.Forms.ToolWindows.LayoutSettingWindow
{
    public partial class LayoutSettingPanel : UserControl
    {
        public LayoutSettingPanel()
        {
            InitializeComponent();

            // デザインモード時にスタティックの何かにアクセスして例外になる模様
            if (!DesignMode)
            {
                var commentNode = new CategoryNode
                {
                    Text = StringResMgr.Get("LAYOUTSETTING_COMMENT"),
                    CreatePage = () => new CommentPage(),
                };
                tvwCategory.Nodes.Add(commentNode);

                var envNode = new CategoryNode
                {
                    Text = StringResMgr.Get("LAYOUTSETTING_ENVIRONMNET"),
                    CreatePage = () => new EnvironmentPage(),
                };
                tvwCategory.Nodes.Add(envNode);

                var userDataNode = new CategoryNode
                {
                    Text = StringResMgr.Get("LAYOUTSETTING_USERDATA"),
                    CreatePage = () => new UserDataPage(),
                };
                tvwCategory.Nodes.Add(userDataNode);

                // 明示的に設定しないと設定されないままになることがある
                tvwCategory.SelectedNode = commentNode;
            }
        }

        private void SetActiveCategory(CategoryNode categoryNode)
        {
            var page = categoryNode.Page;
            if (page == null)
            {
                // 作成が重いのでウェイト表示...
                using (WaitCursor wait = new WaitCursor())
                {
                    page = categoryNode.CreatePage();
                }

                page.Visible = false;
                page.OwnerToolWindow = this.Owner;
                page.Parent = uiSplitContainer1.Panel2;

                page.DefaultPageSize = page.Size;
                categoryNode.Page = page;
            }

            if (ActivePage == null)
            {
                ActivePage = page;
                ActivePage.Visible = true;
            }
            else if (ActivePage != null)
            {
                page.Visible = true;
                ActivePage.Visible = false;
                ActivePage = page;
            }

            // TODO: Active になるごとに必要か？
            new MessageForwarder(ActivePage, WM.WM_MOUSEWHEEL);

            SetCalculationPageSize();

            // 位置が狂うときがあるので明示的に位置ゼロを設定する。
            page.Location = Point.Empty;

            // 内容の更新
            UpdateProperty();

        }


        private void tvwCategory_AfterSelect(object sender, TreeViewEventArgs e)
        {
            SetActiveCategory(e.Node as CategoryNode);
        }



        public void UpdateProperty()
        {
            if (ActivePage != null)
            {
                ActivePage.UpdateProperty();
            }
        }

        public LEToolWindow Owner { get; set; }

        public void SetCalculationPageSize()
        {
            if (ActivePage == null || !ActivePage.Sizable)
                return;

            Size size = this.Owner.ClientSize;
            int x = size.Width - 12, y = size.Height - 16;
            for (Control parent = ActivePage; parent != null && parent != this.Owner; parent = parent.Parent)
            {
                x -= parent.Location.X;
                y -= parent.Location.Y;
            }
            DockStyle style = DockStyle.Fill;
            if (ActivePage.DefaultPageSize.Width > x)
            {
                y -= SystemInformation.HorizontalScrollBarHeight;
            }
            if (ActivePage.DefaultPageSize.Height > y)
            {
                x -= SystemInformation.VerticalScrollBarWidth;
            }
            if (ActivePage.DefaultPageSize.Width > x)
            {
                style = DockStyle.Left;
            }
            if (ActivePage.DefaultPageSize.Height > y)
            {
                style = (style == DockStyle.Fill) ? DockStyle.Top : DockStyle.None;
            }
            this.ActivePage.Dock = style;
        }

        LayoutSettingPage ActivePage { get; set; }

        internal class CategoryNode : TreeNode
        {
            public LayoutSettingPage Page { get; set; }
            public Func<LayoutSettingPage> CreatePage;

        }
    }
}
