﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using LECore.Manipulator;

namespace LayoutEditor.Forms.ToolWindows.LayoutSettingWindow
{
    public partial class CommentPage : LayoutSettingPage
    {
        public CommentPage()
        {
            InitializeComponent();
        }

        private DocumentHeaderManipulator documentHeaderManipulator = new DocumentHeaderManipulator();
        internal override void UpdateProperty()
        {
            var subScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
            if (subScene == null)
            {
                this.Enabled = false;
                return;
            }
            else
            {
                this.Enabled = true;
            }

            // コメント
            documentHeaderManipulator.BindTarget(LECore.LayoutEditorCore.Scene.CurrentISubScene.DocumentHeader);

            // 改行は内部では \n で扱う
            tbxComment.Value = LECore.LayoutEditorCore.Scene.CurrentISubScene.DocumentHeader.Comment.Replace("\n", "\r\n");
        }

        private void tbxComment_ValueChanged(object sender, EventArgs e)
        {
            // 改行は内部では \n で扱う
            documentHeaderManipulator.Comment = tbxComment.Value.Replace("\r\n", "\n");
        }
    }
}
