﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;

namespace LayoutEditor.Forms.ToolWindows.AnimShareWindow
{
    using LECore.Structures;
    using LECore.Manipulator;

    /// <summary>
    /// シーン中のペインの表示状態を保存するクラス
    /// </summary>
    class SubScenePaneHiddenState
    {
        /// <summary>
        /// 個々のペインの状態を保存するクラス
        /// </summary>
        struct PaneHiddenState
        {
            public readonly IPane _pane;
            public readonly bool _hiddenState;

            public PaneHiddenState( IPane pane, bool hiddenState )
            {
                _pane = pane;
                _hiddenState = hiddenState;
            }
        }

        ISubScene _subScene;
        List<PaneHiddenState> _paneHiddenStateMap = new List<PaneHiddenState>();

        /// <summary>
        /// 状態が保存されているかどうか取得します。
        /// </summary>
        public bool Empty
        {
            get { return _paneHiddenStateMap.Count == 0 && _subScene == null; }
        }

        /// <summary>
        /// 状態を保存します。
        /// </summary>
        public void StoreState( ISubScene subScene )
        {
            Debug.Assert( Empty );

            _subScene = subScene;

            // 状態を保存する
            foreach( IPane pane in subScene.IPaneArray )
            {
                _paneHiddenStateMap.Add( new PaneHiddenState( pane, pane.Hidden ) );
            }
        }

        /// <summary>
        /// 保存された状態を復元します。
        /// </summary>
        public void RestoreState()
        {
            if( Empty )
            {
                Debug.Assert( false );
                return;
            }

            ISubScene subScene = _subScene;
            subScene.BeginMassiveModify();

            PaneManipulator paneMnp = new PaneManipulator();
            foreach( PaneHiddenState state in _paneHiddenStateMap )
            {
                paneMnp.BindTarget( state._pane );
                paneMnp.Hidden = state._hiddenState;
            }

            _paneHiddenStateMap.Clear();
            _subScene = null;

            subScene.EndMassiveModify();

        }
    }
}
