﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using LayoutEditor.Forms.ToolWindows.AnimSectionTagWindow;

namespace LayoutEditor.Forms.ToolWindows.AnimSectionTagWindow
{
    using LECore.Structures;
    using LECore.Structures.LECoreInterface;

    /// <summary>
    /// 新規作成ダイアログ
    /// </summary>
    public partial class AnimSectionAddDlg : Form
    {
        readonly IAnimFrameSectionSet _animFrameSectionSet = null;

        /// <summary>
        /// 基本情報パネルを取得します。
        /// </summary>
        public AnimSectionBasicPanel AnimSectionBasicPanel
        {
            get { return _pnlAnimSectionBasic; }
        }

        /// <summary>
        /// コンストラクタ(デザイナ用)
        /// </summary>
        public AnimSectionAddDlg() : this( null ){}

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public AnimSectionAddDlg( IAnimFrameSectionSet animFrameSectionSet )
        {
            InitializeComponent();

            _animFrameSectionSet = animFrameSectionSet;

            _pnlAnimSectionBasic.TragetName =
                _animFrameSectionSet.GetUniqueFrameSectionName(
                AnimFrameSectionSetHelper.DefaultFrameSectionName );

            _pnlAnimSectionBasic.OnChanged += new EventHandler(
                Event_PnlAnimSectionBasic_OnChanged );

            UpdateProperty_();
        }


        /// <summary>
        /// GUIの更新
        /// パラメータの妥当性をチェックして、OKボタンの状態を変更します。
        /// </summary>
        void UpdateProperty_()
        {
            bool bValid = false;
            if( _animFrameSectionSet != null )
            {
                string tagName = _pnlAnimSectionBasic.TragetName;

                bValid = AnimFrameSectionSetHelper.CheckFrameSectionNameValid(tagName) &&
                          !_animFrameSectionSet.CheckExistsByOutputBinaryName(tagName) &&
                          AnimFrameSectionSetHelper.CheckFrameRangeValid(
                            AnimationLoopType.OneTime, _pnlAnimSectionBasic.StartFrame, _pnlAnimSectionBasic.EndFrame);
            }
            _btnOK.Enabled = bValid;
            _pnlAnimSectionBasic.UpdateFrameEditBox();

        }

        /// <summary>
        /// GUI更新ハンドラ
        /// </summary>
        void Event_PnlAnimSectionBasic_OnChanged( object sender, EventArgs e )
        {
            UpdateProperty_();
        }

        /// <summary>
        /// OKボタンクリック
        /// </summary>
        private void Event_BtnOK_Click( object sender, EventArgs e )
        {
            DialogResult = DialogResult.OK;
        }

        /// <summary>
        /// キャンセルボタンクリック
        /// </summary>
        private void Event_BtnCancel_Click( object sender, EventArgs e )
        {
            DialogResult = DialogResult.Cancel;
        }
    }
}
