﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace LayoutEditor.Forms.Dialogs
{
    using LECore.Structures;
    using LECore.Structures.Core;
    using LECore.Manipulator;
    using LayoutEditor.Structures.SerializableObject;
    using UINumericUpDown2 = Controls.UINumericUpDown;

    /// <summary>
    /// 時間スケール調整ダイアログ
    /// </summary>
    class TimeScaleEditDlg : LEBaseDlg, ToolWindows.ILEDataSerializebleWindow
    {

        #region デザイナ生成コード
        private LayoutEditor.Controls.UIRadioButton _radAllFrames;
        private LayoutEditor.Controls.UIRadioButton _radSpecifiedFrames;
        private GroupBox _grpScaleSrcFrame;
        private GroupBox _grpScaleMethod;
        private LayoutEditor.Controls.UIRadioButton _radSpecifiedScale;
        private LayoutEditor.Controls.UIRadioButton _radSpecifiedDstBeginEnd;
        private LayoutEditor.Controls.UINumericUpDown _nudValueScale;
        private LayoutEditor.Controls.UINumericUpDown _nudValueOrigin;
        private LayoutEditor.Controls.UINumericUpDown _nudTimeScale;
        private LayoutEditor.Controls.UINumericUpDown _nudTimeOrigin;
        private Label _lblDstStart;
        private LayoutEditor.Controls.UINumericUpDown _nudDstStart;
        private LayoutEditor.Controls.UINumericUpDown _nudDstEnd;
        private Label _lblScaleOrigin1;
        private Label _lblDstEnd;
        private LayoutEditor.Controls.UICheckBox _chkApplyToSelectOnly;
        private Label _lblValue;
        private Label _lblTime;
        private Panel _pnlSpecifiedDstBeginEnd;
        private Panel _pnlSpecifiedScale;
        private Label _lblScaleOrigin2;
        private Panel _pnlSpecifiedSrcBeginEnd;
        private Label _lblSrcStart;
        private LayoutEditor.Controls.UINumericUpDown _nudSrcStart;
        private LayoutEditor.Controls.UINumericUpDown _nudSrcEnd;
        private Label _lblSrcEnd;
        private Button _btnSelectKey;
        private GroupBox _grpScaleSrc;
        private LayoutEditor.Controls.UIRadioButton _radScaleSrcAllLayout;
        private LayoutEditor.Controls.UIRadioButton _radScaleSrcCurrentCurve;
        private Button _btnApply;

        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(TimeScaleEditDlg));
            this._radAllFrames = new LayoutEditor.Controls.UIRadioButton();
            this._radSpecifiedFrames = new LayoutEditor.Controls.UIRadioButton();
            this._grpScaleSrcFrame = new System.Windows.Forms.GroupBox();
            this._btnSelectKey = new System.Windows.Forms.Button();
            this._pnlSpecifiedSrcBeginEnd = new System.Windows.Forms.Panel();
            this._lblSrcStart = new System.Windows.Forms.Label();
            this._nudSrcStart = new LayoutEditor.Controls.UINumericUpDown();
            this._nudSrcEnd = new LayoutEditor.Controls.UINumericUpDown();
            this._lblSrcEnd = new System.Windows.Forms.Label();
            this._chkApplyToSelectOnly = new LayoutEditor.Controls.UICheckBox();
            this._grpScaleMethod = new System.Windows.Forms.GroupBox();
            this._pnlSpecifiedDstBeginEnd = new System.Windows.Forms.Panel();
            this._nudDstStart = new LayoutEditor.Controls.UINumericUpDown();
            this._lblDstEnd = new System.Windows.Forms.Label();
            this._lblDstStart = new System.Windows.Forms.Label();
            this._nudDstEnd = new LayoutEditor.Controls.UINumericUpDown();
            this._pnlSpecifiedScale = new System.Windows.Forms.Panel();
            this._nudTimeScale = new LayoutEditor.Controls.UINumericUpDown();
            this._nudTimeOrigin = new LayoutEditor.Controls.UINumericUpDown();
            this._nudValueOrigin = new LayoutEditor.Controls.UINumericUpDown();
            this._nudValueScale = new LayoutEditor.Controls.UINumericUpDown();
            this._lblValue = new System.Windows.Forms.Label();
            this._lblScaleOrigin1 = new System.Windows.Forms.Label();
            this._lblScaleOrigin2 = new System.Windows.Forms.Label();
            this._lblTime = new System.Windows.Forms.Label();
            this._radSpecifiedDstBeginEnd = new LayoutEditor.Controls.UIRadioButton();
            this._radSpecifiedScale = new LayoutEditor.Controls.UIRadioButton();
            this._btnApply = new System.Windows.Forms.Button();
            this._grpScaleSrc = new System.Windows.Forms.GroupBox();
            this._radScaleSrcCurrentCurve = new LayoutEditor.Controls.UIRadioButton();
            this._radScaleSrcAllLayout = new LayoutEditor.Controls.UIRadioButton();
            this._grpScaleSrcFrame.SuspendLayout();
            this._pnlSpecifiedSrcBeginEnd.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._nudSrcStart)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this._nudSrcEnd)).BeginInit();
            this._grpScaleMethod.SuspendLayout();
            this._pnlSpecifiedDstBeginEnd.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._nudDstStart)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this._nudDstEnd)).BeginInit();
            this._pnlSpecifiedScale.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._nudTimeScale)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this._nudTimeOrigin)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this._nudValueOrigin)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this._nudValueScale)).BeginInit();
            this._grpScaleSrc.SuspendLayout();
            this.SuspendLayout();
            //
            // _radAllFrames
            //
            resources.ApplyResources(this._radAllFrames, "_radAllFrames");
            this._radAllFrames.Checked = true;
            this._radAllFrames.Name = "_radAllFrames";
            this._radAllFrames.TabStop = true;
            this._radAllFrames.UseVisualStyleBackColor = true;
            this._radAllFrames.CheckedChanged += new System.EventHandler(this.Event_Rad_CheckedChanged);
            //
            // _radSpecifiedFrames
            //
            resources.ApplyResources(this._radSpecifiedFrames, "_radSpecifiedFrames");
            this._radSpecifiedFrames.Name = "_radSpecifiedFrames";
            this._radSpecifiedFrames.TabStop = true;
            this._radSpecifiedFrames.UseVisualStyleBackColor = true;
            //
            // _grpScaleSrcFrame
            //
            this._grpScaleSrcFrame.Controls.Add(this._btnSelectKey);
            this._grpScaleSrcFrame.Controls.Add(this._pnlSpecifiedSrcBeginEnd);
            this._grpScaleSrcFrame.Controls.Add(this._radSpecifiedFrames);
            this._grpScaleSrcFrame.Controls.Add(this._radAllFrames);
            resources.ApplyResources(this._grpScaleSrcFrame, "_grpScaleSrcFrame");
            this._grpScaleSrcFrame.Name = "_grpScaleSrcFrame";
            this._grpScaleSrcFrame.TabStop = false;
            //
            // _btnSelectKey
            //
            resources.ApplyResources(this._btnSelectKey, "_btnSelectKey");
            this._btnSelectKey.Name = "_btnSelectKey";
            this._btnSelectKey.UseVisualStyleBackColor = true;
            this._btnSelectKey.Click += new System.EventHandler(this.Event_BtnSelectKey_Click);
            //
            // _pnlSpecifiedSrcBeginEnd
            //
            this._pnlSpecifiedSrcBeginEnd.Controls.Add(this._lblSrcStart);
            this._pnlSpecifiedSrcBeginEnd.Controls.Add(this._nudSrcStart);
            this._pnlSpecifiedSrcBeginEnd.Controls.Add(this._nudSrcEnd);
            this._pnlSpecifiedSrcBeginEnd.Controls.Add(this._lblSrcEnd);
            resources.ApplyResources(this._pnlSpecifiedSrcBeginEnd, "_pnlSpecifiedSrcBeginEnd");
            this._pnlSpecifiedSrcBeginEnd.Name = "_pnlSpecifiedSrcBeginEnd";
            //
            // _lblSrcStart
            //
            resources.ApplyResources(this._lblSrcStart, "_lblSrcStart");
            this._lblSrcStart.Name = "_lblSrcStart";
            //
            // _nudSrcStart
            //
            resources.ApplyResources(this._nudSrcStart, "_nudSrcStart");
            this._nudSrcStart.Minimum = new decimal(new int[] {
            99999,
            0,
            0,
            -2147483648});
            this._nudSrcStart.Name = "_nudSrcStart";
            this._nudSrcStart.ValueChanged += new System.EventHandler(this.Event_Nud_ValueChanged);
            //
            // _nudSrcEnd
            //
            resources.ApplyResources(this._nudSrcEnd, "_nudSrcEnd");
            this._nudSrcEnd.Maximum = new decimal(new int[] {
            99999,
            0,
            0,
            0});
            this._nudSrcEnd.Minimum = new decimal(new int[] {
            99999,
            0,
            0,
            -2147483648});
            this._nudSrcEnd.Name = "_nudSrcEnd";
            this._nudSrcEnd.ValueChanged += new System.EventHandler(this.Event_Nud_ValueChanged);
            //
            // _lblSrcEnd
            //
            resources.ApplyResources(this._lblSrcEnd, "_lblSrcEnd");
            this._lblSrcEnd.Name = "_lblSrcEnd";
            //
            // _chkApplyToSelectOnly
            //
            resources.ApplyResources(this._chkApplyToSelectOnly, "_chkApplyToSelectOnly");
            this._chkApplyToSelectOnly.Name = "_chkApplyToSelectOnly";
            this._chkApplyToSelectOnly.UseVisualStyleBackColor = true;
            //
            // _grpScaleMethod
            //
            this._grpScaleMethod.Controls.Add(this._pnlSpecifiedDstBeginEnd);
            this._grpScaleMethod.Controls.Add(this._chkApplyToSelectOnly);
            this._grpScaleMethod.Controls.Add(this._pnlSpecifiedScale);
            this._grpScaleMethod.Controls.Add(this._radSpecifiedDstBeginEnd);
            this._grpScaleMethod.Controls.Add(this._radSpecifiedScale);
            resources.ApplyResources(this._grpScaleMethod, "_grpScaleMethod");
            this._grpScaleMethod.Name = "_grpScaleMethod";
            this._grpScaleMethod.TabStop = false;
            //
            // _pnlSpecifiedDstBeginEnd
            //
            this._pnlSpecifiedDstBeginEnd.Controls.Add(this._nudDstStart);
            this._pnlSpecifiedDstBeginEnd.Controls.Add(this._lblDstEnd);
            this._pnlSpecifiedDstBeginEnd.Controls.Add(this._lblDstStart);
            this._pnlSpecifiedDstBeginEnd.Controls.Add(this._nudDstEnd);
            resources.ApplyResources(this._pnlSpecifiedDstBeginEnd, "_pnlSpecifiedDstBeginEnd");
            this._pnlSpecifiedDstBeginEnd.Name = "_pnlSpecifiedDstBeginEnd";
            //
            // _nudDstStart
            //
            resources.ApplyResources(this._nudDstStart, "_nudDstStart");
            this._nudDstStart.Minimum = new decimal(new int[] {
            99999,
            0,
            0,
            -2147483648});
            this._nudDstStart.Name = "_nudDstStart";
            this._nudDstStart.ValueChanged += new System.EventHandler(this.Event_Nud_ValueChanged);
            //
            // _lblDstEnd
            //
            resources.ApplyResources(this._lblDstEnd, "_lblDstEnd");
            this._lblDstEnd.Name = "_lblDstEnd";
            //
            // _lblDstStart
            //
            resources.ApplyResources(this._lblDstStart, "_lblDstStart");
            this._lblDstStart.Name = "_lblDstStart";
            //
            // _nudDstEnd
            //
            resources.ApplyResources(this._nudDstEnd, "_nudDstEnd");
            this._nudDstEnd.Maximum = new decimal(new int[] {
            99999,
            0,
            0,
            0});
            this._nudDstEnd.Minimum = new decimal(new int[] {
            99999,
            0,
            0,
            -2147483648});
            this._nudDstEnd.Name = "_nudDstEnd";
            this._nudDstEnd.ValueChanged += new System.EventHandler(this.Event_Nud_ValueChanged);
            //
            // _pnlSpecifiedScale
            //
            this._pnlSpecifiedScale.Controls.Add(this._nudTimeScale);
            this._pnlSpecifiedScale.Controls.Add(this._nudTimeOrigin);
            this._pnlSpecifiedScale.Controls.Add(this._nudValueOrigin);
            this._pnlSpecifiedScale.Controls.Add(this._nudValueScale);
            this._pnlSpecifiedScale.Controls.Add(this._lblValue);
            this._pnlSpecifiedScale.Controls.Add(this._lblScaleOrigin1);
            this._pnlSpecifiedScale.Controls.Add(this._lblScaleOrigin2);
            this._pnlSpecifiedScale.Controls.Add(this._lblTime);
            resources.ApplyResources(this._pnlSpecifiedScale, "_pnlSpecifiedScale");
            this._pnlSpecifiedScale.Name = "_pnlSpecifiedScale";
            //
            // _nudTimeScale
            //
            this._nudTimeScale.DecimalPlaces = 2;
            this._nudTimeScale.Increment = new decimal(new int[] {
            1,
            0,
            0,
            65536});
            resources.ApplyResources(this._nudTimeScale, "_nudTimeScale");
            this._nudTimeScale.Maximum = new decimal(new int[] {
            10000,
            0,
            0,
            0});
            this._nudTimeScale.Minimum = new decimal(new int[] {
            10000,
            0,
            0,
            -2147483648});
            this._nudTimeScale.Name = "_nudTimeScale";
            this._nudTimeScale.Value = new decimal(new int[] {
            10,
            0,
            0,
            65536});
            this._nudTimeScale.ValueChanged += new System.EventHandler(this.Event_Nud_ValueChanged);
            //
            // _nudTimeOrigin
            //
            this._nudTimeOrigin.DecimalPlaces = 2;
            resources.ApplyResources(this._nudTimeOrigin, "_nudTimeOrigin");
            this._nudTimeOrigin.Maximum = new decimal(new int[] {
            10000,
            0,
            0,
            0});
            this._nudTimeOrigin.Minimum = new decimal(new int[] {
            10000,
            0,
            0,
            -2147483648});
            this._nudTimeOrigin.Name = "_nudTimeOrigin";
            this._nudTimeOrigin.ValueChanged += new System.EventHandler(this.Event_Nud_ValueChanged);
            //
            // _nudValueOrigin
            //
            this._nudValueOrigin.DecimalPlaces = 2;
            resources.ApplyResources(this._nudValueOrigin, "_nudValueOrigin");
            this._nudValueOrigin.Maximum = new decimal(new int[] {
            10000,
            0,
            0,
            0});
            this._nudValueOrigin.Minimum = new decimal(new int[] {
            10000,
            0,
            0,
            -2147483648});
            this._nudValueOrigin.Name = "_nudValueOrigin";
            this._nudValueOrigin.ValueChanged += new System.EventHandler(this.Event_Nud_ValueChanged);
            //
            // _nudValueScale
            //
            this._nudValueScale.DecimalPlaces = 2;
            this._nudValueScale.Increment = new decimal(new int[] {
            1,
            0,
            0,
            65536});
            resources.ApplyResources(this._nudValueScale, "_nudValueScale");
            this._nudValueScale.Maximum = new decimal(new int[] {
            10000,
            0,
            0,
            0});
            this._nudValueScale.Minimum = new decimal(new int[] {
            10000,
            0,
            0,
            -2147483648});
            this._nudValueScale.Name = "_nudValueScale";
            this._nudValueScale.Value = new decimal(new int[] {
            10,
            0,
            0,
            65536});
            this._nudValueScale.ValueChanged += new System.EventHandler(this.Event_Nud_ValueChanged);
            //
            // _lblValue
            //
            resources.ApplyResources(this._lblValue, "_lblValue");
            this._lblValue.Name = "_lblValue";
            //
            // _lblScaleOrigin1
            //
            resources.ApplyResources(this._lblScaleOrigin1, "_lblScaleOrigin1");
            this._lblScaleOrigin1.Name = "_lblScaleOrigin1";
            //
            // _lblScaleOrigin2
            //
            resources.ApplyResources(this._lblScaleOrigin2, "_lblScaleOrigin2");
            this._lblScaleOrigin2.Name = "_lblScaleOrigin2";
            //
            // _lblTime
            //
            resources.ApplyResources(this._lblTime, "_lblTime");
            this._lblTime.Name = "_lblTime";
            //
            // _radSpecifiedDstBeginEnd
            //
            resources.ApplyResources(this._radSpecifiedDstBeginEnd, "_radSpecifiedDstBeginEnd");
            this._radSpecifiedDstBeginEnd.Name = "_radSpecifiedDstBeginEnd";
            this._radSpecifiedDstBeginEnd.TabStop = true;
            this._radSpecifiedDstBeginEnd.UseVisualStyleBackColor = true;
            this._radSpecifiedDstBeginEnd.CheckedChanged += new System.EventHandler(this.Event_Rad_CheckedChanged);
            //
            // _radSpecifiedScale
            //
            resources.ApplyResources(this._radSpecifiedScale, "_radSpecifiedScale");
            this._radSpecifiedScale.Checked = true;
            this._radSpecifiedScale.Name = "_radSpecifiedScale";
            this._radSpecifiedScale.TabStop = true;
            this._radSpecifiedScale.UseVisualStyleBackColor = true;
            //
            // _btnApply
            //
            resources.ApplyResources(this._btnApply, "_btnApply");
            this._btnApply.Name = "_btnApply";
            this._btnApply.UseVisualStyleBackColor = true;
            this._btnApply.Click += new System.EventHandler(this.Event_BtnApply_Click);
            //
            // _grpScaleSrc
            //
            this._grpScaleSrc.Controls.Add(this._radScaleSrcCurrentCurve);
            this._grpScaleSrc.Controls.Add(this._radScaleSrcAllLayout);
            resources.ApplyResources(this._grpScaleSrc, "_grpScaleSrc");
            this._grpScaleSrc.Name = "_grpScaleSrc";
            this._grpScaleSrc.TabStop = false;
            //
            // _radScaleSrcCurrentCurve
            //
            resources.ApplyResources(this._radScaleSrcCurrentCurve, "_radScaleSrcCurrentCurve");
            this._radScaleSrcCurrentCurve.Checked = true;
            this._radScaleSrcCurrentCurve.Name = "_radScaleSrcCurrentCurve";
            this._radScaleSrcCurrentCurve.TabStop = true;
            this._radScaleSrcCurrentCurve.UseVisualStyleBackColor = true;
            //
            // _radScaleSrcAllLayout
            //
            resources.ApplyResources(this._radScaleSrcAllLayout, "_radScaleSrcAllLayout");
            this._radScaleSrcAllLayout.Name = "_radScaleSrcAllLayout";
            this._radScaleSrcAllLayout.UseVisualStyleBackColor = true;
            this._radScaleSrcAllLayout.CheckedChanged += new System.EventHandler(this.Event_Rad_CheckedChanged);
            //
            // TimeScaleEditDlg
            //
            resources.ApplyResources(this, "$this");
            this.Controls.Add(this._grpScaleSrc);
            this.Controls.Add(this._btnApply);
            this.Controls.Add(this._grpScaleMethod);
            this.Controls.Add(this._grpScaleSrcFrame);
            this.Name = "TimeScaleEditDlg";
            this.FormClosing += new System.Windows.Forms.FormClosingEventHandler(this.Event_TimeScaleEditDlg_FormClosing);
            this.Shown += new System.EventHandler(this.Event_TimeScaleEditDlg_Shown);
            this._grpScaleSrcFrame.ResumeLayout(false);
            this._grpScaleSrcFrame.PerformLayout();
            this._pnlSpecifiedSrcBeginEnd.ResumeLayout(false);
            this._pnlSpecifiedSrcBeginEnd.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this._nudSrcStart)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this._nudSrcEnd)).EndInit();
            this._grpScaleMethod.ResumeLayout(false);
            this._grpScaleMethod.PerformLayout();
            this._pnlSpecifiedDstBeginEnd.ResumeLayout(false);
            this._pnlSpecifiedDstBeginEnd.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this._nudDstStart)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this._nudDstEnd)).EndInit();
            this._pnlSpecifiedScale.ResumeLayout(false);
            this._pnlSpecifiedScale.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this._nudTimeScale)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this._nudTimeOrigin)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this._nudValueOrigin)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this._nudValueScale)).EndInit();
            this._grpScaleSrc.ResumeLayout(false);
            this._grpScaleSrc.PerformLayout();
            this.ResumeLayout(false);

        }
        #endregion

        /// <summary>
        /// スケール処理対象のアニメーションカーブを取得します。
        /// </summary>
        public delegate IAnmCurve[] GetScaleTargetAnimCurveSet();

        /// <summary>
        /// キーフレーム選択関数
        /// </summary>
        public delegate void SelectKeyframeFunc( IAnmKeyFrame[] keySet );

        int _srcStartFrame = 0;
        int _srcEndFrame = 100;

        int _dstStartFrame = 0;
        int _dstEndFrame = 100;

        decimal _scaleTime = 1.0M;
        decimal _scaleValue = 1.0M;

        decimal _originTime = 0.0M;
        decimal _originValue = 0.0M;

        bool _bInitializeUI = false;

        LEToolFormSetting _setting;

        GetScaleTargetAnimCurveSet _getScaleTargetFunc;
        SelectKeyframeFunc	_selectKeyframeFunc;


        /// <summary>
        /// コンストラクタ
        /// </summary>
        public TimeScaleEditDlg(
            GetScaleTargetAnimCurveSet getScaleTargetFunc,
            SelectKeyframeFunc selectKeyframeFunc )
        {
            Debug.Assert( getScaleTargetFunc != null );
            Debug.Assert( selectKeyframeFunc != null );

            _getScaleTargetFunc = getScaleTargetFunc;
            _selectKeyframeFunc = selectKeyframeFunc;

            InitializeComponent();
        }

        /// <summary>
        /// フレーム区間が有効か判定します。
        /// </summary>
        static bool IsFrameRangeValid_( decimal start, decimal end )
        {
            return start < end;
        }

        /// <summary>
        /// スケール値は有効か判定します。
        /// </summary>
        static bool IsScaleValid_( decimal scale )
        {
            float fscale = decimal.ToSingle( scale );
            return
                fscale != float.NaN &&
                fscale != float.PositiveInfinity &&
                fscale != float.NegativeInfinity &&
                Math.Abs( fscale ) > float.Epsilon;
        }

        /// <summary>
        /// GUIのすべての入力が有効か判定し、
        /// 有効なら内部変数を更新します。
        /// </summary>
        bool StoreAllGUIInput_()
        {
            // 初期化中なら処理しません。
            if( _bInitializeUI )
            {
                return false;
            }

            bool bInputValid = true;

            // 入力区間
            if( _pnlSpecifiedSrcBeginEnd.Enabled )
            {
                if( IsFrameRangeValid_( _nudSrcStart.Value, _nudSrcEnd.Value ) )
                {
                    _srcStartFrame = (int)_nudSrcStart.Value;
                    _srcEndFrame = (int)_nudSrcEnd.Value;
                }else{
                    _nudSrcStart.Value = _srcStartFrame;
                    _nudSrcEnd.Value = _srcEndFrame;
                    bInputValid = false;
                }
            }

            // 出力区間
            if( _pnlSpecifiedDstBeginEnd.Enabled )
            {
                if( IsFrameRangeValid_( _nudDstStart.Value, _nudDstEnd.Value ) )
                {
                    _dstStartFrame = (int)_nudDstStart.Value;
                    _dstEndFrame = (int)_nudDstEnd.Value;
                }
                else
                {
                    _nudDstStart.Value = _dstStartFrame;
                    _nudDstEnd.Value = _dstEndFrame;
                    bInputValid = false;
                }
            }

            // スケール
            if( _pnlSpecifiedScale.Enabled )
            {
                _originTime = _nudTimeOrigin.Value;
                _originValue = _nudValueOrigin.Value;

                if( IsScaleValid_( _nudTimeScale.Value ) &&
                    IsScaleValid_( _nudValueScale.Value ) )
                {
                    _scaleTime = _nudTimeScale.Value;
                    _scaleValue = _nudValueScale.Value;
                }
                else
                {
                    _nudTimeScale.Value = _scaleTime;
                    _nudValueScale.Value = _scaleValue;
                    bInputValid = false;
                }
            }

            return bInputValid;
        }

        /// <summary>
        /// UI更新
        /// </summary>
        void UpdateProperty_()
        {
            // キー選択ボタンは、操作対象がカーブの場合のみ利用可能とします。
            _btnSelectKey.Enabled = _radScaleSrcCurrentCurve.Checked;

            // 入力ソースパネル有効無効
            _pnlSpecifiedSrcBeginEnd.Enabled = _radSpecifiedFrames.Checked;

            // 方法パネル有効無効
            _pnlSpecifiedDstBeginEnd.Enabled = _radSpecifiedDstBeginEnd.Checked;
            _pnlSpecifiedScale.Enabled = _radSpecifiedScale.Checked;
        }

        //---------------------------------------
        // 対象キー収集
        //---------------------------------------
        #region 対象キー収集
        /// <summary>
        ///
        /// </summary>
        void CollectAllAttrKeys_( IAnmAttribute attr, List<IAnmKeyFrame> keySet )
        {
            if( attr.ICurrentAnimationCurve != null && attr.ICurrentAnimationCurve.NumKeyFrame != 0 )
            {
                keySet.AddRange( attr.ICurrentAnimationCurve.IKeyFrameSet );
            }

            for( int i = 0 ; i < attr.NumSubAttribute ; i++ )
            {
                CollectAllAttrKeys_( attr.FindSubAttributeByIdx( i ), keySet );
            }
        }

        /// <summary>
        ///
        /// </summary>
        void CollectAllPaneKeys_( IPane pane, List<IAnmKeyFrame> keySet )
        {
            foreach( ParamaterKind kind in ParamaterKindHelper.AnimationKindSet )
            {
                IAnmAttribute[] attrSet = PaneAnimationHelper.GetAnimationTargetAttributeSet(pane, kind);
                foreach( IAnmAttribute attr in attrSet )
                {
                    CollectAllAttrKeys_( attr, keySet );
                }
            }
        }

        /// <summary>
        ///
        /// </summary>
        List<IAnmKeyFrame> CollectSourceKeys_()
        {
            //----------------------------------------
            // すべてのキーフレームを集めます。
            ISubScene subScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
            List<IAnmKeyFrame> keySet = new List<IAnmKeyFrame>();

            if( subScene != null )
            {
                // 操作対象の設定によってキー収集法を変えます。
                if( _radScaleSrcAllLayout.Checked )
                {
                    foreach( IPane pane in subScene.IPaneArray )
                    {
                        CollectAllPaneKeys_( pane, keySet );
                    }
                }
                else
                {
                    IAnmCurve[] curveSet = _getScaleTargetFunc();
                    foreach( IAnmCurve curve in curveSet )
                    {
                        if( curve.NumKeyFrame != 0 )
                        {
                            keySet.AddRange( curve.IKeyFrameSet );
                        }
                    }
                }

                //----------------------------------------
                // 入力フレーム範囲が指定されていれば...
                if( _radSpecifiedFrames.Checked )
                {
                    keySet.RemoveAll( delegate( IAnmKeyFrame key )
                    {
                        return key.Time < (int)_srcStartFrame || key.Time > (int)_srcEndFrame;
                    } );
                }
            }

            return keySet;
        }
        #endregion

        //---------------------------------------
        // イベントハンドラ
        //---------------------------------------
        #region イベントハンドラ
        /// <summary>
        /// ラジオボタン更新
        /// </summary>
        private void Event_Rad_CheckedChanged( object sender, EventArgs e )
        {
            UpdateProperty_();
        }

        /// <summary>
        /// 値変更
        /// </summary>
        private void Event_Nud_ValueChanged( object sender, EventArgs e )
        {
            StoreAllGUIInput_();
        }

        /// <summary>
        /// ボタン押しハンドラ
        /// </summary>
        private void Event_BtnApply_Click( object sender, EventArgs e )
        {
            float srcX, dstX;
            float srcY, dstY;

            float sX;
            float sY;

            //----------------------------------------
            // すべてのキーフレームを集めます。
            ISubScene subScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;

            List<IAnmKeyFrame>  keySet = CollectSourceKeys_();

            if( keySet.Count <= 0 )
            {
                return;
            }


            float srcStartFrame;
            float srcEndFrame;
            //---------------------------------------
            // 設定に応じて、入力区間を計算します。
            if( _radSpecifiedFrames.Checked )
            {
                srcStartFrame = _srcStartFrame;
                srcEndFrame = _srcEndFrame;
            }
            else
            {
                float min = 0;
                float max = 0;
                // 開始、終了範囲を求めます。
                keySet.ForEach( delegate( IAnmKeyFrame key )
                {
                    min = Math.Min( min, key.Time );
                    max = Math.Max( max, key.Time );
                } );
                srcStartFrame = min;
                srcEndFrame = max;
            }


            //----------------------------------------
            // フレームの開始
            // 必要ならば、入力範囲と、出力範囲から、スケール値を計算します。
            // スケール原点を決定します。
            if( !_pnlSpecifiedScale.Enabled )
            {
                sX = (float)( _dstEndFrame - _dstStartFrame ) /
                     (float)( srcEndFrame - srcStartFrame );
                sY = 1.0f;

                srcX = srcStartFrame;
                dstX = _dstStartFrame;

                srcY = 0.0f;
                dstY = 0.0f;
            }
            else
            {
                sX = (float)_scaleTime;
                sY = (float)_scaleValue;

                srcX = (int)_originTime;
                dstX = (int)_originTime;

                srcY = (float)_originValue;
                dstY = (float)_originValue;
            }

            //----------------------------------------
            // 選択キーのみ処理する必要があれば...
            if( _chkApplyToSelectOnly.Checked )
            {
                keySet.RemoveAll( delegate( IAnmKeyFrame key )
                {
                    return !key.IsSelected;
                } );
            }


            // 変換後にキーが重複するか確認する
            var curves = from key in keySet
                group key by key.OwnerIAnmCurve;

            var times = curves.Select(
                x => x.Key.IKeyFrameSet.Except(x).Select(y => new Tuple<float, bool>(y.Time, false)) // 変換対象外のキーの時間
                    .Concat(x.Select(y => new Tuple<float, bool>((y.Time - srcX) * sX + dstX, true)))); // 変換後の時間

            Func<IEnumerable<Tuple<float, bool>>, bool> isOverlapped = x =>
            {
                // 隣接する要素を比較する
                // 誤差を考慮しつつ、変換対象外同士はチェックしない
                var ordered = x.OrderBy(y => y.Item1).ToArray();
                return ordered.Zip(ordered.Skip(1), (y, z) => (y.Item2 || z.Item2) && Math.Abs(y.Item1 - z.Item1) < 1.0e-6).Any(y => y);
            };

            if (times.Any(isOverlapped))
            {
                MessageBox.Show(this, StringResMgr.Get("TIMESCALEEDITDLG_OVERLAP"), this.Text);
                return;
            }

            //----------------------------------------
            // すべてのキーについて
            subScene.BeginMassiveModify();

            // キーの変更
            AnmKeyFrameManipulator keyMnp = new AnmKeyFrameManipulator();
            List<IAnmCurve> curveSet = new List<IAnmCurve>();

            foreach( IAnmKeyFrame key in keySet )
            {
                // 実際の変更
                float	time = ( (key.Time - srcX) * sX ) + dstX;
                float	val = ( (key.ValueAsFloat  - srcY) * sY ) + dstY;


                keyMnp.BindTarget( key );
                keyMnp.ModifyForce( val, time );

                if( !curveSet.Contains( key.OwnerIAnmCurve ) )
                {
                    curveSet.Add( key.OwnerIAnmCurve );
                }
            }
            // カーブの再評価
            AnmCurveManipulator curveMnp = new AnmCurveManipulator();
            foreach( IAnmCurve curve in curveSet )
            {
                curveMnp.BindTarget( curve );
                curveMnp.Update( true );
            }

            subScene.EndMassiveModify();

        }

        /// <summary>
        /// キーフレームを選択します。
        ///
        /// 選択処理は、外部モジュールにコールバックします。
        /// </summary>
        private void Event_BtnSelectKey_Click( object sender, EventArgs e )
        {
            _selectKeyframeFunc( CollectSourceKeys_().ToArray() );
        }

        /// <summary>
        /// FormClosing
        /// </summary>
        private void Event_TimeScaleEditDlg_FormClosing( object sender, FormClosingEventArgs e )
        {
            e.Cancel = true;
            this.Visible = false;
        }

        /// <summary>
        /// 初回表示時の初期化処理を行います。
        /// </summary>
        private void Event_TimeScaleEditDlg_Shown( object sender, EventArgs e )
        {
            if( _setting == null )
            {
                return;
            }

            _bInitializeUI = true;

            _setting.TryToFindUserIntDataByName( "srcStartFrame", out _srcStartFrame );
            _setting.TryToFindUserIntDataByName( "srcEndFrame", out _srcEndFrame );

            _setting.TryToFindUserIntDataByName( "dstStartFrame", out _dstStartFrame );
            _setting.TryToFindUserIntDataByName( "dstEndFrame", out _dstEndFrame );

            _setting.TryToFindUserDecimalDataByName( "scaleTime", out _scaleTime );
            _setting.TryToFindUserDecimalDataByName( "scaleValue", out _scaleValue );

            _setting.TryToFindUserDecimalDataByName( "originTime", out _originTime );
            _setting.TryToFindUserDecimalDataByName( "originValue", out _originValue );

            // 入力区間
            _nudSrcStart.Value = _srcStartFrame;
            _nudSrcEnd.Value = _srcEndFrame;

            // 出力区間
            _nudDstStart.Value = _dstStartFrame;
            _nudDstEnd.Value = _dstEndFrame;

            // スケール
            if( !IsScaleValid_( _scaleTime ) )
            {
                _scaleTime = 1.0M;
            }
            if( !IsScaleValid_( _scaleValue ) )
            {
                _scaleValue = 1.0M;
            }
            _nudTimeScale.Value = _scaleTime;
            _nudValueScale.Value = _scaleValue;

            // スケール原点
            _nudTimeOrigin.Value = _originTime;
            _nudValueOrigin.Value = _originValue;

            bool bFlag;
            if( _setting.TryToFindUserBoolDataByName( "_radScaleSrcAllLayout_checked", out bFlag ) )
            {
                _radScaleSrcAllLayout.SetChecked( bFlag );
            }
            if( _setting.TryToFindUserBoolDataByName( "_radAllFrames_checked", out bFlag ) )
            {
                _radAllFrames.SetChecked( bFlag );
            }
            if( _setting.TryToFindUserBoolDataByName( "_chkApplyToSelectOnly_checked", out bFlag ) )
            {
                _chkApplyToSelectOnly.SetChecked( bFlag );

            }
            if( _setting.TryToFindUserBoolDataByName( "_radSpecifiedDstBeginEnd_checked", out bFlag ) )
            {
                _radSpecifiedDstBeginEnd.SetChecked( bFlag );
            }

            _setting = null;
            _bInitializeUI = false;

            StoreAllGUIInput_();
            UpdateProperty_();
        }

        #endregion イベントハンドラ


        //---------------------------------------
        // ILEDataSerializebleWindow メンバ
        //---------------------------------------
        #region ILEDataSerializebleWindow メンバ

        /// <summary>
        ///
        /// </summary>
        public string LEWindowName
        {
            get { return "TimeScaleEditDlg"; }
        }

        /// <summary>
        ///
        /// </summary>
        public string Description
        {
            get { return "Dialog to edit time-scale owned by CurveEditWindow"; }
        }

        /// <summary>
        ///
        /// </summary>
        public void SaveSetting(LEToolFormSetting setting, ToolWindows.SaveSettingOption option)
        {
            ToolWindows.LEToolWindow.SaveToBasicData( this, setting );

            setting.Name = this.LEWindowName;

            if (option.AlsoSaveOtherThanWorkspace)
            {
                setting.AddUserData("srcStartFrame", _srcStartFrame.ToString());
                setting.AddUserData("srcEndFrame", _srcEndFrame.ToString());

                setting.AddUserData("dstStartFrame", _dstStartFrame.ToString());
                setting.AddUserData("dstEndFrame", _dstEndFrame.ToString());

                setting.AddUserData("scaleTime", _scaleTime.ToString());
                setting.AddUserData("scaleValue", _scaleValue.ToString());

                setting.AddUserData("originTime", _originTime.ToString());
                setting.AddUserData("originValue", _originValue.ToString());

                setting.AddUserData("_radScaleSrcAllLayout_checked", _radScaleSrcAllLayout.Checked.ToString());
                setting.AddUserData("_radAllFrames_checked", _radAllFrames.Checked.ToString());
                setting.AddUserData("_chkApplyToSelectOnly_checked", _chkApplyToSelectOnly.Checked.ToString());
                setting.AddUserData("_radSpecifiedDstBeginEnd_checked", _radSpecifiedDstBeginEnd.Checked.ToString());
            }
        }

        /// <summary>
        ///
        /// </summary>
        public void LoadSetting(LEToolFormSetting setting, ToolWindows.LoadSettingOption option)
        {
            ToolWindows.LEToolWindow.LoadFormBasicData( this, setting );

            if (option.AlsoLoadOtherThanWorkspace)
            {
                _setting = setting;
            }
        }

        #endregion




    }
}
