﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using LayoutEditor.Forms.Dialogs;
using LECore.Structures;

namespace LayoutEditor.src.Forms.Dialogs
{
    /// <summary>
    /// 部品上書きプロパティの設定
    /// </summary>
    public partial class SetPartsPropaertyDlg : LEBaseDlg
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public SetPartsPropaertyDlg()
        {
            InitializeComponent();

            // TODO : ヘッダを初期化する。
        }

        //----------------------------------------------------------
        // プロパティ
        //----------------------------------------------------------

        /// <summary>
        /// 選択された上書きペイン列です。
        /// </summary>
        public IEnumerable<PartsPropaertySettingsSource> OverwritePaneNames
        {
            get
            {
                foreach (ListViewItem item in this._lvwPanes.CheckedItems)
                {
                    if(item.Tag is IPane)
                    {
                        yield return new PartsPropaertySettingsSource(
                            item.Tag as IPane,
                            item.SubItems[2].Text);
                    }else{
                        yield return new PartsPropaertySettingsSource(
                            item.SubItems[0].Text,
                            (PaneKind)item.SubItems[1].Tag,
                            item.SubItems[2].Text);
                    }
                }
            }
        }

        //----------------------------------------------------------
        // 初期化
        //----------------------------------------------------------

        /// <summary>
        /// ダイアログを初期化します。
        /// </summary>
        public void Initialize(ISubScene subScene)
        {
            // すべての候補をリストに登録
            IPane[] overridablePaneSet = subScene.GetPaneSet((pane) => PartsSettingsHelper.IsOverridablePaneKind(pane.PaneKind)).ToArray();
            Array.Sort(overridablePaneSet, PaneHelper.ComparePaneByTreeOrder);
            foreach (IPane overridablePane in overridablePaneSet)
            {
                var item = new ListViewItem(new string[]{
                    overridablePane.PaneName,
                    overridablePane.PaneKind.ToString(), string.Empty});
                item.Tag = overridablePane;
                item.SubItems[1].Tag = overridablePane.PaneKind;

                // 上書き対象はチェックしておく。
                var targetProp = subScene.IPartsSettings.OverridePorperties.FirstOrDefault(
                    (prop) => prop.TargetName == overridablePane.PaneName);
                if (targetProp != null)
                {
                    item.Checked = true;
                    item.SubItems[2].Text = targetProp.Description;
                }
                else
                {
                    item.Checked = false;
                }

                _lvwPanes.Items.Add(item);
            }

            // ペインは存在しないが、過去に設定されていた項目も設定しておく。
            foreach (var overridePorpert in subScene.IPartsSettings.OverridePorperties)
            {
                if (_lvwPanes.FindItemWithText(overridePorpert.TargetName) == null)
                {
                    var missItem = new ListViewItem(new string[]{
                    overridePorpert.TargetName,
                    overridePorpert.PaneKind.ToString(), overridePorpert.Description});

                    missItem.ForeColor = Color.Red;
                    missItem.Checked = true;

                    missItem.SubItems[1].Tag = overridePorpert.PaneKind;

                    _lvwPanes.Items.Add(missItem);
                }
            }

            Event_LvwPanes_SelectedIndexChanged(null, null);
        }

        //----------------------------------------------------------
        // イベント
        //----------------------------------------------------------

        /// <summary>
        /// OKボタン
        /// </summary>
        private void Event_BtnOK_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.OK;
        }

        /// <summary>
        /// キャンセルボタン
        /// </summary>
        private void Event_BtnCancel_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }

        /// <summary>
        /// リスト選択変更
        /// </summary>
        private void Event_LvwPanes_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (_lvwPanes.SelectedIndices.Count > 0)
            {
                _lblSelectedPaneName.Text = string.Format("[{0}]", _lvwPanes.SelectedItems[0].SubItems[0].Text);
                _tbxDesc.SetValue(_lvwPanes.SelectedItems[0].SubItems[2].Text.Replace("\n", "\r\n"));
                _tbxDesc.Enabled = true;
            }
            else
            {
                _lblSelectedPaneName.Text = StringResMgr.Get("PARTS_TARGET_PARAM_NONE");
                _tbxDesc.SetValue(string.Empty);
                _tbxDesc.Enabled = false;
            }
        }

        /// <summary>
        /// 説明更新
        /// </summary>
        private void Event_TbxDesc_Validated(object sender, EventArgs e)
        {
            if (_lvwPanes.SelectedIndices.Count > 0)
            {
                _lvwPanes.SelectedItems[0].SubItems[2].Text = _tbxDesc.Text.Replace("\r\n", "\n");
            }
        }
    }
}
