﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace LayoutEditor.Forms.Dialogs
{
    public partial class LEBaseDlg : Form
    {
        public LEBaseDlg()
        {
            InitializeComponent();
        }

        #region デザイナ制御
        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public new bool IsMdiContainer
        {
            get { return base.IsMdiContainer;  }
            set { base.IsMdiContainer = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public new bool MaximizeBox
        {
            get { return base.MaximizeBox;  }
            set { base.MaximizeBox = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public new bool MinimizeBox
        {
            get { return base.MinimizeBox;  }
            set { base.MinimizeBox = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public new bool ShowInTaskbar
        {
            get { return base.ShowInTaskbar;  }
            set { base.ShowInTaskbar = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public new bool TopMost
        {
            get { return base.TopMost;  }
            set { base.TopMost = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public new FormWindowState WindowState
        {
            get { return base.WindowState;  }
            set { base.WindowState = value; }
        }
        #endregion

        #region オーバーライド
        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void OnLoad(EventArgs e)
        {
            if (!this.DesignMode)
            {
                // サイズ変更モード時の設定
                if (this.FormBorderStyle == FormBorderStyle.Sizable)
                {
                    // アイコン
                    this.Icon = LayoutEditor.AppForm.AppIcon;
                }
            }
            base.OnLoad(e);
        }
       #endregion
    }
}
