﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.IO;
using System.Diagnostics;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace LayoutEditor.Forms.Dialogs
{
    /// <summary>
    /// DocumentsCloseDlg の概要の説明です。
    /// </summary>
    public class DocumentsCloseDlg : System.Windows.Forms.Form
    {
        private System.Windows.Forms.Label _lblSaveFile;
        private System.Windows.Forms.Button _btnOK;
        private System.Windows.Forms.Button _btnCancel;
        private System.Windows.Forms.Button _btnNo;
        /// <summary>
        /// 必要なデザイナ変数です。
        /// </summary>
        private System.ComponentModel.Container components = null;

        string[]         _saveFileNameSet = null;
        private LayoutEditor.Controls.UIListView _lvwFileSet;
        private ColumnHeader _cmhName;
        Hashtable        _ListTextFilePathTbl = new Hashtable();


        public string[] SaveFileNameSet
        {
            get{ return _saveFileNameSet;}
        }

        /// <summary>
        /// リスト用文字列を取得します。
        /// </summary>
        string GetListText_( string filePath )
        {
            string listText = string.Format("{0}    ({1})", Path.GetFileName( filePath ), filePath );
            return listText;
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public DocumentsCloseDlg()
        {
            //
            // Windows フォーム デザイナ サポートに必要です。
            //
            InitializeComponent();
        }

        /// <summary>
        /// ファイルを設定します。
        /// </summary>
        public void SetFiles(string[] fileNameSet)
        {
            _ListTextFilePathTbl.Clear();
            _lvwFileSet.Items.Clear();

            foreach( string filePath in fileNameSet )
            {
                string listText = GetListText_( filePath );
                _ListTextFilePathTbl.Add( listText, filePath );

                var newItem = new ListViewItem(listText);
                newItem.Checked = true;

                _lvwFileSet.Items.Add(newItem);
            }
        }

        /// <summary>
        /// 使用されているリソースに後処理を実行します。
        /// </summary>
        protected override void Dispose( bool disposing )
        {
            if( disposing )
            {
                if(components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

        #region Windows フォーム デザイナで生成されたコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(DocumentsCloseDlg));
            this._lblSaveFile = new System.Windows.Forms.Label();
            this._btnOK = new System.Windows.Forms.Button();
            this._btnCancel = new System.Windows.Forms.Button();
            this._btnNo = new System.Windows.Forms.Button();
            this._lvwFileSet = new LayoutEditor.Controls.UIListView();
            this._cmhName = new System.Windows.Forms.ColumnHeader();
            this.SuspendLayout();
            //
            // _lblSaveFile
            //
            resources.ApplyResources(this._lblSaveFile, "_lblSaveFile");
            this._lblSaveFile.Name = "_lblSaveFile";
            //
            // _btnOK
            //
            resources.ApplyResources(this._btnOK, "_btnOK");
            this._btnOK.Name = "_btnOK";
            this._btnOK.Click += new System.EventHandler(this.Event_BtnOK_Click);
            //
            // _btnCancel
            //
            resources.ApplyResources(this._btnCancel, "_btnCancel");
            this._btnCancel.Name = "_btnCancel";
            this._btnCancel.Click += new System.EventHandler(this.Event_BtnCancel_Click);
            //
            // _btnNo
            //
            resources.ApplyResources(this._btnNo, "_btnNo");
            this._btnNo.Name = "_btnNo";
            this._btnNo.Click += new System.EventHandler(this.Event_BtnNo_Click);
            //
            // _lvwFileSet
            //
            resources.ApplyResources(this._lvwFileSet, "_lvwFileSet");
            this._lvwFileSet.CheckBoxes = true;
            this._lvwFileSet.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this._cmhName});
            this._lvwFileSet.FullRowSelect = true;
            this._lvwFileSet.GridLines = true;
            this._lvwFileSet.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
            this._lvwFileSet.LabelEdit = true;
            this._lvwFileSet.MultiSelect = false;
            this._lvwFileSet.Name = "_lvwFileSet";
            this._lvwFileSet.UseCompatibleStateImageBehavior = false;
            this._lvwFileSet.View = System.Windows.Forms.View.Details;
            //
            // _cmhName
            //
            resources.ApplyResources(this._cmhName, "_cmhName");
            //
            // DocumentsCloseDlg
            //
            resources.ApplyResources(this, "$this");
            this.Controls.Add(this._lvwFileSet);
            this.Controls.Add(this._btnNo);
            this.Controls.Add(this._btnCancel);
            this.Controls.Add(this._btnOK);
            this.Controls.Add(this._lblSaveFile);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.SizableToolWindow;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "DocumentsCloseDlg";
            this.ShowInTaskbar = false;
            this.ResumeLayout(false);

        }
        #endregion

        #region イベントハンドラ
        /// <summary>
        /// OKボタン
        /// </summary>
        private void Event_BtnOK_Click(object sender, System.EventArgs e)
        {
            ArrayList checkedFileNameSet = new ArrayList();
            foreach (ListViewItem listItem in _lvwFileSet.CheckedItems)
            {
                var listText = listItem.Text;
                Debug.Assert(_ListTextFilePathTbl.Contains(listText));
                checkedFileNameSet.Add(_ListTextFilePathTbl[listText]);
            }

            _saveFileNameSet = checkedFileNameSet.ToArray(typeof(string)) as string[];

            DialogResult = DialogResult.OK;
        }

        /// <summary>
        /// Noボタン
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Event_BtnNo_Click(object sender, System.EventArgs e)
        {
            _saveFileNameSet = new string[0];
            DialogResult = DialogResult.No;
        }

        /// <summary>
        /// キャンセルボタン
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Event_BtnCancel_Click(object sender, System.EventArgs e)
        {
            _saveFileNameSet = new string[0];
            DialogResult = DialogResult.Cancel;
        }

        #endregion イベントハンドラ


    }
}
