﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Diagnostics;
using System.Reflection;

namespace LayoutEditor.Forms
{
    public partial class AboutDlg : Form
    {
        public AboutDlg()
        {
            InitializeComponent();

            // 情報の取得
            Assembly assembly = Assembly.GetExecutingAssembly();
            FileVersionInfo info = FileVersionInfo.GetVersionInfo( assembly.Location );

            _lblProduct.Text = LECore.AppConstants.GetVersionString();
            _lblCopyright.Text = info.LegalCopyright;
        }

        public void SetAppIconImage(Image img)
        {
            _pctAppIcon.Image = img;
        }

        private void Event_BtnOK_Click( object sender, EventArgs e )
        {
            Close();
        }
    }
}
