﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.ComponentModel;
using System.Collections;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;
using System.Windows.Forms.Design;

namespace LayoutEditor.Controls
{
    // TODO:
    // ToolTip の挙動を統一させるために継承した専用クラスを作成したいが
    // .NET1.1 は ToolTip がsealed で定義されているので継承できない。
    // .NET2.0 では継承可能なのでそれまではアダプタでしのぐ事にする。

    /// <summary>
    /// このファイルのアイコンをコンポーネント用にするためのダミー。
    /// </summary>
    public sealed class DummyClass : Control {
        private void InitializeComponent()
        {
            this.SuspendLayout();
            this.ResumeLayout( false );

        }
    }

    /// <summary>
    /// ツールチップ初期化クラス。
    /// </summary>
    public sealed class ToolTipInitializer
    {
        /// <summary>
        /// 初期化。
        /// </summary>
        public static void Initialize(ToolTip toolTip)
        {
            // デフォルト設定でＯＫ
            // toolTip.AutomaticDelay = 500;
            // toolTip.InitialDelay   = 500;
            // toolTip.ReshowDelay    = 100;

            // 勝手に消えないように長めに表示させる
            toolTip.AutoPopDelay = 30000;
            // 親が非アクティブでも表示させる
            toolTip.ShowAlways = true;
        }
    }
}
